/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.parse;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.Writer;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ElementValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.umlg.sqlg.predicate.FullText;
import org.umlg.sqlg.sql.dialect.SqlBulkDialect;
import org.umlg.sqlg.sql.parse.AliasMapHolder;
import org.umlg.sqlg.sql.parse.ColumnList;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.sql.parse.WhereClause;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Visitor;
import org.umlg.sqlg.util.SqlgUtil;

public class SchemaTableTree {
    public static final String ALIAS_SEPARATOR = "~&~";
    private static final String CONSTRUCT_SQL_MAY_ONLY_BE_CALLED_ON_THE_ROOT_OBJECT = "constructSql may only be called on the root object";
    private static final String WITHIN = "within";
    private static final String WITHOUT = "without";
    private int stepDepth;
    private SchemaTable schemaTable;
    private SchemaTableTree parent;
    private Direction direction;
    private STEP_TYPE stepType;
    private List<SchemaTableTree> children = new ArrayList<SchemaTableTree>();
    private SqlgGraph sqlgGraph;
    private List<SchemaTableTree> leafNodes = new ArrayList<SchemaTableTree>();
    private List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private List<org.javatuples.Pair<Traversal.Admin, Comparator>> comparators = new ArrayList<org.javatuples.Pair<Traversal.Admin, Comparator>>();
    private Set<String> labels;
    private Set<String> realLabels;
    private String reducedLabels;
    private boolean untilFirst;
    private int rootAliasCounter = 1;
    private boolean emit;
    private boolean optionalLeftJoin;
    private AliasMapHolder aliasMapHolder;
    private int tmpTableAliasCounter = 1;
    private Map<String, Map<String, PropertyType>> filteredAllTables;
    private int replacedStepDepth;
    private Map<String, Pair<String, PropertyType>> columnNamePropertyName;
    private String idProperty;
    private String labeledAliasId;
    private boolean localStep = false;
    private boolean fakeEmit = false;
    private Range<Long> range;

    SchemaTableTree(SqlgGraph sqlgGraph, SchemaTable schemaTable, int stepDepth, int replacedStepDepth) {
        this.sqlgGraph = sqlgGraph;
        this.schemaTable = schemaTable;
        this.stepDepth = stepDepth;
        this.hasContainers = new ArrayList<HasContainer>();
        this.comparators = new ArrayList<org.javatuples.Pair<Traversal.Admin, Comparator>>();
        this.labels = Collections.emptySet();
        this.replacedStepDepth = replacedStepDepth;
        this.filteredAllTables = SqlgUtil.filterHasContainers(sqlgGraph.getTopology(), this.hasContainers, "sqlg_schema".equals(schemaTable.getSchema()));
    }

    SchemaTableTree(SqlgGraph sqlgGraph, SchemaTable schemaTable, int stepDepth, List<HasContainer> hasContainers, List<org.javatuples.Pair<Traversal.Admin, Comparator>> comparators, Range<Long> range, STEP_TYPE stepType, boolean emit, boolean untilFirst, boolean optionalLeftJoin, int replacedStepDepth, Set<String> labels) {
        this.sqlgGraph = sqlgGraph;
        this.schemaTable = schemaTable;
        this.stepDepth = stepDepth;
        this.replacedStepDepth = replacedStepDepth;
        this.hasContainers = hasContainers;
        this.comparators = comparators;
        this.range = range;
        this.labels = Collections.unmodifiableSet(labels);
        this.stepType = stepType;
        this.emit = emit;
        this.untilFirst = untilFirst;
        this.optionalLeftJoin = optionalLeftJoin;
        this.filteredAllTables = SqlgUtil.filterHasContainers(sqlgGraph.getTopology(), this.hasContainers, "sqlg_schema".equals(schemaTable.getSchema()));
        this.initializeAliasColumnNameMaps();
    }

    SchemaTableTree addChild(SchemaTable schemaTable, Direction direction, Class<? extends Element> elementClass, ReplacedStep replacedStep, boolean isEdgeVertexStep, Set<String> labels) {
        return this.addChild(schemaTable, direction, elementClass, replacedStep.getHasContainers(), replacedStep.getComparators(), replacedStep.getRange(), replacedStep.getDepth(), isEdgeVertexStep, replacedStep.isEmit(), replacedStep.isUntilFirst(), replacedStep.isLeftJoin(), labels);
    }

    SchemaTableTree addChild(SchemaTable schemaTable, Direction direction, Class<? extends Element> elementClass, ReplacedStep replacedStep, Set<String> labels) {
        boolean emit;
        Preconditions.checkState((boolean)(replacedStep.getStep() instanceof VertexStep), (String)"addChild can only be called for a VertexStep, found %s", (Object[])new Object[]{replacedStep.getStep().getClass().getSimpleName()});
        if (elementClass.isAssignableFrom(Vertex.class)) {
            emit = schemaTable.isVertexTable() && replacedStep.isEmit();
        } else if (elementClass.isAssignableFrom(Edge.class)) {
            emit = schemaTable.isEdgeTable() && replacedStep.isEmit();
        } else {
            throw new IllegalStateException(String.format("BUG: Expected %s, instead found %s", "Edge or Vertex", elementClass.getSimpleName()));
        }
        return this.addChild(schemaTable, direction, elementClass, replacedStep.getHasContainers(), replacedStep.getComparators(), replacedStep.getRange(), replacedStep.getDepth(), false, emit, replacedStep.isUntilFirst(), replacedStep.isLeftJoin(), labels);
    }

    private SchemaTableTree addChild(SchemaTable schemaTable, Direction direction, Class<? extends Element> elementClass, List<HasContainer> hasContainers, List<org.javatuples.Pair<Traversal.Admin, Comparator>> comparators, Range<Long> range, int stepDepth, boolean isEdgeVertexStep, boolean emit, boolean untilFirst, boolean leftJoin, Set<String> labels) {
        SchemaTableTree schemaTableTree = new SchemaTableTree(this.sqlgGraph, schemaTable, stepDepth, this.replacedStepDepth);
        if (elementClass.isAssignableFrom(Edge.class) && schemaTable.getTable().startsWith("E_") || elementClass.isAssignableFrom(Vertex.class) && schemaTable.getTable().startsWith("V_")) {
            schemaTableTree.hasContainers = new ArrayList<HasContainer>(hasContainers);
            schemaTableTree.comparators = new ArrayList<org.javatuples.Pair<Traversal.Admin, Comparator>>(comparators);
            schemaTableTree.range = range;
        }
        schemaTableTree.parent = this;
        schemaTableTree.direction = direction;
        this.children.add(schemaTableTree);
        schemaTableTree.stepType = isEdgeVertexStep ? STEP_TYPE.EDGE_VERTEX_STEP : STEP_TYPE.VERTEX_STEP;
        schemaTableTree.labels = Collections.unmodifiableSet(labels);
        schemaTableTree.emit = emit;
        schemaTableTree.untilFirst = untilFirst;
        schemaTableTree.optionalLeftJoin = leftJoin;
        return schemaTableTree;
    }

    private Map<String, Map<String, PropertyType>> getFilteredAllTables() {
        return this.getRoot().filteredAllTables;
    }

    void initializeAliasColumnNameMaps() {
        this.aliasMapHolder = new AliasMapHolder();
    }

    private Map<String, String> getColumnNameAliasMap() {
        return this.getRoot().aliasMapHolder.getColumnNameAliasMap();
    }

    public Map<String, String> getAliasColumnNameMap() {
        return this.getRoot().aliasMapHolder.getAliasColumnNameMap();
    }

    private Map<String, Pair<String, PropertyType>> getColumnNamePropertyName() {
        if (this.columnNamePropertyName == null) {
            this.columnNamePropertyName = new HashMap<String, Pair<String, PropertyType>>();
            for (Map.Entry<String, String> entry : this.getRoot().aliasMapHolder.getAliasColumnNameMap().entrySet()) {
                String alias = entry.getKey();
                String columnName = entry.getValue();
                if (columnName.endsWith("~&~ID") || !columnName.contains("P~~~") && !columnName.contains("E~~~") || !this.containsLabelledColumn(columnName)) continue;
                String propertyName = this.propertyNameFromLabeledAlias(columnName);
                PropertyType propertyType = this.sqlgGraph.getTopology().getTableFor(this.getSchemaTable()).get(propertyName);
                this.columnNamePropertyName.put(alias, (Pair<String, PropertyType>)Pair.of((Object)propertyName, (Object)((Object)propertyType)));
            }
        }
        return this.columnNamePropertyName;
    }

    private boolean hasParent() {
        return this.parent != null;
    }

    private SchemaTableTree getRoot() {
        return this.walkUp(this);
    }

    private SchemaTableTree walkUp(SchemaTableTree schemaTableTree) {
        if (schemaTableTree.hasParent()) {
            return schemaTableTree.walkUp(schemaTableTree.getParent());
        }
        return schemaTableTree;
    }

    public void setEmit(boolean emit) {
        this.emit = emit;
    }

    public boolean isEmit() {
        return this.emit;
    }

    public boolean isOptionalLeftJoin() {
        return this.optionalLeftJoin;
    }

    public void setOptionalLeftJoin(boolean optionalLeftJoin) {
        this.optionalLeftJoin = optionalLeftJoin;
    }

    public void resetColumnAliasMaps() {
        this.aliasMapHolder.clear();
        this.rootAliasCounter = 1;
    }

    private boolean containsLabelledColumn(String columnName) {
        if (columnName.startsWith(this.stepDepth + ALIAS_SEPARATOR + this.reducedLabels() + ALIAS_SEPARATOR)) {
            String column = columnName.substring((this.stepDepth + ALIAS_SEPARATOR + this.reducedLabels() + ALIAS_SEPARATOR).length());
            Iterator split = Splitter.on((String)ALIAS_SEPARATOR).split((CharSequence)column).iterator();
            String schema = (String)split.next();
            String table = (String)split.next();
            return schema.equals(this.schemaTable.getSchema()) && table.equals(this.schemaTable.getTable());
        }
        return false;
    }

    public SchemaTable getSchemaTable() {
        return this.schemaTable;
    }

    public String constructSql(LinkedList<SchemaTableTree> distinctQueryStack) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)CONSTRUCT_SQL_MAY_ONLY_BE_CALLED_ON_THE_ROOT_OBJECT);
        if (SchemaTableTree.duplicatesInStack(distinctQueryStack)) {
            List<LinkedList<SchemaTableTree>> subQueryStacks = SchemaTableTree.splitIntoSubStacks(distinctQueryStack);
            return SchemaTableTree.constructDuplicatePathSql(this.sqlgGraph, subQueryStacks);
        }
        return SchemaTableTree.constructSinglePathSql(this.sqlgGraph, false, distinctQueryStack, null, null);
    }

    public String constructSqlForOptional(LinkedList<SchemaTableTree> innerJoinStack, Set<SchemaTableTree> leftJoinOn) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)CONSTRUCT_SQL_MAY_ONLY_BE_CALLED_ON_THE_ROOT_OBJECT);
        if (SchemaTableTree.duplicatesInStack(innerJoinStack)) {
            List<LinkedList<SchemaTableTree>> subQueryStacks = SchemaTableTree.splitIntoSubStacks(innerJoinStack);
            return SchemaTableTree.constructDuplicatePathSql(this.sqlgGraph, subQueryStacks, leftJoinOn);
        }
        return SchemaTableTree.constructSinglePathSql(this.sqlgGraph, false, innerJoinStack, null, null, leftJoinOn);
    }

    public String constructSqlForEmit(LinkedList<SchemaTableTree> innerJoinStack) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)CONSTRUCT_SQL_MAY_ONLY_BE_CALLED_ON_THE_ROOT_OBJECT);
        if (SchemaTableTree.duplicatesInStack(innerJoinStack)) {
            List<LinkedList<SchemaTableTree>> subQueryStacks = SchemaTableTree.splitIntoSubStacks(innerJoinStack);
            return SchemaTableTree.constructDuplicatePathSql(this.sqlgGraph, subQueryStacks);
        }
        return SchemaTableTree.constructSinglePathSql(this.sqlgGraph, false, innerJoinStack, null, null);
    }

    public List<Pair<LinkedList<SchemaTableTree>, String>> constructSql() {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)CONSTRUCT_SQL_MAY_ONLY_BE_CALLED_ON_THE_ROOT_OBJECT);
        ArrayList<Pair<LinkedList<SchemaTableTree>, String>> result = new ArrayList<Pair<LinkedList<SchemaTableTree>, String>>();
        List<LinkedList<SchemaTableTree>> distinctQueries = this.constructDistinctQueries();
        for (LinkedList<SchemaTableTree> distinctQueryStack : distinctQueries) {
            if (SchemaTableTree.duplicatesInStack(distinctQueryStack)) {
                List<LinkedList<SchemaTableTree>> subQueryStacks = SchemaTableTree.splitIntoSubStacks(distinctQueryStack);
                String singlePathSql = SchemaTableTree.constructDuplicatePathSql(this.sqlgGraph, subQueryStacks);
                result.add((Pair<LinkedList<SchemaTableTree>, String>)Pair.of(distinctQueryStack, (Object)singlePathSql));
                continue;
            }
            String singlePathSql = SchemaTableTree.constructSinglePathSql(this.sqlgGraph, false, distinctQueryStack, null, null);
            result.add((Pair<LinkedList<SchemaTableTree>, String>)Pair.of(distinctQueryStack, (Object)singlePathSql));
        }
        return result;
    }

    public List<LinkedList<SchemaTableTree>> constructDistinctQueries() {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"constructDistinctQueries may only be called on the root object");
        ArrayList<LinkedList<SchemaTableTree>> result = new ArrayList<LinkedList<SchemaTableTree>>();
        for (SchemaTableTree schemaTableTree : this.leafNodes) {
            if (schemaTableTree.getStepDepth() != this.replacedStepDepth) continue;
            result.add(schemaTableTree.constructQueryStackFromLeaf());
        }
        for (LinkedList linkedList : result) {
            if (((SchemaTableTree)linkedList.get(0)).getParent() == null) continue;
            throw new IllegalStateException("Expected root SchemaTableTree for the first SchemaTableTree in the LinkedList");
        }
        return result;
    }

    public static void constructDistinctOptionalQueries(SchemaTableTree current, List<Pair<LinkedList<SchemaTableTree>, Set<SchemaTableTree>>> result) {
        LinkedList<SchemaTableTree> stack = current.constructQueryStackFromLeaf();
        if (current.isOptionalLeftJoin() && current.getStepDepth() < current.getReplacedStepDepth()) {
            HashSet<SchemaTableTree> leftyChildren = new HashSet<SchemaTableTree>();
            leftyChildren.addAll(current.children);
            Pair p = Pair.of(stack, leftyChildren);
            result.add((Pair<LinkedList<SchemaTableTree>, Set<SchemaTableTree>>)p);
        }
        for (SchemaTableTree child : current.children) {
            if (child.isVertexStep() && child.getSchemaTable().isVertexTable()) {
                SchemaTableTree.constructDistinctOptionalQueries(child, result);
                continue;
            }
            for (SchemaTableTree vertexChild : child.children) {
                SchemaTableTree.constructDistinctOptionalQueries(vertexChild, result);
            }
        }
    }

    public static void constructDistinctEmitBeforeQueries(SchemaTableTree current, List<LinkedList<SchemaTableTree>> result) {
        LinkedList<SchemaTableTree> stack = current.constructQueryStackFromLeaf();
        if (!current.isLocalStep() && current.isEmit() && current.getStepDepth() < current.getReplacedStepDepth()) {
            result.add(stack);
        }
        if (current.isLocalStep() && current.isEmit()) {
            current.setFakeEmit(true);
        }
        for (SchemaTableTree child : current.children) {
            if (child.isVertexStep() && child.getSchemaTable().isVertexTable()) {
                SchemaTableTree.constructDistinctEmitBeforeQueries(child, result);
                continue;
            }
            for (SchemaTableTree vertexChild : child.children) {
                SchemaTableTree.constructDistinctEmitBeforeQueries(vertexChild, result);
            }
        }
    }

    private static String constructDuplicatePathSql(SqlgGraph sqlgGraph, List<LinkedList<SchemaTableTree>> subQueryLinkedLists) {
        return SchemaTableTree.constructDuplicatePathSql(sqlgGraph, subQueryLinkedLists, Collections.emptySet());
    }

    private static String constructDuplicatePathSql(SqlgGraph sqlgGraph, List<LinkedList<SchemaTableTree>> subQueryLinkedLists, Set<SchemaTableTree> leftJoinOn) {
        String singlePathSql = "\nFROM (";
        int count = 1;
        SchemaTableTree lastOfPrevious = null;
        for (LinkedList<SchemaTableTree> subQueryLinkedList : subQueryLinkedLists) {
            boolean last;
            SchemaTableTree firstOfNext = null;
            boolean bl = last = count == subQueryLinkedLists.size();
            if (!last) {
                LinkedList<SchemaTableTree> nextList = subQueryLinkedLists.get(count);
                firstOfNext = nextList.getFirst();
            }
            SchemaTableTree firstSchemaTableTree = subQueryLinkedList.getFirst();
            String sql = last ? SchemaTableTree.constructSinglePathSql(sqlgGraph, true, subQueryLinkedList, lastOfPrevious, null, leftJoinOn) : SchemaTableTree.constructSinglePathSql(sqlgGraph, true, subQueryLinkedList, lastOfPrevious, firstOfNext);
            singlePathSql = singlePathSql + sql;
            if (count == 1) {
                singlePathSql = singlePathSql + "\n) a" + count++ + " INNER JOIN (";
            } else {
                singlePathSql = singlePathSql + "\n) a" + count + " ON ";
                singlePathSql = singlePathSql + SchemaTableTree.constructSectionedJoin(sqlgGraph, lastOfPrevious, firstSchemaTableTree, count);
                if (count++ < subQueryLinkedLists.size()) {
                    singlePathSql = singlePathSql + " INNER JOIN (";
                }
            }
            lastOfPrevious = subQueryLinkedList.getLast();
        }
        singlePathSql = singlePathSql + SchemaTableTree.constructOuterOrderByClause(sqlgGraph, subQueryLinkedLists);
        String result = "SELECT\n\t" + SchemaTableTree.constructOuterFromClause(subQueryLinkedLists);
        return result + singlePathSql;
    }

    private static String constructOuterFromClause(List<LinkedList<SchemaTableTree>> subQueryLinkedLists) {
        String result = "";
        int countOuter = 1;
        LinkedList<SchemaTableTree> previousSubQuery = null;
        for (LinkedList<SchemaTableTree> subQueryLinkedList : subQueryLinkedLists) {
            int countInner = 1;
            for (SchemaTableTree schemaTableTree : subQueryLinkedList) {
                Optional<String> optional;
                if (!schemaTableTree.getLabels().isEmpty()) {
                    result = schemaTableTree.printLabeledOuterFromClause(result, countOuter, schemaTableTree.getColumnNameAliasMap());
                    result = result + ", ";
                }
                if (schemaTableTree.getSchemaTable().isEdgeTable() && schemaTableTree.isEmit() && (optional = schemaTableTree.printEmitMappedAliasIdForOuterFromClause(countOuter, schemaTableTree.getColumnNameAliasMap())).isPresent()) {
                    result = result + optional.get();
                    result = result + ", ";
                }
                if (countOuter == subQueryLinkedLists.size() && countInner == subQueryLinkedList.size()) {
                    SchemaTableTree previousSchemaTableTree = previousSubQuery.getLast();
                    result = result + schemaTableTree.printOuterFromClause(countOuter, schemaTableTree.getColumnNameAliasMap(), previousSchemaTableTree);
                    result = result + ", ";
                }
                ++countInner;
            }
            previousSubQuery = subQueryLinkedList;
            ++countOuter;
        }
        result = result.substring(0, result.length() - 2);
        return result;
    }

    private Optional<String> printEmitMappedAliasIdForOuterFromClause(int countOuter, Map<String, String> columnNameAliasMap) {
        Optional<String> optional = this.mappedAliasIdForOuterFromClause(columnNameAliasMap);
        if (optional.isPresent()) {
            return Optional.of(" a" + countOuter + "." + this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(optional.get()));
        }
        return Optional.empty();
    }

    private static String constructOuterOrderByClause(SqlgGraph sqlgGraph, List<LinkedList<SchemaTableTree>> subQueryLinkedLists) {
        String result = "";
        int countOuter = 1;
        MutableBoolean mutableOrderBy = new MutableBoolean(false);
        for (LinkedList<SchemaTableTree> subQueryLinkedList : subQueryLinkedLists) {
            int countInner = 1;
            for (SchemaTableTree schemaTableTree : subQueryLinkedList) {
                if (countOuter == subQueryLinkedLists.size() && countInner == subQueryLinkedList.size()) {
                    result = result + schemaTableTree.toOrderByClause(sqlgGraph, mutableOrderBy, countOuter);
                    result = result + schemaTableTree.toRangeClause(sqlgGraph);
                }
                ++countInner;
            }
            ++countOuter;
        }
        return result;
    }

    private String printOuterFromClause(int count, Map<String, String> columnNameAliasMapCopy, SchemaTableTree previousSchemaTableTree) {
        String sql = "";
        Map<String, PropertyType> propertyTypeMap = this.getFilteredAllTables().get(this.toString());
        Optional<String> optional = this.lastMappedAliasIdForOuterFrom(columnNameAliasMapCopy);
        if (optional.isPresent()) {
            sql = "a" + count + "." + this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(optional.get());
            if (propertyTypeMap.size() > 0) {
                sql = sql + ", ";
            }
        }
        int propertyCount = 1;
        for (Map.Entry<String, PropertyType> propertyNameEntry : propertyTypeMap.entrySet()) {
            sql = sql + "a" + count + "." + this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.mappedAliasPropertyName(propertyNameEntry.getKey(), columnNameAliasMapCopy));
            for (String postFix : propertyNameEntry.getValue().getPostFixes()) {
                sql = sql + ", ";
                sql = sql + "a" + count + "." + this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.mappedAliasPropertyName(propertyNameEntry.getKey() + postFix, columnNameAliasMapCopy));
            }
            if (propertyCount++ >= propertyTypeMap.size()) continue;
            sql = sql + ", ";
        }
        if (this.getSchemaTable().isEdgeTable()) {
            sql = this.printEdgeInOutVertexIdOuterFromClauseFor("a" + count, sql, previousSchemaTableTree);
        }
        return sql;
    }

    private static String constructSectionedJoin(SqlgGraph sqlgGraph, SchemaTableTree fromSchemaTableTree, SchemaTableTree toSchemaTableTree, int count) {
        String result;
        if (toSchemaTableTree.direction == Direction.BOTH) {
            throw new IllegalStateException("Direction may not be BOTH!");
        }
        String rawToLabel = toSchemaTableTree.getSchemaTable().getTable().startsWith("V_") ? toSchemaTableTree.getSchemaTable().getTable().substring("V_".length()) : toSchemaTableTree.getSchemaTable().getTable();
        String rawFromLabel = fromSchemaTableTree.getSchemaTable().getTable().startsWith("V_") ? fromSchemaTableTree.getSchemaTable().getTable().substring("V_".length()) : fromSchemaTableTree.getSchemaTable().getTable();
        if (fromSchemaTableTree.getSchemaTable().getTable().startsWith("E_")) {
            if (toSchemaTableTree.isEdgeVertexStep()) {
                if (toSchemaTableTree.direction == Direction.OUT) {
                    result = "a" + (count - 1) + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTableTree.getSchemaTable().getSchema() + "." + fromSchemaTableTree.getSchemaTable().getTable() + "." + toSchemaTableTree.getSchemaTable().getSchema() + "." + rawToLabel + "__O");
                    result = result + " = a" + count + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(toSchemaTableTree.lastMappedAliasId());
                } else {
                    result = "a" + (count - 1) + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTableTree.getSchemaTable().getSchema() + "." + fromSchemaTableTree.getSchemaTable().getTable() + "." + toSchemaTableTree.getSchemaTable().getSchema() + "." + rawToLabel + "__I");
                    result = result + " = a" + count + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(toSchemaTableTree.lastMappedAliasId());
                }
            } else if (toSchemaTableTree.direction == Direction.OUT) {
                result = "a" + (count - 1) + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTableTree.getSchemaTable().getSchema() + "." + fromSchemaTableTree.getSchemaTable().getTable() + "." + toSchemaTableTree.getSchemaTable().getSchema() + "." + rawToLabel + "__I");
                result = result + " = a" + count + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(toSchemaTableTree.lastMappedAliasId());
            } else {
                result = "a" + (count - 1) + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTableTree.getSchemaTable().getSchema() + "." + fromSchemaTableTree.getSchemaTable().getTable() + "." + toSchemaTableTree.getSchemaTable().getSchema() + "." + rawToLabel + "__O");
                result = result + " = a" + count + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(toSchemaTableTree.lastMappedAliasId());
            }
        } else if (toSchemaTableTree.direction == Direction.OUT) {
            result = "a" + (count - 1) + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTableTree.getSchemaTable().getSchema() + "." + fromSchemaTableTree.getSchemaTable().getTable() + "." + "ID");
            result = result + " = a" + count + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(toSchemaTableTree.mappedAliasVertexForeignKeyColumnEnd(fromSchemaTableTree, toSchemaTableTree.direction, rawFromLabel));
        } else {
            result = "a" + (count - 1) + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTableTree.getSchemaTable().getSchema() + "." + fromSchemaTableTree.getSchemaTable().getTable() + "." + "ID");
            result = result + " = a" + count + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(toSchemaTableTree.mappedAliasVertexForeignKeyColumnEnd(fromSchemaTableTree, toSchemaTableTree.direction, rawFromLabel));
        }
        return result;
    }

    private static String constructSinglePathSql(SqlgGraph sqlgGraph, boolean partOfDuplicateQuery, LinkedList<SchemaTableTree> distinctQueryStack, SchemaTableTree lastOfPrevious, SchemaTableTree firstOfNextStack) {
        return SchemaTableTree.constructSinglePathSql(sqlgGraph, partOfDuplicateQuery, distinctQueryStack, lastOfPrevious, firstOfNextStack, Collections.emptySet());
    }

    private static String constructSinglePathSql(SqlgGraph sqlgGraph, boolean partOfDuplicateQuery, LinkedList<SchemaTableTree> distinctQueryStack, SchemaTableTree lastOfPrevious, SchemaTableTree firstOfNextStack, Set<SchemaTableTree> leftJoinOn) {
        String singlePathSql = "\nSELECT\n\t";
        SchemaTableTree firstSchemaTableTree = distinctQueryStack.getFirst();
        SchemaTable firstSchemaTable = firstSchemaTableTree.getSchemaTable();
        singlePathSql = singlePathSql + SchemaTableTree.constructFromClause(sqlgGraph, distinctQueryStack, lastOfPrevious, firstOfNextStack);
        singlePathSql = singlePathSql + "\nFROM\n\t";
        singlePathSql = singlePathSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(firstSchemaTableTree.getSchemaTable().getSchema());
        singlePathSql = singlePathSql + ".";
        singlePathSql = singlePathSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(firstSchemaTableTree.getSchemaTable().getTable());
        SchemaTableTree previous = firstSchemaTableTree;
        boolean skipFirst = true;
        for (SchemaTableTree schemaTableTree : distinctQueryStack) {
            if (skipFirst) {
                skipFirst = false;
                continue;
            }
            singlePathSql = singlePathSql + SchemaTableTree.constructJoinBetweenSchemaTables(sqlgGraph, previous, schemaTableTree);
            previous = schemaTableTree;
        }
        SchemaTableTree previousLeftJoinSchemaTableTree = null;
        for (SchemaTableTree schemaTableTree : leftJoinOn) {
            singlePathSql = previousLeftJoinSchemaTableTree == null || !previousLeftJoinSchemaTableTree.getSchemaTable().equals(schemaTableTree.getSchemaTable()) ? singlePathSql + SchemaTableTree.constructJoinBetweenSchemaTables(sqlgGraph, previous, schemaTableTree, true) : singlePathSql + SchemaTableTree.appendToJoinBetweenSchemaTables(sqlgGraph, previous, schemaTableTree, true);
            previousLeftJoinSchemaTableTree = schemaTableTree;
        }
        for (SchemaTableTree schemaTableTree : distinctQueryStack) {
            if (!sqlgGraph.getSqlDialect().supportsBulkWithinOut() || !schemaTableTree.hasBulkWithinOrOut(sqlgGraph)) continue;
            singlePathSql = singlePathSql + schemaTableTree.bulkWithJoin(sqlgGraph);
        }
        if (lastOfPrevious == null && distinctQueryStack.getFirst().stepType != STEP_TYPE.GRAPH_STEP) {
            singlePathSql = singlePathSql + "\nWHERE\n\t";
            singlePathSql = singlePathSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(firstSchemaTable.getSchema());
            singlePathSql = singlePathSql + ".";
            singlePathSql = singlePathSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(firstSchemaTable.getTable());
            singlePathSql = singlePathSql + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID");
            singlePathSql = singlePathSql + " = ? ";
        }
        boolean bl = lastOfPrevious == null && distinctQueryStack.getFirst().stepType != STEP_TYPE.GRAPH_STEP;
        MutableBoolean mutableWhere = new MutableBoolean(bl);
        MutableBoolean mutableOrderBy = new MutableBoolean(false);
        for (SchemaTableTree schemaTableTree : distinctQueryStack) {
            singlePathSql = singlePathSql + schemaTableTree.toWhereClause(sqlgGraph, mutableWhere);
        }
        for (SchemaTableTree schemaTableTree : leftJoinOn) {
            singlePathSql = singlePathSql + schemaTableTree.toOptionalLeftJoinWhereClause(sqlgGraph, mutableWhere);
        }
        if (!partOfDuplicateQuery) {
            for (SchemaTableTree schemaTableTree : distinctQueryStack) {
                singlePathSql = singlePathSql + schemaTableTree.toOrderByClause(sqlgGraph, mutableOrderBy, -1);
                singlePathSql = singlePathSql + schemaTableTree.toRangeClause(sqlgGraph);
            }
        }
        return singlePathSql;
    }

    private boolean hasBulkWithinOrOut(SqlgGraph sqlgGraph) {
        return this.hasContainers.stream().filter(h -> SqlgUtil.isBulkWithinAndOut(sqlgGraph, h)).findAny().isPresent();
    }

    private String bulkWithJoin(SqlgGraph sqlgGraph) {
        StringBuilder sb = new StringBuilder();
        List bulkHasContainers = this.hasContainers.stream().filter(h -> SqlgUtil.isBulkWithinAndOut(sqlgGraph, h)).collect(Collectors.toList());
        for (HasContainer hasContainer : bulkHasContainers) {
            P predicate = hasContainer.getPredicate();
            Collection withInList = (Collection)predicate.getValue();
            HashSet withInOuts = new HashSet(withInList);
            HashMap<String, PropertyType> columns = new HashMap<String, PropertyType>();
            Object next = withInOuts.iterator().next();
            if (next instanceof RecordId) {
                next = ((RecordId)next).getId();
            }
            if (hasContainer.getBiPredicate() == Contains.within) {
                columns.put(WITHIN, PropertyType.from(next));
            } else if (hasContainer.getBiPredicate() == Contains.without) {
                columns.put(WITHOUT, PropertyType.from(next));
            } else {
                throw new UnsupportedOperationException("Only Contains.within and Contains.without is supported!");
            }
            SecureRandom random = new SecureRandom();
            byte[] bytes = new byte[6];
            random.nextBytes(bytes);
            String tmpTableIdentified = Base64.getEncoder().encodeToString(bytes);
            tmpTableIdentified = "V_BULK_TEMP_EDGE" + tmpTableIdentified;
            sqlgGraph.getTopology().createTempTable(tmpTableIdentified, columns);
            HashMap<String, Object> withInOutMap = new HashMap<String, Object>();
            if (hasContainer.getBiPredicate() == Contains.within) {
                withInOutMap.put(WITHIN, "unused");
            } else {
                withInOutMap.put(WITHOUT, "unused");
            }
            String copySql = ((SqlBulkDialect)sqlgGraph.getSqlDialect()).temporaryTableCopyCommandSqlVertex(sqlgGraph, SchemaTable.of("public", tmpTableIdentified.substring("V_".length())), withInOutMap.keySet());
            Writer writer = ((SqlBulkDialect)sqlgGraph.getSqlDialect()).streamSql(this.sqlgGraph, copySql);
            for (Object withInOutValue : withInOuts) {
                if (withInOutValue instanceof RecordId) {
                    withInOutValue = ((RecordId)withInOutValue).getId();
                }
                withInOutMap = new HashMap();
                if (hasContainer.getBiPredicate() == Contains.within) {
                    withInOutMap.put(WITHIN, withInOutValue);
                } else {
                    withInOutMap.put(WITHOUT, withInOutValue);
                }
                ((SqlBulkDialect)sqlgGraph.getSqlDialect()).writeStreamingVertex(writer, withInOutMap);
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (hasContainer.getBiPredicate() == Contains.within) {
                sb.append("\nINNER JOIN ");
            } else {
                sb.append("\nLEFT JOIN ");
            }
            sb.append(" ");
            sb.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(tmpTableIdentified));
            sb.append(" tmp");
            sb.append(this.rootSchemaTableTree().tmpTableAliasCounter);
            sb.append(" on");
            sb.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getSchemaTable().getSchema()));
            sb.append(".");
            sb.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getSchemaTable().getTable()));
            sb.append(".");
            if (hasContainer.getKey().equals(T.id.getAccessor())) {
                sb.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
            } else {
                sb.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(hasContainer.getKey()));
            }
            if (hasContainer.getBiPredicate() == Contains.within) {
                sb.append(" = tmp");
                sb.append(this.rootSchemaTableTree().tmpTableAliasCounter++);
                sb.append(".within");
                continue;
            }
            sb.append(" = tmp");
            sb.append(this.rootSchemaTableTree().tmpTableAliasCounter++);
            sb.append(".without");
        }
        return sb.toString();
    }

    private String toOptionalLeftJoinWhereClause(SqlgGraph sqlgGraph, MutableBoolean printedWhere) {
        StringBuilder result = new StringBuilder();
        if (!printedWhere.booleanValue()) {
            printedWhere.setTrue();
            result.append("\nWHERE\n\t(");
        } else {
            result.append(" AND\n\t(");
        }
        String rawLabel = this.parent.getSchemaTable().getTable().substring("V_".length());
        result.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getSchemaTable().getSchema()));
        result.append(".");
        result.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getSchemaTable().getTable()));
        result.append(".");
        result.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.parent.getSchemaTable().getSchema() + "." + rawLabel + (this.getDirection() == Direction.IN ? "__I" : "__O")));
        result.append(" IS NULL)");
        return result.toString();
    }

    private String toWhereClause(SqlgGraph sqlgGraph, MutableBoolean printedWhere) {
        StringBuilder result = new StringBuilder();
        if (sqlgGraph.getSqlDialect().supportsBulkWithinOut()) {
            this.hasContainers.stream().filter(h -> !SqlgUtil.isBulkWithin(sqlgGraph, h)).forEach(h -> {
                if (!printedWhere.booleanValue()) {
                    printedWhere.setTrue();
                    result.append("\nWHERE\n\t(");
                } else {
                    result.append(" AND (");
                }
                WhereClause whereClause = WhereClause.from(h.getPredicate());
                result.append(" " + whereClause.toSql(sqlgGraph, this, (HasContainer)h) + ")");
            });
        } else {
            for (HasContainer hasContainer : this.getHasContainers()) {
                if (!printedWhere.booleanValue()) {
                    printedWhere.setTrue();
                    result.append("\nWHERE\n\t(");
                } else {
                    result.append(" AND (");
                }
                WhereClause whereClause = WhereClause.from(hasContainer.getPredicate());
                result.append(" " + whereClause.toSql(sqlgGraph, this, hasContainer) + ")");
            }
        }
        return result.toString();
    }

    private String toOrderByClause(SqlgGraph sqlgGraph, MutableBoolean printedOrderBy, int counter) {
        String result = "";
        for (org.javatuples.Pair<Traversal.Admin, Comparator> comparator : this.getComparators()) {
            String prefix;
            String alias;
            String prefix2;
            if (!printedOrderBy.booleanValue()) {
                printedOrderBy.setTrue();
                result = result + "\nORDER BY\n\t";
            } else {
                result = result + ",\n\t";
            }
            if (comparator.getValue1() instanceof ElementValueComparator) {
                ElementValueComparator elementValueComparator = (ElementValueComparator)comparator.getValue1();
                prefix2 = this.getSchemaTable().getSchema();
                prefix2 = prefix2 + ALIAS_SEPARATOR;
                prefix2 = prefix2 + this.getSchemaTable().getTable();
                prefix2 = prefix2 + ALIAS_SEPARATOR;
                prefix2 = prefix2 + elementValueComparator.getPropertyKey();
                alias = counter == -1 ? sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getColumnNameAliasMap().get(prefix2)) : "a" + counter + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getColumnNameAliasMap().get(prefix2));
                result = result + " " + alias;
                if (elementValueComparator.getValueComparator() == Order.incr) {
                    result = result + " ASC";
                    continue;
                }
                if (elementValueComparator.getValueComparator() == Order.decr) {
                    result = result + " DESC";
                    continue;
                }
                throw new RuntimeException("Only handle Order.incr and Order.decr, not " + elementValueComparator.getValueComparator().toString());
            }
            if (comparator.getValue0() instanceof ElementValueTraversal && comparator.getValue1() instanceof Order) {
                ElementValueTraversal elementValueTraversal = (ElementValueTraversal)comparator.getValue0();
                prefix2 = String.valueOf(this.stepDepth);
                prefix2 = prefix2 + ALIAS_SEPARATOR;
                prefix2 = prefix2 + this.getSchemaTable().getSchema();
                prefix2 = prefix2 + ALIAS_SEPARATOR;
                prefix2 = prefix2 + this.getSchemaTable().getTable();
                prefix2 = prefix2 + ALIAS_SEPARATOR;
                prefix2 = prefix2 + elementValueTraversal.getPropertyKey();
                alias = counter == -1 ? sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getColumnNameAliasMap().get(prefix2)) : "a" + counter + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getColumnNameAliasMap().get(prefix2));
                result = result + " " + alias;
                if (comparator.getValue1() == Order.incr) {
                    result = result + " ASC";
                    continue;
                }
                if (comparator.getValue1() == Order.decr) {
                    result = result + " DESC";
                    continue;
                }
                throw new RuntimeException("Only handle Order.incr and Order.decr, not " + ((Comparator)comparator.getValue1()).toString());
            }
            Preconditions.checkState((((Traversal.Admin)comparator.getValue0()).getSteps().size() == 1 ? 1 : 0) != 0, (Object)"toOrderByClause expects a TraversalComparator to have exactly one step!");
            Preconditions.checkState((boolean)(((Traversal.Admin)comparator.getValue0()).getSteps().get(0) instanceof SelectOneStep), (Object)"toOrderByClause expects a TraversalComparator to have exactly one SelectOneStep!");
            SelectOneStep selectOneStep = (SelectOneStep)((Traversal.Admin)comparator.getValue0()).getSteps().get(0);
            Preconditions.checkState((selectOneStep.getScopeKeys().size() == 1 ? 1 : 0) != 0, (Object)"toOrderByClause expects the selectOneStep to have one scopeKey!");
            Preconditions.checkState((selectOneStep.getLocalChildren().size() == 1 ? 1 : 0) != 0, (Object)"toOrderByClause expects the selectOneStep to have one traversal!");
            Preconditions.checkState((boolean)(selectOneStep.getLocalChildren().get(0) instanceof ElementValueTraversal), (Object)"toOrderByClause expects the selectOneStep's traversal to be a ElementValueTraversal!");
            SchemaTableTree selectSchemaTableTree = this.findSelectSchemaTable((String)selectOneStep.getScopeKeys().iterator().next());
            ElementValueTraversal elementValueTraversal = (ElementValueTraversal)selectOneStep.getLocalChildren().get(0);
            if (selectSchemaTableTree.children.isEmpty()) {
                prefix = String.valueOf(selectSchemaTableTree.stepDepth);
                prefix = prefix + ALIAS_SEPARATOR;
            } else {
                prefix = String.valueOf(selectSchemaTableTree.stepDepth);
                prefix = prefix + ALIAS_SEPARATOR;
                prefix = prefix + selectSchemaTableTree.labels.iterator().next();
                prefix = prefix + ALIAS_SEPARATOR;
            }
            prefix = prefix + selectSchemaTableTree.getSchemaTable().getSchema();
            prefix = prefix + ALIAS_SEPARATOR;
            prefix = prefix + selectSchemaTableTree.getSchemaTable().getTable();
            prefix = prefix + ALIAS_SEPARATOR;
            prefix = prefix + elementValueTraversal.getPropertyKey();
            String alias2 = counter == -1 ? sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getColumnNameAliasMap().get(prefix)) : "a" + selectSchemaTableTree.stepDepth + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.getColumnNameAliasMap().get(prefix));
            result = result + " " + alias2;
            if (comparator.getValue1() == Order.incr) {
                result = result + " ASC";
                continue;
            }
            if (comparator.getValue1() == Order.decr) {
                result = result + " DESC";
                continue;
            }
            throw new RuntimeException("Only handle Order.incr and Order.decr, not " + comparator.toString());
        }
        return result;
    }

    private String toRangeClause(SqlgGraph sqlgGraph) {
        if (this.range != null) {
            return " " + sqlgGraph.getSqlDialect().getRangeClause(this.range);
        }
        return "";
    }

    private SchemaTableTree findSelectSchemaTable(String select) {
        return this.walkUp((Set<String> t) -> t.stream().filter(a -> a.endsWith("P~~~" + select)).findAny().isPresent());
    }

    private SchemaTableTree walkUp(Predicate<Set<String>> predicate) {
        if (predicate.test(this.labels)) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.walkUp(predicate);
        }
        return null;
    }

    public static List<LinkedList<SchemaTableTree>> splitIntoSubStacks(LinkedList<SchemaTableTree> distinctQueryStack) {
        ArrayList<LinkedList<SchemaTableTree>> result = new ArrayList<LinkedList<SchemaTableTree>>();
        LinkedList<SchemaTableTree> subList = new LinkedList<SchemaTableTree>();
        result.add(subList);
        HashSet<SchemaTable> alreadyVisited = new HashSet<SchemaTable>();
        for (SchemaTableTree schemaTableTree : distinctQueryStack) {
            if (!alreadyVisited.contains(schemaTableTree.getSchemaTable())) {
                alreadyVisited.add(schemaTableTree.getSchemaTable());
                subList.add(schemaTableTree);
                continue;
            }
            alreadyVisited.clear();
            subList = new LinkedList();
            subList.add(schemaTableTree);
            result.add(subList);
            alreadyVisited.add(schemaTableTree.getSchemaTable());
        }
        return result;
    }

    private static boolean duplicatesInStack(LinkedList<SchemaTableTree> distinctQueryStack) {
        HashSet<SchemaTable> alreadyVisited = new HashSet<SchemaTable>();
        for (SchemaTableTree schemaTableTree : distinctQueryStack) {
            if (!alreadyVisited.contains(schemaTableTree.getSchemaTable())) {
                alreadyVisited.add(schemaTableTree.getSchemaTable());
                continue;
            }
            return true;
        }
        return false;
    }

    private static String constructFromClause(SqlgGraph sqlgGraph, LinkedList<SchemaTableTree> distinctQueryStack, SchemaTableTree previousSchemaTableTree, SchemaTableTree nextSchemaTableTree) {
        SchemaTableTree firstSchemaTableTree = distinctQueryStack.getFirst();
        SchemaTableTree lastSchemaTableTree = distinctQueryStack.getLast();
        SchemaTable firstSchemaTable = firstSchemaTableTree.getSchemaTable();
        SchemaTable lastSchemaTable = lastSchemaTableTree.getSchemaTable();
        if (previousSchemaTableTree != null && previousSchemaTableTree.direction == Direction.BOTH) {
            throw new IllegalStateException("Direction should never be BOTH");
        }
        if (nextSchemaTableTree != null && nextSchemaTableTree.direction == Direction.BOTH) {
            throw new IllegalStateException("Direction should never be BOTH");
        }
        if (nextSchemaTableTree != null && lastSchemaTable.getTable().startsWith("V_") && nextSchemaTableTree.getSchemaTable().getTable().startsWith("V_")) {
            throw new IllegalStateException("Join can not be between 2 vertex tables!");
        }
        if (nextSchemaTableTree != null && lastSchemaTable.getTable().startsWith("E_") && nextSchemaTableTree.getSchemaTable().getTable().startsWith("E_")) {
            throw new IllegalStateException("Join can not be between 2 edge tables!");
        }
        if (previousSchemaTableTree != null && firstSchemaTable.getTable().startsWith("V_") && previousSchemaTableTree.getSchemaTable().getTable().startsWith("V_")) {
            throw new IllegalStateException("Join can not be between 2 vertex tables!");
        }
        if (previousSchemaTableTree != null && firstSchemaTable.getTable().startsWith("E_") && previousSchemaTableTree.getSchemaTable().getTable().startsWith("E_")) {
            throw new IllegalStateException("Join can not be between 2 edge tables!");
        }
        ColumnList columnList = new ColumnList(sqlgGraph);
        boolean printedId = false;
        if (previousSchemaTableTree != null && firstSchemaTable.getTable().startsWith("E_")) {
            if (!previousSchemaTableTree.getSchemaTable().getTable().startsWith("V_")) {
                throw new IllegalStateException("Expected table to start with V_");
            }
            String previousRawLabel = previousSchemaTableTree.getSchemaTable().getTable().substring("V_".length());
            if (firstSchemaTableTree.direction == Direction.OUT) {
                columnList.add(firstSchemaTable, previousSchemaTableTree.getSchemaTable().getSchema() + "." + previousRawLabel + "__O", previousSchemaTableTree.stepDepth, firstSchemaTableTree.calculatedAliasVertexForeignKeyColumnEnd(previousSchemaTableTree, firstSchemaTableTree.direction));
            } else {
                columnList.add(firstSchemaTable, previousSchemaTableTree.getSchemaTable().getSchema() + "." + previousRawLabel + "__I", previousSchemaTableTree.stepDepth, firstSchemaTableTree.calculatedAliasVertexForeignKeyColumnEnd(previousSchemaTableTree, firstSchemaTableTree.direction));
            }
        } else if (previousSchemaTableTree != null && firstSchemaTable.getTable().startsWith("V_")) {
            columnList.add(firstSchemaTable, "ID", firstSchemaTableTree.stepDepth, firstSchemaTableTree.calculatedAliasId());
            boolean bl = printedId = firstSchemaTable == lastSchemaTable;
        }
        if (nextSchemaTableTree != null && lastSchemaTable.getTable().startsWith("E_")) {
            Preconditions.checkState((boolean)nextSchemaTableTree.getSchemaTable().getTable().startsWith("V_"), (String)"Expected table to start with %s", (Object[])new Object[]{"V_"});
            String nextRawLabel = nextSchemaTableTree.getSchemaTable().getTable().substring("V_".length());
            if (nextSchemaTableTree.direction == Direction.OUT) {
                if (nextSchemaTableTree.isEdgeVertexStep()) {
                    columnList.add(lastSchemaTable, nextSchemaTableTree.getSchemaTable().getSchema() + "." + nextRawLabel + "__O", nextSchemaTableTree.stepDepth, lastSchemaTable.getSchema() + "." + lastSchemaTable.getTable() + "." + nextSchemaTableTree.getSchemaTable().getSchema() + "." + nextRawLabel + "__O");
                    SchemaTableTree.constructAllLabeledFromClause(distinctQueryStack, columnList);
                } else {
                    columnList.add(lastSchemaTable, nextSchemaTableTree.getSchemaTable().getSchema() + "." + nextRawLabel + "__I", nextSchemaTableTree.stepDepth, lastSchemaTable.getSchema() + "." + lastSchemaTable.getTable() + "." + nextSchemaTableTree.getSchemaTable().getSchema() + "." + nextRawLabel + "__I");
                    SchemaTableTree.constructAllLabeledFromClause(distinctQueryStack, columnList);
                    SchemaTableTree.constructEmitEdgeIdFromClause(distinctQueryStack, columnList);
                }
            } else if (nextSchemaTableTree.isEdgeVertexStep()) {
                columnList.add(lastSchemaTable, nextSchemaTableTree.getSchemaTable().getSchema() + "." + nextRawLabel + "__I", nextSchemaTableTree.stepDepth, lastSchemaTable.getSchema() + "." + lastSchemaTable.getTable() + "." + nextSchemaTableTree.getSchemaTable().getSchema() + "." + nextRawLabel + "__I");
                SchemaTableTree.constructAllLabeledFromClause(distinctQueryStack, columnList);
            } else {
                columnList.add(lastSchemaTable, nextSchemaTableTree.getSchemaTable().getSchema() + "." + nextRawLabel + "__O", nextSchemaTableTree.stepDepth, lastSchemaTable.getSchema() + "." + lastSchemaTable.getTable() + "." + nextSchemaTableTree.getSchemaTable().getSchema() + "." + nextRawLabel + "__O");
                SchemaTableTree.constructAllLabeledFromClause(distinctQueryStack, columnList);
                SchemaTableTree.constructEmitEdgeIdFromClause(distinctQueryStack, columnList);
            }
        } else if (nextSchemaTableTree != null && lastSchemaTable.getTable().startsWith("V_")) {
            columnList.add(lastSchemaTable, "ID", nextSchemaTableTree.stepDepth, lastSchemaTable.getSchema() + "." + lastSchemaTable.getTable() + "." + "ID");
            SchemaTableTree.constructAllLabeledFromClause(distinctQueryStack, columnList);
            boolean bl = printedId = firstSchemaTable == lastSchemaTable;
        }
        if (nextSchemaTableTree == null) {
            if (!printedId) {
                SchemaTableTree.printIDFromClauseFor(lastSchemaTableTree, columnList);
            }
            SchemaTableTree.printFromClauseFor(lastSchemaTableTree, columnList);
            if (lastSchemaTableTree.getSchemaTable().isEdgeTable()) {
                SchemaTableTree.printEdgeInOutVertexIdFromClauseFor(sqlgGraph, firstSchemaTableTree, lastSchemaTableTree, columnList);
            }
            SchemaTableTree.constructAllLabeledFromClause(distinctQueryStack, columnList);
            SchemaTableTree.constructEmitFromClause(distinctQueryStack, columnList);
        }
        return columnList.toString();
    }

    private String printLabeledOuterFromClause(String sql, int counter, Map<String, String> columnNameAliasMapCopy) {
        sql = sql + " a" + counter + "." + this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.labeledMappedAliasIdForOuterFromClause(columnNameAliasMapCopy));
        Map<String, PropertyType> propertyTypeMap = this.getFilteredAllTables().get(this.getSchemaTable().toString());
        if (!propertyTypeMap.isEmpty()) {
            sql = sql + ", ";
        }
        sql = this.printLabeledOuterFromClauseFor(sql, counter, columnNameAliasMapCopy);
        if (this.getSchemaTable().isEdgeTable()) {
            sql = sql + ", ";
            sql = this.printLabeledEdgeInOutVertexIdOuterFromClauseFor(sql, counter, columnNameAliasMapCopy);
        }
        return sql;
    }

    private static void constructAllLabeledFromClause(LinkedList<SchemaTableTree> distinctQueryStack, ColumnList cols) {
        List labeled = distinctQueryStack.stream().filter(d -> !d.getLabels().isEmpty()).collect(Collectors.toList());
        for (SchemaTableTree schemaTableTree : labeled) {
            SchemaTableTree.printLabeledIDFromClauseFor(schemaTableTree, cols);
            SchemaTableTree.printLabeledFromClauseFor(schemaTableTree, cols);
            if (!schemaTableTree.getSchemaTable().isEdgeTable()) continue;
            schemaTableTree.printLabeledEdgeInOutVertexIdFromClauseFor(cols);
        }
    }

    private static void constructEmitEdgeIdFromClause(LinkedList<SchemaTableTree> distinctQueryStack, ColumnList cols) {
        List emitted = distinctQueryStack.stream().filter(d -> d.getSchemaTable().isEdgeTable() && d.isEmit()).collect(Collectors.toList());
        for (SchemaTableTree schemaTableTree : emitted) {
            SchemaTableTree.printEdgeId(schemaTableTree, cols);
        }
    }

    private static void constructEmitFromClause(LinkedList<SchemaTableTree> distinctQueryStack, ColumnList cols) {
        int count = 1;
        for (SchemaTableTree schemaTableTree : distinctQueryStack) {
            if (count > 1 && !schemaTableTree.getSchemaTable().isEdgeTable() && schemaTableTree.isEmit()) {
                SchemaTableTree.printEdgeId(schemaTableTree.parent, cols);
            }
            ++count;
        }
    }

    private static void printEdgeId(SchemaTableTree schemaTableTree, ColumnList cols) {
        Preconditions.checkArgument((boolean)schemaTableTree.getSchemaTable().isEdgeTable());
        cols.add(schemaTableTree, "ID", schemaTableTree.calculatedAliasId());
    }

    private static void printIDFromClauseFor(SchemaTableTree lastSchemaTableTree, ColumnList cols) {
        cols.add(lastSchemaTableTree, "ID", lastSchemaTableTree.calculatedAliasId());
    }

    private static void printFromClauseFor(SchemaTableTree lastSchemaTableTree, ColumnList cols) {
        Map<String, PropertyType> propertyTypeMap = lastSchemaTableTree.getFilteredAllTables().get(lastSchemaTableTree.getSchemaTable().toString());
        for (Map.Entry<String, PropertyType> propertyTypeMapEntry : propertyTypeMap.entrySet()) {
            String alias = lastSchemaTableTree.calculateAliasPropertyName(propertyTypeMapEntry.getKey());
            cols.add(lastSchemaTableTree, propertyTypeMapEntry.getKey(), alias);
            for (String postFix : propertyTypeMapEntry.getValue().getPostFixes()) {
                alias = lastSchemaTableTree.calculateAliasPropertyName(propertyTypeMapEntry.getKey() + postFix);
                cols.add(lastSchemaTableTree, propertyTypeMapEntry.getKey() + postFix, alias);
            }
        }
    }

    private String printLabeledOuterFromClauseFor(String sql, int counter, Map<String, String> columnNameAliasMapCopy) {
        Map<String, PropertyType> propertyTypeMap = this.getFilteredAllTables().get(this.getSchemaTable().toString());
        int count = 1;
        for (String propertyName : propertyTypeMap.keySet()) {
            sql = sql + " a" + counter + ".";
            sql = sql + this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.labeledMappedAliasPropertyNameForOuterFromClause(propertyName, columnNameAliasMapCopy));
            if (count++ >= propertyTypeMap.size()) continue;
            sql = sql + ", ";
        }
        return sql;
    }

    private static void printLabeledIDFromClauseFor(SchemaTableTree lastSchemaTableTree, ColumnList cols) {
        String alias = cols.getAlias(lastSchemaTableTree, "ID");
        if (alias == null) {
            alias = lastSchemaTableTree.calculateLabeledAliasId();
            cols.add(lastSchemaTableTree, "ID", alias);
        } else {
            lastSchemaTableTree.calculateLabeledAliasId(alias);
        }
    }

    private static void printLabeledFromClauseFor(SchemaTableTree lastSchemaTableTree, ColumnList cols) {
        Map<String, PropertyType> propertyTypeMap = lastSchemaTableTree.getFilteredAllTables().get(lastSchemaTableTree.getSchemaTable().toString());
        for (Map.Entry<String, PropertyType> propertyTypeMapEntry : propertyTypeMap.entrySet()) {
            String col = propertyTypeMapEntry.getKey();
            String alias = cols.getAlias(lastSchemaTableTree, col);
            if (alias == null) {
                alias = lastSchemaTableTree.calculateLabeledAliasPropertyName(propertyTypeMapEntry.getKey());
                cols.add(lastSchemaTableTree, col, alias);
            } else {
                lastSchemaTableTree.calculateLabeledAliasPropertyName(propertyTypeMapEntry.getKey(), alias);
            }
            for (String postFix : propertyTypeMapEntry.getValue().getPostFixes()) {
                col = propertyTypeMapEntry.getKey() + postFix;
                alias = cols.getAlias(lastSchemaTableTree, col);
                if (alias != null) continue;
                alias = lastSchemaTableTree.calculateAliasPropertyName(propertyTypeMapEntry.getKey() + postFix);
                cols.add(lastSchemaTableTree, col, alias);
            }
        }
    }

    private String printEdgeInOutVertexIdOuterFromClauseFor(String prepend, String sql, SchemaTableTree previousSchemaTableTree) {
        Preconditions.checkState((boolean)this.getSchemaTable().isEdgeTable());
        Set edgeForeignKeys = this.sqlgGraph.getTopology().getAllEdgeForeignKeys().get(this.getSchemaTable().toString()).stream().filter(foreignKeyName -> foreignKeyName.equals(previousSchemaTableTree.getSchemaTable().withOutPrefix().toString() + "__I") || foreignKeyName.equals(previousSchemaTableTree.getSchemaTable().withOutPrefix() + "__O")).collect(Collectors.toSet());
        for (String edgeForeignKey : edgeForeignKeys) {
            sql = sql + ", ";
            sql = sql + prepend;
            sql = sql + ".";
            sql = sql + this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.mappedAliasPropertyName(edgeForeignKey, this.getColumnNameAliasMap()));
        }
        return sql;
    }

    private static void printEdgeInOutVertexIdFromClauseFor(SqlgGraph sqlgGraph, SchemaTableTree firstSchemaTableTree, SchemaTableTree lastSchemaTableTree, ColumnList cols) {
        Preconditions.checkState((boolean)lastSchemaTableTree.getSchemaTable().isEdgeTable());
        Set<String> edgeForeignKeys = sqlgGraph.getTopology().getAllEdgeForeignKeys().get(lastSchemaTableTree.getSchemaTable().toString());
        for (String edgeForeignKey : edgeForeignKeys) {
            if (firstSchemaTableTree != null && firstSchemaTableTree.equals(lastSchemaTableTree) && firstSchemaTableTree.getDirection() == SchemaTableTree.getDirectionForForeignKey(edgeForeignKey)) continue;
            String alias = lastSchemaTableTree.calculateAliasPropertyName(edgeForeignKey);
            cols.add(lastSchemaTableTree, edgeForeignKey, alias);
        }
    }

    private static Direction getDirectionForForeignKey(String edgeForeignKey) {
        return edgeForeignKey.endsWith("__I") ? Direction.IN : Direction.OUT;
    }

    private String printLabeledEdgeInOutVertexIdOuterFromClauseFor(String sql, int counter, Map<String, String> columnNameAliasMapCopy) {
        Preconditions.checkState((boolean)this.getSchemaTable().isEdgeTable());
        Set<String> edgeForeignKeys = this.sqlgGraph.getTopology().getAllEdgeForeignKeys().get(this.getSchemaTable().toString());
        int propertyCount = 1;
        for (String edgeForeignKey : edgeForeignKeys) {
            sql = sql + " a" + counter + ".";
            sql = sql + this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.labeledMappedAliasPropertyNameForOuterFromClause(edgeForeignKey, columnNameAliasMapCopy));
            if (propertyCount++ >= edgeForeignKeys.size()) continue;
            sql = sql + ",\n\t";
        }
        return sql;
    }

    private void printLabeledEdgeInOutVertexIdFromClauseFor(ColumnList cols) {
        Preconditions.checkState((boolean)this.getSchemaTable().isEdgeTable());
        Set<String> edgeForeignKeys = this.sqlgGraph.getTopology().getAllEdgeForeignKeys().get(this.getSchemaTable().toString());
        for (String edgeForeignKey : edgeForeignKeys) {
            String alias = cols.getAlias(this.getSchemaTable(), edgeForeignKey, this.stepDepth);
            if (alias == null) {
                cols.add(this.getSchemaTable(), edgeForeignKey, this.stepDepth, this.calculateLabeledAliasPropertyName(edgeForeignKey));
                continue;
            }
            this.calculateLabeledAliasPropertyName(edgeForeignKey, alias);
        }
    }

    private String calculatedAliasId() {
        String result = this.stepDepth + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + "ID";
        String alias = this.rootAliasAndIncrement();
        this.getColumnNameAliasMap().put(result, alias);
        this.getAliasColumnNameMap().put(alias, result);
        return alias;
    }

    private String calculateLabeledAliasId() {
        String reducedLabels = this.reducedLabels();
        String result = this.stepDepth + ALIAS_SEPARATOR + reducedLabels + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + "ID";
        String alias = this.rootAliasAndIncrement();
        this.getColumnNameAliasMap().put(result, alias);
        this.getAliasColumnNameMap().put(alias, result);
        return alias;
    }

    private String calculateLabeledAliasId(String alias) {
        String reducedLabels = this.reducedLabels();
        String result = this.stepDepth + ALIAS_SEPARATOR + reducedLabels + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + "ID";
        this.getColumnNameAliasMap().put(result, alias);
        this.getAliasColumnNameMap().put(alias, result);
        return alias;
    }

    private String calculateLabeledAliasPropertyName(String propertyName) {
        String reducedLabels = this.reducedLabels();
        String result = this.stepDepth + ALIAS_SEPARATOR + reducedLabels + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + propertyName;
        String alias = this.rootAliasAndIncrement();
        this.getColumnNameAliasMap().put(result, alias);
        this.getAliasColumnNameMap().put(alias, result);
        return alias;
    }

    private String calculateLabeledAliasPropertyName(String propertyName, String alias) {
        String reducedLabels = this.reducedLabels();
        String result = this.stepDepth + ALIAS_SEPARATOR + reducedLabels + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + propertyName;
        this.getColumnNameAliasMap().put(result, alias);
        this.getAliasColumnNameMap().put(alias, result);
        return alias;
    }

    private String calculateAliasPropertyName(String propertyName) {
        String result = this.stepDepth + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + propertyName;
        String alias = this.rootAliasAndIncrement();
        this.getColumnNameAliasMap().put(result, alias);
        this.getAliasColumnNameMap().put(alias, result);
        return alias;
    }

    private String calculatedAliasVertexForeignKeyColumnEnd(SchemaTableTree previousSchemaTableTree, Direction direction) {
        String previousRawLabel = previousSchemaTableTree.getSchemaTable().getTable().substring("V_".length());
        String result = this.stepDepth + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + previousSchemaTableTree.getSchemaTable().getSchema() + "." + previousRawLabel + (direction == Direction.IN ? "__I" : "__O");
        String alias = this.rootAliasAndIncrement();
        this.getColumnNameAliasMap().put(result, alias);
        this.getAliasColumnNameMap().put(alias, result);
        return alias;
    }

    private String mappedAliasVertexForeignKeyColumnEnd(SchemaTableTree previousSchemaTableTree, Direction direction, String rawFromLabel) {
        String result = this.stepDepth + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + previousSchemaTableTree.getSchemaTable().getSchema() + "." + rawFromLabel + (direction == Direction.IN ? "__I" : "__O");
        return this.getColumnNameAliasMap().get(result);
    }

    private String labeledMappedAliasPropertyNameForOuterFromClause(String propertyName, Map<String, String> columnNameAliasMapCopy) {
        String reducedLabels = this.reducedLabels();
        String result = this.stepDepth + ALIAS_SEPARATOR + reducedLabels + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + propertyName;
        return columnNameAliasMapCopy.get(result);
    }

    private String labeledMappedAliasIdForOuterFromClause(Map<String, String> columnNameAliasMapCopy) {
        String reducedLabels = this.reducedLabels();
        String result = this.stepDepth + ALIAS_SEPARATOR + reducedLabels + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + "ID";
        return columnNameAliasMapCopy.get(result);
    }

    private Optional<String> mappedAliasIdForOuterFromClause(Map<String, String> columnNameAliasMap) {
        String result = this.stepDepth + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + "ID";
        return Optional.ofNullable(columnNameAliasMap.get(result));
    }

    private Optional<String> lastMappedAliasIdForOuterFrom(Map<String, String> columnNameAliasMapCopy) {
        String result = this.stepDepth + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + "ID";
        return Optional.ofNullable(columnNameAliasMapCopy.get(result));
    }

    private String mappedAliasPropertyName(String propertyName, Map<String, String> columnNameAliasMapCopy) {
        String result = this.stepDepth + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + propertyName;
        return columnNameAliasMapCopy.get(result);
    }

    private String lastMappedAliasId() {
        String result = this.stepDepth + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + "ID";
        return this.getColumnNameAliasMap().get(result);
    }

    public String labeledAliasId() {
        if (this.labeledAliasId == null) {
            String reducedLabels = this.reducedLabels();
            this.labeledAliasId = this.stepDepth + ALIAS_SEPARATOR + reducedLabels + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR + "ID";
        }
        return this.labeledAliasId;
    }

    private String rootAliasAndIncrement() {
        return "alias" + this.rootSchemaTableTree().rootAliasCounter++;
    }

    SchemaTableTree rootSchemaTableTree() {
        if (this.parent != null) {
            return this.parent.rootSchemaTableTree();
        }
        return this;
    }

    private String propertyNameFromLabeledAlias(String alias) {
        String reducedLabels = this.reducedLabels();
        int lengthToWack = (this.stepDepth + ALIAS_SEPARATOR + reducedLabels + ALIAS_SEPARATOR + this.getSchemaTable().getSchema() + ALIAS_SEPARATOR + this.getSchemaTable().getTable() + ALIAS_SEPARATOR).length();
        return alias.substring(lengthToWack);
    }

    private String reducedLabels() {
        if (this.reducedLabels == null) {
            this.reducedLabels = (String)this.getLabels().stream().reduce((a, b) -> a + ALIAS_SEPARATOR + b).get();
        }
        return this.reducedLabels;
    }

    private LinkedList<SchemaTableTree> constructQueryStackFromLeaf() {
        LinkedList<SchemaTableTree> queryCallStack = new LinkedList<SchemaTableTree>();
        SchemaTableTree node = this;
        while (node != null) {
            queryCallStack.add(0, node);
            node = node.parent;
        }
        return queryCallStack;
    }

    private static String constructJoinBetweenSchemaTables(SqlgGraph sqlgGraph, SchemaTableTree fromSchemaTableTree, SchemaTableTree labelToTraversTree) {
        return SchemaTableTree.constructJoinBetweenSchemaTables(sqlgGraph, fromSchemaTableTree, labelToTraversTree, false);
    }

    private static String constructJoinBetweenSchemaTables(SqlgGraph sqlgGraph, SchemaTableTree fromSchemaTableTree, SchemaTableTree labelToTraversTree, boolean leftJoin) {
        SchemaTable fromSchemaTable = fromSchemaTableTree.getSchemaTable();
        SchemaTable labelToTravers = labelToTraversTree.getSchemaTable();
        Preconditions.checkState((fromSchemaTable.isVertexTable() && !labelToTravers.isVertexTable() || !fromSchemaTable.isVertexTable() && labelToTravers.isVertexTable() ? 1 : 0) != 0);
        String rawLabel = fromSchemaTable.getTable().startsWith("V_") ? fromSchemaTable.getTable().substring("V_".length()) : fromSchemaTable.getTable();
        String rawLabelToTravers = labelToTravers.getTable().startsWith("V_") ? labelToTravers.getTable().substring("V_".length()) : labelToTravers.getTable();
        String joinSql = leftJoin ? " LEFT JOIN\n\t" : " INNER JOIN\n\t";
        if (fromSchemaTable.getTable().startsWith("V_")) {
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getTable());
            joinSql = joinSql + " ON ";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getTable());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID");
            joinSql = joinSql + " = ";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getTable());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getSchema() + "." + rawLabel + (labelToTraversTree.getDirection() == Direction.IN ? "__I" : "__O"));
        } else {
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getTable());
            joinSql = joinSql + " ON ";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getTable());
            joinSql = joinSql + ".";
            joinSql = labelToTraversTree.isEdgeVertexStep() ? joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema() + "." + rawLabelToTravers + (labelToTraversTree.getDirection() == Direction.OUT ? "__O" : "__I")) : joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema() + "." + rawLabelToTravers + (labelToTraversTree.getDirection() == Direction.OUT ? "__I" : "__O"));
            joinSql = joinSql + " = ";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getTable());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID");
        }
        return joinSql;
    }

    private static String appendToJoinBetweenSchemaTables(SqlgGraph sqlgGraph, SchemaTableTree fromSchemaTableTree, SchemaTableTree labelToTraversTree, boolean leftJoin) {
        SchemaTable fromSchemaTable = fromSchemaTableTree.getSchemaTable();
        SchemaTable labelToTravers = labelToTraversTree.getSchemaTable();
        Preconditions.checkState((fromSchemaTable.isVertexTable() && !labelToTravers.isVertexTable() || !fromSchemaTable.isVertexTable() && labelToTravers.isVertexTable() ? 1 : 0) != 0);
        String rawLabel = fromSchemaTable.getTable().startsWith("V_") ? fromSchemaTable.getTable().substring("V_".length()) : fromSchemaTable.getTable();
        String rawLabelToTravers = labelToTravers.getTable().startsWith("V_") ? labelToTravers.getTable().substring("V_".length()) : labelToTravers.getTable();
        String joinSql = " OR ";
        if (fromSchemaTable.getTable().startsWith("V_")) {
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getTable());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID");
            joinSql = joinSql + " = ";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getTable());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getSchema() + "." + rawLabel + (labelToTraversTree.getDirection() == Direction.IN ? "__I" : "__O"));
        } else {
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(fromSchemaTable.getTable());
            joinSql = joinSql + ".";
            joinSql = labelToTraversTree.isEdgeVertexStep() ? joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema() + "." + rawLabelToTravers + (labelToTraversTree.getDirection() == Direction.OUT ? "__O" : "__I")) : joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema() + "." + rawLabelToTravers + (labelToTraversTree.getDirection() == Direction.OUT ? "__I" : "__O"));
            joinSql = joinSql + " = ";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getSchema());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes(labelToTravers.getTable());
            joinSql = joinSql + ".";
            joinSql = joinSql + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID");
        }
        return joinSql;
    }

    void removeAllButDeepestAndAddCacheLeafNodes(int depth) {
        LinkedList<SchemaTableTree> queue = new LinkedList<SchemaTableTree>();
        queue.add(this);
        while (!queue.isEmpty()) {
            SchemaTableTree current = (SchemaTableTree)queue.remove();
            if (current.stepDepth < depth && current.children.isEmpty() && !current.isEmit() && !current.isOptionalLeftJoin()) {
                this.removeNode(current);
                continue;
            }
            queue.addAll(current.children);
            if (!(current.stepDepth == depth && current.children.isEmpty() || current.isEmit() && current.children.isEmpty()) && (!current.isOptionalLeftJoin() || !current.children.isEmpty())) continue;
            this.leafNodes.add(current);
        }
    }

    private void removeNode(SchemaTableTree node) {
        SchemaTableTree parent = node.parent;
        if (parent != null) {
            parent.children.remove(node);
            this.leafNodes.remove(node);
            if (parent.children.isEmpty()) {
                this.removeNode(parent);
            }
        }
    }

    boolean removeNodesInvalidatedByHas() {
        if (this.invalidateByHas(this)) {
            return true;
        }
        LinkedList<SchemaTableTree> queue = new LinkedList<SchemaTableTree>();
        queue.add(this);
        while (!queue.isEmpty()) {
            SchemaTableTree current = (SchemaTableTree)queue.remove();
            this.removeObsoleteHasContainers(current);
            if (this.invalidateByHas(current)) {
                this.removeNode(current);
                continue;
            }
            queue.addAll(current.children);
        }
        return false;
    }

    private void removeObsoleteHasContainers(SchemaTableTree schemaTableTree) {
        HashSet<HasContainer> toRemove = new HashSet<HasContainer>();
        for (HasContainer hasContainer : schemaTableTree.hasContainers) {
            if (!hasContainer.getKey().equals(T.label.getAccessor()) || !hasContainer.getBiPredicate().equals(Compare.eq)) continue;
            SchemaTable predicateSchemaTable = SchemaTable.from(this.sqlgGraph, hasContainer.getValue().toString());
            SchemaTable hasContainerLabelSchemaTable = schemaTableTree.getSchemaTable().getTable().startsWith("V_") ? SchemaTable.of(predicateSchemaTable.getSchema(), "V_" + predicateSchemaTable.getTable()) : SchemaTable.of(predicateSchemaTable.getSchema(), "E_" + predicateSchemaTable.getTable());
            if (!hasContainerLabelSchemaTable.toString().equals(schemaTableTree.getSchemaTable().toString())) continue;
            toRemove.add(hasContainer);
        }
        schemaTableTree.hasContainers.removeAll(toRemove);
    }

    private SchemaTable getHasContainerSchemaTable(SchemaTableTree schemaTableTree, SchemaTable predicateSchemaTable) {
        SchemaTable hasContainerLabelSchemaTable = schemaTableTree.getSchemaTable().getTable().startsWith("V_") ? SchemaTable.of(predicateSchemaTable.getSchema(), "V_" + predicateSchemaTable.getTable()) : SchemaTable.of(predicateSchemaTable.getSchema(), "E_" + predicateSchemaTable.getTable());
        return hasContainerLabelSchemaTable;
    }

    private SchemaTable getIDContainerSchemaTable(SchemaTableTree schemaTableTree, Object value) {
        if (value instanceof Long) {
            return schemaTableTree.getSchemaTable();
        }
        RecordId id = !(value instanceof RecordId) ? RecordId.from((Object)String.valueOf(value)) : (RecordId)value;
        return this.getHasContainerSchemaTable(schemaTableTree, id.getSchemaTable());
    }

    private boolean invalidateByHas(SchemaTableTree schemaTableTree) {
        for (HasContainer hasContainer : schemaTableTree.hasContainers) {
            SchemaTable hasContainerLabelSchemaTable;
            if (hasContainer.getKey().equals("~~TopologySelectionWithout~~") || hasContainer.getKey().equals("~~TopologySelectionFrom~~")) continue;
            if (hasContainer.getKey().equals(T.label.getAccessor())) {
                SchemaTable predicateSchemaTable = SchemaTable.from(this.sqlgGraph, hasContainer.getValue().toString());
                hasContainerLabelSchemaTable = this.getHasContainerSchemaTable(schemaTableTree, predicateSchemaTable);
                if (!hasContainer.getBiPredicate().equals(Compare.eq) || hasContainerLabelSchemaTable.toString().equals(schemaTableTree.getSchemaTable().toString())) continue;
                return true;
            }
            if (hasContainer.getKey().equals(T.id.getAccessor())) {
                if (hasContainer.getBiPredicate().equals(Compare.eq)) {
                    Object value = hasContainer.getValue();
                    hasContainerLabelSchemaTable = this.getIDContainerSchemaTable(schemaTableTree, value);
                    if (hasContainerLabelSchemaTable.equals(schemaTableTree.getSchemaTable())) continue;
                    return true;
                }
                if (!hasContainer.getBiPredicate().equals(Contains.within)) continue;
                Collection c = (Collection)hasContainer.getPredicate().getValue();
                Iterator it = c.iterator();
                LinkedList ok = new LinkedList();
                while (it.hasNext()) {
                    Object value = it.next();
                    SchemaTable hasContainerLabelSchemaTable2 = this.getIDContainerSchemaTable(schemaTableTree, value);
                    if (!hasContainerLabelSchemaTable2.equals(schemaTableTree.getSchemaTable())) continue;
                    ok.add(value);
                }
                if (ok.isEmpty()) {
                    return true;
                }
                hasContainer.getPredicate().setValue(ok);
                continue;
            }
            if (hasContainer.getBiPredicate() instanceof FullText && ((FullText)hasContainer.getBiPredicate()).getQuery() != null) {
                return false;
            }
            if (!this.getFilteredAllTables().get(schemaTableTree.getSchemaTable().toString()).containsKey(hasContainer.getKey())) {
                return true;
            }
            if (!this.hasEmptyWithin(hasContainer)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEmptyWithin(HasContainer hasContainer) {
        if (hasContainer.getBiPredicate() == Contains.within) {
            return ((Collection)hasContainer.getPredicate().getValue()).isEmpty();
        }
        return false;
    }

    public String toString() {
        return this.schemaTable.toString();
    }

    public String toTreeString() {
        StringBuilder result = new StringBuilder();
        this.internalToString(result);
        return result.toString();
    }

    private void internalToString(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append("\n");
        }
        for (int i = 0; i < this.stepDepth; ++i) {
            sb.append("\t");
        }
        sb.append(this.schemaTable.toString()).append(" ").append(this.stepDepth).append(" ").append(this.hasContainers.toString()).append(" ").append("Comparators = ").append(this.comparators.toString()).append(" ").append("Range = ").append(String.valueOf(this.range)).append(" ").append(this.direction != null ? this.direction.toString() : "").append(" ").append("isVertexStep = ").append(this.isEdgeVertexStep()).append(" isUntilFirst = ").append(this.isUntilFirst()).append(" labels = ").append(this.labels);
        for (SchemaTableTree child : this.children) {
            child.internalToString(sb);
        }
    }

    private SchemaTableTree getParent() {
        return this.parent;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public List<HasContainer> getHasContainers() {
        return this.hasContainers;
    }

    private List<org.javatuples.Pair<Traversal.Admin, Comparator>> getComparators() {
        return this.comparators;
    }

    public int getStepDepth() {
        return this.stepDepth;
    }

    public int getReplacedStepDepth() {
        return this.replacedStepDepth;
    }

    public int depth() {
        AtomicInteger depth = new AtomicInteger();
        this.walk(v -> {
            if (v.stepDepth > depth.get()) {
                depth.set(v.stepDepth);
            }
            return null;
        });
        return depth.get();
    }

    public int numberOfNodes() {
        AtomicInteger count = new AtomicInteger();
        this.walk(v -> {
            count.getAndIncrement();
            return null;
        });
        return count.get();
    }

    private void walk(Visitor v) {
        v.visit(this);
        this.children.forEach(c -> c.walk(v));
    }

    public SchemaTableTree schemaTableAtDepth(int depth, int number) {
        AtomicInteger count = new AtomicInteger();
        AtomicInteger depthCache = new AtomicInteger(depth);
        return this.walkWithExit(v -> {
            if (depthCache.get() != v.stepDepth) {
                depthCache.set(v.stepDepth);
                count.set(0);
            }
            return count.getAndIncrement() == number && v.stepDepth == depth;
        });
    }

    private SchemaTableTree walkWithExit(Visitor<Boolean> v) {
        if (!v.visit(this).booleanValue() && !this.children.isEmpty()) {
            return this.children.get(0).walkWithExit(v);
        }
        return this;
    }

    public int hashCode() {
        if (this.parent != null) {
            if (this.direction == null) {
                return (this.schemaTable.toString() + this.parent.toString()).hashCode();
            }
            return (this.schemaTable.toString() + this.direction.name() + this.parent.toString()).hashCode();
        }
        if (this.direction == null) {
            return this.schemaTable.toString().hashCode();
        }
        return (this.schemaTable.toString() + this.direction.name()).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SchemaTableTree)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        SchemaTableTree other = (SchemaTableTree)o;
        if (this.direction != other.direction) {
            return false;
        }
        if (this.parent != null && other.parent == null) {
            return false;
        }
        if (this.parent == null && other.parent != null) {
            return false;
        }
        if (this.parent == null && other.parent == null) {
            return this.schemaTable.equals(other.parent);
        }
        return this.parent.equals(other.parent) && this.schemaTable.equals(other.schemaTable);
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public Set<String> getRealLabels() {
        if (this.realLabels == null) {
            this.realLabels = new HashSet<String>();
            for (String label : this.labels) {
                if (label.contains("P~~~")) {
                    this.realLabels.add(label.substring(label.indexOf("P~~~") + "P~~~".length()));
                    continue;
                }
                if (label.contains("E~~~")) {
                    this.realLabels.add(label.substring(label.indexOf("E~~~") + "E~~~".length()));
                    continue;
                }
                throw new IllegalStateException("label must contain P~~~ or E~~~");
            }
        }
        return this.realLabels;
    }

    private boolean isEdgeVertexStep() {
        return this.stepType == STEP_TYPE.EDGE_VERTEX_STEP;
    }

    private boolean isVertexStep() {
        return this.stepType == STEP_TYPE.VERTEX_STEP;
    }

    void setStepType(STEP_TYPE stepType) {
        this.stepType = stepType;
    }

    public boolean isUntilFirst() {
        return this.untilFirst;
    }

    void setUntilFirst(boolean untilFirst) {
        this.untilFirst = untilFirst;
    }

    int getTmpTableAliasCounter() {
        return this.tmpTableAliasCounter;
    }

    public void loadProperty(ResultSet resultSet, SqlgElement sqlgElement) throws SQLException {
        for (int ix = 1; ix <= resultSet.getMetaData().getColumnCount(); ++ix) {
            String columnName = resultSet.getMetaData().getColumnLabel(ix);
            Pair<String, PropertyType> p = this.getColumnNamePropertyName().get(columnName);
            if (p == null) continue;
            String propertyName = (String)p.getKey();
            PropertyType propertyType = (PropertyType)((Object)p.getValue());
            if (propertyName.endsWith("__I")) {
                ((SqlgEdge)sqlgElement).loadInVertex(resultSet, propertyName, ix);
                continue;
            }
            if (propertyName.endsWith("__O")) {
                ((SqlgEdge)sqlgElement).loadOutVertex(resultSet, propertyName, ix);
                continue;
            }
            sqlgElement.loadProperty(resultSet, propertyName, ix, this.getColumnNameAliasMap(), this.stepDepth, propertyType);
        }
    }

    public void clearColumnNamePropertNameMap() {
        if (this.columnNamePropertyName != null) {
            this.columnNamePropertyName.clear();
            this.columnNamePropertyName = null;
        }
    }

    public String idProperty() {
        if (this.idProperty == null) {
            this.idProperty = this.stepDepth + ALIAS_SEPARATOR + this.schemaTable.getSchema() + ALIAS_SEPARATOR + this.schemaTable.getTable() + ALIAS_SEPARATOR + "ID";
        }
        return this.idProperty;
    }

    public boolean isLocalStep() {
        return this.localStep;
    }

    void setLocalStep(boolean localStep) {
        this.localStep = localStep;
    }

    public boolean isFakeEmit() {
        return this.fakeEmit;
    }

    public void setFakeEmit(boolean fakeEmit) {
        this.fakeEmit = fakeEmit;
    }

    static enum STEP_TYPE {
        GRAPH_STEP,
        VERTEX_STEP,
        EDGE_VERTEX_STEP;

    }
}

