/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.parse;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.T;
import org.umlg.sqlg.predicate.FullText;
import org.umlg.sqlg.predicate.Text;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.util.SqlgUtil;

public class WhereClause {
    public static final String LIKE = " like ?";
    public static final String NOT_LIKE = " not like ?";
    private P<?> p;

    private WhereClause(P<?> p) {
        this.p = p;
    }

    public static WhereClause from(P<?> p) {
        return new WhereClause(p);
    }

    public String toSql(SqlgGraph sqlgGraph, SchemaTableTree schemaTableTree, HasContainer hasContainer) {
        String result = "";
        String prefix = sqlgGraph.getSqlDialect().maybeWrapInQoutes(schemaTableTree.getSchemaTable().getSchema());
        prefix = prefix + ".";
        prefix = prefix + sqlgGraph.getSqlDialect().maybeWrapInQoutes(schemaTableTree.getSchemaTable().getTable());
        if (this.p.getBiPredicate() instanceof Compare) {
            result = hasContainer.getKey().equals(T.id.getAccessor()) ? result + prefix + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID") : result + prefix + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(hasContainer.getKey());
            result = result + WhereClause.compareToSql((Compare)this.p.getBiPredicate());
            return result;
        }
        if (!(sqlgGraph.getSqlDialect().supportsBulkWithinOut() && SqlgUtil.isBulkWithinAndOut(sqlgGraph, hasContainer) || !(this.p.getBiPredicate() instanceof Contains))) {
            result = hasContainer.getKey().equals(T.id.getAccessor()) ? result + prefix + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID") : result + prefix + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(hasContainer.getKey());
            result = result + WhereClause.containsToSql((Contains)this.p.getBiPredicate(), ((Collection)this.p.getValue()).size());
            return result;
        }
        if (sqlgGraph.getSqlDialect().supportsBulkWithinOut() && this.p.getBiPredicate() instanceof Contains) {
            result = result + " tmp" + (schemaTableTree.rootSchemaTableTree().getTmpTableAliasCounter() - 1);
            result = result + " .without IS NULL";
            return result;
        }
        if (this.p instanceof AndP) {
            AndP andP = (AndP)this.p;
            Preconditions.checkState((andP.getPredicates().size() == 2 ? 1 : 0) != 0, (Object)"Only handling AndP with 2 predicates!");
            P p1 = (P)andP.getPredicates().get(0);
            String key = hasContainer.getKey().equals(T.id.getAccessor()) ? result + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID") : result + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(hasContainer.getKey());
            result = result + prefix + key + WhereClause.compareToSql((Compare)p1.getBiPredicate());
            P p2 = (P)andP.getPredicates().get(1);
            result = result + " and " + prefix + key + WhereClause.compareToSql((Compare)p2.getBiPredicate());
            return result;
        }
        if (this.p instanceof OrP) {
            OrP orP = (OrP)this.p;
            Preconditions.checkState((orP.getPredicates().size() == 2 ? 1 : 0) != 0, (Object)"Only handling OrP with 2 predicates!");
            P p1 = (P)orP.getPredicates().get(0);
            String key = hasContainer.getKey().equals(T.id.getAccessor()) ? result + sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID") : result + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(hasContainer.getKey());
            result = result + prefix + key + WhereClause.compareToSql((Compare)p1.getBiPredicate());
            P p2 = (P)orP.getPredicates().get(1);
            result = result + " or " + prefix + key + WhereClause.compareToSql((Compare)p2.getBiPredicate());
            return result;
        }
        if (this.p.getBiPredicate() instanceof Text) {
            prefix = prefix + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(hasContainer.getKey());
            result = result + WhereClause.textToSql(sqlgGraph.getSqlDialect(), prefix, (Text)this.p.getBiPredicate());
            return result;
        }
        if (this.p.getBiPredicate() instanceof FullText) {
            prefix = prefix + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes(hasContainer.getKey());
            FullText ft = (FullText)this.p.getBiPredicate();
            result = result + sqlgGraph.getSqlDialect().getFullTextQueryText(ft, prefix);
            return result;
        }
        throw new IllegalStateException("Unhandled BiPredicate " + this.p.getBiPredicate().toString());
    }

    private static String compareToSql(Compare compare) {
        switch (compare) {
            case eq: {
                return " = ?";
            }
            case neq: {
                return " <> ?";
            }
            case gt: {
                return " > ?";
            }
            case gte: {
                return " >= ?";
            }
            case lt: {
                return " < ?";
            }
            case lte: {
                return " <= ?";
            }
        }
        throw new RuntimeException("Unknown Compare " + compare.name());
    }

    private static String containsToSql(Contains contains, int size) {
        String result;
        block10: {
            block9: {
                if (size != 1) break block9;
                switch (contains) {
                    case within: {
                        result = " = ?";
                        break block10;
                    }
                    case without: {
                        result = " <> ?";
                        break block10;
                    }
                    default: {
                        throw new RuntimeException("Unknown Contains" + contains.name());
                    }
                }
            }
            switch (contains) {
                case within: {
                    result = " in (";
                    break;
                }
                case without: {
                    result = " not in (";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Contains" + contains.name());
                }
            }
            for (int i = 0; i < size; ++i) {
                result = result + "?";
                if (i >= size - 1 || size <= 1) continue;
                result = result + ", ";
            }
            result = result + ")";
        }
        return result;
    }

    private static String textToSql(SqlDialect sqlDialect, String prefix, Text text) {
        String result;
        switch (text) {
            case contains: {
                result = LIKE;
                break;
            }
            case ncontains: {
                result = NOT_LIKE;
                break;
            }
            case containsCIS: {
                if (!sqlDialect.supportsILike()) {
                    prefix = "lower(" + prefix + ")";
                }
                if (sqlDialect.supportsILike()) {
                    result = " ilike ?";
                    break;
                }
                result = " like lower(?)";
                break;
            }
            case ncontainsCIS: {
                if (!sqlDialect.supportsILike()) {
                    prefix = "lower(" + prefix + ")";
                }
                if (sqlDialect.supportsILike()) {
                    result = " not ilike ?";
                    break;
                }
                result = " not like lower(?)";
                break;
            }
            case startsWith: {
                result = LIKE;
                break;
            }
            case nstartsWith: {
                result = NOT_LIKE;
                break;
            }
            case endsWith: {
                result = LIKE;
                break;
            }
            case nendsWith: {
                result = NOT_LIKE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown Contains " + text.name());
            }
        }
        return prefix + result;
    }

    public void putKeyValueMap(HasContainer hasContainer, Multimap<String, Object> keyValueMap) {
        if (this.p instanceof OrP) {
            OrP orP = (OrP)this.p;
            Preconditions.checkState((orP.getPredicates().size() == 2 ? 1 : 0) != 0, (Object)"Only handling OrP with 2 predicates!");
            P p1 = (P)orP.getPredicates().get(0);
            P p2 = (P)orP.getPredicates().get(1);
            keyValueMap.put((Object)hasContainer.getKey(), p1.getValue());
            keyValueMap.put((Object)hasContainer.getKey(), p2.getValue());
        } else if (this.p instanceof AndP) {
            AndP andP = (AndP)this.p;
            Preconditions.checkState((andP.getPredicates().size() == 2 ? 1 : 0) != 0, (Object)"Only handling AndP with 2 predicates!");
            P p1 = (P)andP.getPredicates().get(0);
            P p2 = (P)andP.getPredicates().get(1);
            keyValueMap.put((Object)hasContainer.getKey(), p1.getValue());
            keyValueMap.put((Object)hasContainer.getKey(), p2.getValue());
        } else if (this.p.getBiPredicate() == Contains.within || this.p.getBiPredicate() == Contains.without) {
            Collection values = (Collection)hasContainer.getValue();
            for (Object value : values) {
                if (hasContainer.getKey().equals(T.id.getAccessor())) {
                    keyValueMap.put((Object)"ID", value);
                    continue;
                }
                keyValueMap.put((Object)hasContainer.getKey(), value);
            }
        } else if (this.p.getBiPredicate() == Text.contains || this.p.getBiPredicate() == Text.ncontains || this.p.getBiPredicate() == Text.containsCIS || this.p.getBiPredicate() == Text.ncontainsCIS) {
            keyValueMap.put((Object)hasContainer.getKey(), (Object)("%" + hasContainer.getValue() + "%"));
        } else if (this.p.getBiPredicate() == Text.startsWith || this.p.getBiPredicate() == Text.nstartsWith) {
            keyValueMap.put((Object)hasContainer.getKey(), (Object)(hasContainer.getValue() + "%"));
        } else if (this.p.getBiPredicate() == Text.endsWith || this.p.getBiPredicate() == Text.nendsWith) {
            keyValueMap.put((Object)hasContainer.getKey(), (Object)("%" + hasContainer.getValue()));
        } else {
            keyValueMap.put((Object)hasContainer.getKey(), hasContainer.getValue());
        }
    }
}

