/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.strategy;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ElementValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.LoopTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.ChooseStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.CyclicPathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.SimplePathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaCollectingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SackStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SackValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.TreeSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.predicate.FullText;
import org.umlg.sqlg.predicate.Text;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.strategy.SqlgGraphStepCompiled;
import org.umlg.sqlg.strategy.SqlgGraphStepStrategy;
import org.umlg.sqlg.strategy.SqlgStep;
import org.umlg.sqlg.strategy.SqlgVertexStepStrategy;
import org.umlg.sqlg.structure.SqlgGraph;

public abstract class BaseSqlgStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    protected Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String PATH_LABEL_SUFFIX = "P~~~";
    public static final String EMIT_LABEL_SUFFIX = "E~~~";
    private static final String SQLG_PATH_FAKE_LABEL = "sqlgPathFakeLabel";
    private static final List<BiPredicate> SUPPORTED_BI_PREDICATE = Arrays.asList(Compare.eq, Compare.neq, Compare.gt, Compare.gte, Compare.lt, Compare.lte);
    protected static List<Class> UNOPTIMIZABLE_STEPS = Arrays.asList(Order.class, LambdaCollectingBarrierStep.class, SackValueStep.class, SackStep.class);

    BaseSqlgStrategy() {
    }

    protected abstract void replaceStepInTraversal(Step var1, SqlgStep var2, Traversal.Admin<?, ?> var3);

    protected abstract void doLastEntry(Step var1, ListIterator<Step> var2, Traversal.Admin<?, ?> var3, ReplacedStep<?, ?> var4, SqlgStep var5, int var6);

    protected abstract boolean isReplaceableStep(Class<? extends Step> var1, boolean var2);

    protected abstract SqlgStep constructSqlgStep(Traversal.Admin<?, ?> var1, Step var2);

    void combineSteps(Traversal.Admin<?, ?> traversal, List<Step> steps, ListIterator<Step> stepIterator) {
        SqlgStep sqlgStep = null;
        Step previous = null;
        ReplacedStep lastReplacedStep = null;
        int pathCount = 0;
        boolean alreadyReplacedGraphStep = false;
        boolean chooseStepAdded = false;
        MutableInt repeatStepsAdded = new MutableInt(0);
        while (stepIterator.hasNext()) {
            boolean doLastEntry;
            Step step = stepIterator.next();
            if (step instanceof RepeatStep) {
                try {
                    boolean repeatStepAdded = this.flattenRepeatStep(steps, stepIterator, (RepeatStep)step, traversal, repeatStepsAdded);
                    if (!(this instanceof SqlgVertexStepStrategy) || repeatStepAdded) continue;
                    traversal.addStep((Step)new IdentityStep(traversal));
                    continue;
                }
                catch (UnoptimizableException e) {
                    lastReplacedStep.addLabel(pathCount + PATH_LABEL_SUFFIX + SQLG_PATH_FAKE_LABEL);
                    return;
                }
            }
            if (step instanceof ChooseStep) {
                try {
                    chooseStepAdded = this.flattenChooseStep(steps, stepIterator, (ChooseStep)step, traversal);
                    continue;
                }
                catch (UnoptimizableException e) {
                    return;
                }
            }
            if (this.isReplaceableStep(step.getClass(), alreadyReplacedGraphStep)) {
                boolean precedesPathStep;
                ReplacedStep previousReplacedStep;
                List previousReplacedSteps;
                boolean emit = false;
                boolean emitFirst = false;
                boolean untilFirst = false;
                HashSet labels = new HashSet();
                if (repeatStepsAdded.getValue() > 0) {
                    repeatStepsAdded.decrement();
                    RepeatStep repeatStep = (RepeatStep)step.getTraversal().getParent();
                    emit = repeatStep.getEmitTraversal() != null;
                    emitFirst = repeatStep.emitFirst;
                    untilFirst = repeatStep.untilFirst;
                    labels.addAll(repeatStep.getLabels());
                }
                ReplacedStep replacedStep = ReplacedStep.from(((SqlgGraph)traversal.getGraph().get()).getTopology(), (AbstractStep)step, ++pathCount);
                if (sqlgStep == null || step instanceof GraphStep) {
                    sqlgStep = this.constructSqlgStep(traversal, step);
                    if (previous != null) {
                        sqlgStep.setPreviousStep(previous);
                    }
                    boolean bl = alreadyReplacedGraphStep = alreadyReplacedGraphStep || step instanceof GraphStep;
                    if (this instanceof SqlgGraphStepStrategy) {
                        sqlgStep.addReplacedStep(replacedStep);
                    } else if (this instanceof SqlgVertexStepStrategy) {
                        previous = step;
                    } else {
                        throw new IllegalStateException("Unknown strategy " + ((Object)((Object)this)).getClass().getName());
                    }
                    this.replaceStepInTraversal(step, sqlgStep, traversal);
                    if (sqlgStep instanceof SqlgGraphStepCompiled && ((SqlgGraphStepCompiled)sqlgStep).getIds().length > 0) {
                        this.addHasContainerForIds((SqlgGraphStepCompiled)sqlgStep, replacedStep);
                    }
                    this.collectHasSteps(stepIterator, traversal, replacedStep, pathCount);
                }
                if (emit) {
                    previousReplacedSteps = sqlgStep.getReplacedSteps();
                    if (emitFirst) {
                        previousReplacedStep = previousReplacedSteps.get(previousReplacedSteps.size() - 1);
                        --pathCount;
                    } else {
                        previousReplacedStep = replacedStep;
                    }
                    previousReplacedStep.setEmit(true);
                    previousReplacedStep.setUntilFirst(untilFirst);
                    if (labels.isEmpty()) {
                        previousReplacedStep.addLabel(pathCount + EMIT_LABEL_SUFFIX + SQLG_PATH_FAKE_LABEL);
                    } else {
                        for (String label : labels) {
                            previousReplacedStep.addLabel(pathCount + EMIT_LABEL_SUFFIX + label);
                        }
                    }
                    previousReplacedStep.getLabels().remove(pathCount + PATH_LABEL_SUFFIX + SQLG_PATH_FAKE_LABEL);
                    if (emitFirst) {
                        ++pathCount;
                    }
                }
                if (chooseStepAdded) {
                    previousReplacedSteps = sqlgStep.getReplacedSteps();
                    previousReplacedStep = previousReplacedSteps.get(previousReplacedSteps.size() - 1);
                    previousReplacedStep.setLeftJoin(true);
                    previousReplacedStep.getLabels().remove(--pathCount + PATH_LABEL_SUFFIX + SQLG_PATH_FAKE_LABEL);
                    previousReplacedStep.addLabel(pathCount + PATH_LABEL_SUFFIX + SQLG_PATH_FAKE_LABEL);
                    ++pathCount;
                }
                if (replacedStep.getLabels().isEmpty() && (precedesPathStep = this.precedesPathOrTreeStep(traversal))) {
                    replacedStep.addLabel(pathCount + PATH_LABEL_SUFFIX + SQLG_PATH_FAKE_LABEL);
                }
                if (previous != null && !(step instanceof GraphStep)) {
                    sqlgStep.addReplacedStep(replacedStep);
                    int index = TraversalHelper.stepIndex((Step)step, traversal);
                    if (index != -1) {
                        traversal.removeStep(step);
                    }
                    this.collectHasSteps(stepIterator, traversal, replacedStep, pathCount);
                }
                previous = step;
                lastReplacedStep = replacedStep;
                chooseStepAdded = false;
                continue;
            }
            if (lastReplacedStep == null) break;
            boolean bl = doLastEntry = step instanceof OrderGlobalStep || step instanceof RangeGlobalStep;
            if (!doLastEntry && (step instanceof SelectStep || step instanceof SelectOneStep || step instanceof EmptyStep) && stepIterator.hasNext()) {
                Step nextStep = stepIterator.next();
                doLastEntry = nextStep instanceof OrderGlobalStep || nextStep instanceof RangeGlobalStep;
                stepIterator.previous();
            }
            if (!doLastEntry) break;
            this.doLastEntry(step, stepIterator, traversal, lastReplacedStep, sqlgStep, pathCount);
            break;
        }
        if (lastReplacedStep != null && !lastReplacedStep.isEmit() && lastReplacedStep.getLabels().isEmpty()) {
            lastReplacedStep.addLabel(pathCount + PATH_LABEL_SUFFIX + SQLG_PATH_FAKE_LABEL);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean unoptimizableChooseStep(List<Step> steps, int index) {
        List<Step> toCome = steps.subList(index, steps.size());
        Step step = toCome.get(0);
        Preconditions.checkState((boolean)(step instanceof ChooseStep), (Object)("Expected ChooseStep, found " + step.getClass().getSimpleName() + " instead. BUG!"));
        ChooseStep chooseStep = (ChooseStep)step;
        List traversalAdmins = chooseStep.getGlobalChildren();
        if (traversalAdmins.size() != 2) {
            return true;
        }
        Traversal.Admin predicate = (Traversal.Admin)chooseStep.getLocalChildren().get(0);
        ArrayList predicateSteps = new ArrayList(predicate.getSteps());
        if (predicateSteps.stream().anyMatch(s -> s instanceof OrderGlobalStep)) {
            return true;
        }
        predicateSteps.remove(predicate.getSteps().size() - 1);
        Traversal.Admin globalChildOne = (Traversal.Admin)chooseStep.getGlobalChildren().get(0);
        ArrayList globalChildOneSteps = new ArrayList(globalChildOne.getSteps());
        globalChildOneSteps.remove(globalChildOneSteps.size() - 1);
        Traversal.Admin globalChildTwo = (Traversal.Admin)chooseStep.getGlobalChildren().get(1);
        ArrayList globalChildTwoSteps = new ArrayList(globalChildTwo.getSteps());
        globalChildTwoSteps.remove(globalChildTwoSteps.size() - 1);
        boolean hasIdentity = globalChildOne.getSteps().stream().anyMatch(s -> s instanceof IdentityStep);
        if (!hasIdentity) {
            hasIdentity = globalChildTwo.getSteps().stream().anyMatch(s -> s instanceof IdentityStep);
            if (!hasIdentity) return true;
            if (predicateSteps.equals(globalChildOneSteps)) return false;
            return true;
        }
        if (predicateSteps.equals(globalChildTwoSteps)) return false;
        return true;
    }

    protected boolean unoptimizableRepeat(List<Step> steps, int index) {
        List<Step> toCome = steps.subList(index, steps.size());
        boolean repeatExist = toCome.stream().anyMatch(s -> s.getClass().equals(RepeatStep.class));
        if (repeatExist) {
            boolean badRepeat;
            boolean hasUntil = toCome.stream().filter(s -> s.getClass().equals(RepeatStep.class)).allMatch(r -> {
                RepeatStep repeatStep = (RepeatStep)r;
                return repeatStep.getUntilTraversal() != null;
            });
            boolean hasUnoptimizableUntil = false;
            if (hasUntil) {
                hasUnoptimizableUntil = toCome.stream().filter(s -> s.getClass().equals(RepeatStep.class)).allMatch(r -> {
                    RepeatStep repeatStep = (RepeatStep)r;
                    return !(repeatStep.getUntilTraversal() instanceof LoopTraversal);
                });
            }
            boolean bl = badRepeat = !hasUntil || hasUnoptimizableUntil;
            if (!badRepeat) {
                ArrayList collectedRepeatInternalSteps = new ArrayList();
                List repeatSteps = toCome.stream().filter(s -> s.getClass().equals(RepeatStep.class)).collect(Collectors.toList());
                for (Step step : repeatSteps) {
                    RepeatStep repeatStep = (RepeatStep)step;
                    List repeatTraversals = repeatStep.getGlobalChildren();
                    Traversal.Admin admin = (Traversal.Admin)repeatTraversals.get(0);
                    List repeatInternalSteps = admin.getSteps();
                    collectedRepeatInternalSteps.addAll(repeatInternalSteps);
                }
                return !collectedRepeatInternalSteps.stream().filter(s -> !s.getClass().equals(RepeatStep.RepeatEndStep.class)).allMatch(s -> this.isReplaceableStep(s.getClass(), false));
            }
            return true;
        }
        return false;
    }

    boolean canNotBeOptimized(List<Step> steps, int index) {
        List<Step> toCome = steps.subList(index, steps.size());
        return toCome.stream().anyMatch(s -> s.getClass().equals(Order.class) || s.getClass().equals(LambdaCollectingBarrierStep.class) || s.getClass().equals(SackValueStep.class) || s.getClass().equals(SackStep.class));
    }

    boolean canNotBeOptimized(Traversal.Admin<?, ?> traversal) {
        for (Class unoptimizableStep : UNOPTIMIZABLE_STEPS) {
            if (TraversalHelper.getStepsOfAssignableClassRecursively((Class)unoptimizableStep, traversal).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean precedesPathOrTreeStep(Traversal.Admin<?, ?> traversal) {
        LocalStep localStep;
        if (traversal.getParent() != null && traversal.getParent() instanceof LocalStep && this.precedesPathOrTreeStep((localStep = (LocalStep)traversal.getParent()).getTraversal())) {
            return true;
        }
        Predicate<Object> p = s -> s.getClass().equals(PathStep.class) || s.getClass().equals(TreeStep.class) || s.getClass().equals(TreeSideEffectStep.class) || s.getClass().equals(CyclicPathStep.class) || s.getClass().equals(SimplePathStep.class) || s.getClass().equals(EdgeOtherVertexStep.class);
        return TraversalHelper.anyStepRecursively(p, traversal);
    }

    private void collectHasSteps(ListIterator<Step> iterator, Traversal.Admin<?, ?> traversal, ReplacedStep<?, ?> replacedStep, int pathCount) {
        int countToGoPrevious = 0;
        while (iterator.hasNext()) {
            Step currentStep = iterator.next();
            ++countToGoPrevious;
            if (currentStep instanceof HasContainerHolder) {
                HasContainerHolder hasContainerHolder = (HasContainerHolder)currentStep;
                List hasContainers = hasContainerHolder.getHasContainers();
                ArrayList<HasContainer> toRemoveHasContainers = new ArrayList<HasContainer>();
                if (!this.isNotZonedDateTimeOrPeriodOrDuration(hasContainerHolder)) continue;
                toRemoveHasContainers.addAll(this.optimizeHas(replacedStep, hasContainers));
                toRemoveHasContainers.addAll(this.optimizeWithInOut(replacedStep, hasContainers));
                toRemoveHasContainers.addAll(this.optimizeBetween(replacedStep, hasContainers));
                toRemoveHasContainers.addAll(this.optimizeInside(replacedStep, hasContainers));
                toRemoveHasContainers.addAll(this.optimizeOutside(replacedStep, hasContainers));
                toRemoveHasContainers.addAll(this.optimizeTextContains(replacedStep, hasContainers));
                if (toRemoveHasContainers.size() != hasContainers.size()) continue;
                if (!currentStep.getLabels().isEmpty()) {
                    IdentityStep identityStep = new IdentityStep(traversal);
                    currentStep.getLabels().forEach(l -> replacedStep.addLabel(pathCount + PATH_LABEL_SUFFIX + l));
                    TraversalHelper.insertAfterStep((Step)identityStep, (Step)currentStep, traversal);
                }
                if (traversal.getSteps().contains(currentStep)) {
                    traversal.removeStep(currentStep);
                }
                iterator.remove();
                --countToGoPrevious;
                continue;
            }
            if (currentStep instanceof IdentityStep) continue;
            for (int i = 0; i < countToGoPrevious; ++i) {
                iterator.previous();
            }
        }
    }

    protected boolean isNotZonedDateTimeOrPeriodOrDuration(HasContainerHolder currentStep) {
        for (HasContainer h : currentStep.getHasContainers()) {
            P predicate = h.getPredicate();
            if (!(predicate.getValue() instanceof ZonedDateTime) && !(predicate.getValue() instanceof Period) && !(predicate.getValue() instanceof Duration) && (!(predicate.getValue() instanceof List) || !this.containsZonedDateTimePeriodOrDuration((List)predicate.getValue())) && (!(predicate instanceof ConnectiveP) || !this.isConnectivePWithZonedDateTimePeriodOrDuration((ConnectiveP)h.getPredicate()))) continue;
            return false;
        }
        return true;
    }

    private boolean containsZonedDateTimePeriodOrDuration(List<Object> values) {
        for (Object value : values) {
            if (!(value instanceof ZonedDateTime) && !(value instanceof Period) && !(value instanceof Duration)) continue;
            return true;
        }
        return false;
    }

    private boolean isConnectivePWithZonedDateTimePeriodOrDuration(ConnectiveP connectiveP) {
        List ps = connectiveP.getPredicates();
        for (P predicate : ps) {
            if (!(predicate.getValue() instanceof ZonedDateTime) && !(predicate.getValue() instanceof Period) && !(predicate.getValue() instanceof Duration)) continue;
            return true;
        }
        return false;
    }

    private List<HasContainer> optimizeWithInOut(ReplacedStep<?, ?> replacedStep, List<HasContainer> hasContainers) {
        ArrayList<HasContainer> result = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : hasContainers) {
            if (hasContainer.getKey().equals(T.label.getAccessor()) || hasContainer.getBiPredicate() != Contains.without && hasContainer.getBiPredicate() != Contains.within) continue;
            replacedStep.addHasContainer(hasContainer);
            result.add(hasContainer);
        }
        return result;
    }

    private List<HasContainer> optimizeHas(ReplacedStep<?, ?> replacedStep, List<HasContainer> hasContainers) {
        ArrayList<HasContainer> result = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : hasContainers) {
            if (!SUPPORTED_BI_PREDICATE.contains(hasContainer.getBiPredicate())) continue;
            replacedStep.addHasContainer(hasContainer);
            result.add(hasContainer);
        }
        return result;
    }

    private List<HasContainer> optimizeBetween(ReplacedStep<?, ?> replacedStep, List<HasContainer> hasContainers) {
        ArrayList<HasContainer> result = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : hasContainers) {
            AndP andP;
            List predicates;
            if (!(hasContainer.getPredicate() instanceof AndP) || (predicates = (andP = (AndP)hasContainer.getPredicate()).getPredicates()).size() != 2 || ((P)predicates.get(0)).getBiPredicate() != Compare.gte || ((P)predicates.get(1)).getBiPredicate() != Compare.lt) continue;
            replacedStep.addHasContainer(hasContainer);
            result.add(hasContainer);
        }
        return result;
    }

    private List<HasContainer> optimizeInside(ReplacedStep<?, ?> replacedStep, List<HasContainer> hasContainers) {
        ArrayList<HasContainer> result = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : hasContainers) {
            AndP andP;
            List predicates;
            if (!(hasContainer.getPredicate() instanceof AndP) || (predicates = (andP = (AndP)hasContainer.getPredicate()).getPredicates()).size() != 2 || ((P)predicates.get(0)).getBiPredicate() != Compare.gt || ((P)predicates.get(1)).getBiPredicate() != Compare.lt) continue;
            replacedStep.addHasContainer(hasContainer);
            result.add(hasContainer);
        }
        return result;
    }

    private List<HasContainer> optimizeOutside(ReplacedStep<?, ?> replacedStep, List<HasContainer> hasContainers) {
        ArrayList<HasContainer> result = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : hasContainers) {
            OrP orP;
            List predicates;
            if (!(hasContainer.getPredicate() instanceof OrP) || (predicates = (orP = (OrP)hasContainer.getPredicate()).getPredicates()).size() != 2 || ((P)predicates.get(0)).getBiPredicate() != Compare.lt || ((P)predicates.get(1)).getBiPredicate() != Compare.gt) continue;
            replacedStep.addHasContainer(hasContainer);
            result.add(hasContainer);
        }
        return result;
    }

    private List<HasContainer> optimizeTextContains(ReplacedStep<?, ?> replacedStep, List<HasContainer> hasContainers) {
        ArrayList<HasContainer> result = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : hasContainers) {
            if (!(hasContainer.getBiPredicate() instanceof Text) && !(hasContainer.getBiPredicate() instanceof FullText)) continue;
            replacedStep.addHasContainer(hasContainer);
            result.add(hasContainer);
        }
        return result;
    }

    private boolean isTextContains(List<HasContainer> hasContainers) {
        return hasContainers.size() == 1 && !hasContainers.get(0).getKey().equals(T.label.getAccessor()) && !hasContainers.get(0).getKey().equals(T.id.getAccessor()) && (hasContainers.get(0).getBiPredicate() instanceof Text || hasContainers.get(0).getBiPredicate() instanceof FullText);
    }

    static boolean isElementValueComparator(OrderGlobalStep orderGlobalStep) {
        return orderGlobalStep.getComparators().stream().allMatch(c -> c instanceof ElementValueComparator && (((ElementValueComparator)c).getValueComparator() == Order.incr || ((ElementValueComparator)c).getValueComparator() == Order.decr) || c instanceof Pair && ((Pair)c).getValue0() instanceof ElementValueTraversal && ((Pair)c).getValue1() instanceof Order);
    }

    static boolean isTraversalComparatorWithSelectOneStep(OrderGlobalStep orderGlobalStep) {
        Iterator iterator = orderGlobalStep.getComparators().iterator();
        if (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            Traversal.Admin traversal = (Traversal.Admin)pair.getValue0();
            List traversalComparatorSteps = traversal.getSteps();
            return traversalComparatorSteps.size() == 1 && traversalComparatorSteps.get(0) instanceof SelectOneStep;
        }
        return false;
    }

    private boolean isSingleBiPredicate(List<HasContainer> hasContainers) {
        if (hasContainers.size() == 1) {
            return SUPPORTED_BI_PREDICATE.contains(hasContainers.get(0).getBiPredicate());
        }
        return false;
    }

    private boolean isBetween(List<HasContainer> hasContainers) {
        if (hasContainers.size() == 2) {
            HasContainer hasContainer1 = hasContainers.get(0);
            HasContainer hasContainer2 = hasContainers.get(1);
            return hasContainer1.getBiPredicate().equals(Compare.gte) && hasContainer2.getBiPredicate().equals(Compare.lt);
        }
        return false;
    }

    private boolean isInside(List<HasContainer> hasContainers) {
        if (hasContainers.size() == 2) {
            HasContainer hasContainer1 = hasContainers.get(0);
            HasContainer hasContainer2 = hasContainers.get(1);
            return hasContainer1.getBiPredicate().equals(Compare.gt) && hasContainer2.getBiPredicate().equals(Compare.lt);
        }
        return false;
    }

    private <V> boolean isOutside(List<HasContainer> hasContainers) {
        if (hasContainers.size() == 1 && hasContainers.get(0).getPredicate() instanceof OrP) {
            OrP orP = (OrP)hasContainers.get(0).getPredicate();
            if (orP.getPredicates().size() == 2) {
                P predicate1 = (P)orP.getPredicates().get(0);
                P predicate2 = (P)orP.getPredicates().get(1);
                return predicate1.getBiPredicate().equals(Compare.lt) && predicate2.getBiPredicate().equals(Compare.gt);
            }
            return false;
        }
        return false;
    }

    private boolean isWithinOut(List<HasContainer> hasContainers) {
        return hasContainers.size() == 1 && !hasContainers.get(0).getKey().equals(T.label.getAccessor()) && (hasContainers.get(0).getBiPredicate() == Contains.without || hasContainers.get(0).getBiPredicate() == Contains.within);
    }

    private boolean flattenChooseStep(List<Step> steps, ListIterator<Step> stepIterator, ChooseStep chooseStep, Traversal.Admin<?, ?> traversal) {
        Step internalVertexStep;
        int stepsAdded = 0;
        if (this.unoptimizableChooseStep(steps, stepIterator.previousIndex())) {
            this.logger.debug("gremlin not optimized due to ChooseStep with ... " + traversal.toString() + "\nPath to gremlin:\n" + ExceptionUtils.getStackTrace((Throwable)new Throwable()));
            throw new UnoptimizableException();
        }
        boolean chooseStepAdded = false;
        List localChildren = chooseStep.getLocalChildren();
        Preconditions.checkState((localChildren.size() == 1 ? 1 : 0) != 0, (Object)"ChooseStep's localChildren must have size 1, one for the predicate traversal");
        List globalChildren = chooseStep.getGlobalChildren();
        Preconditions.checkState((globalChildren.size() == 2 ? 1 : 0) != 0, (Object)"ChooseStep's globalChildren must have size 2, one for true and one for false");
        Traversal.Admin a = (Traversal.Admin)globalChildren.get(0);
        Traversal.Admin b = (Traversal.Admin)globalChildren.get(1);
        Traversal.Admin trueTraversal = a.getSteps().stream().filter(s -> s instanceof IdentityStep).findAny().isPresent() ? b : a;
        boolean addedNestedChooseStep = false;
        List chooseStepInternalVertexSteps = trueTraversal.getSteps();
        Iterator iterator = chooseStepInternalVertexSteps.iterator();
        while (iterator.hasNext() && !((internalVertexStep = (Step)iterator.next()) instanceof ComputerAwareStep.EndStep)) {
            internalVertexStep.setPreviousStep(chooseStep.getPreviousStep());
            stepIterator.add(internalVertexStep);
            stepIterator.previous();
            stepIterator.next();
            ++stepsAdded;
            chooseStepAdded = true;
            if (!(internalVertexStep instanceof ChooseStep)) continue;
            addedNestedChooseStep = true;
        }
        if (!addedNestedChooseStep) {
            stepIterator.add((Step)EmptyStep.instance());
            stepIterator.previous();
            stepIterator.next();
            ++stepsAdded;
        }
        if (traversal.getSteps().contains(chooseStep)) {
            traversal.removeStep((Step)chooseStep);
        }
        for (int i = 0; i < stepsAdded; ++i) {
            stepIterator.previous();
        }
        return chooseStepAdded;
    }

    private boolean flattenRepeatStep(List<Step> steps, ListIterator<Step> stepIterator, RepeatStep repeatStep, Traversal.Admin<?, ?> traversal, MutableInt repeatStepsAdded) {
        if (this.unoptimizableRepeat(steps, stepIterator.previousIndex())) {
            this.logger.debug("gremlin not optimized due to RepeatStep with emit. " + traversal.toString() + "\nPath to gremlin:\n" + ExceptionUtils.getStackTrace((Throwable)new Throwable()));
            throw new UnoptimizableException();
        }
        repeatStepsAdded.setValue(0);
        boolean repeatStepAdded = false;
        List repeatTraversals = repeatStep.getGlobalChildren();
        Traversal.Admin admin = (Traversal.Admin)repeatTraversals.get(0);
        List repeatStepInternalVertexSteps = admin.getSteps();
        LoopTraversal loopTraversal = (LoopTraversal)repeatStep.getUntilTraversal();
        long numberOfLoops = loopTraversal.getMaxLoops();
        int i = 0;
        while ((long)i < numberOfLoops) {
            Step internalVertexStep;
            Iterator iterator = repeatStepInternalVertexSteps.iterator();
            while (iterator.hasNext() && !((internalVertexStep = (Step)iterator.next()) instanceof RepeatStep.RepeatEndStep)) {
                internalVertexStep.setPreviousStep(repeatStep.getPreviousStep());
                stepIterator.add(internalVertexStep);
                stepIterator.previous();
                stepIterator.next();
                repeatStepAdded = true;
                repeatStepsAdded.increment();
            }
            ++i;
        }
        traversal.removeStep((Step)repeatStep);
        for (i = 0; i < repeatStepsAdded.getValue(); ++i) {
            stepIterator.previous();
        }
        return repeatStepAdded;
    }

    private void addHasContainerForIds(SqlgGraphStepCompiled sqlgGraphStepCompiled, ReplacedStep replacedStep) {
        Object[] ids = sqlgGraphStepCompiled.getIds();
        ArrayList<Object> recordsIds = new ArrayList<Object>();
        for (Object id : ids) {
            if (id instanceof Element) {
                recordsIds.add(((Element)id).id());
                continue;
            }
            recordsIds.add(id);
        }
        HasContainer idHasContainer = new HasContainer(T.id.getAccessor(), P.within((Object[])recordsIds.toArray()));
        replacedStep.addHasContainers(Collections.singletonList(idHasContainer));
        sqlgGraphStepCompiled.clearIds();
    }

    private class UnoptimizableException
    extends RuntimeException {
        private UnoptimizableException() {
        }
    }
}

