/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.strategy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_LP_O_P_S_SE_SL_Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.B_LP_O_P_S_SE_SL_TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.process.SqlgRawIteratorToEmitIterator;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.strategy.Emit;
import org.umlg.sqlg.strategy.SqlgStep;
import org.umlg.sqlg.structure.SqlgCompiledResultIterator;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgGraph;

public class SqlgGraphStepCompiled<S extends SqlgElement, E extends SqlgElement>
extends GraphStep
implements SqlgStep,
TraversalParent {
    private Logger logger = LoggerFactory.getLogger((String)SqlgGraphStepCompiled.class.getName());
    private List<ReplacedStep<S, E>> replacedSteps = new ArrayList<ReplacedStep<S, E>>();
    private SqlgGraph sqlgGraph;
    private Map<SchemaTableTree, List<Pair<LinkedList<SchemaTableTree>, String>>> parsedForStrategySql = new HashMap<SchemaTableTree, List<Pair<LinkedList<SchemaTableTree>, String>>>();
    private transient Supplier<Iterator<Emit<E>>> iteratorSupplier;
    private Iterator<Emit<E>> iterator = EmptyIterator.instance();
    private Traverser.Admin<E> previousHead;
    private boolean emitToList = true;
    private List<Emit<E>> emitted = null;

    SqlgGraphStepCompiled(SqlgGraph sqlgGraph, Traversal.Admin traversal, Class<E> returnClass, boolean isStart, Object ... ids) {
        super(traversal, returnClass, isStart, ids);
        this.sqlgGraph = sqlgGraph;
        this.iteratorSupplier = new SqlgRawIteratorToEmitIterator(this::elements);
        this.emitToList = !isStart;
    }

    protected Traverser.Admin<E> processNextStart() {
        while (true) {
            if (this.iterator.hasNext()) {
                Traverser.Admin traverser = null;
                Emit<E> emit = this.iterator.next();
                if (this.emitToList && this.emitted != null) {
                    this.emitted.add(emit);
                }
                boolean first = true;
                Iterator labelIter = emit.getPath().labels().iterator();
                for (Object o : emit.getPath().objects()) {
                    Set labels;
                    SqlgElement e = (SqlgElement)o;
                    this.labels = labels = (Set)labelIter.next();
                    if (!this.isStart && this.previousHead != null && traverser == null) {
                        traverser = this.previousHead.split((Object)e, (Step)this);
                        continue;
                    }
                    if (first) {
                        first = false;
                        traverser = B_LP_O_P_S_SE_SL_TraverserGenerator.instance().generate((Object)e, (Step)this, 1L);
                        continue;
                    }
                    traverser = ((B_LP_O_P_S_SE_SL_Traverser)traverser).split((Object)e, (Step)this);
                }
                return traverser;
            }
            if (this.isStart) {
                if (this.done) {
                    throw FastNoSuchElementException.instance();
                }
                this.done = true;
                this.iterator = null == this.iteratorSupplier ? EmptyIterator.instance() : this.iteratorSupplier.get();
                continue;
            }
            this.previousHead = this.starts.next();
            if (this.emitted != null) {
                this.emitToList = false;
                this.iterator = this.emitted.iterator();
                continue;
            }
            this.iterator = null == this.iteratorSupplier ? EmptyIterator.instance() : this.iteratorSupplier.get();
            this.emitted = new LinkedList<Emit<E>>();
        }
    }

    public void reset() {
        super.reset();
        this.previousHead = null;
        this.emitToList = !this.isStart;
        this.emitted = null;
        this.iterator = EmptyIterator.instance();
    }

    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[]{TraverserRequirement.PATH, TraverserRequirement.SIDE_EFFECTS});
    }

    private Iterator<List<Emit<E>>> elements() {
        this.sqlgGraph.tx().readWrite();
        if (this.sqlgGraph.tx().getBatchManager().isStreaming()) {
            throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Preconditions.checkState((this.replacedSteps.size() > 0 ? 1 : 0) != 0, (Object)"There must be at least one replacedStep");
        Preconditions.checkState((boolean)this.replacedSteps.get(0).isGraphStep(), (Object)"The first step must a SqlgGraphStep");
        Set<SchemaTableTree> rootSchemaTableTrees = this.sqlgGraph.getGremlinParser().parse(this.replacedSteps);
        SqlgCompiledResultIterator<List<Emit<E>>> resultIterator = new SqlgCompiledResultIterator<List<Emit<E>>>(this.sqlgGraph, rootSchemaTableTrees);
        stopWatch.stop();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SqlgGraphStepCompiled finished, time taken {}", (Object)stopWatch.toString());
        }
        return resultIterator;
    }

    public void addReplacedStep(ReplacedStep replacedStep) {
        replacedStep.setDepth(this.replacedSteps.size());
        this.replacedSteps.add(replacedStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseForStrategy() {
        this.parsedForStrategySql.clear();
        Preconditions.checkState((this.replacedSteps.size() > 0 ? 1 : 0) != 0, (Object)"There must be at least one replacedStep");
        Preconditions.checkState((boolean)this.replacedSteps.get(0).isGraphStep(), (Object)"The first step must a SqlgGraphStep");
        Set<SchemaTableTree> rootSchemaTableTrees = this.sqlgGraph.getGremlinParser().parseForStrategy(this.replacedSteps);
        for (SchemaTableTree rootSchemaTableTree : rootSchemaTableTrees) {
            try {
                if (this.sqlgGraph.tx().isOpen() && this.sqlgGraph.tx().getBatchManager().isStreaming()) {
                    throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
                }
                List<Pair<LinkedList<SchemaTableTree>, String>> sqlStatements = rootSchemaTableTree.constructSql();
                this.parsedForStrategySql.put(rootSchemaTableTree, sqlStatements);
            }
            finally {
                rootSchemaTableTree.resetColumnAliasMaps();
            }
        }
    }

    @Override
    public boolean isForMultipleQueries() {
        return this.parsedForStrategySql.size() > 1 || this.parsedForStrategySql.values().stream().filter(l -> l.size() > 1).count() > 0L;
    }

    @Override
    public List<ReplacedStep<S, E>> getReplacedSteps() {
        return this.replacedSteps;
    }

    public int hashCode() {
        int result = super.hashCode() ^ this.returnClass.hashCode();
        for (Object id : this.ids) {
            result ^= id.hashCode();
        }
        return result;
    }
}

