/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.strategy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.optimization.MessagePassingReductionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.InlineFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathRetractionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.RepeatUnrollStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.strategy.BaseSqlgStrategy;
import org.umlg.sqlg.strategy.SqlgGraphStepCompiled;
import org.umlg.sqlg.strategy.SqlgStep;
import org.umlg.sqlg.strategy.SqlgVertexStepStrategy;
import org.umlg.sqlg.structure.SqlgGraph;

public class SqlgGraphStepStrategy
extends BaseSqlgStrategy {
    private static final List<Class> CONSECUTIVE_STEPS_TO_REPLACE = Arrays.asList(VertexStep.class, EdgeVertexStep.class, GraphStep.class, EdgeOtherVertexStep.class);
    private Logger logger = LoggerFactory.getLogger((String)SqlgVertexStepStrategy.class.getName());

    public void apply(Traversal.Admin<?, ?> traversal) {
        ListIterator<Step> stepIterator;
        ArrayList<Step> steps;
        Object id;
        Step startStep = traversal.getStartStep();
        if (!(startStep instanceof GraphStep) || !(traversal.getGraph().get() instanceof SqlgGraph)) {
            return;
        }
        SqlgGraph sqlgGraph = (SqlgGraph)traversal.getGraph().get();
        GraphStep originalGraphStep = (GraphStep)startStep;
        if (sqlgGraph.features().supportsBatchMode() && sqlgGraph.tx().isInNormalBatchMode()) {
            sqlgGraph.tx().flush();
        }
        if (originalGraphStep.getIds().length > 0 && (id = originalGraphStep.getIds()[0]) != null) {
            Class<?> clazz = id.getClass();
            if (!Stream.of(originalGraphStep.getIds()).allMatch(i -> clazz.isAssignableFrom(i.getClass()))) {
                throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
            }
        }
        if (this.canNotBeOptimized(steps = new ArrayList<Step>(traversal.asAdmin().getSteps()), (stepIterator = steps.listIterator()).nextIndex())) {
            this.logger.debug("gremlin not optimized due to path or tree step. " + traversal.toString() + "\nPath to gremlin:\n" + ExceptionUtils.getStackTrace((Throwable)new Throwable()));
            return;
        }
        this.combineSteps(traversal, steps, stepIterator);
    }

    @Override
    protected SqlgStep constructSqlgStep(Traversal.Admin<?, ?> traversal, Step startStep) {
        Preconditions.checkArgument((boolean)(startStep instanceof GraphStep), (Object)("Expected a GraphStep, found instead a " + startStep.getClass().getName()));
        return new SqlgGraphStepCompiled((SqlgGraph)traversal.getGraph().get(), traversal, ((GraphStep)startStep).getReturnClass(), ((GraphStep)startStep).isStartStep(), ((GraphStep)startStep).getIds());
    }

    @Override
    protected boolean isReplaceableStep(Class<? extends Step> stepClass, boolean alreadyReplacedGraphStep) {
        return CONSECUTIVE_STEPS_TO_REPLACE.contains(stepClass);
    }

    @Override
    protected void replaceStepInTraversal(Step firstStep, SqlgStep sqlgStep, Traversal.Admin<?, ?> traversal) {
        TraversalHelper.replaceStep((Step)firstStep, (Step)sqlgStep, traversal);
    }

    @Override
    protected void doLastEntry(Step step, ListIterator<Step> stepIterator, Traversal.Admin<?, ?> traversal, ReplacedStep<?, ?> lastReplacedStep, SqlgStep sqlgStep, int pathCount) {
        Preconditions.checkArgument((lastReplacedStep != null ? 1 : 0) != 0);
        sqlgStep.parseForStrategy();
        if (!sqlgStep.isForMultipleQueries()) {
            SqlgGraphStepStrategy.collectOrderGlobalSteps(step, stepIterator, traversal, lastReplacedStep, pathCount);
        } else if (stepIterator.hasNext() && !SqlgGraphStepStrategy.collectRangeGlobalStep(step = stepIterator.next(), stepIterator, traversal, lastReplacedStep, true, pathCount)) {
            stepIterator.previous();
        }
    }

    private static boolean collectRangeGlobalStep(Step step, ListIterator<Step> iterator, Traversal.Admin<?, ?> traversal, ReplacedStep<?, ?> replacedStep, boolean multiple, int pathCount) {
        if (step instanceof RangeGlobalStep) {
            RangeGlobalStep rgs = (RangeGlobalStep)step;
            if (!multiple || rgs.getLowRange() == 0L) {
                long high = rgs.getHighRange();
                if (multiple) {
                    ++high;
                }
                replacedStep.setRange((Range<Long>)Range.between((Comparable)Long.valueOf(rgs.getLowRange()), (Comparable)Long.valueOf(high)));
                for (Object l : step.getLabels()) {
                    replacedStep.addLabel(pathCount + "P~~~" + l);
                }
                if (!multiple) {
                    iterator.remove();
                    traversal.removeStep(step);
                    return true;
                }
            }
        }
        return false;
    }

    private static void collectOrderGlobalSteps(Step step, ListIterator<Step> iterator, Traversal.Admin<?, ?> traversal, ReplacedStep<?, ?> replacedStep, int pathCount) {
        if (step instanceof OrderGlobalStep && SqlgGraphStepStrategy.isElementValueComparator((OrderGlobalStep)step)) {
            iterator.remove();
            traversal.removeStep(step);
            replacedStep.getComparators().addAll(((OrderGlobalStep)step).getComparators());
            for (Object l : step.getLabels()) {
                replacedStep.addLabel(pathCount + "P~~~" + l);
            }
            if (iterator.hasNext() && !SqlgGraphStepStrategy.collectRangeGlobalStep(step = iterator.next(), iterator, traversal, replacedStep, false, pathCount)) {
                iterator.previous();
            }
        } else if (!SqlgGraphStepStrategy.collectRangeGlobalStep(step, iterator, traversal, replacedStep, false, pathCount)) {
            SqlgGraphStepStrategy.collectSelectOrderGlobalSteps(iterator, traversal, replacedStep, pathCount);
        }
    }

    private static void collectSelectOrderGlobalSteps(ListIterator<Step> iterator, Traversal.Admin<?, ?> traversal, ReplacedStep<?, ?> replacedStep, int pathCount) {
        while (iterator.hasNext()) {
            Step currentStep = iterator.next();
            if (currentStep instanceof OrderGlobalStep && (SqlgGraphStepStrategy.isElementValueComparator((OrderGlobalStep)currentStep) || SqlgGraphStepStrategy.isTraversalComparatorWithSelectOneStep((OrderGlobalStep)currentStep))) {
                iterator.remove();
                traversal.removeStep(currentStep);
                replacedStep.getComparators().addAll(((OrderGlobalStep)currentStep).getComparators());
                for (Object l : currentStep.getLabels()) {
                    replacedStep.addLabel(pathCount + "P~~~" + l);
                }
                continue;
            }
            if (currentStep instanceof IdentityStep || SqlgGraphStepStrategy.collectRangeGlobalStep(currentStep, iterator, traversal, replacedStep, false, pathCount)) continue;
            iterator.previous();
            break;
        }
    }

    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPost() {
        return Stream.of(RepeatUnrollStrategy.class, PathRetractionStrategy.class, InlineFilterStrategy.class, MessagePassingReductionStrategy.class).collect(Collectors.toSet());
    }
}

