/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.strategy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;
import org.umlg.sqlg.process.SqlgRawIteratorToEmitIterator;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.strategy.Emit;
import org.umlg.sqlg.strategy.SqlgOrderGlobalStep;
import org.umlg.sqlg.strategy.SqlgStep;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgGraph;

public class SqlgVertexStepCompiled<S extends SqlgElement, E extends SqlgElement>
extends FlatMapStep
implements SqlgStep {
    private Traverser.Admin<E> head = null;
    private Iterator<Emit<E>> iterator = EmptyIterator.instance();
    private List<ReplacedStep<S, E>> replacedSteps = new ArrayList<ReplacedStep<S, E>>();
    private Map<SchemaTableTree, List<Pair<LinkedList<SchemaTableTree>, String>>> parsedForStrategySql = new HashMap<SchemaTableTree, List<Pair<LinkedList<SchemaTableTree>, String>>>();

    public SqlgVertexStepCompiled(Traversal.Admin traversal) {
        super(traversal);
    }

    protected Traverser.Admin<E> processNextStart() {
        while (true) {
            if (this.iterator.hasNext()) {
                Traverser.Admin traverser = this.head;
                Emit<E> emit = this.iterator.next();
                if (emit.isFake()) {
                    return traverser;
                }
                if (emit.isIncomingOnlyLocalOptionalStep()) {
                    return traverser;
                }
                for (int i = 0; i < emit.getPath().size(); ++i) {
                    SqlgElement e = (SqlgElement)emit.getPath().objects().get(i);
                    traverser = traverser.split((Object)e, (Step)EmptyStep.instance());
                    traverser.addLabels((Set)emit.getPath().labels().get(i));
                }
                return traverser;
            }
            this.head = this.starts.next();
            this.iterator = new SqlgRawIteratorToEmitIterator<E>(this.flatMapCustom(this.head));
        }
    }

    public Set<String> getLabels() {
        return new HashSet<String>();
    }

    private Iterator<List<Emit<E>>> flatMapCustom(Traverser.Admin<E> traverser) {
        SqlgElement s = (SqlgElement)traverser.get();
        SqlgGraph sqlgGraph = (SqlgGraph)s.graph();
        ArrayList steps = new ArrayList(this.traversal.asAdmin().getSteps());
        ListIterator stepIterator = steps.listIterator();
        boolean afterThis = false;
        while (stepIterator.hasNext()) {
            Step step = (Step)stepIterator.next();
            if (afterThis && step instanceof SqlgOrderGlobalStep) {
                this.parseForStrategy(sqlgGraph, SchemaTable.of(s.getSchema(), s instanceof Vertex ? "V_" + s.getTable() : "E_" + s.getTable()));
                if (!this.isForMultipleQueries()) {
                    ((SqlgOrderGlobalStep)step).setIgnore(true);
                }
            }
            if (step != this) continue;
            afterThis = true;
        }
        return s.elements(this.replacedSteps);
    }

    protected Iterator<E> flatMap(Traverser.Admin traverser) {
        throw new IllegalStateException("SqlgVertexStepCompiled.flatMap should never be called, it existVertexLabel been replaced with flatMapCustom");
    }

    public void addReplacedStep(ReplacedStep replacedStep) {
        replacedStep.setDepth(this.replacedSteps.size());
        this.replacedSteps.add(replacedStep);
    }

    @Override
    public List<ReplacedStep<S, E>> getReplacedSteps() {
        return this.replacedSteps;
    }

    public void reset() {
        super.reset();
        this.iterator = EmptyIterator.instance();
    }

    public Set<TraverserRequirement> getRequirements() {
        return EnumSet.of(TraverserRequirement.PATH, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public void parseForStrategy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseForStrategy(SqlgGraph sqlgGraph, SchemaTable schemaTable) {
        this.parsedForStrategySql.clear();
        Preconditions.checkState((this.replacedSteps.size() > 0 ? 1 : 0) != 0, (Object)"There must be at least one replacedStep");
        Preconditions.checkState((this.replacedSteps.get(0).isVertexStep() || this.replacedSteps.get(0).isEdgeVertexStep() || this.replacedSteps.get(0).isGraphStep() ? 1 : 0) != 0, (Object)("The first step must a VertexStep, EdgeVertexStep or GraphStep found " + this.replacedSteps.get(0).getStep().getClass().toString()));
        SchemaTableTree rootSchemaTableTree = null;
        try {
            rootSchemaTableTree = sqlgGraph.getGremlinParser().parse(schemaTable, this.replacedSteps);
            List<Pair<LinkedList<SchemaTableTree>, String>> sqlStatements = rootSchemaTableTree.constructSql();
            this.parsedForStrategySql.put(rootSchemaTableTree, sqlStatements);
        }
        finally {
            if (rootSchemaTableTree != null) {
                rootSchemaTableTree.resetColumnAliasMaps();
            }
        }
    }

    @Override
    public boolean isForMultipleQueries() {
        return this.parsedForStrategySql.size() > 1 || this.parsedForStrategySql.values().stream().filter(l -> l.size() > 1).count() > 0L;
    }
}

