/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.strategy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.strategy.BaseSqlgStrategy;
import org.umlg.sqlg.strategy.SqlgGraphStepStrategy;
import org.umlg.sqlg.strategy.SqlgOrderGlobalStep;
import org.umlg.sqlg.strategy.SqlgStep;
import org.umlg.sqlg.strategy.SqlgVertexStepCompiled;
import org.umlg.sqlg.structure.SqlgGraph;

public class SqlgVertexStepStrategy
extends BaseSqlgStrategy {
    private static final List<Class> CONSECUTIVE_STEPS_TO_REPLACE = Arrays.asList(VertexStep.class, EdgeVertexStep.class, EdgeOtherVertexStep.class);
    private Logger logger = LoggerFactory.getLogger((String)SqlgVertexStepStrategy.class.getName());

    public void apply(Traversal.Admin<?, ?> traversal) {
        ListIterator<Step> stepIterator;
        ArrayList<Step> steps;
        if (!(traversal.getGraph().get() instanceof SqlgGraph)) {
            return;
        }
        SqlgGraph sqlgGraph = (SqlgGraph)traversal.getGraph().get();
        if (sqlgGraph.features().supportsBatchMode() && sqlgGraph.tx().isInNormalBatchMode()) {
            sqlgGraph.tx().flush();
        }
        if (this.canNotBeOptimized(steps = new ArrayList<Step>(traversal.asAdmin().getSteps()), (stepIterator = steps.listIterator()).nextIndex())) {
            this.logger.debug("gremlin not optimized due to path or tree step. " + traversal.toString() + "\nPath to gremlin:\n" + ExceptionUtils.getStackTrace((Throwable)new Throwable()));
            return;
        }
        this.combineSteps(traversal, steps, stepIterator);
    }

    @Override
    protected SqlgStep constructSqlgStep(Traversal.Admin<?, ?> traversal, Step startStep) {
        SqlgVertexStepCompiled sqlgStep = new SqlgVertexStepCompiled(traversal);
        ReplacedStep replacedStep = ReplacedStep.from(((SqlgGraph)traversal.getGraph().get()).getTopology());
        sqlgStep.addReplacedStep(replacedStep);
        return sqlgStep;
    }

    @Override
    protected boolean isReplaceableStep(Class<? extends Step> stepClass, boolean alreadyReplacedGraphStep) {
        return CONSECUTIVE_STEPS_TO_REPLACE.contains(stepClass);
    }

    @Override
    protected void replaceStepInTraversal(Step stepToReplace, SqlgStep sqlgStep, Traversal.Admin<?, ?> traversal) {
        if (traversal.getSteps().contains(stepToReplace)) {
            TraversalHelper.replaceStep((Step)stepToReplace, (Step)sqlgStep, traversal);
        } else {
            TraversalHelper.insertAfterStep((Step)sqlgStep, (Step)stepToReplace.getPreviousStep(), traversal);
        }
    }

    @Override
    protected void doLastEntry(Step step, ListIterator<Step> stepIterator, Traversal.Admin<?, ?> traversal, ReplacedStep<?, ?> lastReplacedStep, SqlgStep sqlgStep, int pathCount) {
        Preconditions.checkArgument((lastReplacedStep != null ? 1 : 0) != 0);
        SqlgVertexStepStrategy.replaceOrderGlobalSteps(step, stepIterator, traversal, lastReplacedStep);
    }

    private static void replaceOrderGlobalSteps(Step step, ListIterator<Step> iterator, Traversal.Admin<?, ?> traversal, ReplacedStep<?, ?> replacedStep) {
        if (step instanceof OrderGlobalStep && SqlgVertexStepStrategy.isElementValueComparator((OrderGlobalStep)step)) {
            TraversalHelper.replaceStep((Step)step, new SqlgOrderGlobalStep((OrderGlobalStep)step), traversal);
            iterator.remove();
            replacedStep.getComparators().addAll(((OrderGlobalStep)step).getComparators());
        } else {
            SqlgVertexStepStrategy.replaceSelectOrderGlobalSteps(iterator, traversal, replacedStep);
        }
    }

    private static void replaceSelectOrderGlobalSteps(ListIterator<Step> iterator, Traversal.Admin<?, ?> traversal, ReplacedStep<?, ?> replacedStep) {
        while (iterator.hasNext()) {
            Step currentStep = iterator.next();
            if (currentStep instanceof OrderGlobalStep && SqlgVertexStepStrategy.isElementValueComparator((OrderGlobalStep)currentStep)) {
                iterator.remove();
                TraversalHelper.replaceStep((Step)currentStep, new SqlgOrderGlobalStep((OrderGlobalStep)currentStep), traversal);
                replacedStep.getComparators().addAll(((OrderGlobalStep)currentStep).getComparators());
                continue;
            }
            if (currentStep instanceof IdentityStep) continue;
            iterator.previous();
            break;
        }
    }

    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return Stream.of(SqlgGraphStepStrategy.class).collect(Collectors.toSet());
    }
}

