/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.umlg.sqlg.predicate.FullText;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.strategy.SqlgGraphStepCompiled;
import org.umlg.sqlg.structure.SqlgGraph;

public class SqlgWhereStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final long serialVersionUID = 5608856947238999912L;

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!(traversal.getGraph().get() instanceof SqlgGraph)) {
            return;
        }
        SqlgGraph sqlgGraph = (SqlgGraph)traversal.getGraph().get();
        if (sqlgGraph.features().supportsBatchMode() && sqlgGraph.tx().isInNormalBatchMode()) {
            sqlgGraph.tx().flush();
        }
        ArrayList steps = new ArrayList(traversal.asAdmin().getSteps());
        ListIterator stepIterator = steps.listIterator();
        HashMap<String, Object> stepsByLabel = new HashMap<String, Object>();
        stepIterator = steps.listIterator();
        Step previous = null;
        int idx = 0;
        while (stepIterator.hasNext()) {
            WherePredicateStep wps;
            Step step = (Step)stepIterator.next();
            this.captureLabels(step, stepsByLabel);
            if (step instanceof WherePredicateStep && (wps = (WherePredicateStep)step).getPredicate().isPresent() && ((P)wps.getPredicate().get()).getBiPredicate() instanceof FullText) {
                SqlgGraphStepCompiled sgs;
                Object referTo = previous;
                if (wps.getStartKey().isPresent()) {
                    referTo = stepsByLabel.get(wps.getStartKey().get());
                }
                if (referTo instanceof SqlgGraphStepCompiled && (sgs = (SqlgGraphStepCompiled)referTo).getReplacedSteps().size() > 0) {
                    referTo = sgs.getReplacedSteps().get(sgs.getReplacedSteps().size() - 1);
                }
                if (referTo instanceof ReplacedStep) {
                    ReplacedStep rs = (ReplacedStep)referTo;
                    rs.addHasContainer(new HasContainer("__dummy__", (P)wps.getPredicate().get()));
                    traversal.removeStep(idx);
                }
            }
            previous = step;
            ++idx;
        }
    }

    private void captureLabels(Step<?, ?> step, Map<String, Object> stepsByLabel) {
        for (String s : step.getLabels()) {
            stepsByLabel.put(s, step);
        }
        if (step instanceof SqlgGraphStepCompiled) {
            SqlgGraphStepCompiled sgs = (SqlgGraphStepCompiled)step;
            for (ReplacedStep rs : sgs.getReplacedSteps()) {
                for (String label : rs.getLabels()) {
                    if (label.contains("P~~~")) {
                        stepsByLabel.put(label.substring(label.indexOf("P~~~") + "P~~~".length()), rs);
                        continue;
                    }
                    if (!label.contains("E~~~")) continue;
                    stepsByLabel.put(label.substring(label.indexOf("E~~~") + "E~~~".length()), rs);
                }
            }
        }
    }
}

