/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.structure.Index;
import org.umlg.sqlg.structure.IndexType;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.Schema;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyChangeAction;
import org.umlg.sqlg.structure.TopologyInf;
import org.umlg.sqlg.structure.TopologyManager;
import org.umlg.sqlg.structure.VertexLabel;

public abstract class AbstractLabel
implements TopologyInf {
    private Logger logger = LoggerFactory.getLogger((String)AbstractLabel.class.getName());
    protected boolean committed = true;
    protected String label;
    protected SqlgGraph sqlgGraph;
    protected Map<String, PropertyColumn> properties = new HashMap<String, PropertyColumn>();
    Map<String, PropertyColumn> uncommittedProperties = new HashMap<String, PropertyColumn>();
    Set<String> uncommittedRemovedProperties = new HashSet<String>();
    protected Map<String, PropertyColumn> globalUniqueIndexProperties = new HashMap<String, PropertyColumn>();
    Map<String, PropertyColumn> uncommittedGlobalUniqueIndexProperties = new HashMap<String, PropertyColumn>();
    private Map<String, Index> indexes = new HashMap<String, Index>();
    private Map<String, Index> uncommittedIndexes = new HashMap<String, Index>();
    private Set<String> uncommittedRemovedIndexes = new HashSet<String>();

    AbstractLabel(SqlgGraph sqlgGraph, String label, Map<String, PropertyType> properties) {
        this.sqlgGraph = sqlgGraph;
        this.label = label;
        for (Map.Entry<String, PropertyType> propertyEntry : properties.entrySet()) {
            PropertyColumn property = new PropertyColumn(this, propertyEntry.getKey(), propertyEntry.getValue());
            property.setCommitted(false);
            this.uncommittedProperties.put(propertyEntry.getKey(), property);
        }
    }

    AbstractLabel(SqlgGraph sqlgGraph, String label) {
        this.sqlgGraph = sqlgGraph;
        this.label = label;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    public Index ensureIndexExists(IndexType indexType, List<PropertyColumn> properties) {
        String prefix = this instanceof VertexLabel ? "V_" : "E_";
        SchemaTable schemaTable = SchemaTable.of(this.getSchema().getName(), this.getLabel());
        String indexName = this.sqlgGraph.getSqlDialect().indexName(schemaTable, prefix, properties.stream().map(PropertyColumn::getName).collect(Collectors.toList()));
        Optional<Index> indexOptional = this.getIndex(indexName);
        if (!indexOptional.isPresent()) {
            this.getSchema().getTopology().lock();
            indexOptional = this.getIndex(indexName);
            if (!indexOptional.isPresent()) {
                return this.createIndex(indexName, indexType, properties);
            }
            return indexOptional.get();
        }
        return indexOptional.get();
    }

    private Index createIndex(String indexName, IndexType indexType, List<PropertyColumn> properties) {
        Index index = Index.createIndex(this.sqlgGraph, this, indexName, indexType, properties);
        this.uncommittedIndexes.put(indexName, index);
        this.getSchema().getTopology().fire(index, "", TopologyChangeAction.CREATE);
        return index;
    }

    void addIndex(Index i) {
        this.indexes.put(i.getName(), i);
    }

    public abstract Schema getSchema();

    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.label;
    }

    public String getFullName() {
        return this.getSchema().getName() + "." + this.getName();
    }

    public Map<String, PropertyColumn> getProperties() {
        HashMap<String, PropertyColumn> result = new HashMap<String, PropertyColumn>();
        result.putAll(this.properties);
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            result.putAll(this.uncommittedProperties);
            for (String s : this.uncommittedRemovedProperties) {
                result.remove(s);
            }
        }
        return result;
    }

    public Map<String, PropertyColumn> getGlobalUniqueIndexProperties() {
        HashMap<String, PropertyColumn> result = new HashMap<String, PropertyColumn>();
        result.putAll(this.globalUniqueIndexProperties);
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            result.putAll(this.uncommittedGlobalUniqueIndexProperties);
        }
        return result;
    }

    public Optional<PropertyColumn> getProperty(String key) {
        PropertyColumn propertyColumn = this.getProperties().get(key);
        if (propertyColumn != null) {
            return Optional.of(propertyColumn);
        }
        return Optional.empty();
    }

    public Map<String, Index> getIndexes() {
        HashMap<String, Index> result = new HashMap<String, Index>();
        result.putAll(this.indexes);
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            result.putAll(this.uncommittedIndexes);
            for (String i : this.uncommittedRemovedIndexes) {
                result.remove(i);
            }
        }
        return result;
    }

    public Optional<Index> getIndex(String key) {
        Index index = this.getIndexes().get(key);
        if (index != null) {
            return Optional.of(index);
        }
        return Optional.empty();
    }

    Map<String, PropertyType> getPropertyTypeMap() {
        HashMap<String, PropertyType> result = new HashMap<String, PropertyType>();
        this.properties.forEach((k, v) -> result.put((String)k, v.getPropertyType()));
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            this.uncommittedProperties.forEach((k, v) -> result.put((String)k, v.getPropertyType()));
            for (String s : this.uncommittedRemovedProperties) {
                result.remove(s);
            }
        }
        return result;
    }

    Map<String, PropertyColumn> getUncommittedPropertyTypeMap() {
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            return this.uncommittedProperties;
        }
        return Collections.emptyMap();
    }

    Set<String> getUncommittedRemovedProperties() {
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            return this.uncommittedRemovedProperties;
        }
        return Collections.emptySet();
    }

    static void buildColumns(SqlgGraph sqlgGraph, Map<String, PropertyType> columns, StringBuilder sql) {
        int i = 1;
        ArrayList<String> keys = new ArrayList<String>(columns.keySet());
        Collections.sort(keys);
        for (String column : keys) {
            String[] propertyTypeToSqlDefinition;
            PropertyType propertyType = columns.get(column);
            int count = 1;
            for (String sqlDefinition : propertyTypeToSqlDefinition = sqlgGraph.getSqlDialect().propertyTypeToSqlDefinition(propertyType)) {
                if (count > 1) {
                    sql.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(column + propertyType.getPostFixes()[count - 2])).append(" ").append(sqlDefinition);
                } else {
                    sql.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(column)).append(" ").append(sqlDefinition);
                }
                if (count++ >= propertyTypeToSqlDefinition.length) continue;
                sql.append(", ");
            }
            if (i++ >= columns.size()) continue;
            sql.append(", ");
        }
    }

    protected void addColumn(String schema, String table, ImmutablePair<String, PropertyType> keyValue) {
        String[] propertyTypeToSqlDefinition;
        int count = 1;
        for (String sqlDefinition : propertyTypeToSqlDefinition = this.sqlgGraph.getSqlDialect().propertyTypeToSqlDefinition((PropertyType)((Object)keyValue.getRight()))) {
            StringBuilder sql = new StringBuilder("ALTER TABLE ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(schema));
            sql.append(".");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(table));
            sql.append(" ADD ");
            if (count > 1) {
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes((String)keyValue.getLeft() + ((PropertyType)((Object)keyValue.getRight())).getPostFixes()[count - 2]));
            } else {
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes((String)keyValue.getLeft()));
            }
            ++count;
            sql.append(" ");
            sql.append(sqlDefinition);
            if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            Connection conn = this.sqlgGraph.tx().getConnection();
            try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void addProperty(Vertex propertyVertex) {
        PropertyColumn property = new PropertyColumn(this, (String)propertyVertex.value("name"), PropertyType.valueOf((String)propertyVertex.value("type")));
        this.properties.put((String)propertyVertex.value("name"), property);
    }

    void afterCommit() {
        Preconditions.checkState((boolean)this.getSchema().getTopology().isWriteLockHeldByCurrentThread(), (Object)"Abstract.afterCommit must hold the write lock");
        Iterator<Object> it = this.uncommittedProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PropertyColumn> entry = it.next();
            this.properties.put(entry.getKey(), entry.getValue());
            entry.getValue().afterCommit();
            it.remove();
        }
        it = this.uncommittedRemovedProperties.iterator();
        while (it.hasNext()) {
            String string = (String)it.next();
            this.properties.remove(string);
            it.remove();
        }
        it = this.uncommittedGlobalUniqueIndexProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            this.globalUniqueIndexProperties.put((String)entry.getKey(), (PropertyColumn)entry.getValue());
            ((PropertyColumn)entry.getValue()).afterCommit();
            it.remove();
        }
        it = this.uncommittedIndexes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            this.indexes.put((String)entry.getKey(), (Index)entry.getValue());
            ((Index)entry.getValue()).afterCommit();
            it.remove();
        }
        it = this.uncommittedRemovedIndexes.iterator();
        while (it.hasNext()) {
            String string = (String)it.next();
            this.indexes.remove(string);
            it.remove();
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            ((PropertyColumn)entry.getValue()).afterCommit();
        }
        this.committed = true;
    }

    void afterRollback() {
        Preconditions.checkState((boolean)this.getSchema().getTopology().isWriteLockHeldByCurrentThread(), (Object)"Abstract.afterRollback must hold the write lock");
        Iterator<Map.Entry<String, TopologyInf>> it = this.uncommittedProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PropertyColumn> entry = it.next();
            entry.getValue().afterRollback();
            it.remove();
        }
        this.uncommittedRemovedProperties.clear();
        this.uncommittedGlobalUniqueIndexProperties.clear();
        it = this.uncommittedIndexes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, TopologyInf> entry = it.next();
            ((Index)entry.getValue()).afterRollback();
            it.remove();
        }
        this.uncommittedRemovedIndexes.clear();
        for (Map.Entry<String, TopologyInf> entry : this.properties.entrySet()) {
            ((PropertyColumn)entry.getValue()).afterRollback();
        }
    }

    protected JsonNode toJson() {
        ArrayNode propertyArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (PropertyColumn property : this.properties.values()) {
            propertyArrayNode.add((JsonNode)property.toNotifyJson());
        }
        return propertyArrayNode;
    }

    protected Optional<JsonNode> toNotifyJson() {
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            ObjectNode result = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
            ArrayNode propertyArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (PropertyColumn propertyColumn : this.uncommittedProperties.values()) {
                propertyArrayNode.add((JsonNode)propertyColumn.toNotifyJson());
            }
            ArrayNode removedPropertyArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (String string : this.uncommittedRemovedProperties) {
                removedPropertyArrayNode.add(string);
            }
            ArrayNode arrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (Index index : this.uncommittedIndexes.values()) {
                Optional<JsonNode> indexJsonOptional = index.toNotifyJson();
                Preconditions.checkState((boolean)indexJsonOptional.isPresent());
                arrayNode.add(indexJsonOptional.get());
            }
            ArrayNode arrayNode2 = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (String property : this.uncommittedRemovedIndexes) {
                arrayNode2.add(property);
            }
            result.set("uncommittedProperties", (JsonNode)propertyArrayNode);
            result.set("uncommittedRemovedProperties", (JsonNode)removedPropertyArrayNode);
            result.set("uncommittedIndexes", (JsonNode)arrayNode);
            result.set("uncommittedRemovedIndexes", (JsonNode)arrayNode2);
            if (propertyArrayNode.size() == 0 && removedPropertyArrayNode.size() == 0 && arrayNode.size() == 0 && arrayNode2.size() == 0) {
                return Optional.empty();
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    void fromPropertyNotifyJson(JsonNode vertexLabelJson, boolean fire) {
        ArrayNode removedIndexArrayNode;
        ArrayNode indexNodes;
        ArrayNode removedPropertyArrayNode;
        ArrayNode propertiesNode = (ArrayNode)vertexLabelJson.get("uncommittedProperties");
        if (propertiesNode != null) {
            for (Object propertyNode : propertiesNode) {
                PropertyColumn propertyColumn = PropertyColumn.fromNotifyJson(this, (JsonNode)propertyNode);
                PropertyColumn old = this.properties.put(propertyColumn.getName(), propertyColumn);
                if (!fire || old != null) continue;
                this.getSchema().getTopology().fire(propertyColumn, "", TopologyChangeAction.CREATE);
            }
        }
        if ((removedPropertyArrayNode = (ArrayNode)vertexLabelJson.get("uncommittedRemovedProperties")) != null) {
            for (Object propertyNode : removedPropertyArrayNode) {
                String pName = propertyNode.asText();
                PropertyColumn old = this.properties.remove(pName);
                if (!fire || old == null) continue;
                this.getSchema().getTopology().fire(old, "", TopologyChangeAction.DELETE);
            }
        }
        if ((indexNodes = (ArrayNode)vertexLabelJson.get("uncommittedIndexes")) != null) {
            for (JsonNode indexNode : indexNodes) {
                Index index = Index.fromNotifyJson(this, indexNode);
                this.indexes.put(index.getName(), index);
                this.getSchema().getTopology().fire(index, "", TopologyChangeAction.CREATE);
            }
        }
        if ((removedIndexArrayNode = (ArrayNode)vertexLabelJson.get("uncommittedRemovedIndexes")) != null) {
            for (JsonNode indexNode : removedIndexArrayNode) {
                String iName = indexNode.asText();
                Index old = this.indexes.remove(iName);
                if (!fire || old == null) continue;
                this.getSchema().getTopology().fire(old, "", TopologyChangeAction.DELETE);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AbstractLabel)) {
            return false;
        }
        AbstractLabel other = (AbstractLabel)o;
        return this.label.equals(other.label);
    }

    void addGlobalUniqueIndexToUncommittedProperties(PropertyColumn propertyColumn) {
        this.uncommittedGlobalUniqueIndexProperties.put(propertyColumn.getName(), propertyColumn);
    }

    void addGlobalUniqueIndexToProperties(PropertyColumn propertyColumn) {
        this.globalUniqueIndexProperties.put(propertyColumn.getName(), propertyColumn);
    }

    protected abstract List<Topology.TopologyValidationError> validateTopology(DatabaseMetaData var1) throws SQLException;

    protected abstract String getPrefix();

    abstract void removeProperty(PropertyColumn var1, boolean var2);

    void removeColumn(String schema, String table, String column) {
        StringBuilder sql = new StringBuilder("ALTER TABLE ");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(schema));
        sql.append(".");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(table));
        sql.append(" DROP COLUMN IF EXISTS ");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(column));
        if (this.sqlgGraph.getSqlDialect().supportsCascade()) {
            sql.append(" CASCADE");
        }
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void removeIndex(Index idx, boolean preserveData) {
        this.getSchema().getTopology().lock();
        if (!this.uncommittedRemovedIndexes.contains(idx.getName())) {
            this.uncommittedRemovedIndexes.add(idx.getName());
            TopologyManager.removeIndex(this.sqlgGraph, idx);
            if (!preserveData) {
                idx.delete(this.sqlgGraph);
            }
            this.getSchema().getTopology().fire(idx, "", TopologyChangeAction.DELETE);
        }
    }
}

