/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.umlg.sqlg.sql.dialect.SqlBulkDialect;
import org.umlg.sqlg.structure.MetaEdge;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgProperty;
import org.umlg.sqlg.structure.SqlgVertex;

public class BatchManager {
    private SqlgGraph sqlgGraph;
    private SqlBulkDialect sqlDialect;
    private Map<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>> vertexCache = new HashMap<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>>();
    private Map<MetaEdge, Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>>> edgeCache = new HashMap<MetaEdge, Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>>>();
    private Map<SchemaTable, Pair<SortedSet<String>, Map<SqlgEdge, Map<String, Object>>>> edgePropertyCache = new LinkedHashMap<SchemaTable, Pair<SortedSet<String>, Map<SqlgEdge, Map<String, Object>>>>();
    private Map<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>> vertexPropertyCache = new LinkedHashMap<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>>();
    private Map<SchemaTable, List<SqlgVertex>> removeVertexCache = new LinkedHashMap<SchemaTable, List<SqlgVertex>>();
    private Map<SchemaTable, List<SqlgEdge>> removeEdgeCache = new LinkedHashMap<SchemaTable, List<SqlgEdge>>();
    private Map<SchemaTable, Writer> streamingVertexOutputStreamCache = new LinkedHashMap<SchemaTable, Writer>();
    private Map<SchemaTable, Writer> streamingEdgeOutputStreamCache = new LinkedHashMap<SchemaTable, Writer>();
    private SchemaTable streamingBatchModeVertexSchemaTable;
    private List<String> streamingBatchModeVertexKeys;
    private SchemaTable streamingBatchModeEdgeSchemaTable;
    private List<String> streamingBatchModeEdgeKeys;
    private int batchCount;
    private long batchIndex;
    private boolean isBusyFlushing;
    private BatchModeType batchModeType = BatchModeType.NONE;

    BatchManager(SqlgGraph sqlgGraph, SqlBulkDialect sqlDialect) {
        this.sqlgGraph = sqlgGraph;
        this.sqlDialect = sqlDialect;
    }

    public boolean isInNormalMode() {
        return this.batchModeType == BatchModeType.NORMAL;
    }

    public boolean isInStreamingMode() {
        return this.batchModeType == BatchModeType.STREAMING;
    }

    public boolean isInStreamingModeWithLock() {
        return this.batchModeType == BatchModeType.STREAMING_WITH_LOCK;
    }

    boolean isInBatchMode() {
        return this.batchModeType != BatchModeType.NONE;
    }

    BatchModeType getBatchModeType() {
        return this.batchModeType;
    }

    void batchModeOn(BatchModeType batchModeType) {
        this.batchModeType = batchModeType;
    }

    void addTemporaryVertex(SqlgVertex sqlgVertex, Map<String, Object> keyValueMap) {
        SchemaTable schemaTable = SchemaTable.of(sqlgVertex.getSchema(), sqlgVertex.getTable());
        Writer writer = this.streamingVertexOutputStreamCache.get(schemaTable);
        if (writer == null) {
            String sql = this.sqlDialect.constructCompleteCopyCommandTemporarySqlVertex(this.sqlgGraph, sqlgVertex, keyValueMap);
            writer = this.sqlDialect.streamSql(this.sqlgGraph, sql);
            this.streamingVertexOutputStreamCache.put(schemaTable, writer);
        }
        this.sqlDialect.writeStreamingVertex(writer, keyValueMap);
    }

    void addVertex(boolean streaming, SqlgVertex sqlgVertex, Map<String, Object> keyValueMap) {
        SchemaTable schemaTable = SchemaTable.of(sqlgVertex.getSchema(), sqlgVertex.getTable());
        if (!streaming) {
            Pair pairs = this.vertexCache.get(schemaTable);
            if (pairs == null) {
                pairs = Pair.of(new TreeSet<String>(keyValueMap.keySet()), new LinkedHashMap());
                ((Map)pairs.getRight()).put(sqlgVertex, keyValueMap);
                this.vertexCache.put(schemaTable, (Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>)pairs);
            } else {
                ((SortedSet)pairs.getLeft()).addAll(keyValueMap.keySet());
                ((Map)pairs.getRight()).put(sqlgVertex, keyValueMap);
            }
        } else {
            Writer writer;
            if (this.streamingBatchModeVertexSchemaTable == null) {
                this.streamingBatchModeVertexSchemaTable = sqlgVertex.getSchemaTable();
            }
            if (this.streamingBatchModeVertexKeys == null) {
                this.streamingBatchModeVertexKeys = new ArrayList<String>(keyValueMap.keySet());
            }
            if (this.isStreamingEdges()) {
                throw new IllegalStateException("streaming edge is in progress, first flush or commit before streaming vertices.");
            }
            if (this.isInStreamingModeWithLock() && this.batchCount == 0) {
                this.sqlDialect.lockTable(this.sqlgGraph, schemaTable, "V_");
                this.batchIndex = this.sqlDialect.nextSequenceVal(this.sqlgGraph, schemaTable, "V_");
            }
            if (this.isInStreamingModeWithLock()) {
                sqlgVertex.setInternalPrimaryKey(RecordId.from(schemaTable, ++this.batchIndex));
            }
            if ((writer = this.streamingVertexOutputStreamCache.get(schemaTable)) == null) {
                String sql = this.sqlDialect.constructCompleteCopyCommandSqlVertex(this.sqlgGraph, sqlgVertex, keyValueMap);
                writer = this.sqlDialect.streamSql(this.sqlgGraph, sql);
                this.streamingVertexOutputStreamCache.put(schemaTable, writer);
            }
            this.sqlDialect.writeStreamingVertex(writer, keyValueMap);
            if (this.isInStreamingModeWithLock()) {
                ++this.batchCount;
            }
        }
    }

    void addEdge(boolean streaming, SqlgEdge sqlgEdge, SqlgVertex outVertex, SqlgVertex inVertex, Map<String, Object> keyValueMap) {
        SchemaTable outSchemaTable = SchemaTable.of(outVertex.getSchema(), sqlgEdge.getTable());
        MetaEdge metaEdge = MetaEdge.from(outSchemaTable, outVertex, inVertex);
        if (!streaming) {
            Pair triples = this.edgeCache.get(metaEdge);
            if (triples == null) {
                triples = Pair.of(new TreeSet<String>(keyValueMap.keySet()), new LinkedHashMap());
                ((Map)triples.getRight()).put(sqlgEdge, Triple.of((Object)outVertex, (Object)inVertex, keyValueMap));
                this.edgeCache.put(metaEdge, (Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>>)triples);
            } else {
                ((SortedSet)triples.getLeft()).addAll(keyValueMap.keySet());
                ((Map)triples.getRight()).put(sqlgEdge, Triple.of((Object)outVertex, (Object)inVertex, keyValueMap));
            }
        } else {
            Writer writer;
            if (this.streamingBatchModeEdgeSchemaTable == null) {
                this.streamingBatchModeEdgeSchemaTable = sqlgEdge.getSchemaTablePrefixed();
            }
            if (this.streamingBatchModeEdgeKeys == null) {
                this.streamingBatchModeEdgeKeys = new ArrayList<String>(keyValueMap.keySet());
            }
            if (this.isStreamingVertices()) {
                throw new IllegalStateException("streaming vertex is in progress, first flush or commit before streaming edges.");
            }
            if (this.isInStreamingModeWithLock() && this.batchCount == 0) {
                this.sqlDialect.lockTable(this.sqlgGraph, outSchemaTable, "E_");
                this.batchIndex = this.sqlDialect.nextSequenceVal(this.sqlgGraph, outSchemaTable, "E_");
            }
            if (this.isInStreamingModeWithLock()) {
                sqlgEdge.setInternalPrimaryKey(RecordId.from(outSchemaTable, ++this.batchIndex));
            }
            if ((writer = this.streamingEdgeOutputStreamCache.get(outSchemaTable)) == null) {
                String sql = this.sqlDialect.constructCompleteCopyCommandSqlEdge(this.sqlgGraph, sqlgEdge, outVertex, inVertex, keyValueMap);
                writer = this.sqlDialect.streamSql(this.sqlgGraph, sql);
                this.streamingEdgeOutputStreamCache.put(outSchemaTable, writer);
            }
            try {
                this.sqlDialect.writeStreamingEdge(writer, sqlgEdge, outVertex, inVertex, keyValueMap);
                if (this.isInStreamingModeWithLock()) {
                    ++this.batchCount;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Map<SchemaTable, Pair<Long, Long>> flush() {
        this.isBusyFlushing = true;
        Map<SchemaTable, Pair<Long, Long>> verticesRange = this.sqlDialect.flushVertexCache(this.sqlgGraph, this.vertexCache);
        this.sqlDialect.flushEdgeCache(this.sqlgGraph, this.edgeCache);
        this.sqlDialect.flushVertexPropertyCache(this.sqlgGraph, this.vertexPropertyCache);
        this.sqlDialect.flushEdgePropertyCache(this.sqlgGraph, this.edgePropertyCache);
        this.sqlDialect.flushRemovedEdges(this.sqlgGraph, this.removeEdgeCache);
        this.sqlDialect.flushRemovedVertices(this.sqlgGraph, this.removeVertexCache);
        this.close();
        this.isBusyFlushing = false;
        this.sqlDialect.flushVertexGlobalUniqueIndexes(this.sqlgGraph, this.vertexCache);
        this.sqlDialect.flushEdgeGlobalUniqueIndexes(this.sqlgGraph, this.edgeCache);
        this.sqlDialect.flushVertexGlobalUniqueIndexPropertyCache(this.sqlgGraph, this.vertexPropertyCache);
        this.sqlDialect.flushEdgeGlobalUniqueIndexPropertyCache(this.sqlgGraph, this.edgePropertyCache);
        this.sqlDialect.flushRemovedGlobalUniqueIndexVertices(this.sqlgGraph, this.removeVertexCache);
        this.clear();
        return verticesRange;
    }

    public void close() {
        this.streamingVertexOutputStreamCache.values().forEach(o -> {
            try {
                o.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.streamingVertexOutputStreamCache.clear();
        this.streamingEdgeOutputStreamCache.values().forEach(o -> {
            try {
                o.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        if (this.isInStreamingModeWithLock()) {
            this.batchCount = 0;
        }
        this.streamingEdgeOutputStreamCache.clear();
        this.streamingBatchModeVertexSchemaTable = null;
        if (this.streamingBatchModeVertexKeys != null) {
            this.streamingBatchModeVertexKeys.clear();
        }
        this.streamingBatchModeEdgeSchemaTable = null;
        if (this.streamingBatchModeEdgeKeys != null) {
            this.streamingBatchModeEdgeKeys.clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean updateProperty(SqlgElement sqlgElement, String key, Object value) {
        SchemaTable schemaTable = SchemaTable.of(sqlgElement.getSchema(), sqlgElement.getTable());
        if (Vertex.class.isAssignableFrom(sqlgElement.getClass())) {
            Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> triples = this.vertexCache.get(schemaTable);
            if (triples != null) {
                Map triple = (Map)((Map)triples.getRight()).get(sqlgElement);
                if (triple == null) return false;
                triple.put(key, value);
                ((SortedSet)triples.getLeft()).add(key);
                return true;
            }
            Pair schemaVertices = this.vertexPropertyCache.get(schemaTable);
            if (schemaVertices == null) {
                schemaVertices = Pair.of(new TreeSet(), new LinkedHashMap());
                this.vertexPropertyCache.put(schemaTable, (Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>)schemaVertices);
            }
            SortedSet keys = (SortedSet)schemaVertices.getLeft();
            keys.add(key);
            LinkedHashMap<String, Object> properties = (LinkedHashMap<String, Object>)((Map)schemaVertices.getRight()).get(sqlgElement);
            if (properties == null) {
                properties = new LinkedHashMap<String, Object>();
                ((Map)schemaVertices.getRight()).put((SqlgVertex)sqlgElement, properties);
            }
            properties.put(key, value);
            return true;
        }
        SqlgEdge sqlgEdge = (SqlgEdge)sqlgElement;
        MetaEdge metaEdge = MetaEdge.from(schemaTable, sqlgEdge.getOutVertex(), sqlgEdge.getInVertex());
        Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> triples = this.edgeCache.get(metaEdge);
        if (triples != null) {
            Triple triple = (Triple)((Map)triples.getRight()).get(sqlgElement);
            if (triple == null) return false;
            ((Map)triple.getRight()).put(key, value);
            ((SortedSet)triples.getLeft()).add(key);
            return true;
        }
        Pair schemaEdges = this.edgePropertyCache.get(schemaTable);
        if (schemaEdges == null) {
            schemaEdges = Pair.of(new TreeSet(), new LinkedHashMap());
            this.edgePropertyCache.put(schemaTable, (Pair<SortedSet<String>, Map<SqlgEdge, Map<String, Object>>>)schemaEdges);
        }
        SortedSet keys = (SortedSet)schemaEdges.getLeft();
        keys.add(key);
        LinkedHashMap<String, Object> properties = (LinkedHashMap<String, Object>)((Map)schemaEdges.getRight()).get(sqlgElement);
        if (properties == null) {
            properties = new LinkedHashMap<String, Object>();
            ((Map)schemaEdges.getRight()).put((SqlgEdge)sqlgElement, properties);
        }
        properties.put(key, value);
        return true;
    }

    boolean removeProperty(SqlgProperty sqlgProperty, String key) {
        SqlgElement sqlgElement = (SqlgElement)sqlgProperty.element();
        SchemaTable schemaTable = SchemaTable.of(sqlgElement.getSchema(), sqlgElement.getTable());
        if (Vertex.class.isAssignableFrom(sqlgElement.getClass())) {
            Map triple;
            Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> triples = this.vertexCache.get(schemaTable);
            if (triples != null && (triple = (Map)((Map)triples.getRight()).get(sqlgElement)) != null) {
                triple.remove(key);
                return true;
            }
        } else {
            Triple triple;
            SqlgEdge sqlgEdge = (SqlgEdge)sqlgElement;
            MetaEdge metaEdge = MetaEdge.from(schemaTable, sqlgEdge.getOutVertex(), sqlgEdge.getInVertex());
            Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> triples = this.edgeCache.get(metaEdge);
            if (triples != null && (triple = (Triple)((Map)triples.getRight()).get(sqlgElement)) != null) {
                ((Map)triple.getRight()).remove(key);
                return true;
            }
        }
        return false;
    }

    boolean vertexIsCached(SqlgVertex vertex) {
        Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> map = this.vertexCache.get(SchemaTable.of(vertex.getSchema(), vertex.getTable()));
        return map != null && ((Map)map.getRight()).containsKey(vertex);
    }

    public void clear() {
        this.vertexCache.clear();
        this.edgeCache.clear();
        this.removeEdgeCache.clear();
        this.removeVertexCache.clear();
        this.edgePropertyCache.clear();
        this.vertexPropertyCache.clear();
    }

    void removeVertex(String schema, String table, SqlgVertex vertex) {
        SchemaTable schemaTable = SchemaTable.of(schema, table);
        Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> vertexSortedSetMapPair = this.vertexCache.get(schemaTable);
        if (vertexSortedSetMapPair != null && ((Map)vertexSortedSetMapPair.getRight()).containsKey(vertex)) {
            ((Map)vertexSortedSetMapPair.getRight()).remove(vertex);
            HashSet<MetaEdge> toRemoveMetaEdges = new HashSet<MetaEdge>();
            for (Map.Entry<MetaEdge, Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>>> metaEdgePairEntry : this.edgeCache.entrySet()) {
                MetaEdge metaEdge = metaEdgePairEntry.getKey();
                Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> edges = metaEdgePairEntry.getValue();
                HashSet<SqlgEdge> toRemove = new HashSet<SqlgEdge>();
                for (Map.Entry sqlgEdgeTripleEntry : ((Map)edges.getRight()).entrySet()) {
                    SqlgEdge sqlgEdge = (SqlgEdge)sqlgEdgeTripleEntry.getKey();
                    Triple inOutVertices = (Triple)sqlgEdgeTripleEntry.getValue();
                    if (!((SqlgVertex)inOutVertices.getLeft()).equals(vertex) && !((SqlgVertex)inOutVertices.getMiddle()).equals(vertex)) continue;
                    toRemove.add(sqlgEdge);
                }
                for (SqlgEdge sqlgEdge : toRemove) {
                    ((Map)edges.getRight()).remove(sqlgEdge);
                }
                if (!((Map)edges.getRight()).isEmpty()) continue;
                toRemoveMetaEdges.add(metaEdge);
            }
            for (MetaEdge toRemoveMetaEdge : toRemoveMetaEdges) {
                this.edgeCache.remove(toRemoveMetaEdge);
            }
        } else {
            List<SqlgVertex> vertices = this.removeVertexCache.get(schemaTable);
            if (vertices == null) {
                vertices = new ArrayList<SqlgVertex>();
                this.removeVertexCache.put(schemaTable, vertices);
            }
            vertices.add(vertex);
        }
    }

    void removeEdge(String schema, String table, SqlgEdge edge) {
        SchemaTable schemaTable = SchemaTable.of(schema, table);
        MetaEdge metaEdge = MetaEdge.from(schemaTable, edge.getOutVertex(), edge.getInVertex());
        Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> sqlgEdgeTripleMap = this.edgeCache.get(metaEdge);
        if (sqlgEdgeTripleMap != null && ((Map)sqlgEdgeTripleMap.getRight()).containsKey(edge)) {
            ((Map)sqlgEdgeTripleMap.getRight()).remove(edge);
        } else {
            List<SqlgEdge> edges = this.removeEdgeCache.get(schemaTable);
            if (edges == null) {
                edges = new ArrayList<SqlgEdge>();
                this.removeEdgeCache.put(schemaTable, edges);
            }
            edges.add(edge);
        }
    }

    SchemaTable getStreamingBatchModeVertexSchemaTable() {
        return this.streamingBatchModeVertexSchemaTable;
    }

    List<String> getStreamingBatchModeVertexKeys() {
        return this.streamingBatchModeVertexKeys;
    }

    SchemaTable getStreamingBatchModeEdgeSchemaTable() {
        return this.streamingBatchModeEdgeSchemaTable;
    }

    List<String> getStreamingBatchModeEdgeKeys() {
        return this.streamingBatchModeEdgeKeys;
    }

    public boolean isStreaming() {
        return this.isStreamingVertices() || this.isStreamingEdges();
    }

    private boolean isStreamingVertices() {
        return !this.streamingVertexOutputStreamCache.isEmpty();
    }

    private boolean isStreamingEdges() {
        return !this.streamingEdgeOutputStreamCache.isEmpty();
    }

    boolean isBusyFlushing() {
        return this.isBusyFlushing;
    }

    public static enum BatchModeType {
        NONE,
        NORMAL,
        STREAMING,
        STREAMING_WITH_LOCK;

    }
}

