/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.structure.AbstractLabel;
import org.umlg.sqlg.structure.EdgeRole;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.Schema;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyChangeAction;
import org.umlg.sqlg.structure.TopologyManager;
import org.umlg.sqlg.structure.VertexLabel;

public class EdgeLabel
extends AbstractLabel {
    private Logger logger = LoggerFactory.getLogger((String)EdgeLabel.class.getName());
    Set<VertexLabel> outVertexLabels = new HashSet<VertexLabel>();
    Set<VertexLabel> inVertexLabels = new HashSet<VertexLabel>();
    private Set<VertexLabel> uncommittedOutVertexLabels = new HashSet<VertexLabel>();
    private Set<VertexLabel> uncommittedInVertexLabels = new HashSet<VertexLabel>();
    private Set<VertexLabel> uncommittedRemovedInVertexLabels = new HashSet<VertexLabel>();
    private Set<VertexLabel> uncommittedRemovedOutVertexLabels = new HashSet<VertexLabel>();
    private Topology topology;

    static EdgeLabel loadSqlgSchemaEdgeLabel(String edgeLabelName, VertexLabel outVertexLabel, VertexLabel inVertexLabel, Map<String, PropertyType> properties) {
        EdgeLabel edgeLabel = new EdgeLabel(true, edgeLabelName, outVertexLabel, inVertexLabel, properties);
        return edgeLabel;
    }

    static EdgeLabel createEdgeLabel(String edgeLabelName, VertexLabel outVertexLabel, VertexLabel inVertexLabel, Map<String, PropertyType> properties) {
        EdgeLabel edgeLabel = new EdgeLabel(false, edgeLabelName, outVertexLabel, inVertexLabel, properties);
        if (!inVertexLabel.getSchema().isSqlgSchema()) {
            edgeLabel.createEdgeTable(outVertexLabel, inVertexLabel, properties);
        }
        edgeLabel.committed = false;
        return edgeLabel;
    }

    static EdgeLabel loadFromDb(Topology topology, String edgeLabelName) {
        return new EdgeLabel(topology, edgeLabelName);
    }

    private EdgeLabel(boolean forSqlgSchema, String edgeLabelName, VertexLabel outVertexLabel, VertexLabel inVertexLabel, Map<String, PropertyType> properties) {
        super(outVertexLabel.getSchema().getSqlgGraph(), edgeLabelName, properties);
        if (forSqlgSchema) {
            this.outVertexLabels.add(outVertexLabel);
            this.inVertexLabels.add(inVertexLabel);
        } else {
            this.uncommittedOutVertexLabels.add(outVertexLabel);
            this.uncommittedInVertexLabels.add(inVertexLabel);
        }
        this.topology = outVertexLabel.getSchema().getTopology();
    }

    EdgeLabel(Topology topology, String edgeLabelName) {
        super(topology.getSqlgGraph(), edgeLabelName, Collections.emptyMap());
        this.topology = topology;
    }

    @Override
    public Schema getSchema() {
        if (!this.outVertexLabels.isEmpty()) {
            VertexLabel vertexLabel = this.outVertexLabels.iterator().next();
            return vertexLabel.getSchema();
        }
        if (this.topology.isWriteLockHeldByCurrentThread() && !this.uncommittedOutVertexLabels.isEmpty()) {
            VertexLabel vertexLabel = this.uncommittedOutVertexLabels.iterator().next();
            return vertexLabel.getSchema();
        }
        throw new IllegalStateException("BUG: no outVertexLabels present when getSchema() is called");
    }

    public void ensurePropertiesExist(Map<String, PropertyType> columns) {
        for (Map.Entry<String, PropertyType> column : columns.entrySet()) {
            if (this.properties.containsKey(column.getKey()) || this.uncommittedProperties.containsKey(column.getKey())) continue;
            this.getSchema().getTopology().lock();
            if (this.uncommittedProperties.containsKey(column.getKey())) continue;
            TopologyManager.addEdgeColumn(this.sqlgGraph, this.getSchema().getName(), "E_" + this.getLabel(), column);
            this.addColumn(this.getSchema().getName(), "E_" + this.getLabel(), (ImmutablePair<String, PropertyType>)ImmutablePair.of((Object)column.getKey(), (Object)((Object)column.getValue())));
            PropertyColumn propertyColumn = new PropertyColumn(this, column.getKey(), column.getValue());
            propertyColumn.setCommitted(false);
            this.uncommittedProperties.put(column.getKey(), propertyColumn);
            this.getSchema().getTopology().fire(propertyColumn, "", TopologyChangeAction.CREATE);
        }
    }

    private void createEdgeTable(VertexLabel outVertexLabel, VertexLabel inVertexLabel, Map<String, PropertyType> columns) {
        String schema = outVertexLabel.getSchema().getName();
        String tableName = "E_" + this.getLabel();
        SqlDialect sqlDialect = this.sqlgGraph.getSqlDialect();
        sqlDialect.assertTableName(tableName);
        StringBuilder sql = new StringBuilder(sqlDialect.createTableStatement());
        sql.append(sqlDialect.maybeWrapInQoutes(schema));
        sql.append(".");
        sql.append(sqlDialect.maybeWrapInQoutes(tableName));
        sql.append("(");
        sql.append(sqlDialect.maybeWrapInQoutes("ID"));
        sql.append(" ");
        sql.append(sqlDialect.getAutoIncrementPrimaryKeyConstruct());
        if (columns.size() > 0) {
            sql.append(", ");
        }
        EdgeLabel.buildColumns(this.sqlgGraph, columns, sql);
        sql.append(", ");
        sql.append(sqlDialect.maybeWrapInQoutes(inVertexLabel.getFullName() + "__I"));
        sql.append(" ");
        sql.append(sqlDialect.getForeignKeyTypeDefinition());
        sql.append(", ");
        sql.append(sqlDialect.maybeWrapInQoutes(outVertexLabel.getFullName() + "__O"));
        sql.append(" ");
        sql.append(sqlDialect.getForeignKeyTypeDefinition());
        if (this.sqlgGraph.isImplementForeignKeys()) {
            sql.append(", ");
            sql.append("FOREIGN KEY (");
            sql.append(sqlDialect.maybeWrapInQoutes(inVertexLabel.getSchema().getName() + "." + inVertexLabel.getLabel() + "__I"));
            sql.append(") REFERENCES ");
            sql.append(sqlDialect.maybeWrapInQoutes(inVertexLabel.getSchema().getName()));
            sql.append(".");
            sql.append(sqlDialect.maybeWrapInQoutes("V_" + inVertexLabel.getLabel()));
            sql.append(" (");
            sql.append(sqlDialect.maybeWrapInQoutes("ID"));
            sql.append("), ");
            sql.append(" FOREIGN KEY (");
            sql.append(sqlDialect.maybeWrapInQoutes(outVertexLabel.getSchema().getName() + "." + outVertexLabel.getLabel() + "__O"));
            sql.append(") REFERENCES ");
            sql.append(sqlDialect.maybeWrapInQoutes(outVertexLabel.getSchema().getName()));
            sql.append(".");
            sql.append(sqlDialect.maybeWrapInQoutes("V_" + outVertexLabel.getLabel()));
            sql.append(" (");
            sql.append(sqlDialect.maybeWrapInQoutes("ID"));
            sql.append(")");
        }
        sql.append(")");
        if (sqlDialect.needsSemicolon()) {
            sql.append(";");
        }
        if (sqlDialect.needForeignKeyIndex()) {
            sql.append("\nCREATE INDEX ON ");
            sql.append(sqlDialect.maybeWrapInQoutes(schema));
            sql.append(".");
            sql.append(sqlDialect.maybeWrapInQoutes(tableName));
            sql.append(" (");
            sql.append(sqlDialect.maybeWrapInQoutes(inVertexLabel.getSchema().getName() + "." + inVertexLabel.getLabel() + "__I"));
            sql.append(");");
            sql.append("\nCREATE INDEX ON ");
            sql.append(sqlDialect.maybeWrapInQoutes(schema));
            sql.append(".");
            sql.append(sqlDialect.maybeWrapInQoutes(tableName));
            sql.append(" (");
            sql.append(sqlDialect.maybeWrapInQoutes(outVertexLabel.getSchema().getName() + "." + outVertexLabel.getLabel() + "__O"));
            sql.append(");");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void afterCommit() {
        VertexLabel vertexLabel;
        Preconditions.checkState((boolean)this.getSchema().getTopology().isWriteLockHeldByCurrentThread(), (Object)"EdgeLabel.afterCommit must hold the write lock");
        super.afterCommit();
        Iterator<VertexLabel> it = this.uncommittedInVertexLabels.iterator();
        while (it.hasNext()) {
            vertexLabel = it.next();
            this.inVertexLabels.add(vertexLabel);
            it.remove();
        }
        it = this.uncommittedRemovedInVertexLabels.iterator();
        while (it.hasNext()) {
            vertexLabel = it.next();
            this.inVertexLabels.remove(vertexLabel);
            it.remove();
        }
        it = this.uncommittedOutVertexLabels.iterator();
        while (it.hasNext()) {
            vertexLabel = it.next();
            this.outVertexLabels.add(vertexLabel);
            it.remove();
        }
        it = this.uncommittedRemovedOutVertexLabels.iterator();
        while (it.hasNext()) {
            vertexLabel = it.next();
            this.outVertexLabels.remove(vertexLabel);
            it.remove();
        }
    }

    void afterRollbackInEdges(VertexLabel vertexLabel) {
        Preconditions.checkState((boolean)this.getSchema().getTopology().isWriteLockHeldByCurrentThread(), (Object)"EdgeLabel.afterRollback must hold the write lock");
        super.afterRollback();
        this.uncommittedInVertexLabels.remove(vertexLabel);
    }

    void afterRollbackOutEdges(VertexLabel vertexLabel) {
        Preconditions.checkState((boolean)this.getSchema().getTopology().isWriteLockHeldByCurrentThread(), (Object)"EdgeLabel.afterRollback must hold the write lock");
        super.afterRollback();
        this.uncommittedOutVertexLabels.remove(vertexLabel);
    }

    public String toString() {
        return this.toJson().toString();
    }

    private boolean foreignKeysContains(Direction direction, VertexLabel vertexLabel) {
        switch (direction) {
            case OUT: {
                if (!this.outVertexLabels.contains(vertexLabel)) break;
                return true;
            }
            case IN: {
                if (!this.inVertexLabels.contains(vertexLabel)) break;
                return true;
            }
            case BOTH: {
                throw new IllegalStateException("foreignKeysContains may not be called for Direction.BOTH");
            }
        }
        if (this.topology.isWriteLockHeldByCurrentThread()) {
            switch (direction) {
                case OUT: {
                    if (!this.uncommittedOutVertexLabels.contains(vertexLabel)) break;
                    return true;
                }
                case IN: {
                    if (!this.uncommittedInVertexLabels.contains(vertexLabel)) break;
                    return true;
                }
                case BOTH: {
                    throw new IllegalStateException("foreignKeysContains may not be called for Direction.BOTH");
                }
            }
        }
        return false;
    }

    Set<String> getAllEdgeForeignKeys() {
        HashSet<String> result = new HashSet<String>();
        for (VertexLabel vertexLabel : this.getInVertexLabels()) {
            if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && this.uncommittedRemovedInVertexLabels.contains(vertexLabel)) continue;
            result.add(vertexLabel.getSchema().getName() + "." + vertexLabel.getLabel() + "__I");
        }
        for (VertexLabel vertexLabel : this.getOutVertexLabels()) {
            if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && this.uncommittedRemovedOutVertexLabels.contains(vertexLabel)) continue;
            result.add(vertexLabel.getSchema().getName() + "." + vertexLabel.getLabel() + "__O");
        }
        return result;
    }

    Set<String> getUncommittedEdgeForeignKeys() {
        HashSet<String> result = new HashSet<String>();
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            for (VertexLabel vertexLabel : this.uncommittedInVertexLabels) {
                if (this.uncommittedRemovedInVertexLabels.contains(vertexLabel)) continue;
                result.add(vertexLabel.getFullName() + "__I");
            }
            for (VertexLabel vertexLabel : this.uncommittedOutVertexLabels) {
                if (this.uncommittedRemovedOutVertexLabels.contains(vertexLabel)) continue;
                result.add(vertexLabel.getFullName() + "__O");
            }
        }
        return result;
    }

    boolean isValid() {
        return this.outVertexLabels.size() > 0 || this.uncommittedOutVertexLabels.size() > 0;
    }

    public Set<VertexLabel> getOutVertexLabels() {
        HashSet<VertexLabel> result = new HashSet<VertexLabel>();
        result.addAll(this.outVertexLabels);
        if (this.isValid() && this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            result.addAll(this.uncommittedOutVertexLabels);
            result.removeAll(this.uncommittedRemovedOutVertexLabels);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<VertexLabel> getInVertexLabels() {
        HashSet<VertexLabel> result = new HashSet<VertexLabel>();
        result.addAll(this.inVertexLabels);
        if (this.isValid() && this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            result.addAll(this.uncommittedInVertexLabels);
            result.removeAll(this.uncommittedRemovedInVertexLabels);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<EdgeRole> getOutEdgeRoles() {
        HashSet<EdgeRole> result = new HashSet<EdgeRole>();
        for (VertexLabel lbl : this.outVertexLabels) {
            if (this.uncommittedOutVertexLabels.contains(lbl)) continue;
            result.add(new EdgeRole(lbl, this, Direction.OUT, true));
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            for (VertexLabel lbl : this.uncommittedOutVertexLabels) {
                if (this.uncommittedOutVertexLabels.contains(lbl)) continue;
                result.add(new EdgeRole(lbl, this, Direction.OUT, false));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<EdgeRole> getInEdgeRoles() {
        HashSet<EdgeRole> result = new HashSet<EdgeRole>();
        for (VertexLabel lbl : this.inVertexLabels) {
            if (this.uncommittedInVertexLabels.contains(lbl)) continue;
            result.add(new EdgeRole(lbl, this, Direction.IN, true));
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            for (VertexLabel lbl : this.uncommittedInVertexLabels) {
                if (this.uncommittedInVertexLabels.contains(lbl)) continue;
                result.add(new EdgeRole(lbl, this, Direction.IN, false));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public void ensureEdgeVertexLabelExist(Direction direction, VertexLabel vertexLabel) {
        if (direction == Direction.OUT) {
            Preconditions.checkState((boolean)vertexLabel.getSchema().equals(this.getSchema()), (String)"For Direction.OUT the VertexLabel must be in the same schema as the edge. Found %s and %s", (Object[])new Object[]{vertexLabel.getSchema().getName(), this.getSchema().getName()});
        }
        SchemaTable foreignKey = SchemaTable.of(vertexLabel.getSchema().getName(), vertexLabel.getLabel() + (direction == Direction.IN ? "__I" : "__O"));
        if (!this.foreignKeysContains(direction, vertexLabel)) {
            Schema schema = this.getSchema();
            schema.getTopology().lock();
            if (!this.foreignKeysContains(direction, vertexLabel)) {
                TopologyManager.addLabelToEdge(this.sqlgGraph, this.getSchema().getName(), "E_" + this.getLabel(), direction == Direction.IN, foreignKey);
                if (direction == Direction.IN) {
                    this.uncommittedInVertexLabels.add(vertexLabel);
                    vertexLabel.addToUncommittedInEdgeLabels(schema, this);
                } else {
                    this.uncommittedOutVertexLabels.add(vertexLabel);
                    vertexLabel.addToUncommittedOutEdgeLabels(schema, this);
                }
                SchemaTable vertexSchemaTable = SchemaTable.of(vertexLabel.getSchema().getName(), vertexLabel.getLabel());
                this.addEdgeForeignKey(schema.getName(), "E_" + this.getLabel(), foreignKey, vertexSchemaTable);
                this.getSchema().getTopology().fire(this, vertexSchemaTable.toString(), TopologyChangeAction.ADD_IN_VERTEX_LABELTO_EDGE);
            }
        }
    }

    private void addEdgeForeignKey(String schema, String table, SchemaTable foreignKey, SchemaTable otherVertex) {
        Throwable throwable;
        PreparedStatement preparedStatement;
        Preconditions.checkState((!this.getSchema().isSqlgSchema() ? 1 : 0) != 0, (String)"BUG: ensureEdgeVertexLabelExist may not be called for %s", (Object[])new Object[]{"sqlg_schema"});
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(schema));
        sql.append(".");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(table));
        sql.append(" ADD COLUMN ");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(foreignKey.getSchema() + "." + foreignKey.getTable()));
        sql.append(" ");
        sql.append(this.sqlgGraph.getSqlDialect().getForeignKeyTypeDefinition());
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try {
            preparedStatement = conn.prepareStatement(sql.toString());
            throwable = null;
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        sql.setLength(0);
        if (this.sqlgGraph.isImplementForeignKeys()) {
            sql.append(" ALTER TABLE ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(schema));
            sql.append(".");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(table));
            sql.append(" ADD CONSTRAINT ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(table + "_" + foreignKey.getSchema() + "." + foreignKey.getTable() + "_fkey"));
            sql.append(" FOREIGN KEY (");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(foreignKey.getSchema() + "." + foreignKey.getTable()));
            sql.append(") REFERENCES ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(otherVertex.getSchema()));
            sql.append(".");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("V_" + otherVertex.getTable()));
            sql.append(" (");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
            sql.append(")");
            if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            try {
                preparedStatement = conn.prepareStatement(sql.toString());
                throwable = null;
                try {
                    preparedStatement.executeUpdate();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (preparedStatement != null) {
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            preparedStatement.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        sql.setLength(0);
        if (this.sqlgGraph.getSqlDialect().needForeignKeyIndex()) {
            sql.append("\nCREATE INDEX ON ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(schema));
            sql.append(".");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(table));
            sql.append(" (");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(foreignKey.getSchema() + "." + foreignKey.getTable()));
            sql.append(")");
            if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            try {
                preparedStatement = conn.prepareStatement(sql.toString());
                throwable = null;
                try {
                    preparedStatement.executeUpdate();
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (preparedStatement != null) {
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            preparedStatement.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void addToOutVertexLabel(VertexLabel vertexLabel) {
        this.outVertexLabels.add(vertexLabel);
    }

    void addToInVertexLabel(VertexLabel vertexLabel) {
        this.inVertexLabels.add(vertexLabel);
    }

    public int hashCode() {
        VertexLabel vertexLabel = !this.outVertexLabels.isEmpty() ? this.outVertexLabels.iterator().next() : this.uncommittedOutVertexLabels.iterator().next();
        return (vertexLabel.getSchema().getName() + this.getLabel()).hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof EdgeLabel)) {
            return false;
        }
        EdgeLabel otherEdgeLabel = (EdgeLabel)other;
        if (this.isValid()) {
            if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedInVertexLabels.isEmpty()) {
                VertexLabel vertexLabel = this.uncommittedOutVertexLabels.iterator().next();
                VertexLabel otherVertexLabel = otherEdgeLabel.uncommittedOutVertexLabels.iterator().next();
                return vertexLabel.getSchema().equals(otherVertexLabel.getSchema()) && otherEdgeLabel.getLabel().equals(this.getLabel());
            }
            VertexLabel vertexLabel = this.outVertexLabels.iterator().next();
            VertexLabel otherVertexLabel = otherEdgeLabel.outVertexLabels.iterator().next();
            return vertexLabel.getSchema().equals(otherVertexLabel.getSchema()) && otherEdgeLabel.getLabel().equals(this.getLabel());
        }
        return otherEdgeLabel.getLabel().equals(this.getLabel());
    }

    boolean deepEquals(EdgeLabel otherEdgeLabel) {
        boolean ok;
        Preconditions.checkState((boolean)this.equals(otherEdgeLabel), (Object)"equals must have passed before calling deepEquals");
        for (VertexLabel outVertexLabel : this.outVertexLabels) {
            ok = false;
            for (VertexLabel otherOutVertexLabel : otherEdgeLabel.outVertexLabels) {
                if (!outVertexLabel.equals(otherOutVertexLabel)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        for (VertexLabel inVertexLabel : this.inVertexLabels) {
            ok = false;
            for (VertexLabel otherInVertexLabel : otherEdgeLabel.inVertexLabels) {
                if (!inVertexLabel.equals(otherInVertexLabel)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    @Override
    protected JsonNode toJson() {
        ObjectNode inVertexLabelObjectNode;
        ObjectNode edgeLabelNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        if (this.isValid()) {
            edgeLabelNode.put("schema", this.getSchema().getName());
        }
        edgeLabelNode.put("label", this.getLabel());
        edgeLabelNode.set("properties", super.toJson());
        ArrayNode outVertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (VertexLabel outVertexLabel : this.outVertexLabels) {
            ObjectNode outVertexLabelObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
            outVertexLabelObjectNode.put("label", outVertexLabel.getLabel());
            outVertexLabelArrayNode.add((JsonNode)outVertexLabelObjectNode);
        }
        edgeLabelNode.set("outVertexLabels", (JsonNode)outVertexLabelArrayNode);
        ArrayNode inVertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (VertexLabel inVertexLabel : this.inVertexLabels) {
            inVertexLabelObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
            inVertexLabelObjectNode.put("label", inVertexLabel.getLabel());
            inVertexLabelArrayNode.add((JsonNode)inVertexLabelObjectNode);
        }
        edgeLabelNode.set("inVertexLabels", (JsonNode)inVertexLabelArrayNode);
        if (this.isValid() && this.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            outVertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (VertexLabel outVertexLabel : this.uncommittedOutVertexLabels) {
                ObjectNode outVertexLabelObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
                outVertexLabelObjectNode.put("label", outVertexLabel.getLabel());
                outVertexLabelArrayNode.add((JsonNode)outVertexLabelObjectNode);
            }
            edgeLabelNode.set("uncommittedOutVertexLabels", (JsonNode)outVertexLabelArrayNode);
            inVertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (VertexLabel inVertexLabel : this.uncommittedInVertexLabels) {
                inVertexLabelObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
                inVertexLabelObjectNode.put("label", inVertexLabel.getLabel());
                inVertexLabelArrayNode.add((JsonNode)inVertexLabelObjectNode);
            }
            edgeLabelNode.set("uncommittedInVertexLabels", (JsonNode)inVertexLabelArrayNode);
        }
        return edgeLabelNode;
    }

    @Override
    protected Optional<JsonNode> toNotifyJson() {
        ObjectNode inVertexLabelObjectNode;
        ArrayNode inVertexLabelArrayNode;
        ObjectNode outVertexLabelObjectNode;
        ArrayNode outVertexLabelArrayNode;
        boolean foundSomething = false;
        ObjectNode edgeLabelNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        edgeLabelNode.put("schema", this.getSchema().getName());
        edgeLabelNode.put("label", this.getLabel());
        Optional<JsonNode> abstractLabelNode = super.toNotifyJson();
        if (abstractLabelNode.isPresent()) {
            foundSomething = true;
            edgeLabelNode.set("uncommittedProperties", abstractLabelNode.get().get("uncommittedProperties"));
            edgeLabelNode.set("uncommittedIndexes", abstractLabelNode.get().get("uncommittedIndexes"));
            edgeLabelNode.set("uncommittedRemovedProperties", abstractLabelNode.get().get("uncommittedRemovedProperties"));
            edgeLabelNode.set("uncommittedRemovedIndexes", abstractLabelNode.get().get("uncommittedRemovedIndexes"));
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedOutVertexLabels.isEmpty()) {
            foundSomething = true;
            outVertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (VertexLabel outVertexLabel : this.uncommittedOutVertexLabels) {
                outVertexLabelObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
                outVertexLabelObjectNode.put("label", outVertexLabel.getLabel());
                outVertexLabelArrayNode.add((JsonNode)outVertexLabelObjectNode);
            }
            edgeLabelNode.set("uncommittedOutVertexLabels", (JsonNode)outVertexLabelArrayNode);
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedRemovedOutVertexLabels.isEmpty()) {
            foundSomething = true;
            outVertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (VertexLabel outVertexLabel : this.uncommittedRemovedOutVertexLabels) {
                outVertexLabelObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
                outVertexLabelObjectNode.put("label", outVertexLabel.getLabel());
                outVertexLabelArrayNode.add((JsonNode)outVertexLabelObjectNode);
            }
            edgeLabelNode.set("uncommittedRemovedOutVertexLabels", (JsonNode)outVertexLabelArrayNode);
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedInVertexLabels.isEmpty()) {
            foundSomething = true;
            inVertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (VertexLabel inVertexLabel : this.uncommittedInVertexLabels) {
                inVertexLabelObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
                inVertexLabelObjectNode.put("label", inVertexLabel.getLabel());
                inVertexLabelArrayNode.add((JsonNode)inVertexLabelObjectNode);
            }
            edgeLabelNode.set("uncommittedInVertexLabels", (JsonNode)inVertexLabelArrayNode);
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedRemovedInVertexLabels.isEmpty()) {
            foundSomething = true;
            inVertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (VertexLabel inVertexLabel : this.uncommittedRemovedInVertexLabels) {
                inVertexLabelObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
                inVertexLabelObjectNode.put("label", inVertexLabel.getLabel());
                inVertexLabelArrayNode.add((JsonNode)inVertexLabelObjectNode);
            }
            edgeLabelNode.set("uncommittedRemovedInVertexLabels", (JsonNode)inVertexLabelArrayNode);
        }
        if (foundSomething) {
            return Optional.of(edgeLabelNode);
        }
        return Optional.empty();
    }

    @Override
    public List<Topology.TopologyValidationError> validateTopology(DatabaseMetaData metadata) throws SQLException {
        ArrayList<Topology.TopologyValidationError> validationErrors = new ArrayList<Topology.TopologyValidationError>();
        for (PropertyColumn propertyColumn : this.getProperties().values()) {
            ResultSet propertyRs = metadata.getColumns(null, this.getSchema().getName(), "E_" + this.getLabel(), propertyColumn.getName());
            Throwable throwable = null;
            try {
                if (propertyRs.next()) continue;
                validationErrors.add(new Topology.TopologyValidationError(propertyColumn));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (propertyRs == null) continue;
                if (throwable != null) {
                    try {
                        propertyRs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                propertyRs.close();
            }
        }
        return validationErrors;
    }

    @Override
    protected String getPrefix() {
        return "E_";
    }

    @Override
    void removeProperty(PropertyColumn propertyColumn, boolean preserveData) {
        this.getSchema().getTopology().lock();
        if (!this.uncommittedRemovedProperties.contains(propertyColumn.getName())) {
            this.uncommittedRemovedProperties.add(propertyColumn.getName());
            TopologyManager.removeEdgeColumn(this.sqlgGraph, this.getSchema().getName(), "E_" + this.getLabel(), propertyColumn.getName());
            if (!preserveData) {
                this.removeColumn(this.getSchema().getName(), "E_" + this.getLabel(), propertyColumn.getName());
            }
            this.getSchema().getTopology().fire(propertyColumn, "", TopologyChangeAction.DELETE);
        }
    }

    @Override
    public void remove(boolean preserveData) {
        this.getSchema().removeEdgeLabel(this, preserveData);
    }

    void delete() {
        String schema = this.getSchema().getName();
        String tableName = "E_" + this.getLabel();
        SqlDialect sqlDialect = this.sqlgGraph.getSqlDialect();
        sqlDialect.assertTableName(tableName);
        StringBuilder sql = new StringBuilder("DROP TABLE IF EXISTS ");
        sql.append(sqlDialect.maybeWrapInQoutes(schema));
        sql.append(".");
        sql.append(sqlDialect.maybeWrapInQoutes(tableName));
        if (sqlDialect.supportsCascade()) {
            sql.append(" CASCADE");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        if (sqlDialect.needsSemicolon()) {
            sql.append(";");
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void deleteColumn(String column) {
        this.removeColumn(this.getSchema().getName(), "E_" + this.getLabel(), column);
    }

    void removeOutVertexLabel(VertexLabel lbl, boolean preserveData) {
        this.uncommittedRemovedOutVertexLabels.add(lbl);
        if (!preserveData) {
            this.deleteColumn(lbl.getFullName() + "__O");
        }
    }

    void removeInVertexLabel(VertexLabel lbl, boolean preserveData) {
        this.uncommittedRemovedInVertexLabels.add(lbl);
        if (!preserveData) {
            this.deleteColumn(lbl.getFullName() + "__I");
        }
    }
}

