/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import org.apache.tinkerpop.gremlin.structure.Direction;
import org.umlg.sqlg.structure.EdgeLabel;
import org.umlg.sqlg.structure.TopologyInf;
import org.umlg.sqlg.structure.VertexLabel;

public class EdgeRole
implements TopologyInf {
    private VertexLabel vertexLabel;
    private EdgeLabel edgeLabel;
    private Direction direction;
    private boolean committed;

    EdgeRole(VertexLabel vertexLabel, EdgeLabel edgeLabel, Direction direction, boolean committed) {
        this.vertexLabel = vertexLabel;
        this.edgeLabel = edgeLabel;
        this.direction = direction;
        this.committed = committed;
    }

    public VertexLabel getVertexLabel() {
        return this.vertexLabel;
    }

    public EdgeLabel getEdgeLabel() {
        return this.edgeLabel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.edgeLabel == null ? 0 : this.edgeLabel.hashCode());
        result = 31 * result + (this.vertexLabel == null ? 0 : this.vertexLabel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EdgeRole other = (EdgeRole)obj;
        if (this.direction != other.direction) {
            return false;
        }
        if (this.edgeLabel == null ? other.edgeLabel != null : !this.edgeLabel.equals(other.edgeLabel)) {
            return false;
        }
        return !(this.vertexLabel == null ? other.vertexLabel != null : !this.vertexLabel.equals(other.vertexLabel));
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public void remove(boolean preserveData) {
        this.getVertexLabel().removeEdgeRole(this, preserveData);
    }

    @Override
    public String getName() {
        String dir = "";
        switch (this.direction) {
            case BOTH: {
                dir = "<->";
                break;
            }
            case IN: {
                dir = "<-";
                break;
            }
            case OUT: {
                dir = "->";
                break;
            }
            default: {
                dir = "unknown";
            }
        }
        return this.vertexLabel.getName() + dir + this.edgeLabel.getName();
    }

    public String toString() {
        return this.getName();
    }
}

