/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.umlg.sqlg.structure.IndexType;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyInf;
import org.umlg.sqlg.structure.TopologyManager;
import org.umlg.sqlg.structure.VertexLabel;

public class GlobalUniqueIndex
implements TopologyInf {
    private Topology topology;
    private String name;
    private boolean committed = true;
    private Set<PropertyColumn> properties = new HashSet<PropertyColumn>();
    private Set<PropertyColumn> uncommittedProperties = new HashSet<PropertyColumn>();
    public static final String GLOBAL_UNIQUE_INDEX_VALUE = "value";
    public static final String GLOBAL_UNIQUE_INDEX_RECORD_ID = "recordId";
    public static final String GLOBAL_UNIQUE_INDEX_PROPERTY_NAME = "property";

    private GlobalUniqueIndex(Topology topology, String name, Set<PropertyColumn> uncommittedProperties) {
        this.topology = topology;
        this.name = name;
        this.uncommittedProperties = uncommittedProperties;
        for (PropertyColumn uncommittedProperty : uncommittedProperties) {
            uncommittedProperty.addGlobalUniqueIndex(this);
        }
    }

    public Set<PropertyColumn> getProperties() {
        return this.properties;
    }

    private GlobalUniqueIndex(Topology topology, String name) {
        this.topology = topology;
        this.name = name;
    }

    static GlobalUniqueIndex instantiateGlobalUniqueIndex(Topology topology, String name) {
        return new GlobalUniqueIndex(topology, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalUniqueIndex)) {
            return false;
        }
        GlobalUniqueIndex otherIndex = (GlobalUniqueIndex)other;
        return this.name.equals(otherIndex.name);
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    void addGlobalUniqueProperties(Set<PropertyColumn> properties) {
        for (PropertyColumn property : properties) {
            property.addToGlobalUniqueIndexes(this);
        }
        this.properties = properties;
    }

    void afterCommit() {
        Iterator<PropertyColumn> propertyColumnIterator = this.uncommittedProperties.iterator();
        while (propertyColumnIterator.hasNext()) {
            PropertyColumn propertyColumn = propertyColumnIterator.next();
            this.properties.add(propertyColumn);
            propertyColumnIterator.remove();
        }
        this.committed = true;
    }

    void afterRollback() {
        this.uncommittedProperties.clear();
    }

    static GlobalUniqueIndex createGlobalUniqueIndex(SqlgGraph sqlgGraph, Topology topology, String globalUniqueIndexName, Set<PropertyColumn> properties) {
        PropertyType propertyType = properties.iterator().next().getPropertyType();
        HashMap<String, PropertyType> valueColumn = new HashMap<String, PropertyType>();
        valueColumn.put(GLOBAL_UNIQUE_INDEX_RECORD_ID, PropertyType.STRING);
        valueColumn.put(GLOBAL_UNIQUE_INDEX_PROPERTY_NAME, PropertyType.STRING);
        valueColumn.put(GLOBAL_UNIQUE_INDEX_VALUE, propertyType);
        VertexLabel vertexLabel = topology.getGlobalUniqueIndexSchema().ensureVertexLabelExist(globalUniqueIndexName, valueColumn);
        PropertyColumn valuePropertyColumn = vertexLabel.getProperty(GLOBAL_UNIQUE_INDEX_VALUE).get();
        PropertyColumn recordIdColumn = vertexLabel.getProperty(GLOBAL_UNIQUE_INDEX_RECORD_ID).get();
        PropertyColumn propertyColumn = vertexLabel.getProperty(GLOBAL_UNIQUE_INDEX_PROPERTY_NAME).get();
        vertexLabel.ensureIndexExists(IndexType.UNIQUE, Collections.singletonList(valuePropertyColumn));
        vertexLabel.ensureIndexExists(IndexType.UNIQUE, Arrays.asList(recordIdColumn, propertyColumn));
        GlobalUniqueIndex globalUniqueIndex = new GlobalUniqueIndex(topology, globalUniqueIndexName, properties);
        topology.getGlobalUniqueIndexSchema().globalUniqueIndexes.put(globalUniqueIndex.getName(), globalUniqueIndex);
        TopologyManager.addGlobalUniqueIndex(sqlgGraph, globalUniqueIndexName, properties);
        globalUniqueIndex.committed = false;
        return globalUniqueIndex;
    }

    static String globalUniqueIndexName(Topology topology, Set<PropertyColumn> properties) {
        ArrayList<PropertyColumn> propertyColumns = new ArrayList<PropertyColumn>(properties);
        propertyColumns.sort(Comparator.comparing(PropertyColumn::getName));
        String name = propertyColumns.stream().map(p -> p.getParentLabel().getLabel() + "_" + p.getName()).reduce((a, b) -> a + "_" + b).get();
        if (("gui_schema_V_A" + name).length() > 50) {
            name = "globalUniqueIndex_" + topology.getGlobalUniqueIndexes().size();
        }
        return name;
    }

    Optional<JsonNode> toNotifyJson() {
        Preconditions.checkState((boolean)this.topology.isWriteLockHeldByCurrentThread(), (Object)"GlobalUniqueIndex toNotifyJson() may only be called is the lock is held.");
        ObjectNode result = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        ArrayNode propertyArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (PropertyColumn property : this.uncommittedProperties) {
            ObjectNode objectNode = property.toNotifyJson();
            objectNode.put("schemaName", property.getParentLabel().getSchema().getName());
            objectNode.put("abstractLabelLabel", property.getParentLabel().getLabel());
            propertyArrayNode.add((JsonNode)objectNode);
        }
        result.put("name", this.getName());
        result.set("uncommittedProperties", (JsonNode)propertyArrayNode);
        return Optional.of(result);
    }

    protected JsonNode toJson() {
        ObjectNode result = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        ArrayNode propertyArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (PropertyColumn property : this.properties) {
            ObjectNode objectNode = property.toNotifyJson();
            objectNode.put("schemaName", property.getParentLabel().getSchema().getName());
            objectNode.put("abstractLabelLabel", property.getParentLabel().getLabel());
            propertyArrayNode.add((JsonNode)objectNode);
        }
        result.put("name", this.getName());
        result.set("properties", (JsonNode)propertyArrayNode);
        return result;
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public void remove(boolean preserveData) {
        this.topology.getGlobalUniqueIndexSchema().removeGlobalUniqueIndex(this, preserveData);
    }
}

