/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.structure.AbstractLabel;
import org.umlg.sqlg.structure.IndexType;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyInf;
import org.umlg.sqlg.structure.TopologyManager;
import org.umlg.sqlg.structure.VertexLabel;

public class Index
implements TopologyInf {
    private Logger logger = LoggerFactory.getLogger((String)Index.class.getName());
    private String name;
    private boolean committed = true;
    private AbstractLabel abstractLabel;
    private IndexType indexType;
    private List<PropertyColumn> properties = new ArrayList<PropertyColumn>();
    private IndexType uncommittedIndexType;
    private List<PropertyColumn> uncommittedProperties = new ArrayList<PropertyColumn>();

    Index(String name, IndexType indexType, AbstractLabel abstractLabel, List<PropertyColumn> properties) {
        this.name = name;
        this.indexType = indexType;
        this.uncommittedIndexType = indexType;
        this.abstractLabel = abstractLabel;
        this.uncommittedProperties.addAll(properties);
    }

    Index(String name, IndexType indexType, AbstractLabel abstractLabel) {
        this.name = name;
        this.indexType = indexType;
        this.abstractLabel = abstractLabel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return (this.abstractLabel.getName() + this.getName()).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Index)) {
            return false;
        }
        Index otherIndex = (Index)other;
        return this.abstractLabel.equals(otherIndex.abstractLabel) && this.name.equals(otherIndex.name);
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    void addProperty(PropertyColumn property) {
        this.properties.add(property);
    }

    void afterCommit() {
        this.indexType = this.uncommittedIndexType;
        Iterator<PropertyColumn> propertyColumnIterator = this.uncommittedProperties.iterator();
        while (propertyColumnIterator.hasNext()) {
            PropertyColumn propertyColumn = propertyColumnIterator.next();
            this.properties.add(propertyColumn);
            propertyColumn.afterCommit();
            propertyColumnIterator.remove();
        }
        this.uncommittedIndexType = null;
        this.committed = true;
    }

    void afterRollback() {
        this.uncommittedIndexType = null;
        this.uncommittedProperties.clear();
    }

    private void addIndex(SqlgGraph sqlgGraph, SchemaTable schemaTable) {
        String prefix = this.abstractLabel instanceof VertexLabel ? "V_" : "E_";
        StringBuilder sql = new StringBuilder("CREATE ");
        if (IndexType.UNIQUE.equals(this.getIndexType())) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        SqlDialect sqlDialect = sqlgGraph.getSqlDialect();
        sql.append(sqlDialect.maybeWrapInQoutes(this.getName()));
        sql.append(" ON ");
        sql.append(sqlDialect.maybeWrapInQoutes(schemaTable.getSchema()));
        sql.append(".");
        sql.append(sqlDialect.maybeWrapInQoutes(prefix + schemaTable.getTable()));
        if (this.indexType.isGIN()) {
            sql.append(" USING GIN");
        }
        sql.append(" (");
        List<PropertyColumn> props = this.getProperties();
        if ("GIN_FULLTEXT".equals(this.getIndexType().getName())) {
            sql.append("to_tsvector(");
            String conf = this.indexType.getProperties().get("config");
            if (conf != null) {
                sql.append("'" + conf + "'");
                sql.append(",");
            }
            int count = 1;
            for (PropertyColumn property : props) {
                sql.append(sqlDialect.maybeWrapInQoutes(property.getName()));
                if (count++ >= props.size()) continue;
                sql.append(" || ' ' || ");
            }
            sql.append(")");
        } else {
            int count = 1;
            for (PropertyColumn property : props) {
                sql.append(sqlDialect.maybeWrapInQoutes(property.getName()));
                if (count++ >= props.size()) continue;
                sql.append(",");
            }
        }
        sql.append(")");
        if (sqlDialect.needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = sqlgGraph.tx().getConnection();
        try {
            Statement stmt = conn.createStatement();
            Object object = null;
            try {
                stmt.execute(sql.toString());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (object != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected Optional<JsonNode> toNotifyJson() {
        Preconditions.checkState((this.abstractLabel.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedProperties.isEmpty() ? 1 : 0) != 0);
        ObjectNode result = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        result.put("name", this.name);
        result.set("indexType", this.uncommittedIndexType.toNotifyJson());
        ArrayNode propertyArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (PropertyColumn property : this.uncommittedProperties) {
            propertyArrayNode.add((JsonNode)property.toNotifyJson());
        }
        result.set("uncommittedProperties", (JsonNode)propertyArrayNode);
        return Optional.of(result);
    }

    public static Index fromNotifyJson(AbstractLabel abstractLabel, JsonNode indexNode) {
        IndexType indexType = IndexType.fromNotifyJson(indexNode.get("indexType"));
        String name = indexNode.get("name").asText();
        ArrayNode propertiesNode = (ArrayNode)indexNode.get("uncommittedProperties");
        ArrayList<PropertyColumn> properties = new ArrayList<PropertyColumn>();
        for (JsonNode propertyNode : propertiesNode) {
            String propertyName = propertyNode.get("name").asText();
            PropertyType propertyType = PropertyType.valueOf(propertyNode.get("propertyType").asText());
            Optional<PropertyColumn> propertyColumnOptional = abstractLabel.getProperty(propertyName);
            Preconditions.checkState((boolean)propertyColumnOptional.isPresent(), (String)"BUG: property %s for PropertyType %s not found.", (Object[])new Object[]{propertyName, propertyType.name()});
            properties.add(propertyColumnOptional.get());
        }
        Index index = new Index(name, indexType, abstractLabel, properties);
        return index;
    }

    static Index createIndex(SqlgGraph sqlgGraph, AbstractLabel abstractLabel, String indexName, IndexType indexType, List<PropertyColumn> properties) {
        Index index = new Index(indexName, indexType, abstractLabel, properties);
        SchemaTable schemaTable = SchemaTable.of(abstractLabel.getSchema().getName(), abstractLabel.getLabel());
        index.addIndex(sqlgGraph, schemaTable);
        TopologyManager.addIndex(sqlgGraph, index);
        index.committed = false;
        return index;
    }

    List<Topology.TopologyValidationError> validateTopology(DatabaseMetaData metadata) throws SQLException {
        ArrayList<Topology.TopologyValidationError> validationErrors = new ArrayList<Topology.TopologyValidationError>();
        try (ResultSet propertyRs = metadata.getIndexInfo(null, this.abstractLabel.getSchema().getName(), this.abstractLabel.getPrefix() + this.abstractLabel.getLabel(), false, false);){
            HashMap indexColumns = new HashMap();
            while (propertyRs.next()) {
                List<String> columnNames;
                String columnName = propertyRs.getString("COLUMN_NAME");
                String indexName = propertyRs.getString("INDEX_NAME");
                if (!indexColumns.containsKey(indexName)) {
                    columnNames = new ArrayList();
                    indexColumns.put(indexName, columnNames);
                } else {
                    columnNames = (List)indexColumns.get(indexName);
                }
                columnNames.add(columnName);
            }
            if (!indexColumns.containsKey(this.getName())) {
                validationErrors.add(new Topology.TopologyValidationError(this));
            }
        }
        return validationErrors;
    }

    public AbstractLabel getParentLabel() {
        return this.abstractLabel;
    }

    public List<PropertyColumn> getProperties() {
        ArrayList<PropertyColumn> props = new ArrayList<PropertyColumn>(this.properties);
        if (this.getParentLabel().getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            props.addAll(this.uncommittedProperties);
        }
        return Collections.unmodifiableList(props);
    }

    void delete(SqlgGraph sqlgGraph) {
        StringBuilder sql = new StringBuilder("DROP INDEX IF EXISTS ");
        SqlDialect sqlDialect = sqlgGraph.getSqlDialect();
        sql.append(sqlDialect.maybeWrapInQoutes(this.getParentLabel().getSchema().getName()));
        sql.append(".");
        sql.append(sqlDialect.maybeWrapInQoutes(this.getName()));
        if (sqlDialect.needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove(boolean preserveData) {
        this.getParentLabel().removeIndex(this, preserveData);
    }
}

