/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.umlg.sqlg.structure.Topology;

public class IndexType {
    public static final IndexType UNIQUE = new IndexType("UNIQUE");
    public static final IndexType NON_UNIQUE = new IndexType("NON_UNIQUE");
    public static final String GIN_FULLTEXT = "GIN_FULLTEXT";
    public static final String GIN_CONFIGURATION = "config";
    private String name;
    private Map<String, String> properties = new HashMap<String, String>();

    public static IndexType getFullTextGIN(String configuration) {
        IndexType it = new IndexType(GIN_FULLTEXT);
        it.getProperties().put(GIN_CONFIGURATION, configuration);
        return it;
    }

    public IndexType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isGIN() {
        return GIN_FULLTEXT.equals(this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexType other = (IndexType)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return this.toNotifyJson().toString();
    }

    public JsonNode toNotifyJson() {
        ObjectNode result = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        result.put("name", this.name);
        for (String k : this.properties.keySet()) {
            result.put(k, this.properties.get(k));
        }
        return result;
    }

    public static IndexType fromString(String node) {
        try {
            return IndexType.fromNotifyJson(Topology.OBJECT_MAPPER.readTree(node));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexType fromNotifyJson(JsonNode node) {
        if (node.isValueNode()) {
            String s = node.asText();
            if ("UNIQUE".equalsIgnoreCase(s)) {
                return UNIQUE;
            }
            if ("NON_UNIQUE".equalsIgnoreCase(s)) {
                return NON_UNIQUE;
            }
        }
        IndexType it = new IndexType(node.get("name").asText());
        Iterator keys = node.fieldNames();
        while (keys.hasNext()) {
            String k = (String)keys.next();
            if ("name".equals(k)) continue;
            it.getProperties().put(k, node.get(k).asText());
        }
        return it;
    }
}

