/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.umlg.sqlg.structure.AbstractLabel;
import org.umlg.sqlg.structure.GlobalUniqueIndex;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyInf;

public class PropertyColumn
implements TopologyInf {
    private AbstractLabel abstractLabel;
    private String name;
    private boolean committed = true;
    private PropertyType propertyType;
    private Set<GlobalUniqueIndex> globalUniqueIndices = new HashSet<GlobalUniqueIndex>();
    private Set<GlobalUniqueIndex> uncommittedGlobalUniqueIndices = new HashSet<GlobalUniqueIndex>();

    PropertyColumn(AbstractLabel abstractLabel, String name, PropertyType propertyType) {
        this.abstractLabel = abstractLabel;
        this.name = name;
        this.propertyType = propertyType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public AbstractLabel getParentLabel() {
        return this.abstractLabel;
    }

    void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public Set<GlobalUniqueIndex> getGlobalUniqueIndices() {
        HashSet<GlobalUniqueIndex> result = new HashSet<GlobalUniqueIndex>();
        result.addAll(this.globalUniqueIndices);
        if (this.abstractLabel.getSchema().getTopology().isWriteLockHeldByCurrentThread()) {
            result.addAll(this.uncommittedGlobalUniqueIndices);
        }
        return result;
    }

    void afterCommit() {
        Iterator<GlobalUniqueIndex> globalUniqueIndexIter = this.uncommittedGlobalUniqueIndices.iterator();
        while (globalUniqueIndexIter.hasNext()) {
            GlobalUniqueIndex globalUniqueIndex = globalUniqueIndexIter.next();
            this.globalUniqueIndices.add(globalUniqueIndex);
            globalUniqueIndexIter.remove();
        }
        this.committed = true;
    }

    void afterRollback() {
        Preconditions.checkState((boolean)this.getParentLabel().getSchema().getTopology().isWriteLockHeldByCurrentThread(), (Object)"PropertyColumn.afterRollback must hold the write lock");
        this.uncommittedGlobalUniqueIndices.clear();
    }

    void addToGlobalUniqueIndexes(GlobalUniqueIndex globalUniqueIndex) {
        this.globalUniqueIndices.add(globalUniqueIndex);
        this.abstractLabel.addGlobalUniqueIndexToProperties(this);
    }

    void addGlobalUniqueIndex(GlobalUniqueIndex globalUniqueIndex) {
        this.uncommittedGlobalUniqueIndices.add(globalUniqueIndex);
        this.abstractLabel.addGlobalUniqueIndexToUncommittedProperties(this);
    }

    ObjectNode toNotifyJson() {
        ObjectNode propertyObjectNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        propertyObjectNode.put("name", this.name);
        propertyObjectNode.put("propertyType", this.propertyType.name());
        return propertyObjectNode;
    }

    static PropertyColumn fromNotifyJson(AbstractLabel abstractLabel, JsonNode jsonNode) {
        PropertyColumn property = new PropertyColumn(abstractLabel, jsonNode.get("name").asText(), PropertyType.valueOf(jsonNode.get("propertyType").asText()));
        return property;
    }

    public int hashCode() {
        return (this.abstractLabel.getSchema().getName() + this.abstractLabel.getLabel() + this.getName()).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PropertyColumn)) {
            return false;
        }
        PropertyColumn other = (PropertyColumn)o;
        if (this.abstractLabel.getSchema().getName().equals(other.abstractLabel.getSchema().getName())) {
            if (this.abstractLabel.getLabel().equals(other.abstractLabel.getLabel())) {
                return this.getName().equals(other.getName()) && this.getPropertyType() == other.getPropertyType();
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.abstractLabel.getSchema().getName() + "." + this.abstractLabel.getLabel() + "." + this.name;
    }

    @Override
    public void remove(boolean preserveData) {
        this.abstractLabel.removeProperty(this, preserveData);
    }
}

