/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Property;

public enum PropertyType {
    BOOLEAN(Boolean.class.getName(), new String[0]),
    BYTE(Byte.class.getName(), new String[0]),
    SHORT(Short.class.getName(), new String[0]),
    INTEGER(Integer.class.getName(), new String[0]),
    LONG(Long.class.getName(), new String[0]),
    FLOAT(Float.class.getName(), new String[0]),
    DOUBLE(Double.class.getName(), new String[0]),
    STRING(String.class.getName(), new String[0]),
    LOCALDATE(LocalDate.class.getName(), new String[0]),
    LOCALDATETIME(LocalDateTime.class.getName(), new String[0]),
    LOCALTIME(LocalTime.class.getName(), new String[0]),
    ZONEDDATETIME(ZonedDateTime.class.getName(), new String[]{"~~~ZONEID"}),
    PERIOD(Period.class.getName(), new String[]{"~~~MONTHS", "~~~DAYS"}),
    DURATION(Duration.class.getName(), new String[]{"~~~NANOS"}),
    JSON(JsonNode.class.getName(), new String[0]),
    POINT("org.postgis.Point", new String[0]),
    LINESTRING("org.postgis.LineString", new String[0]),
    POLYGON("org.postgis.Polygon", new String[0]),
    GEOGRAPHY_POINT("org.umlg.sqlg.gis.GeographyPoint", new String[0]),
    GEOGRAPHY_POLYGON("org.umlg.sqlg.gis.GeographyPolygon", new String[0]),
    boolean_ARRAY(boolean[].class.getName(), new String[0]),
    BOOLEAN_ARRAY(Boolean[].class.getName(), new String[0]),
    byte_ARRAY(byte[].class.getName(), new String[0]),
    BYTE_ARRAY(Byte[].class.getName(), new String[0]),
    short_ARRAY(short[].class.getName(), new String[0]),
    SHORT_ARRAY(Short[].class.getName(), new String[0]),
    int_ARRAY(int[].class.getName(), new String[0]),
    INTEGER_ARRAY(Integer[].class.getName(), new String[0]),
    long_ARRAY(long[].class.getName(), new String[0]),
    LONG_ARRAY(Long[].class.getName(), new String[0]),
    float_ARRAY(float[].class.getName(), new String[0]),
    FLOAT_ARRAY(Float[].class.getName(), new String[0]),
    double_ARRAY(double[].class.getName(), new String[0]),
    DOUBLE_ARRAY(Double[].class.getName(), new String[0]),
    STRING_ARRAY(String[].class.getName(), new String[0]),
    LOCALDATETIME_ARRAY(LocalDateTime[].class.getName(), new String[0]),
    LOCALDATE_ARRAY(LocalDate[].class.getName(), new String[0]),
    LOCALTIME_ARRAY(LocalTime[].class.getName(), new String[0]),
    ZONEDDATETIME_ARRAY(ZonedDateTime[].class.getName(), new String[]{"~~~ZONEID"}),
    DURATION_ARRAY(Duration[].class.getName(), new String[]{"~~~NANOS"}),
    PERIOD_ARRAY(Period[].class.getName(), new String[]{"~~~MONTHS", "~~~DAYS"}),
    JSON_ARRAY(JsonNode[].class.getName(), new String[0]);

    private String javaClassName;
    private String[] postFixes;
    private static final Map<String, PropertyType> javaClassNameToEnum;

    private PropertyType(String javaClassName, String[] postFixes) {
        this.javaClassName = javaClassName;
        this.postFixes = postFixes;
    }

    public static PropertyType from(Object o) {
        PropertyType propertyType = javaClassNameToEnum.get(o.getClass().getName());
        if (propertyType == null && o instanceof JsonNode) {
            propertyType = javaClassNameToEnum.get(JsonNode.class.getName());
        } else if (propertyType == null && o instanceof JsonNode[]) {
            propertyType = javaClassNameToEnum.get(JsonNode[].class.getName());
        }
        if (propertyType == null) {
            throw Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)o);
        }
        return propertyType;
    }

    public String[] getPostFixes() {
        return this.postFixes;
    }

    public boolean isArray() {
        return this.name().endsWith("_ARRAY");
    }

    static {
        javaClassNameToEnum = new HashMap<String, PropertyType>();
        for (PropertyType pt : PropertyType.values()) {
            javaClassNameToEnum.put(pt.javaClassName, pt);
        }
    }
}

