/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.KryoSerializable;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.util.SqlgUtil;

public class RecordId
implements KryoSerializable,
Comparable {
    public static final String RECORD_ID_DELIMITER = ":::";
    private SchemaTable schemaTable;
    private Long id;

    public RecordId() {
    }

    private RecordId(SchemaTable schemaTable, Long id) {
        this.schemaTable = schemaTable;
        this.id = id;
    }

    private RecordId(String label, Long id) {
        this.schemaTable = SqlgUtil.parseLabel(label);
        this.id = id;
    }

    public static RecordId from(SchemaTable schemaTable, Long id) {
        return new RecordId(schemaTable, id);
    }

    public static List<RecordId> from(Object ... elementId) {
        ArrayList<RecordId> result = new ArrayList<RecordId>(elementId.length);
        for (Object o : elementId) {
            if (o instanceof RecordId) {
                result.add((RecordId)o);
                continue;
            }
            result.add(RecordId.from(o));
        }
        return result;
    }

    public static RecordId from(Object vertexId) {
        if (!(vertexId instanceof String)) {
            throw SqlgExceptions.invalidId(vertexId.toString());
        }
        String stringId = (String)vertexId;
        String[] splittedId = stringId.split(RECORD_ID_DELIMITER);
        if (splittedId.length != 2) {
            throw SqlgExceptions.invalidId(vertexId.toString());
        }
        String label = splittedId[0];
        String id = splittedId[1];
        try {
            Long labelId = Long.valueOf(id);
            return new RecordId(label, labelId);
        }
        catch (NumberFormatException e) {
            throw SqlgExceptions.invalidId(vertexId.toString());
        }
    }

    public SchemaTable getSchemaTable() {
        return this.schemaTable;
    }

    public Long getId() {
        return this.id;
    }

    static Map<SchemaTable, List<Long>> normalizeIds(List<RecordId> vertexId) {
        HashMap<SchemaTable, List<Long>> result = new HashMap<SchemaTable, List<Long>>();
        for (RecordId recordId : vertexId) {
            ArrayList<Long> ids = (ArrayList<Long>)result.get(recordId.getSchemaTable());
            if (ids == null) {
                ids = new ArrayList<Long>();
                result.put(recordId.getSchemaTable(), ids);
            }
            ids.add(recordId.getId());
        }
        return result;
    }

    public String toString() {
        return this.schemaTable.toString() + RECORD_ID_DELIMITER + this.id.toString();
    }

    public int hashCode() {
        return (this.schemaTable + this.id.toString()).hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof RecordId)) {
            return false;
        }
        RecordId otherRecordId = (RecordId)other;
        return this.schemaTable.equals(otherRecordId.getSchemaTable()) && this.id.equals(otherRecordId.getId());
    }

    public void write(Kryo kryo, Output output) {
        output.writeString(this.getSchemaTable().getSchema());
        output.writeString(this.getSchemaTable().getTable());
        output.writeLong(this.getId().longValue());
    }

    public void read(Kryo kryo, Input input) {
        this.schemaTable = SchemaTable.of(input.readString(), input.readString());
        this.id = input.readLong();
    }

    public int compareTo(Object o) {
        if (!(o instanceof RecordId)) {
            return -1;
        }
        RecordId other = (RecordId)o;
        int first = this.getSchemaTable().compareTo(other.getSchemaTable());
        if (first != 0) {
            return first;
        }
        return this.getId().compareTo(other.getId());
    }

    static class RecordIdJacksonDeserializerV2d0
    extends AbstractObjectDeserializer<RecordId> {
        RecordIdJacksonDeserializerV2d0() {
            super(RecordId.class);
        }

        public RecordId createObject(Map data) {
            return RecordId.from((SchemaTable)data.get("schemaTable"), (Long)data.get("id"));
        }
    }

    static class RecordIdJacksonSerializerV2d0
    extends StdSerializer<RecordId> {
        RecordIdJacksonSerializerV2d0() {
            super(RecordId.class);
        }

        public void serialize(RecordId recordId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeString(recordId.toString());
        }

        public void serializeWithType(RecordId recordId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            typeSerializer.writeTypePrefixForScalar((Object)recordId, jsonGenerator);
            HashMap<String, Comparable> m = new HashMap<String, Comparable>();
            m.put("schemaTable", recordId.getSchemaTable());
            m.put("id", recordId.getId());
            jsonGenerator.writeObject(m);
            typeSerializer.writeTypeSuffixForScalar((Object)recordId, jsonGenerator);
        }
    }
}

