/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.structure.AbstractLabel;
import org.umlg.sqlg.structure.EdgeLabel;
import org.umlg.sqlg.structure.EdgeRole;
import org.umlg.sqlg.structure.GlobalUniqueIndex;
import org.umlg.sqlg.structure.Index;
import org.umlg.sqlg.structure.IndexType;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyChangeAction;
import org.umlg.sqlg.structure.TopologyInf;
import org.umlg.sqlg.structure.TopologyManager;
import org.umlg.sqlg.structure.VertexLabel;

public class Schema
implements TopologyInf {
    private static Logger logger = LoggerFactory.getLogger((String)Schema.class.getName());
    private SqlgGraph sqlgGraph;
    private Topology topology;
    private String name;
    private boolean committed = true;
    private Map<String, VertexLabel> vertexLabels = new HashMap<String, VertexLabel>();
    private Map<String, VertexLabel> uncommittedVertexLabels = new HashMap<String, VertexLabel>();
    private Set<String> uncommittedRemovedVertexLabels = new HashSet<String>();
    private Map<String, EdgeLabel> outEdgeLabels = new HashMap<String, EdgeLabel>();
    private Map<String, EdgeLabel> uncommittedOutEdgeLabels = new HashMap<String, EdgeLabel>();
    private Set<String> uncommittedRemovedEdgeLabels = new HashSet<String>();
    public static final String GLOBAL_UNIQUE_INDEX_SCHEMA = "gui_schema";
    private Map<String, GlobalUniqueIndex> uncommittedGlobalUniqueIndexes = new HashMap<String, GlobalUniqueIndex>();
    private Set<String> uncommittedRemovedGlobalUniqueIndexes = new HashSet<String>();
    Map<String, GlobalUniqueIndex> globalUniqueIndexes = new HashMap<String, GlobalUniqueIndex>();
    private static final String MARKER = "~gremlin.incidentToAdjacent";

    static Schema instantiateSqlgSchema(Topology topology) {
        return new Schema(topology, "sqlg_schema");
    }

    static Schema createPublicSchema(SqlgGraph sqlgGraph, Topology topology, String publicSchemaName) {
        Schema schema = new Schema(topology, publicSchemaName);
        if (!Schema.existPublicSchema(sqlgGraph)) {
            schema.createSchemaOnDb();
        }
        schema.committed = false;
        return schema;
    }

    private static boolean existPublicSchema(SqlgGraph sqlgGraph) {
        Connection conn = sqlgGraph.tx().getConnection();
        try {
            if (sqlgGraph.getSqlDialect().supportSchemas()) {
                DatabaseMetaData metadata = conn.getMetaData();
                return sqlgGraph.getSqlDialect().schemaExists(metadata, null, sqlgGraph.getSqlDialect().getPublicSchema());
            }
            throw new IllegalStateException("schemas not supported not supported, i.e. probably MariaDB not supported.");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static Schema createGlobalUniqueIndexSchema(Topology topology) {
        return new Schema(topology, GLOBAL_UNIQUE_INDEX_SCHEMA);
    }

    static Schema createSchema(SqlgGraph sqlgGraph, Topology topology, String name) {
        Schema schema = new Schema(topology, name);
        Preconditions.checkArgument((!name.equals("sqlg_schema") && !sqlgGraph.getSqlDialect().getPublicSchema().equals(name) ? 1 : 0) != 0, (Object)"createSchema may not be called for 'sqlg_schema' or 'public'");
        schema.createSchemaOnDb();
        TopologyManager.addSchema(sqlgGraph, name);
        schema.committed = false;
        return schema;
    }

    static Schema instantiateSchema(Topology topology, String schemaName) {
        Schema schema = new Schema(topology, schemaName);
        return schema;
    }

    private Schema(Topology topology, String name) {
        this.topology = topology;
        this.name = name;
        this.sqlgGraph = this.topology.getSqlgGraph();
    }

    SqlgGraph getSqlgGraph() {
        return this.sqlgGraph;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    public VertexLabel ensureVertexLabelExist(String label) {
        return this.ensureVertexLabelExist(label, Collections.emptyMap());
    }

    public VertexLabel ensureVertexLabelExist(String label, Map<String, PropertyType> columns) {
        Objects.requireNonNull(label, "Given table must not be null");
        Preconditions.checkArgument((!label.startsWith("V_") ? 1 : 0) != 0, (String)"label may not be prefixed with %s", (Object[])new Object[]{"V_"});
        Optional<VertexLabel> vertexLabelOptional = this.getVertexLabel(label);
        if (!vertexLabelOptional.isPresent()) {
            this.topology.lock();
            vertexLabelOptional = this.getVertexLabel(label);
            if (!vertexLabelOptional.isPresent()) {
                return this.createVertexLabel(label, columns);
            }
            return vertexLabelOptional.get();
        }
        VertexLabel vertexLabel = vertexLabelOptional.get();
        vertexLabel.ensurePropertiesExist(columns);
        return vertexLabel;
    }

    public EdgeLabel ensureEdgeLabelExist(String edgeLabelName, VertexLabel outVertexLabel, VertexLabel inVertexLabel, Map<String, PropertyType> columns) {
        EdgeLabel edgeLabel;
        Objects.requireNonNull(edgeLabelName, "Given edgeLabelName may not be null");
        Objects.requireNonNull(outVertexLabel, "Given outVertexLabel may not be null");
        Objects.requireNonNull(inVertexLabel, "Given inVertexLabel may not be null");
        Optional<EdgeLabel> edgeLabelOptional = this.getEdgeLabel(edgeLabelName);
        if (!edgeLabelOptional.isPresent()) {
            this.topology.lock();
            edgeLabelOptional = this.getEdgeLabel(edgeLabelName);
            if (!edgeLabelOptional.isPresent()) {
                edgeLabel = this.createEdgeLabel(edgeLabelName, outVertexLabel, inVertexLabel, columns);
                this.uncommittedOutEdgeLabels.put(this.name + "." + "E_" + edgeLabelName, edgeLabel);
                this.getTopology().fire(edgeLabel, "", TopologyChangeAction.CREATE);
            } else {
                edgeLabel = this.internalEnsureEdgeTableExists(edgeLabelOptional.get(), outVertexLabel, inVertexLabel, columns);
            }
        } else {
            edgeLabel = this.internalEnsureEdgeTableExists(edgeLabelOptional.get(), outVertexLabel, inVertexLabel, columns);
        }
        return edgeLabel;
    }

    private EdgeLabel internalEnsureEdgeTableExists(EdgeLabel edgeLabel, VertexLabel outVertexLabel, VertexLabel inVertexLabel, Map<String, PropertyType> columns) {
        edgeLabel.ensureEdgeVertexLabelExist(Direction.OUT, outVertexLabel);
        edgeLabel.ensureEdgeVertexLabelExist(Direction.IN, inVertexLabel);
        edgeLabel.ensurePropertiesExist(columns);
        return edgeLabel;
    }

    private EdgeLabel createEdgeLabel(String edgeLabelName, VertexLabel outVertexLabel, VertexLabel inVertexLabel, Map<String, PropertyType> columns) {
        Preconditions.checkArgument((boolean)this.topology.isWriteLockHeldByCurrentThread(), (Object)"Lock must be held by the thread to call createEdgeLabel");
        Preconditions.checkArgument((!edgeLabelName.startsWith("E_") ? 1 : 0) != 0, (Object)"edgeLabelName may not start with E_");
        Preconditions.checkState((!this.isSqlgSchema() ? 1 : 0) != 0, (String)"createEdgeLabel may not be called for \"%s\"", (Object[])new Object[]{"sqlg_schema"});
        Schema inVertexSchema = inVertexLabel.getSchema();
        Preconditions.checkState((!this.getEdgeLabel(edgeLabelName).isPresent() ? 1 : 0) != 0, (String)"BUG: Edge \"%s\" already exists!", (Object[])new Object[]{edgeLabelName});
        SchemaTable foreignKeyOut = SchemaTable.of(this.name, outVertexLabel.getLabel());
        SchemaTable foreignKeyIn = SchemaTable.of(inVertexSchema.name, inVertexLabel.getLabel());
        TopologyManager.addEdgeLabel(this.sqlgGraph, this.getName(), "E_" + edgeLabelName, foreignKeyOut, foreignKeyIn, columns);
        return outVertexLabel.addEdgeLabel(edgeLabelName, inVertexLabel, columns);
    }

    VertexLabel createSqlgSchemaVertexLabel(String vertexLabelName, Map<String, PropertyType> columns) {
        Preconditions.checkState((boolean)this.isSqlgSchema(), (String)"createSqlgSchemaVertexLabel may only be called for \"%s\"", (Object[])new Object[]{"sqlg_schema"});
        Preconditions.checkArgument((!vertexLabelName.startsWith("V_") ? 1 : 0) != 0, (Object)"vertex label may not start with V_");
        VertexLabel vertexLabel = VertexLabel.createSqlgSchemaVertexLabel(this, vertexLabelName, columns);
        this.vertexLabels.put(this.name + "." + "V_" + vertexLabelName, vertexLabel);
        return vertexLabel;
    }

    private VertexLabel createVertexLabel(String vertexLabelName, Map<String, PropertyType> columns) {
        Preconditions.checkState((!this.isSqlgSchema() ? 1 : 0) != 0, (String)"createVertexLabel may not be called for \"%s\"", (Object[])new Object[]{"sqlg_schema"});
        Preconditions.checkArgument((!vertexLabelName.startsWith("V_") ? 1 : 0) != 0, (Object)"vertex label may not start with V_");
        VertexLabel vertexLabel = VertexLabel.createVertexLabel(this.sqlgGraph, this, vertexLabelName, columns);
        this.uncommittedVertexLabels.put(this.name + "." + "V_" + vertexLabelName, vertexLabel);
        this.getTopology().fire(vertexLabel, "", TopologyChangeAction.CREATE);
        return vertexLabel;
    }

    void ensureVertexColumnsExist(String label, Map<String, PropertyType> columns) {
        Preconditions.checkArgument((!label.startsWith("V_") ? 1 : 0) != 0, (String)"label may not start with \"%s\"", (Object[])new Object[]{"V_"});
        Preconditions.checkState((!this.isSqlgSchema() ? 1 : 0) != 0, (String)"Schema.ensureVertexLabelPropertiesExist may not be called for \"%s\"", (Object[])new Object[]{"sqlg_schema"});
        Optional<VertexLabel> vertexLabel = this.getVertexLabel(label);
        Preconditions.checkState((boolean)vertexLabel.isPresent(), (String)"BUG: vertexLabel \"%s\" must exist", (Object[])new Object[]{label});
        vertexLabel.get().ensurePropertiesExist(columns);
    }

    void ensureEdgeColumnsExist(String label, Map<String, PropertyType> columns) {
        Preconditions.checkArgument((!label.startsWith("E_") ? 1 : 0) != 0, (String)"label may not start with \"%s\"", (Object[])new Object[]{"E_"});
        Preconditions.checkState((!this.isSqlgSchema() ? 1 : 0) != 0, (String)"Schema.ensureEdgePropertiesExist may not be called for \"%s\"", (Object[])new Object[]{"sqlg_schema"});
        Optional<EdgeLabel> edgeLabel = this.getEdgeLabel(label);
        Preconditions.checkState((boolean)edgeLabel.isPresent(), (String)"BUG: edgeLabel \"%s\" must exist", (Object[])new Object[]{label});
        edgeLabel.get().ensurePropertiesExist(columns);
    }

    private void createSchemaOnDb() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.topology.getSqlgGraph().getSqlDialect().createSchemaStatement());
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.name));
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            logger.error("schema creation failed " + this.sqlgGraph.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static Schema loadUserSchema(Topology topology, String schemaName) {
        return new Schema(topology, schemaName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    Topology getTopology() {
        return this.topology;
    }

    private Map<String, VertexLabel> getUncommittedVertexLabels() {
        return this.uncommittedVertexLabels;
    }

    public Optional<VertexLabel> getVertexLabel(String vertexLabelName) {
        Preconditions.checkArgument((!vertexLabelName.startsWith("V_") ? 1 : 0) != 0, (String)"vertex label may not start with \"%s\"", (Object[])new Object[]{"V_"});
        if (this.topology.isWriteLockHeldByCurrentThread() && this.uncommittedRemovedVertexLabels.contains(this.name + "." + "V_" + vertexLabelName)) {
            return Optional.empty();
        }
        VertexLabel result = this.vertexLabels.get(this.name + "." + "V_" + vertexLabelName);
        if (result == null && this.topology.isWriteLockHeldByCurrentThread()) {
            result = this.uncommittedVertexLabels.get(this.name + "." + "V_" + vertexLabelName);
        }
        return Optional.ofNullable(result);
    }

    Map<String, EdgeLabel> getEdgeLabels() {
        HashMap<String, EdgeLabel> result = new HashMap<String, EdgeLabel>();
        result.putAll(this.outEdgeLabels);
        if (this.topology.isWriteLockHeldByCurrentThread()) {
            result.putAll(this.uncommittedOutEdgeLabels);
            for (String e : this.uncommittedRemovedEdgeLabels) {
                result.remove(e);
            }
        }
        return result;
    }

    private Map<String, EdgeLabel> getUncommittedOutEdgeLabels() {
        HashMap<String, EdgeLabel> result = new HashMap<String, EdgeLabel>();
        for (VertexLabel vertexLabel : this.vertexLabels.values()) {
            result.putAll(vertexLabel.getUncommittedOutEdgeLabels());
        }
        if (this.topology.isWriteLockHeldByCurrentThread()) {
            for (VertexLabel vertexLabel : this.uncommittedVertexLabels.values()) {
                result.putAll(vertexLabel.getUncommittedOutEdgeLabels());
            }
            for (String e : this.uncommittedRemovedEdgeLabels) {
                result.remove(e);
            }
        }
        return result;
    }

    public Optional<EdgeLabel> getEdgeLabel(String edgeLabelName) {
        Preconditions.checkArgument((!edgeLabelName.startsWith("E_") ? 1 : 0) != 0, (String)"edge label may not start with \"%s\"", (Object[])new Object[]{"E_"});
        if (this.topology.isWriteLockHeldByCurrentThread() && this.uncommittedRemovedEdgeLabels.contains(this.name + "." + "E_" + edgeLabelName)) {
            return Optional.empty();
        }
        EdgeLabel edgeLabel = this.outEdgeLabels.get(this.name + "." + "E_" + edgeLabelName);
        if (edgeLabel != null) {
            return Optional.of(edgeLabel);
        }
        if (this.topology.isWriteLockHeldByCurrentThread() && (edgeLabel = this.uncommittedOutEdgeLabels.get(this.name + "." + "E_" + edgeLabelName)) != null) {
            return Optional.of(edgeLabel);
        }
        return Optional.empty();
    }

    Map<String, Map<String, PropertyType>> getAllTables() {
        String vertexQualifiedName;
        HashMap<String, Map<String, PropertyType>> result = new HashMap<String, Map<String, PropertyType>>();
        for (Map.Entry<String, VertexLabel> entry : this.vertexLabels.entrySet()) {
            vertexQualifiedName = this.name + "." + "V_" + entry.getValue().getLabel();
            result.put(vertexQualifiedName, entry.getValue().getPropertyTypeMap());
        }
        if (this.topology.isWriteLockHeldByCurrentThread()) {
            for (Map.Entry entry : this.uncommittedVertexLabels.entrySet()) {
                vertexQualifiedName = (String)entry.getKey();
                VertexLabel vertexLabel = (VertexLabel)entry.getValue();
                result.put(vertexQualifiedName, vertexLabel.getPropertyTypeMap());
            }
        }
        for (EdgeLabel edgeLabel : this.getEdgeLabels().values()) {
            String edgeQualifiedName = this.name + "." + "E_" + edgeLabel.getLabel();
            result.put(edgeQualifiedName, edgeLabel.getPropertyTypeMap());
        }
        return result;
    }

    Map<String, VertexLabel> getVertexLabelsOnly() {
        return this.vertexLabels;
    }

    public Map<String, VertexLabel> getVertexLabels() {
        HashMap<String, VertexLabel> result = new HashMap<String, VertexLabel>();
        result.putAll(this.vertexLabels);
        if (this.topology.isWriteLockHeldByCurrentThread()) {
            result.putAll(this.uncommittedVertexLabels);
            for (String e : this.uncommittedRemovedVertexLabels) {
                result.remove(e);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    Map<String, AbstractLabel> getUncommittedLabels() {
        Preconditions.checkState((boolean)this.getTopology().isWriteLockHeldByCurrentThread(), (Object)"Schema.getUncommittedAllTables must be called with the lock held");
        HashMap<String, AbstractLabel> result = new HashMap<String, AbstractLabel>();
        for (Map.Entry<String, VertexLabel> vertexLabelEntry : this.vertexLabels.entrySet()) {
            String vertexQualifiedName = this.name + "." + "V_" + vertexLabelEntry.getValue().getLabel();
            Map<String, PropertyColumn> uncommittedPropertyColumnMap = vertexLabelEntry.getValue().getUncommittedPropertyTypeMap();
            Set<String> uncommittedRemovedProperties = vertexLabelEntry.getValue().getUncommittedRemovedProperties();
            if (uncommittedPropertyColumnMap.isEmpty() && uncommittedRemovedProperties.isEmpty()) continue;
            result.put(vertexQualifiedName, vertexLabelEntry.getValue());
        }
        for (Map.Entry<String, VertexLabel> stringVertexLabelEntry : this.uncommittedVertexLabels.entrySet()) {
            String vertexQualifiedLabel = stringVertexLabelEntry.getKey();
            VertexLabel vertexLabel = stringVertexLabelEntry.getValue();
            result.put(vertexQualifiedLabel, vertexLabel);
        }
        for (EdgeLabel edgeLabel : this.getUncommittedOutEdgeLabels().values()) {
            result.put(this.name + "." + "E_" + edgeLabel.getLabel(), edgeLabel);
        }
        return result;
    }

    Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> getUncommittedSchemaTableForeignKeys() {
        Pair<Set<SchemaTable>, Set<SchemaTable>> uncommittedSchemaTableForeignKeys;
        SchemaTable schemaTable;
        String vertexQualifiedName;
        Preconditions.checkState((boolean)this.getTopology().isWriteLockHeldByCurrentThread(), (Object)"Schema.getUncommittedSchemaTableForeignKeys must be called with the lock held");
        HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> result = new HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>>();
        for (Map.Entry<String, VertexLabel> vertexLabelEntry : this.vertexLabels.entrySet()) {
            vertexQualifiedName = this.name + "." + "V_" + vertexLabelEntry.getValue().getLabel();
            schemaTable = SchemaTable.from(this.sqlgGraph, vertexQualifiedName);
            uncommittedSchemaTableForeignKeys = vertexLabelEntry.getValue().getUncommittedSchemaTableForeignKeys();
            if (((Set)uncommittedSchemaTableForeignKeys.getLeft()).isEmpty() && ((Set)uncommittedSchemaTableForeignKeys.getRight()).isEmpty()) continue;
            result.put(schemaTable, uncommittedSchemaTableForeignKeys);
        }
        for (Map.Entry<String, VertexLabel> uncommittedVertexLabelEntry : this.uncommittedVertexLabels.entrySet()) {
            vertexQualifiedName = this.name + "." + "V_" + uncommittedVertexLabelEntry.getValue().getLabel();
            schemaTable = SchemaTable.from(this.sqlgGraph, vertexQualifiedName);
            uncommittedSchemaTableForeignKeys = uncommittedVertexLabelEntry.getValue().getUncommittedSchemaTableForeignKeys();
            result.put(schemaTable, uncommittedSchemaTableForeignKeys);
        }
        return result;
    }

    Map<String, Set<String>> getUncommittedEdgeForeignKeys() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (EdgeLabel outEdgeLabel : this.outEdgeLabels.values()) {
            result.put(this.getName() + "." + "E_" + outEdgeLabel.getLabel(), outEdgeLabel.getUncommittedEdgeForeignKeys());
        }
        for (EdgeLabel outEdgeLabel : this.uncommittedOutEdgeLabels.values()) {
            result.put(this.getName() + "." + "E_" + outEdgeLabel.getLabel(), outEdgeLabel.getUncommittedEdgeForeignKeys());
        }
        return result;
    }

    Map<String, PropertyColumn> getPropertiesFor(SchemaTable schemaTable) {
        Preconditions.checkArgument((schemaTable.getTable().startsWith("V_") || schemaTable.getTable().startsWith("E_") ? 1 : 0) != 0, (String)"label must start with \"%s\" or \"%s\"", (Object[])new Object[]{"V_", "E_"});
        if (schemaTable.isVertexTable()) {
            Optional<VertexLabel> vertexLabelOptional = this.getVertexLabel(schemaTable.withOutPrefix().getTable());
            if (vertexLabelOptional.isPresent()) {
                return vertexLabelOptional.get().getProperties();
            }
        } else {
            Optional<EdgeLabel> edgeLabelOptional = this.getEdgeLabel(schemaTable.withOutPrefix().getTable());
            if (edgeLabelOptional.isPresent()) {
                return edgeLabelOptional.get().getProperties();
            }
        }
        return Collections.emptyMap();
    }

    Map<String, PropertyColumn> getPropertiesWithGlobalUniqueIndexFor(SchemaTable schemaTable) {
        Preconditions.checkArgument((schemaTable.getTable().startsWith("V_") || schemaTable.getTable().startsWith("E_") ? 1 : 0) != 0, (String)"label must start with \"%s\" or \"%s\"", (Object[])new Object[]{"V_", "E_"});
        if (schemaTable.isVertexTable()) {
            Optional<VertexLabel> vertexLabelOptional = this.getVertexLabel(schemaTable.withOutPrefix().getTable());
            if (vertexLabelOptional.isPresent()) {
                return vertexLabelOptional.get().getGlobalUniqueIndexProperties();
            }
        } else {
            Optional<EdgeLabel> edgeLabelOptional = this.getEdgeLabel(schemaTable.withOutPrefix().getTable());
            if (edgeLabelOptional.isPresent()) {
                return edgeLabelOptional.get().getGlobalUniqueIndexProperties();
            }
        }
        return Collections.emptyMap();
    }

    Map<String, PropertyType> getTableFor(SchemaTable schemaTable) {
        Preconditions.checkArgument((schemaTable.getTable().startsWith("V_") || schemaTable.getTable().startsWith("E_") ? 1 : 0) != 0, (String)"label must start with \"%s\" or \"%s\"", (Object[])new Object[]{"V_", "E_"});
        if (schemaTable.isVertexTable()) {
            Optional<VertexLabel> vertexLabelOptional = this.getVertexLabel(schemaTable.withOutPrefix().getTable());
            if (vertexLabelOptional.isPresent()) {
                return vertexLabelOptional.get().getPropertyTypeMap();
            }
        } else {
            Optional<EdgeLabel> edgeLabelOptional = this.getEdgeLabel(schemaTable.withOutPrefix().getTable());
            if (edgeLabelOptional.isPresent()) {
                return edgeLabelOptional.get().getPropertyTypeMap();
            }
        }
        return Collections.emptyMap();
    }

    Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> getTableLabels() {
        SchemaTable schemaTable;
        HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> result = new HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>>();
        for (Map.Entry<String, VertexLabel> vertexLabelEntry : this.vertexLabels.entrySet()) {
            Preconditions.checkState((!vertexLabelEntry.getValue().getLabel().startsWith("V_") ? 1 : 0) != 0, (Object)"vertexLabel may not start with V_");
            String string = "V_" + vertexLabelEntry.getValue().getLabel();
            schemaTable = SchemaTable.of(this.getName(), string);
            result.put(schemaTable, vertexLabelEntry.getValue().getTableLabels());
        }
        HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> uncommittedResult = new HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>>();
        if (this.topology.isWriteLockHeldByCurrentThread()) {
            for (Map.Entry<Object, Object> entry : this.uncommittedVertexLabels.entrySet()) {
                Preconditions.checkState((!((VertexLabel)entry.getValue()).getLabel().startsWith("V_") ? 1 : 0) != 0, (Object)"vertexLabel may not start with V_");
                String prefixedVertexName = "V_" + ((VertexLabel)entry.getValue()).getLabel();
                SchemaTable schemaTable2 = SchemaTable.of(this.getName(), prefixedVertexName);
                uncommittedResult.put(schemaTable2, ((VertexLabel)entry.getValue()).getTableLabels());
            }
        }
        for (Map.Entry<Object, Object> entry : uncommittedResult.entrySet()) {
            schemaTable = (SchemaTable)entry.getKey();
            Pair uncommittedForeignKeys = (Pair)entry.getValue();
            Pair foreignKeys = (Pair)result.get(schemaTable);
            if (foreignKeys != null) {
                ((Set)foreignKeys.getLeft()).addAll((Collection)uncommittedForeignKeys.getLeft());
                ((Set)foreignKeys.getRight()).addAll((Collection)uncommittedForeignKeys.getRight());
                continue;
            }
            result.put(schemaTable, (Pair<Set<SchemaTable>, Set<SchemaTable>>)uncommittedForeignKeys);
        }
        return result;
    }

    Map<String, Set<String>> getAllEdgeForeignKeys() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, EdgeLabel> stringEdgeLabelEntry : this.getEdgeLabels().entrySet()) {
            String edgeSchemaAndLabel = stringEdgeLabelEntry.getKey();
            EdgeLabel edgeLabel = stringEdgeLabelEntry.getValue();
            result.put(edgeSchemaAndLabel, edgeLabel.getAllEdgeForeignKeys());
        }
        return result;
    }

    public GlobalUniqueIndex ensureGlobalUniqueIndexExist(Set<PropertyColumn> properties) {
        String globalUniqueIndexName = GlobalUniqueIndex.globalUniqueIndexName(this.topology, properties);
        Optional<GlobalUniqueIndex> globalIndexOptional = this.getGlobalUniqueIndex(globalUniqueIndexName);
        if (!globalIndexOptional.isPresent()) {
            properties.iterator().next().getParentLabel().getSchema().getTopology().lock();
            globalIndexOptional = this.getGlobalUniqueIndex(globalUniqueIndexName);
            if (!globalIndexOptional.isPresent()) {
                GlobalUniqueIndex globalUniqueIndex = GlobalUniqueIndex.createGlobalUniqueIndex(this.sqlgGraph, this.topology, globalUniqueIndexName, properties);
                this.uncommittedGlobalUniqueIndexes.put(globalUniqueIndexName, globalUniqueIndex);
                this.getTopology().fire(globalUniqueIndex, "", TopologyChangeAction.CREATE);
                return globalUniqueIndex;
            }
            return globalIndexOptional.get();
        }
        return globalIndexOptional.get();
    }

    public Optional<GlobalUniqueIndex> getGlobalUniqueIndex(String name) {
        Objects.requireNonNull(name, () -> "name may not be null for getGlobalUniqueIndex");
        GlobalUniqueIndex globalUniqueIndex = this.getGlobalUniqueIndexes().get(name);
        return Optional.ofNullable(globalUniqueIndex);
    }

    public Map<String, GlobalUniqueIndex> getGlobalUniqueIndexes() {
        HashMap<String, GlobalUniqueIndex> result = new HashMap<String, GlobalUniqueIndex>();
        result.putAll(this.globalUniqueIndexes);
        if (this.getTopology().isWriteLockHeldByCurrentThread()) {
            result.putAll(this.uncommittedGlobalUniqueIndexes);
            for (String s : this.uncommittedRemovedGlobalUniqueIndexes) {
                result.remove(s);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    void afterCommit() {
        String s;
        Map.Entry entry;
        Preconditions.checkState((boolean)this.getTopology().isWriteLockHeldByCurrentThread(), (Object)"Schema.afterCommit must hold the write lock");
        Iterator<Object> it = this.uncommittedVertexLabels.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            this.vertexLabels.put(entry.getKey(), entry.getValue());
            it.remove();
        }
        if (this.getName().equals(GLOBAL_UNIQUE_INDEX_SCHEMA)) {
            it = this.uncommittedGlobalUniqueIndexes.entrySet().iterator();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                this.globalUniqueIndexes.put((String)entry.getKey(), (GlobalUniqueIndex)entry.getValue());
                it.remove();
            }
        }
        it = this.uncommittedRemovedVertexLabels.iterator();
        while (it.hasNext()) {
            s = (String)it.next();
            VertexLabel lbl = this.vertexLabels.remove(s);
            if (lbl != null) {
                this.getTopology().removeVertexLabel(lbl);
            }
            it.remove();
        }
        for (VertexLabel vertexLabel : this.vertexLabels.values()) {
            vertexLabel.afterCommit();
        }
        if (this.getName().equals(GLOBAL_UNIQUE_INDEX_SCHEMA)) {
            for (GlobalUniqueIndex globalUniqueIndex : this.globalUniqueIndexes.values()) {
                globalUniqueIndex.afterCommit();
            }
            it = this.uncommittedRemovedGlobalUniqueIndexes.iterator();
            while (it.hasNext()) {
                s = (String)it.next();
                this.globalUniqueIndexes.remove(s);
                it.remove();
            }
        }
        it = this.uncommittedRemovedEdgeLabels.iterator();
        while (it.hasNext()) {
            s = (String)it.next();
            this.outEdgeLabels.remove(s);
            it.remove();
        }
        this.uncommittedOutEdgeLabels.clear();
        this.committed = true;
    }

    void afterRollback() {
        Map.Entry<String, TopologyInf> entry;
        Preconditions.checkState((boolean)this.getTopology().isWriteLockHeldByCurrentThread(), (Object)"Schema.afterRollback must hold the write lock");
        Iterator<Map.Entry<String, TopologyInf>> it = this.uncommittedVertexLabels.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entry.getValue().afterRollbackForInEdges();
            it.remove();
        }
        it = this.uncommittedVertexLabels.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            entry.getValue().afterRollbackForOutEdges();
            it.remove();
        }
        if (this.getName().equals(GLOBAL_UNIQUE_INDEX_SCHEMA)) {
            it = this.uncommittedGlobalUniqueIndexes.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                ((GlobalUniqueIndex)entry.getValue()).afterRollback();
                it.remove();
            }
        }
        for (VertexLabel vertexLabel : this.vertexLabels.values()) {
            vertexLabel.afterRollbackForInEdges();
        }
        for (VertexLabel vertexLabel : this.vertexLabels.values()) {
            vertexLabel.afterRollbackForOutEdges();
        }
        if (this.getName().equals(GLOBAL_UNIQUE_INDEX_SCHEMA)) {
            for (GlobalUniqueIndex globalUniqueIndex : this.globalUniqueIndexes.values()) {
                globalUniqueIndex.afterRollback();
            }
        }
        this.uncommittedOutEdgeLabels.clear();
        this.uncommittedRemovedEdgeLabels.clear();
        this.uncommittedRemovedVertexLabels.clear();
        this.uncommittedRemovedGlobalUniqueIndexes.clear();
    }

    boolean isSqlgSchema() {
        return this.name.equals("sqlg_schema");
    }

    void loadVertexOutEdgesAndProperties(GraphTraversalSource traversalSource, Vertex schemaVertex) {
        List vertices = traversalSource.V(new Object[]{schemaVertex}).out(new String[]{"schema_vertex"}).as("vertex", new String[0]).optional((Traversal)__.out((String[])new String[]{"vertex_property"}).as("property", new String[0])).path().toList();
        for (Path vertexProperties : vertices) {
            Vertex vertexVertex = null;
            Vertex propertyVertex = null;
            List labelsList = vertexProperties.labels();
            for (Set labels : labelsList) {
                block28: for (String label : labels) {
                    switch (label) {
                        case "vertex": {
                            vertexVertex = (Vertex)vertexProperties.get("vertex");
                            continue block28;
                        }
                        case "property": {
                            propertyVertex = (Vertex)vertexProperties.get("property");
                            continue block28;
                        }
                        case "sqlgPathFakeLabel": {
                            continue block28;
                        }
                        case "~gremlin.incidentToAdjacent": {
                            continue block28;
                        }
                    }
                    throw new IllegalStateException(String.format("BUG: Only \"vertex\" and \"property\" is expected as a label. Found %s", label));
                }
            }
            Preconditions.checkState((vertexVertex != null ? 1 : 0) != 0, (Object)"BUG: Topology vertex not found.");
            String schemaName = (String)schemaVertex.value("name");
            String tableName = (String)vertexVertex.value("name");
            Object vertexLabel = this.vertexLabels.get(schemaName + "." + "V_" + tableName);
            if (vertexLabel == null) {
                vertexLabel = new VertexLabel(this, tableName);
                this.vertexLabels.put(schemaName + "." + "V_" + tableName, (VertexLabel)vertexLabel);
            }
            if (propertyVertex == null) continue;
            ((AbstractLabel)vertexLabel).addProperty(propertyVertex);
        }
        List outEdges = traversalSource.V(new Object[]{schemaVertex}).out(new String[]{"schema_vertex"}).as("vertex", new String[0]).optional((Traversal)__.out((String[])new String[]{"out_edges"}).as("outEdgeVertex", new String[0]).optional((Traversal)__.out((String[])new String[]{"edge_property"}).as("property", new String[0]))).path().toList();
        for (Path outEdgePath : outEdges) {
            EdgeLabel edgeLabel;
            List labelsList = outEdgePath.labels();
            Vertex vertexVertex = null;
            Vertex outEdgeVertex = null;
            Vertex edgePropertyVertex = null;
            for (Set labels : labelsList) {
                Object object = labels.iterator();
                block31: while (object.hasNext()) {
                    String label;
                    switch (label = (String)object.next()) {
                        case "vertex": {
                            vertexVertex = (Vertex)outEdgePath.get("vertex");
                            continue block31;
                        }
                        case "outEdgeVertex": {
                            outEdgeVertex = (Vertex)outEdgePath.get("outEdgeVertex");
                            continue block31;
                        }
                        case "property": {
                            edgePropertyVertex = (Vertex)outEdgePath.get("property");
                            continue block31;
                        }
                        case "sqlgPathFakeLabel": {
                            continue block31;
                        }
                        case "~gremlin.incidentToAdjacent": {
                            continue block31;
                        }
                    }
                    throw new IllegalStateException(String.format("BUG: Only \"vertex\", \"outEdgeVertex\" and \"property\" is expected as a label. Found \"%s\"", label));
                }
            }
            Preconditions.checkState((vertexVertex != null ? 1 : 0) != 0, (Object)"BUG: Topology vertex not found.");
            String schemaName = (String)schemaVertex.value("name");
            String tableName = (String)vertexVertex.value("name");
            VertexLabel vertexLabel = this.vertexLabels.get(schemaName + "." + "V_" + tableName);
            Preconditions.checkState((vertexLabel != null ? 1 : 0) != 0, (String)"vertexLabel must be present when loading outEdges. Not found for \"%s\"", (Object[])new Object[]{schemaName + "." + "V_" + tableName});
            if (outEdgeVertex == null) continue;
            String edgeLabelName = (String)outEdgeVertex.value("name");
            Optional<EdgeLabel> edgeLabelOptional = this.getEdgeLabel(edgeLabelName);
            if (!edgeLabelOptional.isPresent()) {
                edgeLabel = EdgeLabel.loadFromDb(vertexLabel.getSchema().getTopology(), edgeLabelName);
                vertexLabel.addToOutEdgeLabels(schemaName, edgeLabel);
            } else {
                edgeLabel = edgeLabelOptional.get();
                vertexLabel.addToOutEdgeLabels(schemaName, edgeLabel);
            }
            if (edgePropertyVertex != null) {
                edgeLabel.addProperty(edgePropertyVertex);
            }
            this.outEdgeLabels.put(schemaName + "." + "E_" + edgeLabelName, edgeLabel);
        }
    }

    void loadVertexIndices(GraphTraversalSource traversalSource, Vertex schemaVertex) {
        List indices = traversalSource.V(new Object[]{schemaVertex}).out(new String[]{"schema_vertex"}).as("vertex", new String[0]).optional((Traversal)__.out((String[])new String[]{"vertex_index"}).as("index", new String[0]).optional((Traversal)__.out((String[])new String[]{"index_property"}).as("property", new String[0]))).path().toList();
        for (Path vertexIndices : indices) {
            Index idx;
            Vertex vertexVertex = null;
            Vertex vertexIndex = null;
            Vertex propertyIndex = null;
            List labelsList = vertexIndices.labels();
            for (Set labels : labelsList) {
                Iterator iterator = labels.iterator();
                block16: while (iterator.hasNext()) {
                    String label;
                    switch (label = (String)iterator.next()) {
                        case "vertex": {
                            vertexVertex = (Vertex)vertexIndices.get("vertex");
                            continue block16;
                        }
                        case "index": {
                            vertexIndex = (Vertex)vertexIndices.get("index");
                            continue block16;
                        }
                        case "property": {
                            propertyIndex = (Vertex)vertexIndices.get("property");
                            continue block16;
                        }
                        case "sqlgPathFakeLabel": {
                            continue block16;
                        }
                        case "~gremlin.incidentToAdjacent": {
                            continue block16;
                        }
                    }
                    throw new IllegalStateException(String.format("BUG: Only \"vertex\",\"index\" and \"property\" is expected as a label. Found %s", label));
                }
            }
            Preconditions.checkState((vertexVertex != null ? 1 : 0) != 0, (Object)"BUG: Topology vertex not found.");
            String schemaName = (String)schemaVertex.value("name");
            String tableName = (String)vertexVertex.value("name");
            VertexLabel vertexLabel = this.vertexLabels.get(schemaName + "." + "V_" + tableName);
            if (vertexLabel == null) {
                vertexLabel = new VertexLabel(this, tableName);
                this.vertexLabels.put(schemaName + "." + "V_" + tableName, vertexLabel);
            }
            if (vertexIndex == null) continue;
            String indexName = (String)vertexIndex.value("name");
            Optional<Index> oidx = vertexLabel.getIndex(indexName);
            if (oidx.isPresent()) {
                idx = oidx.get();
            } else {
                idx = new Index(indexName, IndexType.fromString((String)vertexIndex.value("index_type")), vertexLabel);
                vertexLabel.addIndex(idx);
            }
            if (propertyIndex == null) continue;
            String propertyName = (String)propertyIndex.value("name");
            vertexLabel.getProperty(propertyName).ifPresent(pc -> idx.addProperty((PropertyColumn)pc));
        }
    }

    void loadInEdgeLabels(GraphTraversalSource traversalSource, Vertex schemaVertex) {
        List inEdges = traversalSource.V(new Object[]{schemaVertex}).out(new String[]{"schema_vertex"}).as("vertex", new String[0]).optional((Traversal)__.out((String[])new String[]{"out_edges"}).as("outEdgeVertex", new String[0]).in(new String[]{"in_edges"}).as("inVertex", new String[0]).in(new String[]{"schema_vertex"}).as("inSchema", new String[0])).path().toList();
        for (Path inEdgePath : inEdges) {
            List labelsList = inEdgePath.labels();
            Vertex vertexVertex = null;
            Vertex outEdgeVertex = null;
            Vertex inVertex = null;
            Vertex inSchemaVertex = null;
            for (Set labels : labelsList) {
                Iterator iterator = labels.iterator();
                block18: while (iterator.hasNext()) {
                    String label;
                    switch (label = (String)iterator.next()) {
                        case "vertex": {
                            vertexVertex = (Vertex)inEdgePath.get("vertex");
                            continue block18;
                        }
                        case "outEdgeVertex": {
                            outEdgeVertex = (Vertex)inEdgePath.get("outEdgeVertex");
                            continue block18;
                        }
                        case "inVertex": {
                            inVertex = (Vertex)inEdgePath.get("inVertex");
                            continue block18;
                        }
                        case "inSchema": {
                            inSchemaVertex = (Vertex)inEdgePath.get("inSchema");
                            continue block18;
                        }
                        case "sqlgPathFakeLabel": {
                            continue block18;
                        }
                        case "~gremlin.incidentToAdjacent": {
                            continue block18;
                        }
                    }
                    throw new IllegalStateException(String.format("BUG: Only \"vertex\", \"outEdgeVertex\" and \"inVertex\" are expected as a label. Found %s", label));
                }
            }
            Preconditions.checkState((vertexVertex != null ? 1 : 0) != 0, (Object)"BUG: Topology vertex not found.");
            String schemaName = (String)schemaVertex.value("name");
            String tableName = (String)vertexVertex.value("name");
            VertexLabel vertexLabel = this.vertexLabels.get(schemaName + "." + "V_" + tableName);
            Preconditions.checkState((vertexLabel != null ? 1 : 0) != 0, (String)"vertexLabel must be present when loading inEdges. Not found for %s", (Object[])new Object[]{schemaName + "." + "V_" + tableName});
            if (outEdgeVertex == null) continue;
            String edgeLabelName = (String)outEdgeVertex.value("name");
            Preconditions.checkState((inVertex != null ? 1 : 0) != 0, (String)"BUG: In vertex not found edge for \"%s\"", (Object[])new Object[]{edgeLabelName});
            Preconditions.checkState((inSchemaVertex != null ? 1 : 0) != 0, (String)"BUG: In schema vertex not found for edge \"%s\"", (Object[])new Object[]{edgeLabelName});
            Optional<EdgeLabel> outEdgeLabelOptional = this.topology.getEdgeLabel(this.getName(), edgeLabelName);
            Preconditions.checkState((boolean)outEdgeLabelOptional.isPresent(), (String)"BUG: EdgeLabel for \"%s\" should already be loaded", (Object[])new Object[]{this.getName() + "." + edgeLabelName});
            EdgeLabel outEdgeLabel = outEdgeLabelOptional.get();
            String inVertexLabelName = (String)inVertex.value("name");
            String inSchemaVertexLabelName = (String)inSchemaVertex.value("name");
            Optional<VertexLabel> vertexLabelOptional = this.topology.getVertexLabel(inSchemaVertexLabelName, inVertexLabelName);
            Preconditions.checkState((boolean)vertexLabelOptional.isPresent(), (String)"BUG: VertexLabel not found for schema %s and label %s", (Object[])new Object[]{inSchemaVertexLabelName, inVertexLabelName});
            VertexLabel inVertexLabel = vertexLabelOptional.get();
            inVertexLabel.addToInEdgeLabels(outEdgeLabel);
        }
    }

    void loadEdgeIndices(GraphTraversalSource traversalSource, Vertex schemaVertex) {
        List indices = traversalSource.V(new Object[]{schemaVertex}).out(new String[]{"schema_vertex"}).as("vertex", new String[0]).optional((Traversal)__.out((String[])new String[]{"out_edges"}).as("outEdgeVertex", new String[0]).optional((Traversal)__.out((String[])new String[]{"edge_index"}).as("index", new String[0]).optional((Traversal)__.out((String[])new String[]{"index_property"}).as("property", new String[0])))).path().toList();
        for (Path vertexIndices : indices) {
            Index idx;
            String edgeName;
            Optional<EdgeLabel> oel;
            Vertex vertexVertex = null;
            Vertex vertexEdge = null;
            Vertex vertexIndex = null;
            Vertex propertyIndex = null;
            List labelsList = vertexIndices.labels();
            for (Set labels : labelsList) {
                Iterator iterator = labels.iterator();
                block18: while (iterator.hasNext()) {
                    String label;
                    switch (label = (String)iterator.next()) {
                        case "vertex": {
                            vertexVertex = (Vertex)vertexIndices.get("vertex");
                            continue block18;
                        }
                        case "outEdgeVertex": {
                            vertexEdge = (Vertex)vertexIndices.get("outEdgeVertex");
                            continue block18;
                        }
                        case "index": {
                            vertexIndex = (Vertex)vertexIndices.get("index");
                            continue block18;
                        }
                        case "property": {
                            propertyIndex = (Vertex)vertexIndices.get("property");
                            continue block18;
                        }
                        case "sqlgPathFakeLabel": {
                            continue block18;
                        }
                        case "~gremlin.incidentToAdjacent": {
                            continue block18;
                        }
                    }
                    throw new IllegalStateException(String.format("BUG: Only \"vertex\",\"outEdgeVertex\",\"index\" and \"property\" is expected as a label. Found %s", label));
                }
            }
            Preconditions.checkState((vertexVertex != null ? 1 : 0) != 0, (Object)"BUG: Topology vertex not found.");
            String schemaName = (String)schemaVertex.value("name");
            String tableName = (String)vertexVertex.value("name");
            VertexLabel vertexLabel = this.vertexLabels.get(schemaName + "." + "V_" + tableName);
            if (vertexLabel == null) {
                vertexLabel = new VertexLabel(this, tableName);
                this.vertexLabels.put(schemaName + "." + "V_" + tableName, vertexLabel);
            }
            if (vertexEdge == null || !(oel = vertexLabel.getOutEdgeLabel(edgeName = (String)vertexEdge.value("name"))).isPresent()) continue;
            EdgeLabel edgeLabel = oel.get();
            if (vertexIndex == null) continue;
            String indexName = (String)vertexIndex.value("name");
            Optional<Index> oidx = edgeLabel.getIndex(indexName);
            if (oidx.isPresent()) {
                idx = oidx.get();
            } else {
                idx = new Index(indexName, IndexType.fromString((String)vertexIndex.value("index_type")), edgeLabel);
                edgeLabel.addIndex(idx);
            }
            if (propertyIndex == null) continue;
            String propertyName = (String)propertyIndex.value("name");
            edgeLabel.getProperty(propertyName).ifPresent(pc -> idx.addProperty((PropertyColumn)pc));
        }
    }

    JsonNode toJson() {
        ObjectNode schemaNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        schemaNode.put("name", this.getName());
        ArrayNode vertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (VertexLabel vertexLabel : this.getVertexLabels().values()) {
            vertexLabelArrayNode.add(vertexLabel.toJson());
        }
        schemaNode.set("vertexLabels", (JsonNode)vertexLabelArrayNode);
        return schemaNode;
    }

    Optional<JsonNode> toNotifyJson() {
        ArrayNode unCommittedGlobalUniqueIndexesArrayNode;
        ArrayNode vertexLabelArrayNode;
        boolean foundVertexLabels = false;
        ObjectNode schemaNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        schemaNode.put("name", this.getName());
        if (this.getTopology().isWriteLockHeldByCurrentThread() && !this.getUncommittedVertexLabels().isEmpty()) {
            vertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (VertexLabel vertexLabel : this.getUncommittedVertexLabels().values()) {
                JsonNode jsonNode = vertexLabel.toNotifyJson().get();
                vertexLabelArrayNode.add(jsonNode);
            }
            schemaNode.set("uncommittedVertexLabels", (JsonNode)vertexLabelArrayNode);
            foundVertexLabels = true;
        }
        if (this.getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedRemovedVertexLabels.isEmpty()) {
            vertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (String string : this.uncommittedRemovedVertexLabels) {
                vertexLabelArrayNode.add(string);
            }
            schemaNode.set("uncommittedRemovedVertexLabels", (JsonNode)vertexLabelArrayNode);
            foundVertexLabels = true;
        }
        if (this.getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedRemovedEdgeLabels.isEmpty()) {
            ArrayNode edgeLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (String string : this.uncommittedRemovedEdgeLabels) {
                edgeLabelArrayNode.add(string);
            }
            schemaNode.set("uncommittedRemovedEdgeLabels", (JsonNode)edgeLabelArrayNode);
            foundVertexLabels = true;
        }
        if (this.getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedGlobalUniqueIndexes.isEmpty()) {
            unCommittedGlobalUniqueIndexesArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (GlobalUniqueIndex globalUniqueIndex : this.uncommittedGlobalUniqueIndexes.values()) {
                Optional<JsonNode> jsonNodeOptional = globalUniqueIndex.toNotifyJson();
                if (!jsonNodeOptional.isPresent()) continue;
                unCommittedGlobalUniqueIndexesArrayNode.add(jsonNodeOptional.get());
            }
            schemaNode.set("uncommittedGlobalUniqueIndexes", (JsonNode)unCommittedGlobalUniqueIndexesArrayNode);
        }
        if (this.getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedRemovedGlobalUniqueIndexes.isEmpty()) {
            unCommittedGlobalUniqueIndexesArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (String string : this.uncommittedRemovedGlobalUniqueIndexes) {
                unCommittedGlobalUniqueIndexesArrayNode.add(string);
            }
            schemaNode.set("uncommittedRemovedGlobalUniqueIndexes", (JsonNode)unCommittedGlobalUniqueIndexesArrayNode);
        }
        if (!this.getVertexLabelsOnly().isEmpty()) {
            vertexLabelArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (VertexLabel vertexLabel : this.getVertexLabelsOnly().values()) {
                JsonNode notifyJson;
                Optional<JsonNode> notifyJsonOptional = vertexLabel.toNotifyJson();
                if (!notifyJsonOptional.isPresent() || (notifyJson = notifyJsonOptional.get()).get("uncommittedProperties") == null && notifyJson.get("uncommittedOutEdgeLabels") == null && notifyJson.get("uncommittedInEdgeLabels") == null && notifyJson.get("outEdgeLabels") == null && notifyJson.get("inEdgeLabels") == null && notifyJson.get("uncommittedRemovedOutEdgeLabels") == null && notifyJson.get("uncommittedRemovedInEdgeLabels") == null) continue;
                vertexLabelArrayNode.add(notifyJsonOptional.get());
                foundVertexLabels = true;
            }
            if (vertexLabelArrayNode.size() > 0) {
                schemaNode.set("vertexLabels", (JsonNode)vertexLabelArrayNode);
            }
        }
        if (foundVertexLabels) {
            return Optional.of(schemaNode);
        }
        return Optional.empty();
    }

    void fromNotifyJsonOutEdges(JsonNode jsonSchema) {
        ArrayNode remGlobalUniqueIndexes;
        ArrayNode globalUniqueIndexes;
        String s;
        ArrayNode an;
        for (String s2 : Arrays.asList("vertexLabels", "uncommittedVertexLabels")) {
            JsonNode vertexLabels = jsonSchema.get(s2);
            if (vertexLabels == null) continue;
            for (JsonNode vertexLabelJson : vertexLabels) {
                VertexLabel vertexLabel;
                String vertexLabelName = vertexLabelJson.get("label").asText();
                Optional<VertexLabel> vertexLabelOptional = this.getVertexLabel(vertexLabelName);
                if (vertexLabelOptional.isPresent()) {
                    vertexLabel = vertexLabelOptional.get();
                } else {
                    vertexLabel = new VertexLabel(this, vertexLabelName);
                    this.vertexLabels.put(this.name + "." + "V_" + vertexLabelName, vertexLabel);
                    this.getTopology().fire(vertexLabel, "", TopologyChangeAction.CREATE);
                }
                vertexLabel.fromNotifyJsonOutEdge(vertexLabelJson, vertexLabelOptional.isPresent());
                this.getTopology().addToAllTables(this.getName() + "." + "V_" + vertexLabelName, vertexLabel.getPropertyTypeMap());
            }
        }
        JsonNode rem = jsonSchema.get("uncommittedRemovedVertexLabels");
        if (rem != null && rem.isArray()) {
            an = (ArrayNode)rem;
            for (int a = 0; a < an.size(); ++a) {
                s = an.get(a).asText();
                VertexLabel lbl = this.vertexLabels.remove(s);
                if (lbl == null) continue;
                this.getTopology().removeVertexLabel(lbl);
                for (EdgeRole er : lbl.getOutEdgeRoles().values()) {
                    er.getEdgeLabel().outVertexLabels.remove(lbl);
                }
                for (EdgeRole er : lbl.getInEdgeRoles().values()) {
                    er.getEdgeLabel().inVertexLabels.remove(lbl);
                }
                this.getTopology().fire(lbl, "", TopologyChangeAction.DELETE);
            }
        }
        if ((rem = jsonSchema.get("uncommittedRemovedEdgeLabels")) != null && rem.isArray()) {
            an = (ArrayNode)rem;
            for (int a = 0; a < an.size(); ++a) {
                s = an.get(a).asText();
                EdgeLabel edgeLabel = this.outEdgeLabels.remove(s);
                if (edgeLabel == null) continue;
                for (VertexLabel lbl : edgeLabel.getOutVertexLabels()) {
                    if (!edgeLabel.isValid()) continue;
                    lbl.outEdgeLabels.remove(edgeLabel.getFullName());
                }
                for (VertexLabel lbl : edgeLabel.getInVertexLabels()) {
                    if (!edgeLabel.isValid()) continue;
                    lbl.inEdgeLabels.remove(edgeLabel.getFullName());
                }
                this.getTopology().fire(edgeLabel, "", TopologyChangeAction.DELETE);
            }
        }
        if ((globalUniqueIndexes = (ArrayNode)jsonSchema.get("uncommittedGlobalUniqueIndexes")) != null) {
            for (JsonNode jsonGlobalUniqueIndex : globalUniqueIndexes) {
                String globalUniqueIndexName = jsonGlobalUniqueIndex.get("name").asText();
                GlobalUniqueIndex globalUniqueIndex = this.globalUniqueIndexes.get(globalUniqueIndexName);
                if (globalUniqueIndex == null) {
                    globalUniqueIndex = GlobalUniqueIndex.instantiateGlobalUniqueIndex(this.getTopology(), globalUniqueIndexName);
                    this.getTopology().fire(globalUniqueIndex, "", TopologyChangeAction.CREATE);
                }
                HashSet<PropertyColumn> properties = new HashSet<PropertyColumn>();
                ArrayNode jsonProperties = (ArrayNode)jsonGlobalUniqueIndex.get("uncommittedProperties");
                for (JsonNode jsonProperty : jsonProperties) {
                    AbstractLabel abstractLabel;
                    ObjectNode propertyObjectNode = (ObjectNode)jsonProperty;
                    String propertyName = propertyObjectNode.get("name").asText();
                    String schemaName = propertyObjectNode.get("schemaName").asText();
                    Optional<Schema> schemaOptional = this.getTopology().getSchema(schemaName);
                    Preconditions.checkState((boolean)schemaOptional.isPresent(), (Object)"Schema must be present for GlobalUniqueIndexes fromNotifyJson");
                    Schema schema = schemaOptional.get();
                    String abstractLabelName = propertyObjectNode.get("abstractLabelLabel").asText();
                    Optional<VertexLabel> vertexLabelOptional = schema.getVertexLabel(abstractLabelName);
                    if (!vertexLabelOptional.isPresent()) {
                        Optional<EdgeLabel> edgeLabelOptional = schema.getEdgeLabel(abstractLabelName);
                        Preconditions.checkState((boolean)edgeLabelOptional.isPresent(), (Object)"VertexLabel or EdgeLabl must be present for GlobalUniqueIndex fromNotifyJson");
                        abstractLabel = edgeLabelOptional.get();
                    } else {
                        abstractLabel = vertexLabelOptional.get();
                    }
                    Optional<PropertyColumn> propertyColumnOptional = abstractLabel.getProperty(propertyName);
                    Preconditions.checkState((boolean)propertyColumnOptional.isPresent(), (Object)"PropertyColumn must be present for GlobalUniqueIndex fromNotifyJson");
                    properties.add(propertyColumnOptional.get());
                }
                globalUniqueIndex.addGlobalUniqueProperties(properties);
                this.globalUniqueIndexes.put(globalUniqueIndexName, globalUniqueIndex);
            }
        }
        if ((remGlobalUniqueIndexes = (ArrayNode)jsonSchema.get("uncommittedRemovedGlobalUniqueIndexes")) != null) {
            for (JsonNode jsonGlobalUniqueIndex : remGlobalUniqueIndexes) {
                String globalUniqueIndexName = jsonGlobalUniqueIndex.asText();
                GlobalUniqueIndex gui = this.globalUniqueIndexes.remove(globalUniqueIndexName);
                if (gui == null) continue;
                this.getTopology().fire(gui, "", TopologyChangeAction.DELETE);
            }
        }
    }

    void fromNotifyJsonInEdges(JsonNode jsonSchema) {
        JsonNode rem = jsonSchema.get("uncommittedRemovedVertexLabels");
        HashSet<String> removed = new HashSet<String>();
        if (rem != null && rem.isArray()) {
            ArrayNode an = (ArrayNode)rem;
            for (int a = 0; a < an.size(); ++a) {
                String s = an.get(a).asText();
                removed.add(s);
            }
        }
        for (String s : Arrays.asList("vertexLabels", "uncommittedVertexLabels")) {
            JsonNode vertexLabels = jsonSchema.get(s);
            if (vertexLabels == null) continue;
            for (JsonNode vertexLabelJson : vertexLabels) {
                String vertexLabelName = vertexLabelJson.get("label").asText();
                if (removed.contains(this.name + "." + "V_" + vertexLabelName)) continue;
                Optional<VertexLabel> vertexLabelOptional = this.getVertexLabel(vertexLabelName);
                Preconditions.checkState((boolean)vertexLabelOptional.isPresent(), (Object)("VertexLabel " + vertexLabelName + " must be present"));
                VertexLabel vertexLabel = vertexLabelOptional.get();
                vertexLabel.fromNotifyJsonInEdge(vertexLabelJson);
            }
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        return this.name.equals(other.name);
    }

    boolean deepEquals(Schema other) {
        Preconditions.checkState((boolean)this.name.equals(other.name), (Object)"deepEquals is called after the regular equals. i.e. the names must be equals");
        if (!this.vertexLabels.equals(other.getVertexLabels())) {
            return false;
        }
        if (!this.vertexLabels.equals(other.getVertexLabels())) {
            return false;
        }
        for (Map.Entry<String, VertexLabel> vertexLabelEntry : this.vertexLabels.entrySet()) {
            VertexLabel otherVertexLabel;
            VertexLabel vertexLabel = vertexLabelEntry.getValue();
            if (vertexLabel.deepEquals(otherVertexLabel = other.getVertexLabels().get(vertexLabelEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "schema: " + this.name;
    }

    void cacheEdgeLabels() {
        for (Map.Entry<String, VertexLabel> entry : this.vertexLabels.entrySet()) {
            for (EdgeLabel edgeLabel : entry.getValue().getOutEdgeLabels().values()) {
                this.outEdgeLabels.put(this.name + "." + "E_" + edgeLabel.getLabel(), edgeLabel);
            }
        }
    }

    void addToAllEdgeCache(EdgeLabel edgeLabel) {
        this.outEdgeLabels.put(this.name + "." + "E_" + edgeLabel.getLabel(), edgeLabel);
    }

    List<Topology.TopologyValidationError> validateTopology(DatabaseMetaData metadata) throws SQLException {
        ArrayList<Topology.TopologyValidationError> validationErrors = new ArrayList<Topology.TopologyValidationError>();
        for (VertexLabel vertexLabel : this.getVertexLabels().values()) {
            ResultSet tableRs = metadata.getTables(null, this.getName(), "V_" + vertexLabel.getLabel(), null);
            Throwable throwable = null;
            try {
                if (!tableRs.next()) {
                    validationErrors.add(new Topology.TopologyValidationError(vertexLabel));
                    continue;
                }
                validationErrors.addAll(vertexLabel.validateTopology(metadata));
                for (EdgeLabel edgeLabel : vertexLabel.getOutEdgeLabels().values()) {
                    ResultSet edgeRs = metadata.getTables(null, this.getName(), "E_" + edgeLabel.getLabel(), null);
                    Throwable throwable2 = null;
                    try {
                        if (!edgeRs.next()) {
                            validationErrors.add(new Topology.TopologyValidationError(edgeLabel));
                            continue;
                        }
                        validationErrors.addAll(edgeLabel.validateTopology(metadata));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (edgeRs == null) continue;
                        if (throwable2 != null) {
                            try {
                                edgeRs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        edgeRs.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (tableRs == null) continue;
                if (throwable != null) {
                    try {
                        tableRs.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                tableRs.close();
            }
        }
        return validationErrors;
    }

    @Override
    public void remove(boolean preserveData) {
        this.getTopology().removeSchema(this, preserveData);
    }

    void removeEdgeLabel(EdgeLabel edgeLabel, boolean preserveData) {
        this.getTopology().lock();
        String fn = this.name + "." + "E_" + edgeLabel.getName();
        if (!this.uncommittedRemovedEdgeLabels.contains(fn)) {
            this.uncommittedRemovedEdgeLabels.add(fn);
            TopologyManager.removeEdgeLabel(this.sqlgGraph, edgeLabel);
            for (VertexLabel lbl : edgeLabel.getOutVertexLabels()) {
                lbl.removeOutEdge(edgeLabel);
            }
            for (VertexLabel lbl : edgeLabel.getInVertexLabels()) {
                lbl.removeInEdge(edgeLabel);
            }
            if (!preserveData) {
                edgeLabel.delete();
            }
            this.getTopology().fire(edgeLabel, "", TopologyChangeAction.DELETE);
        }
    }

    void removeVertexLabel(VertexLabel vertexLabel, boolean preserveData) {
        this.getTopology().lock();
        String fn = this.name + "." + "V_" + vertexLabel.getName();
        if (!this.uncommittedRemovedVertexLabels.contains(fn)) {
            this.uncommittedRemovedVertexLabels.add(fn);
            TopologyManager.removeVertexLabel(this.sqlgGraph, vertexLabel);
            for (EdgeRole er : vertexLabel.getOutEdgeRoles().values()) {
                er.remove(preserveData);
            }
            for (EdgeRole er : vertexLabel.getInEdgeRoles().values()) {
                er.remove(preserveData);
            }
            if (!preserveData) {
                vertexLabel.delete();
            }
            this.getTopology().fire(vertexLabel, "", TopologyChangeAction.DELETE);
        }
    }

    void removeGlobalUniqueIndex(GlobalUniqueIndex index, boolean preserveData) {
        this.getTopology().lock();
        String fn = index.getName();
        if (!this.uncommittedRemovedGlobalUniqueIndexes.contains(fn)) {
            this.uncommittedRemovedGlobalUniqueIndexes.add(fn);
            TopologyManager.removeGlobalUniqueIndex(this.sqlgGraph, fn);
            if (!preserveData) {
                this.getVertexLabel(index.getName()).ifPresent(vl -> vl.remove(false));
            }
            this.getTopology().fire(index, "", TopologyChangeAction.DELETE);
        }
    }

    void delete() {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP SCHEMA ");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.name));
        if (this.sqlgGraph.getSqlDialect().supportsCascade()) {
            sql.append(" CASCADE");
        }
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            logger.error("schema deletion failed " + this.sqlgGraph.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

