/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.Schema;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyInf;
import org.umlg.sqlg.util.SqlgUtil;

public class SchemaManager {
    private Topology topology;
    public static final String VERTEX_PREFIX = "V_";
    public static final String EDGE_PREFIX = "E_";
    public static final String VERTICES = "VERTICES";
    public static final String ID = "ID";
    public static final String VERTEX_SCHEMA = "VERTEX_SCHEMA";
    public static final String VERTEX_TABLE = "VERTEX_TABLE";
    public static final String LABEL_SEPARATOR = ":::";
    public static final String IN_VERTEX_COLUMN_END = "__I";
    public static final String OUT_VERTEX_COLUMN_END = "__O";
    public static final String ZONEID = "~~~ZONEID";
    public static final String MONTHS = "~~~MONTHS";
    public static final String DAYS = "~~~DAYS";
    public static final String DURATION_NANOS = "~~~NANOS";
    public static final String BULK_TEMP_EDGE = "BULK_TEMP_EDGE";
    private SqlgGraph sqlgGraph;
    private SqlDialect sqlDialect;

    SchemaManager(SqlgGraph sqlgGraph, Topology topology) {
        this.sqlgGraph = sqlgGraph;
        this.sqlDialect = sqlgGraph.getSqlDialect();
        this.topology = topology;
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public Topology getTopology() {
        return this.topology;
    }

    public void clear() {
        block27: {
            try (Connection conn = this.sqlgGraph.getConnection();){
                DatabaseMetaData metadata = conn.getMetaData();
                if (this.sqlDialect.supportsCascade()) {
                    String catalog = "sqlgraphdb";
                    String schemaPattern = null;
                    String tableNamePattern = "%";
                    String[] types = new String[]{"TABLE"};
                    ResultSet result = metadata.getTables(catalog, schemaPattern, tableNamePattern, types);
                    while (result.next()) {
                        StringBuilder sql = new StringBuilder("DROP TABLE ");
                        sql.append(this.sqlDialect.maybeWrapInQoutes(result.getString(3)));
                        sql.append(" CASCADE");
                        if (this.sqlDialect.needsSemicolon()) {
                            sql.append(";");
                        }
                        PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                        Throwable throwable = null;
                        try {
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    break block27;
                }
                throw new RuntimeException("Not yet implemented!");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    Set<String> getEdgeForeignKeys(String schemaTable) {
        return this.getAllEdgeForeignKeys().get(schemaTable);
    }

    public Map<String, Set<String>> getEdgeForeignKeys() {
        return this.getAllEdgeForeignKeys();
    }

    public Map<String, Set<String>> getAllEdgeForeignKeys() {
        return this.topology.getAllEdgeForeignKeys();
    }

    public Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> getTableLabels() {
        return this.topology.getTableLabels();
    }

    @Deprecated
    public Pair<Set<SchemaTable>, Set<SchemaTable>> getTableLabels(SchemaTable schemaTable) {
        return this.topology.getTableLabels(schemaTable);
    }

    Map<String, Map<String, PropertyType>> getTables() {
        return this.topology.getAllTables();
    }

    public Map<String, Map<String, PropertyType>> getAllTables() {
        return this.getAllTablesWithout(this.getTopology().getSqlgSchemaAbstractLabels());
    }

    @Deprecated
    public Map<String, Map<String, PropertyType>> getAllTablesWithout(Set<TopologyInf> filter) {
        return this.topology.getAllTablesWithout(filter);
    }

    public Map<String, Map<String, PropertyType>> getAllTablesFrom(Set<TopologyInf> selectFrom) {
        return this.topology.getAllTablesFrom(selectFrom);
    }

    public boolean tableExist(String schema, String table) {
        SchemaTable schemaTable = SchemaTable.of(schema, table);
        Optional<Schema> schemaOptional = this.topology.getSchema(schemaTable.getSchema());
        if (schemaTable.isVertexTable()) {
            return schemaOptional.isPresent() && schemaOptional.get().getVertexLabel(schemaTable.withOutPrefix().getTable()).isPresent();
        }
        return schemaOptional.isPresent() && schemaOptional.get().getEdgeLabel(schemaTable.withOutPrefix().getTable()).isPresent();
    }

    public Map<String, PropertyType> getTableFor(SchemaTable schemaTable) {
        Preconditions.checkArgument((schemaTable.getTable().startsWith(VERTEX_PREFIX) || schemaTable.getTable().startsWith(EDGE_PREFIX) ? 1 : 0) != 0, (Object)"BUG: SchemaTable.table must start with edge or vertex prefix.");
        return this.topology.getTableFor(schemaTable);
    }

    public void createTempTable(String tmpTableIdentified, Map<String, PropertyType> columns) {
        this.topology.createTempTable(tmpTableIdentified, columns);
    }

    public void ensureVertexColumnExist(String schema, String label, ImmutablePair<String, PropertyType> keyValue) {
        HashedMap columns = new HashedMap();
        columns.put(keyValue.getLeft(), keyValue.getRight());
        this.ensureVertexColumnsExist(schema, label, (Map<String, PropertyType>)columns);
    }

    public void ensureEdgeColumnExist(String schema, String label, ImmutablePair<String, PropertyType> keyValue) {
        HashedMap columns = new HashedMap();
        columns.put(keyValue.getLeft(), keyValue.getRight());
        this.ensureEdgeColumnsExist(schema, label, (Map<String, PropertyType>)columns);
    }

    private void ensureVertexColumnsExist(String schema, String label, Map<String, PropertyType> columns) {
        Preconditions.checkArgument((!label.startsWith(VERTEX_PREFIX) ? 1 : 0) != 0, (String)"label may not start with \"%s\"", (Object[])new Object[]{VERTEX_PREFIX});
        this.topology.ensureVertexLabelPropertiesExist(schema, label, columns);
    }

    private void ensureEdgeColumnsExist(String schema, String label, Map<String, PropertyType> columns) {
        Preconditions.checkArgument((!label.startsWith(EDGE_PREFIX) ? 1 : 0) != 0, (String)"label may not start with \"%s\"", (Object[])new Object[]{EDGE_PREFIX});
        this.topology.ensureEdgePropertiesExist(schema, label, columns);
    }

    void ensureVertexTableExist(String schema, String label, Map<String, PropertyType> columns) {
        this.topology.ensureVertexLabelExist(schema, label, columns);
    }

    void ensureVertexTableExist(String schema, String label, Object ... keyValues) {
        ConcurrentHashMap<String, PropertyType> columns = SqlgUtil.transformToColumnDefinitionMap(keyValues);
        this.ensureVertexTableExist(schema, label, columns);
    }

    public SchemaTable ensureEdgeTableExist(String edgeLabelName, SchemaTable foreignKeyOut, SchemaTable foreignKeyIn, Map<String, PropertyType> columns) {
        return this.topology.ensureEdgeLabelExist(edgeLabelName, foreignKeyOut, foreignKeyIn, columns);
    }

    public SchemaTable ensureEdgeTableExist(String edgeLabelName, SchemaTable foreignKeyOut, SchemaTable foreignKeyIn, Object ... keyValues) {
        ConcurrentHashMap<String, PropertyType> columns = SqlgUtil.transformToColumnDefinitionMap(keyValues);
        return this.ensureEdgeTableExist(edgeLabelName, foreignKeyOut, foreignKeyIn, columns);
    }

    void ensureVertexTemporaryTableExist(String schema, String table, Map<String, PropertyType> columns) {
        this.topology.ensureVertexTemporaryTableExist(schema, table, columns);
    }

    void ensureVertexTemporaryTableExist(String schema, String table, Object ... keyValues) {
        ConcurrentHashMap<String, PropertyType> columns = SqlgUtil.transformToColumnDefinitionMap(keyValues);
        this.ensureVertexTemporaryTableExist(schema, table, columns);
    }
}

