/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.umlg.sqlg.structure.SqlgGraph;

public class SchemaTable
implements Serializable,
Comparable {
    private String schema;
    private String table;

    public SchemaTable() {
    }

    private SchemaTable(String schema, String table) {
        this.schema = schema;
        this.table = table;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public static SchemaTable of(String schema, String table) {
        return new SchemaTable(schema, table);
    }

    public static SchemaTable from(SqlgGraph sqlgGraph, String label) {
        String table;
        String schema;
        Objects.requireNonNull(label, "label may not be null!");
        int indexOfPeriod = label.indexOf(".");
        if (indexOfPeriod == -1) {
            schema = sqlgGraph.getSqlDialect().getPublicSchema();
            table = label;
        } else {
            schema = label.substring(0, indexOfPeriod);
            table = label.substring(indexOfPeriod + 1);
        }
        sqlgGraph.getSqlDialect().validateSchemaName(schema);
        sqlgGraph.getSqlDialect().validateTableName(table);
        return SchemaTable.of(schema, table);
    }

    public String toString() {
        return this.schema + "." + this.table;
    }

    public int hashCode() {
        return (this.schema + this.table).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SchemaTable)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        SchemaTable other = (SchemaTable)o;
        return this.schema.equals(other.schema) && this.table.equals(other.table);
    }

    public boolean isVertexTable() {
        return this.table.startsWith("V_");
    }

    public boolean isEdgeTable() {
        return !this.isVertexTable();
    }

    public SchemaTable withOutPrefix() {
        Preconditions.checkState((this.table.startsWith("V_") || this.table.startsWith("E_") ? 1 : 0) != 0);
        if (this.table.startsWith("V_")) {
            return SchemaTable.of(this.getSchema(), this.getTable().substring("V_".length()));
        }
        return SchemaTable.of(this.getSchema(), this.getTable().substring("E_".length()));
    }

    public SchemaTable withPrefix(String prefix) {
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)("Prefix must be either V_ or E_ for " + prefix));
        Preconditions.checkState((!this.table.startsWith("V_") && !this.table.startsWith("E_") ? 1 : 0) != 0, (Object)"SchemaTable is already prefixed.");
        return SchemaTable.of(this.getSchema(), prefix + this.getTable());
    }

    public int compareTo(Object o) {
        if (!(o instanceof SchemaTable)) {
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }

    static class SchemaTableIdJacksonDeserializerV2d0
    extends AbstractObjectDeserializer<SchemaTable> {
        SchemaTableIdJacksonDeserializerV2d0() {
            super(SchemaTable.class);
        }

        public SchemaTable createObject(Map data) {
            return SchemaTable.of((String)data.get("schema"), (String)data.get("table"));
        }
    }

    static class SchemaTableIdJacksonSerializerV2d0
    extends StdSerializer<SchemaTable> {
        SchemaTableIdJacksonSerializerV2d0() {
            super(SchemaTable.class);
        }

        public void serialize(SchemaTable schemaTable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeString(schemaTable.toString());
        }

        public void serializeWithType(SchemaTable schemaTable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            typeSerializer.writeTypePrefixForScalar((Object)schemaTable, jsonGenerator);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("schema", schemaTable.getSchema());
            m.put("table", schemaTable.getTable());
            jsonGenerator.writeObject(m);
            typeSerializer.writeTypeSuffixForScalar((Object)schemaTable, jsonGenerator);
        }
    }
}

