/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.strategy.Emit;
import org.umlg.sqlg.strategy.SqlgSqlExecutor;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.util.SqlgUtil;

public class SqlgCompiledResultIterator<E>
implements Iterator<E> {
    private SqlgGraph sqlgGraph;
    private Set<SchemaTableTree> rootSchemaTableTrees;
    private RecordId recordId;
    private Iterator<SchemaTableTree> rootSchemaTableTreeIterator = EmptyIterator.instance();
    private SchemaTableTree currentRootSchemaTableTree;
    private Iterator<LinkedList<SchemaTableTree>> distinctQueriesIterator = EmptyIterator.instance();
    private LinkedList<SchemaTableTree> currentDistinctQueryStack;
    private Iterator<Pair<LinkedList<SchemaTableTree>, Set<SchemaTableTree>>> optionalLeftJoinResultsIterator = EmptyIterator.instance();
    private Pair<LinkedList<SchemaTableTree>, Set<SchemaTableTree>> optionalCurrentLeftJoinResult;
    private Iterator<LinkedList<SchemaTableTree>> emitLeftJoinResultsIterator = EmptyIterator.instance();
    private LinkedList<SchemaTableTree> emitCurrentLeftJoinResult;
    private List<LinkedList<SchemaTableTree>> subQueryStacks;
    private Triple<ResultSet, ResultSetMetaData, PreparedStatement> queryResult;
    private List<Emit<SqlgElement>> elements = null;
    private Iterator<List<Emit<SqlgElement>>> allElements = null;
    private boolean lazy = true;
    private boolean first = true;
    private Map<String, Integer> lastElementIdCountMap = new HashMap<String, Integer>();
    private QUERY queryState = QUERY.REGULAR;

    SqlgCompiledResultIterator(SqlgGraph sqlgGraph, Set<SchemaTableTree> rootSchemaTableTrees, RecordId recordId) {
        this(sqlgGraph, rootSchemaTableTrees);
        this.recordId = recordId;
    }

    public SqlgCompiledResultIterator(SqlgGraph sqlgGraph, Set<SchemaTableTree> rootSchemaTableTrees) {
        this.sqlgGraph = sqlgGraph;
        this.rootSchemaTableTrees = rootSchemaTableTrees;
        this.rootSchemaTableTreeIterator = rootSchemaTableTrees.iterator();
        this.lazy = sqlgGraph.tx().isLazyQueries();
    }

    @Override
    public boolean hasNext() {
        if (this.lazy) {
            return this.hasNextLazy();
        }
        if (this.allElements == null) {
            LinkedList<List<Emit<SqlgElement>>> allList = new LinkedList<List<Emit<SqlgElement>>>();
            while (this.hasNextLazy()) {
                allList.add(this.elements);
                this.elements = null;
            }
            this.allElements = allList.iterator();
        }
        return this.allElements.hasNext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNextLazy() {
        try {
            block7: while (true) {
                switch (this.queryState) {
                    case REGULAR: {
                        if (this.elements != null) {
                            return true;
                        }
                        if (this.queryResult != null) {
                            this.iterateRegularQueries();
                            this.first = false;
                        }
                        if (this.elements != null) continue block7;
                        this.closePreparedStatement();
                        if (this.distinctQueriesIterator.hasNext()) {
                            this.currentDistinctQueryStack = this.distinctQueriesIterator.next();
                            this.subQueryStacks = SchemaTableTree.splitIntoSubStacks(this.currentDistinctQueryStack);
                            this.currentRootSchemaTableTree.resetColumnAliasMaps();
                            this.executeRegularQuery();
                            this.first = true;
                            break;
                        }
                        if (this.rootSchemaTableTreeIterator.hasNext()) {
                            this.currentRootSchemaTableTree = this.rootSchemaTableTreeIterator.next();
                            this.distinctQueriesIterator = this.currentRootSchemaTableTree.constructDistinctQueries().iterator();
                            break;
                        }
                        if (this.currentRootSchemaTableTree != null) {
                            this.currentRootSchemaTableTree.resetColumnAliasMaps();
                        }
                        this.queryState = QUERY.OPTIONAL;
                        this.rootSchemaTableTreeIterator = this.rootSchemaTableTrees.iterator();
                        break;
                    }
                    case OPTIONAL: {
                        ArrayList<Pair<LinkedList<SchemaTableTree>, Set<SchemaTableTree>>> leftJoinResult;
                        if (this.elements != null) {
                            return true;
                        }
                        if (this.queryResult != null) {
                            this.iterateOptionalQueries();
                            this.first = false;
                        }
                        if (this.elements != null) continue block7;
                        this.closePreparedStatement();
                        if (this.optionalLeftJoinResultsIterator.hasNext()) {
                            this.optionalCurrentLeftJoinResult = this.optionalLeftJoinResultsIterator.next();
                            this.subQueryStacks = SchemaTableTree.splitIntoSubStacks((LinkedList)this.optionalCurrentLeftJoinResult.getLeft());
                            this.currentRootSchemaTableTree.resetColumnAliasMaps();
                            this.executeOptionalQuery();
                            this.first = true;
                            break;
                        }
                        if (this.rootSchemaTableTreeIterator.hasNext()) {
                            this.currentRootSchemaTableTree = this.rootSchemaTableTreeIterator.next();
                            leftJoinResult = new ArrayList<Pair<LinkedList<SchemaTableTree>, Set<SchemaTableTree>>>();
                            SchemaTableTree.constructDistinctOptionalQueries(this.currentRootSchemaTableTree, leftJoinResult);
                            this.optionalLeftJoinResultsIterator = leftJoinResult.iterator();
                            break;
                        }
                        if (this.currentRootSchemaTableTree != null) {
                            this.currentRootSchemaTableTree.resetColumnAliasMaps();
                        }
                        this.queryState = QUERY.EMIT;
                        this.rootSchemaTableTreeIterator = this.rootSchemaTableTrees.iterator();
                        break;
                    }
                    case EMIT: {
                        ArrayList<Pair<LinkedList<SchemaTableTree>, Set<SchemaTableTree>>> leftJoinResult;
                        if (this.elements != null) {
                            return true;
                        }
                        if (this.queryResult != null) {
                            this.iterateEmitQueries();
                            this.first = false;
                        }
                        if (this.elements != null) continue block7;
                        this.closePreparedStatement();
                        if (this.emitLeftJoinResultsIterator.hasNext()) {
                            this.emitCurrentLeftJoinResult = this.emitLeftJoinResultsIterator.next();
                            this.subQueryStacks = SchemaTableTree.splitIntoSubStacks(this.emitCurrentLeftJoinResult);
                            this.currentRootSchemaTableTree.resetColumnAliasMaps();
                            this.executeEmitQuery();
                            this.first = true;
                            break;
                        }
                        if (this.rootSchemaTableTreeIterator.hasNext()) {
                            this.currentRootSchemaTableTree = this.rootSchemaTableTreeIterator.next();
                            leftJoinResult = new ArrayList();
                            SchemaTableTree.constructDistinctEmitBeforeQueries(this.currentRootSchemaTableTree, leftJoinResult);
                            this.emitLeftJoinResultsIterator = leftJoinResult.iterator();
                            if (!this.currentRootSchemaTableTree.isFakeEmit()) continue block7;
                            ArrayList<Emit<SqlgElement>> fake = new ArrayList<Emit<SqlgElement>>();
                            fake.add(new Emit());
                            this.elements = fake;
                            this.currentRootSchemaTableTree.setFakeEmit(false);
                            break;
                        }
                        if (this.currentRootSchemaTableTree != null) {
                            this.currentRootSchemaTableTree.resetColumnAliasMaps();
                        }
                        return false;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public E next() {
        if (this.lazy) {
            return this.nextLazy();
        }
        return (E)this.allElements.next();
    }

    public E nextLazy() {
        List<Emit<SqlgElement>> result = this.elements;
        this.elements = null;
        return (E)result;
    }

    private void executeRegularQuery() {
        this.queryResult = SqlgSqlExecutor.executeRegularQuery(this.sqlgGraph, this.currentRootSchemaTableTree, this.recordId, this.currentDistinctQueryStack);
    }

    private void executeOptionalQuery() {
        this.queryResult = SqlgSqlExecutor.executeOptionalQuery(this.sqlgGraph, this.currentRootSchemaTableTree, this.recordId, this.optionalCurrentLeftJoinResult);
    }

    private void executeEmitQuery() {
        this.queryResult = SqlgSqlExecutor.executeEmitQuery(this.sqlgGraph, this.currentRootSchemaTableTree, this.recordId, this.emitCurrentLeftJoinResult);
    }

    private void iterateRegularQueries() throws SQLException {
        List<Emit<SqlgElement>> result = SqlgUtil.loadResultSetIntoResultIterator(this.sqlgGraph, (ResultSetMetaData)this.queryResult.getMiddle(), (ResultSet)this.queryResult.getLeft(), this.currentRootSchemaTableTree, this.subQueryStacks, this.first, this.lastElementIdCountMap);
        if (!result.isEmpty()) {
            this.elements = result;
        }
    }

    private void iterateOptionalQueries() throws SQLException {
        List<Emit<SqlgElement>> result = SqlgUtil.loadResultSetIntoResultIterator(this.sqlgGraph, (ResultSetMetaData)this.queryResult.getMiddle(), (ResultSet)this.queryResult.getLeft(), this.currentRootSchemaTableTree, this.subQueryStacks, this.first, this.lastElementIdCountMap);
        if (!result.isEmpty()) {
            this.elements = result;
        }
    }

    private void iterateEmitQueries() throws SQLException {
        List<Emit<SqlgElement>> result = SqlgUtil.loadResultSetIntoResultIterator(this.sqlgGraph, (ResultSetMetaData)this.queryResult.getMiddle(), (ResultSet)this.queryResult.getLeft(), this.currentRootSchemaTableTree, this.subQueryStacks, this.first, this.lastElementIdCountMap);
        if (!result.isEmpty()) {
            this.elements = result;
        }
    }

    private void closePreparedStatement() {
        if (this.queryResult != null) {
            try {
                ((PreparedStatement)this.queryResult.getRight()).close();
                this.queryResult = null;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static enum QUERY {
        REGULAR,
        OPTIONAL,
        EMIT;

    }
}

