/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.structure.EdgeLabel;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.VertexLabel;
import org.umlg.sqlg.util.SqlgUtil;

public class SqlgEdge
extends SqlgElement
implements Edge {
    private Logger logger = LoggerFactory.getLogger((String)SqlgEdge.class.getName());
    private SqlgVertex inVertex;
    private SqlgVertex outVertex;

    public SqlgEdge(SqlgGraph sqlgGraph, boolean streaming, String schema, String table, SqlgVertex inVertex, SqlgVertex outVertex, Pair<Map<String, Object>, Map<String, Object>> keyValueMapPair) {
        super(sqlgGraph, schema, table);
        this.inVertex = inVertex;
        this.outVertex = outVertex;
        try {
            this.insertEdge(streaming, keyValueMapPair);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public SqlgEdge(SqlgGraph sqlgGraph, Long id, String schema, String table) {
        super(sqlgGraph, id, schema, table);
    }

    @Override
    public <V> Property<V> property(String key, V value) {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Edge.class, (Object)this.id());
        }
        this.sqlgGraph.tx().readWrite();
        return super.property(key, value);
    }

    private Iterator<Vertex> internalGetVertices(Direction direction) {
        ArrayList<SqlgVertex> vertices = new ArrayList<SqlgVertex>();
        if (direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) {
            vertices.add(this.getOutVertex());
        }
        if (direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) {
            vertices.add(this.getInVertex());
        }
        return vertices.iterator();
    }

    @Override
    public void remove() {
        this.sqlgGraph.tx().readWrite();
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(this.getClass(), (Object)this.id());
        }
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode()) {
            this.sqlgGraph.tx().getBatchManager().removeEdge(this.schema, this.table, this);
        } else {
            super.remove();
        }
    }

    public SqlgVertex getInVertex() {
        if (this.inVertex == null) {
            this.load();
        }
        return this.inVertex;
    }

    public SqlgVertex getOutVertex() {
        if (this.outVertex == null) {
            this.load();
        }
        return this.outVertex;
    }

    public String toString() {
        if (this.inVertex == null) {
            this.load();
        }
        return StringFactory.edgeString((Edge)this);
    }

    private void insertEdge(boolean complete, Pair<Map<String, Object>, Map<String, Object>> keyValueMapPair) throws SQLException {
        Map allKeyValueMap = (Map)keyValueMapPair.getLeft();
        Map notNullKeyValueMap = (Map)keyValueMapPair.getRight();
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode()) {
            this.internalBatchAddEdge(complete, allKeyValueMap);
        } else {
            this.internalAddEdge(notNullKeyValueMap);
        }
        this.properties.putAll(notNullKeyValueMap);
    }

    private void internalBatchAddEdge(boolean streaming, Map<String, Object> keyValueMap) {
        this.sqlgGraph.tx().getBatchManager().addEdge(streaming, this, this.outVertex, this.inVertex, keyValueMap);
    }

    private void internalAddEdge(Map<String, Object> keyValueMap) throws SQLException {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.schema));
        sql.append(".");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("E_" + this.table));
        sql.append(" (");
        HashMap<String, Pair<PropertyColumn, Object>> propertyColumnValueMap = new HashMap<String, Pair<PropertyColumn, Object>>();
        Map<String, PropertyColumn> propertyColumns = null;
        if (!keyValueMap.isEmpty()) {
            propertyColumns = this.sqlgGraph.getTopology().getSchema(this.schema).orElseThrow(() -> new IllegalStateException(String.format("Schema %s not found", this.schema))).getEdgeLabel(this.table).orElseThrow(() -> new IllegalStateException(String.format("EdgeLabel %s not found", this.table))).getProperties();
            for (Map.Entry<String, Object> keyValueEntry : keyValueMap.entrySet()) {
                PropertyColumn propertyColumn = propertyColumns.get(keyValueEntry.getKey());
                Pair propertyColumnObjectPair = Pair.of((Object)propertyColumn, (Object)keyValueEntry.getValue());
                propertyColumnValueMap.put(keyValueEntry.getKey(), (Pair<PropertyColumn, Object>)propertyColumnObjectPair);
            }
        }
        this.writeColumnNames(propertyColumnValueMap, sql);
        if (keyValueMap.size() > 0) {
            sql.append(", ");
        }
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.inVertex.schema + "." + this.inVertex.table + "__I"));
        sql.append(", ");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.outVertex.schema + "." + this.outVertex.table + "__O"));
        sql.append(") VALUES (");
        this.writeColumnParameters(propertyColumnValueMap, sql);
        if (keyValueMap.size() > 0) {
            sql.append(", ");
        }
        sql.append("?, ?");
        sql.append(")");
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        int i = 1;
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString(), 1);){
            i = SqlgUtil.setKeyValuesAsParameterUsingPropertyColumn(this.sqlgGraph, i, preparedStatement, propertyColumnValueMap);
            preparedStatement.setLong(i++, this.inVertex.recordId.getId());
            preparedStatement.setLong(i, this.outVertex.recordId.getId());
            preparedStatement.executeUpdate();
            ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
            if (!generatedKeys.next()) {
                throw new RuntimeException("Could not retrieve the id after an insert into VERTICES");
            }
            this.recordId = RecordId.from(SchemaTable.of(this.schema, this.table), generatedKeys.getLong(1));
            if (!keyValueMap.isEmpty()) {
                this.insertGlobalUniqueIndex(keyValueMap, propertyColumns);
            }
        }
    }

    @Override
    protected void load() {
        if (this.recordId != null && this.properties.isEmpty()) {
            if (this.sqlgGraph.tx().getBatchManager().isStreaming()) {
                throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
            }
            EdgeLabel edgeLabel = this.sqlgGraph.getTopology().getSchema(this.schema).get().getEdgeLabel(this.table).get();
            StringBuilder sql = new StringBuilder("SELECT\n\t");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
            for (PropertyColumn propertyColumn : edgeLabel.properties.values()) {
                sql.append(", ");
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(propertyColumn.getName()));
                String[] ps = propertyColumn.getPropertyType().getPostFixes();
                if (ps == null) continue;
                for (String p : propertyColumn.getPropertyType().getPostFixes()) {
                    sql.append(", ");
                    sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(propertyColumn.getName() + p));
                }
            }
            for (VertexLabel vertexLabel : edgeLabel.getOutVertexLabels()) {
                sql.append(", ");
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(vertexLabel.getSchema().getName() + "." + vertexLabel.getName() + "__O"));
            }
            for (VertexLabel vertexLabel : edgeLabel.getInVertexLabels()) {
                sql.append(", ");
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(vertexLabel.getSchema().getName() + "." + vertexLabel.getName() + "__I"));
            }
            sql.append("\nFROM\n\t");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.schema));
            sql.append(".");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("E_" + this.table));
            sql.append(" WHERE ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
            sql.append(" = ?");
            if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            Connection conn = this.sqlgGraph.tx().getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                preparedStatement.setCursorName("");
                preparedStatement.setLong(1, this.recordId.getId());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this.loadResultSet(resultSet);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void loadInVertex(ResultSet resultSet, String label, int columnIdx) throws SQLException {
        SchemaTable inVertexColumnName = SchemaTable.from(this.sqlgGraph, label);
        Long inId = resultSet.getLong(columnIdx);
        if (!resultSet.wasNull()) {
            this.inVertex = SqlgVertex.of(this.sqlgGraph, inId, inVertexColumnName.getSchema(), SqlgUtil.removeTrailingInId(inVertexColumnName.getTable()));
        }
    }

    public void loadOutVertex(ResultSet resultSet, String label, int columnIdx) throws SQLException {
        SchemaTable outVertexColumnName = SchemaTable.from(this.sqlgGraph, label);
        Long outId = resultSet.getLong(columnIdx);
        if (!resultSet.wasNull()) {
            this.outVertex = SqlgVertex.of(this.sqlgGraph, outId, outVertexColumnName.getSchema(), SqlgUtil.removeTrailingOutId(outVertexColumnName.getTable()));
        }
    }

    @Override
    public void loadResultSet(ResultSet resultSet) throws SQLException {
        SchemaTable inVertexColumnName = null;
        SchemaTable outVertexColumnName = null;
        int inVertexColumnIndex = 0;
        int outVertexColumnIndex = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i);
            if (!(columnName.equals("ID") || columnName.endsWith("__O") || columnName.endsWith("__I"))) {
                this.loadProperty(resultSet, columnName, i);
            }
            if (columnName.endsWith("__I")) {
                inVertexColumnName = SchemaTable.from(this.sqlgGraph, columnName);
                inVertexColumnIndex = i;
                continue;
            }
            if (!columnName.endsWith("__O")) continue;
            outVertexColumnName = SchemaTable.from(this.sqlgGraph, columnName);
            outVertexColumnIndex = i;
        }
        if (inVertexColumnName == null || inVertexColumnIndex == 0 || outVertexColumnName == null || outVertexColumnIndex == 0) {
            throw new IllegalStateException("in or out vertex id not set!!!!");
        }
        Long inId = resultSet.getLong(inVertexColumnIndex);
        Long outId = resultSet.getLong(outVertexColumnIndex);
        this.inVertex = SqlgVertex.of(this.sqlgGraph, inId, inVertexColumnName.getSchema(), SqlgUtil.removeTrailingInId(inVertexColumnName.getTable()));
        this.outVertex = SqlgVertex.of(this.sqlgGraph, outId, outVertexColumnName.getSchema(), SqlgUtil.removeTrailingOutId(outVertexColumnName.getTable()));
    }

    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        return super.properties(propertyKeys);
    }

    public Iterator<Vertex> vertices(Direction direction) {
        this.sqlgGraph.tx().readWrite();
        return this.internalGetVertices(direction);
    }

    @Override
    SchemaTable getSchemaTablePrefixed() {
        return SchemaTable.of(this.getSchema(), "E_" + this.getTable());
    }
}

