/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.google.common.base.Preconditions;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.strategy.Emit;
import org.umlg.sqlg.structure.ElementPropertyRollback;
import org.umlg.sqlg.structure.GlobalUniqueIndex;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgCompiledResultIterator;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgProperty;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.util.SqlgUtil;

public abstract class SqlgElement
implements Element {
    private Logger logger = LoggerFactory.getLogger((String)SqlgVertex.class.getName());
    protected String schema;
    protected String table;
    RecordId recordId;
    protected final SqlgGraph sqlgGraph;
    protected Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private SqlgElementElementPropertyRollback elementPropertyRollback;
    boolean removed = false;

    public SqlgElement(SqlgGraph sqlgGraph, String schema, String table) {
        this.sqlgGraph = sqlgGraph;
        this.schema = schema;
        this.table = table;
        this.elementPropertyRollback = new SqlgElementElementPropertyRollback();
    }

    public SqlgElement(SqlgGraph sqlgGraph, Long id, String schema, String table) {
        if (table.startsWith("V_") || table.startsWith("E_")) {
            throw new IllegalStateException("SqlgElement.table may not be prefixed with V_ or E_");
        }
        this.sqlgGraph = sqlgGraph;
        this.schema = schema;
        this.table = table;
        this.recordId = RecordId.from(SchemaTable.of(this.schema, this.table), id);
        this.elementPropertyRollback = new SqlgElementElementPropertyRollback();
    }

    public Graph graph() {
        return this.sqlgGraph;
    }

    public void setInternalPrimaryKey(RecordId recordId) {
        this.recordId = recordId;
    }

    abstract SchemaTable getSchemaTablePrefixed();

    public Object id() {
        return this.recordId;
    }

    public String label() {
        return this.table;
    }

    public void remove() {
        StringBuilder sql = new StringBuilder("DELETE FROM ");
        sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(this.schema));
        sql.append(".");
        sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes((this instanceof Vertex ? "V_" : "E_") + this.table));
        sql.append(" WHERE ");
        sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("ID"));
        sql.append(" = ?");
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            preparedStatement.setLong(1, ((RecordId)this.id()).getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.removed = true;
        this.removeGlobalUniqueIndex();
    }

    private void removeGlobalUniqueIndex() {
        Map<String, PropertyColumn> properties = this.sqlgGraph.getTopology().getPropertiesWithGlobalUniqueIndexFor(this.getSchemaTablePrefixed());
        for (PropertyColumn propertyColumn : properties.values()) {
            for (GlobalUniqueIndex globalUniqueIndex : propertyColumn.getGlobalUniqueIndices()) {
                StringBuilder sql = new StringBuilder("DELETE FROM ");
                sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("gui_schema"));
                sql.append(".");
                sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("V_" + globalUniqueIndex.getName()));
                sql.append(" WHERE ");
                sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("recordId"));
                sql.append(" = ? AND ");
                sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("property"));
                sql.append(" = ?");
                if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
                    sql.append(";");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(sql.toString());
                }
                Connection conn = this.sqlgGraph.tx().getConnection();
                try {
                    PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                    Throwable throwable = null;
                    try {
                        preparedStatement.setString(1, this.id().toString());
                        preparedStatement.setString(2, propertyColumn.getName());
                        preparedStatement.executeUpdate();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        preparedStatement.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Set<String> keys() {
        this.sqlgGraph.tx().readWrite();
        return this.internalGetProperties(new String[0]).keySet();
    }

    public <V> Property<V> property(String key) {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(this.getClass(), (Object)this.id());
        }
        Property<V> property = this.internalGetProperties(new String[0]).get(key);
        if (property == null) {
            return this.emptyProperty();
        }
        return property;
    }

    protected Property emptyProperty() {
        return Property.empty();
    }

    public <V> Property<V> property(String key, V value) {
        ElementHelper.validateProperty((String)key, value);
        this.sqlgGraph.getSqlDialect().validateProperty(key, value);
        if (!this.sqlgGraph.tx().isInStreamingBatchMode() && !this.sqlgGraph.tx().isInStreamingWithLockBatchMode()) {
            this.sqlgGraph.tx().addElementPropertyRollback(this.elementPropertyRollback);
        }
        PropertyType.from(value);
        if (this instanceof Vertex) {
            HashMap<String, PropertyType> columns = new HashMap<String, PropertyType>();
            columns.put(key, PropertyType.from(value));
            this.sqlgGraph.getTopology().ensureVertexLabelPropertiesExist(this.schema, this.table, columns);
        } else {
            HashedMap columns = new HashedMap();
            columns.put(key, PropertyType.from(value));
            this.sqlgGraph.getTopology().ensureEdgePropertiesExist(this.schema, this.table, (Map<String, PropertyType>)columns);
        }
        this.load();
        this.updateRow(key, value);
        return this.instantiateProperty(key, value);
    }

    protected <V> SqlgProperty<V> instantiateProperty(String key, V value) {
        return new SqlgProperty<V>(this.sqlgGraph, this, key, value);
    }

    protected abstract void load();

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    private void updateRow(String key, Object value) {
        boolean elementInInsertedCache = false;
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode()) {
            elementInInsertedCache = this.sqlgGraph.tx().getBatchManager().updateProperty(this, key, value);
        }
        if (!elementInInsertedCache) {
            Object oldValue = this.property(key).orElse(null);
            if (oldValue != null && oldValue.equals(value)) {
                return;
            }
            Map<String, PropertyColumn> properties = this instanceof Vertex ? this.sqlgGraph.getTopology().getSchema(this.schema).orElseThrow(() -> new IllegalStateException(String.format("Schema %s not found", this.schema))).getVertexLabel(this.table).orElseThrow(() -> new IllegalStateException(String.format("VertexLabel %s not found", this.table))).getProperties() : this.sqlgGraph.getTopology().getSchema(this.schema).orElseThrow(() -> new IllegalStateException(String.format("Schema %s not found", this.schema))).getEdgeLabel(this.table).orElseThrow(() -> new IllegalStateException(String.format("EdgeLabel %s not found", this.table))).getProperties();
            PropertyColumn propertyColumn = properties.get(key);
            Pair propertyColumnObjectPair = Pair.of((Object)propertyColumn, (Object)value);
            for (GlobalUniqueIndex globalUniqueIndex : propertyColumn.getGlobalUniqueIndices()) {
                SqlgElement.updateGlobalUniqueIndex(this.sqlgGraph, globalUniqueIndex, this.recordId, (Pair<PropertyColumn, Object>)propertyColumnObjectPair);
            }
            String tableName = (this instanceof Vertex ? "V_" : "E_") + this.table;
            StringBuilder sql = new StringBuilder("UPDATE ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.schema));
            sql.append(".");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(tableName));
            sql.append(" SET ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(key));
            sql.append(" = ?");
            PropertyType pt = PropertyType.from(value);
            String[] postfixes = this.sqlgGraph.getSqlDialect().propertyTypeToSqlDefinition(pt);
            if (postfixes != null && postfixes.length > 1) {
                for (int i = 1; i < postfixes.length; ++i) {
                    sql.append(",");
                    sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(key + pt.getPostFixes()[i - 1]));
                    sql.append(" = ?");
                }
            }
            sql.append(" WHERE ");
            sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
            sql.append(" = ?");
            if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            Connection conn = this.sqlgGraph.tx().getConnection();
            try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                HashMap<String, Object> keyValue = new HashMap<String, Object>();
                keyValue.put(key, value);
                int idx = SqlgElement.setKeyValuesAsParameter(this.sqlgGraph, 1, preparedStatement, keyValue);
                preparedStatement.setLong(idx, ((RecordId)this.id()).getId());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        this.properties.put(key, value);
    }

    public <S, E extends SqlgElement> Iterator<List<Emit<E>>> elements(List<ReplacedStep<S, E>> replacedSteps) {
        this.sqlgGraph.tx().readWrite();
        if (this.sqlgGraph.tx().getBatchManager().isStreaming()) {
            throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
        }
        return this.internalGetElements(replacedSteps);
    }

    private <S, E extends SqlgElement> Iterator<List<Emit<E>>> internalGetElements(List<ReplacedStep<S, E>> replacedSteps) {
        SchemaTable schemaTable = this.getSchemaTablePrefixed();
        SchemaTableTree rootSchemaTableTree = this.sqlgGraph.getGremlinParser().parse(schemaTable, replacedSteps);
        HashSet<SchemaTableTree> rootSchemaTableTrees = new HashSet<SchemaTableTree>();
        rootSchemaTableTrees.add(rootSchemaTableTree);
        return new SqlgCompiledResultIterator<List<Emit<E>>>(this.sqlgGraph, rootSchemaTableTrees, this.recordId);
    }

    public boolean equals(Object object) {
        this.sqlgGraph.tx().readWrite();
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode()) {
            if (this.id() != null && object != null && object instanceof SqlgElement && ((SqlgElement)object).id() != null) {
                return ElementHelper.areEqual((Element)this, (Object)object);
            }
            return super.equals(object);
        }
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    public int hashCode() {
        this.sqlgGraph.tx().readWrite();
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode()) {
            if (this.id() != null) {
                return ElementHelper.hashCode((Element)this);
            }
            return super.hashCode();
        }
        return ElementHelper.hashCode((Element)this);
    }

    private static int setKeyValuesAsParameter(SqlgGraph sqlgGraph, int i, PreparedStatement preparedStatement, Map<String, Object> keyValues) throws SQLException {
        List<ImmutablePair<PropertyType, Object>> typeAndValues = SqlgUtil.transformToTypeAndValue(keyValues);
        i = SqlgElement.setKeyValueAsParameter(sqlgGraph, i, preparedStatement, typeAndValues);
        return i;
    }

    private static int setKeyValueAsParameter(SqlgGraph sqlgGraph, int parameterStartIndex, PreparedStatement preparedStatement, List<ImmutablePair<PropertyType, Object>> typeAndValues) throws SQLException {
        return SqlgUtil.setKeyValuesAsParameter(sqlgGraph, true, parameterStartIndex++, preparedStatement, typeAndValues);
    }

    protected <V> Map<String, ? extends Property<V>> internalGetProperties(String ... propertyKeys) {
        this.sqlgGraph.tx().readWrite();
        this.load();
        HashMap properties = new HashMap();
        this.properties.entrySet().stream().filter(entry -> propertyKeys.length == 0 || Stream.of(propertyKeys).filter(k -> k.equals(entry.getKey())).findAny().isPresent()).filter(entry -> !((String)entry.getKey()).equals("ID")).filter(entry -> entry.getValue() != null).forEach(entry -> properties.put(entry.getKey(), this.instantiateProperty((String)entry.getKey(), entry.getValue())));
        return properties;
    }

    protected void writeColumnNames(Map<String, Pair<PropertyColumn, Object>> keyValueMap, StringBuilder sql) {
        int i = 1;
        for (String column : keyValueMap.keySet()) {
            Pair<PropertyColumn, Object> propertyColumnValue = keyValueMap.get(column);
            PropertyType propertyType = ((PropertyColumn)propertyColumnValue.getLeft()).getPropertyType();
            String[] sqlDefinitions = this.sqlgGraph.getSqlDialect().propertyTypeToSqlDefinition(propertyType);
            int count = 1;
            for (String sqlDefinition : sqlDefinitions) {
                if (count > 1) {
                    sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(column + propertyType.getPostFixes()[count - 2]));
                } else {
                    sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(column));
                }
                if (count++ >= sqlDefinitions.length) continue;
                sql.append(",");
            }
            if (i++ >= keyValueMap.size()) continue;
            sql.append(", ");
        }
    }

    protected void writeColumnParameters(Map<String, Pair<PropertyColumn, Object>> keyValueMap, StringBuilder sql) {
        int i = 1;
        for (String column : keyValueMap.keySet()) {
            PropertyType propertyType = ((PropertyColumn)keyValueMap.get(column).getLeft()).getPropertyType();
            String[] sqlDefinitions = this.sqlgGraph.getSqlDialect().propertyTypeToSqlDefinition(propertyType);
            int count = 1;
            for (String sqlDefinition : sqlDefinitions) {
                if (count > 1) {
                    sql.append("?");
                } else {
                    sql.append("?");
                }
                if (count++ >= sqlDefinitions.length) continue;
                sql.append(",");
            }
            if (i++ >= keyValueMap.size()) continue;
            sql.append(", ");
        }
    }

    protected void insertGlobalUniqueIndex(Map<String, Object> keyValueMap, Map<String, PropertyColumn> propertyColumns) {
        for (PropertyColumn propertyColumn : propertyColumns.values()) {
            for (GlobalUniqueIndex globalUniqueIndex : propertyColumn.getGlobalUniqueIndices()) {
                Object value = keyValueMap.get(propertyColumn.getName());
                Pair propertyColumnObjectPair = Pair.of((Object)propertyColumn, (Object)value);
                this.insertGlobalUniqueIndex(this.sqlgGraph, globalUniqueIndex, (Pair<PropertyColumn, Object>)propertyColumnObjectPair);
            }
        }
    }

    private void insertGlobalUniqueIndex(SqlgGraph sqlgGraph, GlobalUniqueIndex globalUniqueIndex, Pair<PropertyColumn, Object> propertyColumnObjectPair) {
        if (propertyColumnObjectPair.getRight() != null) {
            sqlgGraph.addVertex(T.label, "gui_schema." + globalUniqueIndex.getName(), "value", propertyColumnObjectPair.getValue(), "recordId", this.recordId.toString(), "property", ((PropertyColumn)propertyColumnObjectPair.getKey()).getName());
        } else {
            sqlgGraph.addVertex(T.label, "gui_schema." + globalUniqueIndex.getName(), "recordId", this.recordId.toString(), "property", ((PropertyColumn)propertyColumnObjectPair.getKey()).getName());
        }
    }

    private static void updateGlobalUniqueIndex(SqlgGraph sqlgGraph, GlobalUniqueIndex globalUniqueIndex, RecordId recordId, Pair<PropertyColumn, Object> propertyColumnObjectPair) {
        List globalUniqueIndexVertexes = sqlgGraph.globalUniqueIndexes().V(new Object[0]).hasLabel("gui_schema." + globalUniqueIndex.getName(), new String[0]).has("recordId", (Object)recordId.toString()).has("property", (Object)((PropertyColumn)propertyColumnObjectPair.getKey()).getName()).toList();
        Preconditions.checkState((globalUniqueIndexVertexes.size() <= 1 ? 1 : 0) != 0, (String)"More than one GlobalUniqueIndex for %s and recordId %s found", (Object[])new Object[]{"gui_schema." + globalUniqueIndex.getName(), recordId.toString()});
        if (!globalUniqueIndexVertexes.isEmpty()) {
            Vertex globalUniqueIndexVertex = (Vertex)globalUniqueIndexVertexes.get(0);
            globalUniqueIndexVertex.property("value", propertyColumnObjectPair.getValue());
        } else {
            sqlgGraph.addVertex(T.label, "gui_schema." + globalUniqueIndex.getName(), "value", propertyColumnObjectPair.getValue(), "recordId", recordId.toString(), "property", ((PropertyColumn)propertyColumnObjectPair.getKey()).getName());
        }
    }

    public <V> Iterator<? extends Property<V>> properties(String ... propertyKeys) {
        this.sqlgGraph.tx().readWrite();
        return this.internalGetProperties(propertyKeys).values().iterator();
    }

    public void loadProperty(ResultSet resultSet, String propertyName, int columnIndex, Map<String, String> columnNameAliasMap, int stepDepth, PropertyType propertyType) throws SQLException {
        if (propertyName.endsWith("~~~ZONEID") || propertyName.endsWith("~~~MONTHS") || propertyName.endsWith("~~~DAYS") || propertyName.endsWith("~~~NANOS")) {
            return;
        }
        switch (propertyType) {
            case BOOLEAN: {
                boolean aBoolean = resultSet.getBoolean(columnIndex);
                if (resultSet.wasNull()) break;
                this.properties.put(propertyName, aBoolean);
                break;
            }
            case BYTE: {
                byte aByte = resultSet.getByte(columnIndex);
                if (resultSet.wasNull()) break;
                this.properties.put(propertyName, aByte);
                break;
            }
            case SHORT: {
                short s = resultSet.getShort(columnIndex);
                if (resultSet.wasNull()) break;
                this.properties.put(propertyName, s);
                break;
            }
            case INTEGER: {
                int anInt = resultSet.getInt(columnIndex);
                if (resultSet.wasNull()) break;
                this.properties.put(propertyName, anInt);
                break;
            }
            case LONG: {
                long aLong = resultSet.getLong(columnIndex);
                if (resultSet.wasNull()) break;
                this.properties.put(propertyName, aLong);
                break;
            }
            case FLOAT: {
                float aFloat = resultSet.getFloat(columnIndex);
                if (resultSet.wasNull()) break;
                this.properties.put(propertyName, Float.valueOf(aFloat));
                break;
            }
            case DOUBLE: {
                double aDouble = resultSet.getDouble(columnIndex);
                if (resultSet.wasNull()) break;
                this.properties.put(propertyName, aDouble);
                break;
            }
            case STRING: {
                String string = resultSet.getString(columnIndex);
                if (resultSet.wasNull()) break;
                this.properties.put(propertyName, string);
                break;
            }
            case LOCALDATE: {
                Date date = resultSet.getDate(columnIndex);
                if (date == null) break;
                this.properties.put(propertyName, date.toLocalDate());
                break;
            }
            case LOCALDATETIME: {
                Timestamp timestamp = resultSet.getTimestamp(columnIndex);
                if (timestamp == null) break;
                this.properties.put(propertyName, timestamp.toLocalDateTime());
                break;
            }
            case ZONEDDATETIME: {
                Timestamp timestamp1 = resultSet.getTimestamp(columnIndex);
                if (timestamp1 == null) break;
                String zoneIdColumn = stepDepth + "~&~" + this.getSchemaTablePrefixed().toString().replace(".", "~&~") + "~&~" + propertyName + propertyType.getPostFixes()[0];
                String zonedId = columnNameAliasMap.get(zoneIdColumn);
                if (zonedId == null) {
                    zonedId = propertyName + propertyType.getPostFixes()[0];
                }
                String zoneId = resultSet.getString(zonedId);
                ZoneId zoneId1 = ZoneId.of(zoneId);
                ZonedDateTime zonedDateTimeAGT = ZonedDateTime.of(timestamp1.toLocalDateTime(), zoneId1);
                this.properties.put(propertyName, zonedDateTimeAGT);
                break;
            }
            case LOCALTIME: {
                Time time = resultSet.getTime(columnIndex);
                if (time == null) break;
                this.properties.put(propertyName, time.toLocalTime());
                break;
            }
            case PERIOD: {
                int years = resultSet.getInt(columnIndex);
                if (resultSet.wasNull()) break;
                String monthColumn = stepDepth + "~&~" + this.getSchemaTablePrefixed().toString().replace(".", "~&~") + "~&~" + propertyName + propertyType.getPostFixes()[0];
                String aliasedMonth = columnNameAliasMap.get(monthColumn);
                if (aliasedMonth == null) {
                    aliasedMonth = propertyName + propertyType.getPostFixes()[0];
                }
                int months = resultSet.getInt(aliasedMonth);
                String dayColumn = stepDepth + "~&~" + this.getSchemaTablePrefixed().toString().replace(".", "~&~") + "~&~" + propertyName + propertyType.getPostFixes()[1];
                String aliasedDay = columnNameAliasMap.get(dayColumn);
                if (aliasedDay == null) {
                    aliasedDay = propertyName + propertyType.getPostFixes()[1];
                }
                int days = resultSet.getInt(aliasedDay);
                this.properties.put(propertyName, Period.of(years, months, days));
                break;
            }
            case DURATION: {
                long seconds = resultSet.getLong(columnIndex);
                if (resultSet.wasNull()) break;
                String nanosColumn = stepDepth + "~&~" + this.getSchemaTablePrefixed().toString().replace(".", "~&~") + "~&~" + propertyName + propertyType.getPostFixes()[0];
                String aliasedNanos = columnNameAliasMap.get(nanosColumn);
                if (aliasedNanos == null) {
                    aliasedNanos = propertyName + propertyType.getPostFixes()[0];
                }
                int nanos = resultSet.getInt(aliasedNanos);
                this.properties.put(propertyName, Duration.ofSeconds(seconds, nanos));
                break;
            }
            case JSON: {
                Object object = resultSet.getObject(columnIndex);
                if (object == null) break;
                this.sqlgGraph.getSqlDialect().handleOther(this.properties, propertyName, object, propertyType);
                break;
            }
            case POINT: {
                Object object1 = resultSet.getObject(columnIndex);
                if (object1 == null) break;
                this.sqlgGraph.getSqlDialect().handleOther(this.properties, propertyName, object1, propertyType);
                break;
            }
            case LINESTRING: {
                Object object2 = resultSet.getObject(columnIndex);
                if (object2 == null) break;
                this.sqlgGraph.getSqlDialect().handleOther(this.properties, propertyName, object2, propertyType);
                break;
            }
            case POLYGON: {
                Object object3 = resultSet.getObject(columnIndex);
                if (object3 == null) break;
                this.sqlgGraph.getSqlDialect().handleOther(this.properties, propertyName, object3, propertyType);
                break;
            }
            case GEOGRAPHY_POINT: {
                Object object4 = resultSet.getObject(columnIndex);
                if (object4 == null) break;
                this.sqlgGraph.getSqlDialect().handleOther(this.properties, propertyName, object4, propertyType);
                break;
            }
            case GEOGRAPHY_POLYGON: {
                Object object5 = resultSet.getObject(columnIndex);
                if (object5 == null) break;
                this.sqlgGraph.getSqlDialect().handleOther(this.properties, propertyName, object5, propertyType);
                break;
            }
            case boolean_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case BOOLEAN_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case byte_ARRAY: {
                Object object6 = resultSet.getObject(columnIndex);
                if (object6 == null) break;
                this.properties.put(propertyName, object6);
                break;
            }
            case BYTE_ARRAY: {
                Object object7 = resultSet.getObject(columnIndex);
                if (object7 == null) break;
                this.properties.put(propertyName, SqlgUtil.convertPrimitiveByteArrayToByteArray((byte[])object7));
                break;
            }
            case short_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case SHORT_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case int_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case INTEGER_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case long_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case LONG_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case float_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case FLOAT_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case double_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case DOUBLE_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case STRING_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case LOCALDATETIME_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case LOCALDATE_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case LOCALTIME_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            case ZONEDDATETIME_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                String zoneIdColumn = stepDepth + "~&~" + this.getSchemaTablePrefixed().toString().replace(".", "~&~") + "~&~" + propertyName + propertyType.getPostFixes()[0];
                String zonedId = columnNameAliasMap.get(zoneIdColumn);
                if (zonedId == null) {
                    zonedId = propertyName + propertyType.getPostFixes()[0];
                }
                Array zoneIdArray = resultSet.getArray(zonedId);
                String[] objectZoneIdArray = (String[])this.sqlgGraph.getSqlDialect().convertArray(PropertyType.STRING_ARRAY, zoneIdArray);
                LocalDateTime[] localDateTimes = (LocalDateTime[])this.sqlgGraph.getSqlDialect().convertArray(PropertyType.LOCALDATETIME_ARRAY, array);
                ZonedDateTime[] zonedDateTimes = new ZonedDateTime[localDateTimes.length];
                int count = 0;
                for (LocalDateTime localDateTime : localDateTimes) {
                    ZoneId zoneId1 = ZoneId.of(objectZoneIdArray[count]);
                    ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zoneId1);
                    zonedDateTimes[count++] = zonedDateTime;
                }
                this.properties.put(propertyName, zonedDateTimes);
                break;
            }
            case DURATION_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                String nanosColumn = stepDepth + "~&~" + this.getSchemaTablePrefixed().toString().replace(".", "~&~") + "~&~" + propertyName + propertyType.getPostFixes()[0];
                String aliasedNanos = columnNameAliasMap.get(nanosColumn);
                if (aliasedNanos == null) {
                    aliasedNanos = propertyName + propertyType.getPostFixes()[0];
                }
                long[] secondsArray = (long[])this.sqlgGraph.getSqlDialect().convertArray(PropertyType.long_ARRAY, array);
                Array nanosArray = resultSet.getArray(aliasedNanos);
                int[] nanoArray = (int[])this.sqlgGraph.getSqlDialect().convertArray(PropertyType.int_ARRAY, nanosArray);
                Duration[] durations = new Duration[secondsArray.length];
                int count = 0;
                long[] lArray = secondsArray;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long second = lArray[i];
                    durations[count] = Duration.ofSeconds(second, nanoArray[count++]);
                }
                this.properties.put(propertyName, durations);
                break;
            }
            case PERIOD_ARRAY: {
                String daysColumn;
                String aliasedDays;
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                String monthsColumn = stepDepth + "~&~" + this.getSchemaTablePrefixed().toString().replace(".", "~&~") + "~&~" + propertyName + propertyType.getPostFixes()[0];
                String aliasedMonths = columnNameAliasMap.get(monthsColumn);
                if (aliasedMonths == null) {
                    aliasedMonths = propertyName + propertyType.getPostFixes()[0];
                }
                if ((aliasedDays = columnNameAliasMap.get(daysColumn = stepDepth + "~&~" + this.getSchemaTablePrefixed().toString().replace(".", "~&~") + "~&~" + propertyName + propertyType.getPostFixes()[1])) == null) {
                    aliasedDays = propertyName + propertyType.getPostFixes()[1];
                }
                Integer[] yearsIntegers = (Integer[])this.sqlgGraph.getSqlDialect().convertArray(PropertyType.INTEGER_ARRAY, array);
                Array monthsArray = resultSet.getArray(aliasedMonths);
                Integer[] monthsIntegers = (Integer[])this.sqlgGraph.getSqlDialect().convertArray(PropertyType.INTEGER_ARRAY, monthsArray);
                Array daysArray = resultSet.getArray(aliasedDays);
                Integer[] daysIntegers = (Integer[])this.sqlgGraph.getSqlDialect().convertArray(PropertyType.INTEGER_ARRAY, daysArray);
                Period[] periods = new Period[yearsIntegers.length];
                int count = 0;
                for (Integer year : yearsIntegers) {
                    periods[count] = Period.of(year, monthsIntegers[count], daysIntegers[count++]);
                }
                this.properties.put(propertyName, periods);
                break;
            }
            case JSON_ARRAY: {
                Array array = resultSet.getArray(columnIndex);
                if (array == null) break;
                this.properties.put(propertyName, this.sqlgGraph.getSqlDialect().convertArray(propertyType, array));
                break;
            }
            default: {
                throw SqlgExceptions.invalidPropertyType(propertyType);
            }
        }
    }

    void loadProperty(ResultSet resultSet, String propertyName, int columnIndex) throws SQLException {
        if (propertyName.endsWith("~~~ZONEID") || propertyName.endsWith("~~~MONTHS") || propertyName.endsWith("~~~DAYS") || propertyName.endsWith("~~~NANOS")) {
            return;
        }
        PropertyType propertyType = this.sqlgGraph.getTopology().getTableFor(this.getSchemaTablePrefixed()).get(propertyName);
        this.loadProperty(resultSet, propertyName, columnIndex, Collections.emptyMap(), -1, propertyType);
    }

    public abstract void loadResultSet(ResultSet var1) throws SQLException;

    private class SqlgElementElementPropertyRollback
    implements ElementPropertyRollback {
        private SqlgElementElementPropertyRollback() {
        }

        @Override
        public void clearProperties() {
            SqlgElement.this.properties.clear();
        }
    }
}

