/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.FeatureDescriptor;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.SqlgPlugin;
import org.umlg.sqlg.sql.dialect.SqlBulkDialect;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.sql.parse.GremlinParser;
import org.umlg.sqlg.strategy.SqlgGraphStepStrategy;
import org.umlg.sqlg.strategy.SqlgVertexStepStrategy;
import org.umlg.sqlg.strategy.SqlgWhereStrategy;
import org.umlg.sqlg.strategy.TopologyStrategy;
import org.umlg.sqlg.structure.BatchManager;
import org.umlg.sqlg.structure.IndexType;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaManager;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgDataSourceFactory;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.structure.SqlgGraphTraversalSource;
import org.umlg.sqlg.structure.SqlgIoRegistry;
import org.umlg.sqlg.structure.SqlgStartupManager;
import org.umlg.sqlg.structure.SqlgTransaction;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.VertexLabel;
import org.umlg.sqlg.structure.ds.C3p0DataSourceFactory;
import org.umlg.sqlg.structure.ds.JNDIDataSource;
import org.umlg.sqlg.util.SqlgUtil;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite")})
@Graph.OptOuts(value={@Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.TraversalInterruptionTest", method="*", reason="Fails for HSQLDB. HSQLDB has its own interrupt logic that does not play well with TinkerPop's interrupt."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.structure.TransactionTest", method="shouldRollbackElementAutoTransactionByDefault", reason="Fails for HSQLDB as HSQLDB commits the transaction on schema creation and buggers the rollback test logic."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.structure.TransactionTest", method="shouldSupportTransactionIsolationCommitCheck", reason="Fails for as the schema creation deadlock because of unnatural locking in the test."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.structure.TransactionTest", method="shouldRollbackElementAutoTransactionByDefault", reason="Fails for HSQLDB as HSQLDB commits the transaction on schema creation and buggers the rollback test logic."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ExplainTest$Traversals", method="g_V_outE_identity_inV_explain", reason="Assertions assume that the strategies are in a particular order."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasTest$Traversals", method="g_V_hasId_compilationEquality", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="modern_V_out_out_profileXmetricsX", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="grateful_V_out_out_profileXmetricsX", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="g_V_repeat_both_profileXmetricsX", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="grateful_V_out_out_profile", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="g_V_repeat_both_profile", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="modern_V_out_out_profile", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="testProfileStrategyCallback", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="testProfileStrategyCallbackSideEffect", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyProfileTest$Traversals", method="modern_V_out_out_profileXmetricsX", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyProfileTest$Traversals", method="grateful_V_out_out_profileXmetricsX", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyProfileTest$Traversals", method="g_V_repeat_both_profileXmetricsX", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyProfileTest$Traversals", method="grateful_V_out_out_profile", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyProfileTest$Traversals", method="g_V_repeat_both_profile", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyProfileTest$Traversals", method="modern_V_out_out_profile", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyProfileTest$Traversals", method="testProfileStrategyCallback", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyProfileTest$Traversals", method="testProfileStrategyCallbackSideEffect", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.structure.SerializationTest$GraphSONTest", method="shouldSerializeTraversalMetrics", reason="Assertions are TinkerGraph specific."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.CountTest$Traversals", method="g_V_repeatXoutX_timesX3X_count", reason="Takes too long, and too much memory at present."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.CountTest$Traversals", method="g_V_both_both_count", reason="Travis times out."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.CountTest$Traversals", method="g_V_repeatXoutX_timesX5X_asXaX_outXwrittenByX_asXbX_selectXa_bX_count", reason="Takes too long"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.CountTest$Traversals", method="g_V_repeatXoutX_timesX8X_count", reason="Takes too long"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyCountTest$Traversals", method="g_V_repeatXoutX_timesX3X_count", reason="Takes too long"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyCountTest$Traversals", method="g_V_repeatXoutX_timesX8X_count", reason="Takes too long"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.GroovyCountTest$Traversals", method="g_V_repeatXoutX_timesX5X_asXaX_outXwrittenByX_asXbX_selectXa_bX_count", reason="Takes too long"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatTest$Traversals", method="g_V_repeatXbothX_timesX10X_asXaX_out_asXbX_selectXa_bX", reason="Takes too long"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutorPerformanceTest", method="executorEval", reason="Takes too long"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.structure.GraphTest", method="shouldHaveStandardStringRepresentation", reason="SQLGGRAPH INCLUDES THE JDBC CONNECTION URL."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.structure.GraphTest", method="shouldHaveStandardStringRepresentation", reason="SQLGGRAPH INCLUDES THE JDBC CONNECTION URL.")})
public class SqlgGraph
implements Graph {
    public static final String JDBC_URL = "jdbc.url";
    public static final String DISTRIBUTED = "distributed";
    public static final String MODE_FOR_STREAM_VERTEX = " mode for streamVertex";
    public static final String TRANSACTION_MUST_BE_IN = "Transaction must be in ";
    private final SqlgDataSourceFactory.SqlgDataSource sqlgDataSource;
    private Logger logger = LoggerFactory.getLogger((String)SqlgGraph.class.getName());
    private final SqlgTransaction sqlgTransaction;
    private SchemaManager schemaManager;
    private Topology topology;
    private GremlinParser gremlinParser;
    private SqlDialect sqlDialect;
    private String jdbcUrl;
    private ObjectMapper mapper = new ObjectMapper();
    private boolean implementForeignKeys;
    private Configuration configuration = new BaseConfiguration();
    private final ISqlGFeatures features = new SqlGFeatures();

    public static <G extends Graph> G open(Configuration configuration) {
        return SqlgGraph.open(configuration, SqlgGraph.createDataSourceFactory(configuration));
    }

    public static <G extends Graph> G open(Configuration configuration, SqlgDataSourceFactory dataSourceFactory) {
        if (null == configuration) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"configuration");
        }
        if (!configuration.containsKey(JDBC_URL)) {
            throw new IllegalArgumentException(String.format("SqlgGraph configuration requires that the %s be set", JDBC_URL));
        }
        SqlgGraph sqlgGraph = new SqlgGraph(configuration, dataSourceFactory);
        SqlgStartupManager sqlgStartupManager = new SqlgStartupManager(sqlgGraph);
        sqlgStartupManager.loadSchema();
        return (G)sqlgGraph;
    }

    public static <G extends Graph> G open(String pathToSqlgProperties) {
        PropertiesConfiguration configuration;
        if (null == pathToSqlgProperties) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"pathToSqlgProperties");
        }
        try {
            configuration = new PropertiesConfiguration(pathToSqlgProperties);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return SqlgGraph.open((Configuration)configuration, SqlgGraph.createDataSourceFactory((Configuration)configuration));
    }

    public static SqlgDataSourceFactory createDataSourceFactory(Configuration configuration) {
        try {
            return (SqlgDataSourceFactory)Class.forName(configuration.getString("jdbc.factory", C3p0DataSourceFactory.class.getCanonicalName())).newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create sqlg factory", ex);
        }
    }

    private SqlgGraph(Configuration configuration, SqlgDataSourceFactory dataSourceFactory) {
        this.implementForeignKeys = configuration.getBoolean("implement.foreign.keys", true);
        this.configuration = configuration;
        try {
            Throwable throwable;
            Connection conn;
            this.jdbcUrl = this.configuration.getString(JDBC_URL);
            if (JNDIDataSource.isJNDIUrl(this.jdbcUrl)) {
                this.sqlgDataSource = JNDIDataSource.create(configuration);
                conn = this.getConnection();
                throwable = null;
                try {
                    SqlgPlugin p = this.findSqlgPlugin(conn.getMetaData());
                    if (p == null) {
                        throw new IllegalStateException("Could not find suitable sqlg plugin for the JDBC URL: " + this.jdbcUrl);
                    }
                    this.sqlDialect = p.instantiateDialect();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (conn != null) {
                        if (throwable != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            conn.close();
                        }
                    }
                }
            } else {
                SqlgPlugin p = this.findSqlgPlugin(this.jdbcUrl);
                if (p == null) {
                    throw new IllegalStateException("Could not find suitable sqlg plugin for the JDBC URL: " + this.jdbcUrl);
                }
                this.sqlDialect = p.instantiateDialect();
                this.sqlgDataSource = dataSourceFactory.setup(p.getDriverFor(this.jdbcUrl), this.configuration);
            }
            this.logger.debug(String.format("Opening graph. Connection url = %s, maxPoolSize = %d", this.getJdbcUrl(), configuration.getInt("maxPoolSize", 100)));
            conn = this.getConnection();
            throwable = null;
            try {
                this.sqlDialect.prepareDB(conn);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.sqlgTransaction = new SqlgTransaction(this, this.configuration.getBoolean("cache.vertices", false));
        this.tx().readWrite();
        this.topology = new Topology(this);
        this.schemaManager = new SchemaManager(this, this.topology);
        this.gremlinParser = new GremlinParser(this);
        if (!this.sqlDialect.supportSchemas() && !this.getTopology().getSchema(this.sqlDialect.getPublicSchema()).isPresent()) {
            this.getTopology().ensureSchemaExist(this.sqlDialect.getPublicSchema());
        }
        this.tx().commit();
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public Topology getTopology() {
        return this.topology;
    }

    public GremlinParser getGremlinParser() {
        return this.gremlinParser;
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public GraphTraversalSource traversal() {
        return (GraphTraversalSource)this.traversal(SqlgGraphTraversalSource.class);
    }

    public GraphTraversalSource topology() {
        return this.traversal().withStrategies(new TraversalStrategy[]{TopologyStrategy.build().selectFrom(this.getTopology().getSqlgSchemaAbstractLabels()).create()});
    }

    public GraphTraversalSource globalUniqueIndexes() {
        return this.traversal().withStrategies(new TraversalStrategy[]{TopologyStrategy.build().selectFrom(this.getTopology().getGlobalUniqueIndexes()).create()});
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Vertex addVertex(String label, Map<String, Object> keyValues) {
        HashMap<Object, Object> tmp = new HashMap<Object, Object>(keyValues);
        tmp.put((String)T.label, label);
        return this.addVertex(SqlgUtil.mapTokeyValues(tmp));
    }

    public Vertex addVertex(Object ... keyValues) {
        if (this.tx().isInStreamingBatchMode()) {
            throw SqlgExceptions.invalidMode(String.format("Transaction is in %s, use streamVertex(Object ... keyValues)", this.tx().getBatchModeType().toString()));
        }
        if (this.tx().isInStreamingWithLockBatchMode()) {
            return this.internalStreamVertex(keyValues);
        }
        Triple<Map<String, PropertyType>, Map<String, Object>, Map<String, Object>> keyValueMapTriple = SqlgUtil.validateVertexKeysValues(this.sqlDialect, keyValues);
        Pair keyValueMapPair = Pair.of((Object)keyValueMapTriple.getMiddle(), (Object)keyValueMapTriple.getRight());
        Map columns = (Map)keyValueMapTriple.getLeft();
        String label = ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex");
        SchemaTable schemaTablePair = SchemaTable.from(this, label);
        this.tx().readWrite();
        this.getTopology().ensureVertexLabelExist(schemaTablePair.getSchema(), schemaTablePair.getTable(), columns);
        return new SqlgVertex(this, false, schemaTablePair.getSchema(), schemaTablePair.getTable(), (Pair<Map<String, Object>, Map<String, Object>>)keyValueMapPair);
    }

    public void streamVertex(String label) {
        this.streamVertex(label, new LinkedHashMap<String, Object>());
    }

    public void streamVertex(Object ... keyValues) {
        if (!this.tx().isInStreamingBatchMode()) {
            throw SqlgExceptions.invalidMode(TRANSACTION_MUST_BE_IN + this.tx().getBatchModeType().toString() + MODE_FOR_STREAM_VERTEX);
        }
        this.internalStreamVertex(keyValues);
    }

    public void streamVertex(String label, LinkedHashMap<String, Object> keyValues) {
        if (!this.tx().isInStreamingBatchMode()) {
            throw SqlgExceptions.invalidMode(TRANSACTION_MUST_BE_IN + this.tx().getBatchModeType().toString() + MODE_FOR_STREAM_VERTEX);
        }
        LinkedHashMap<Object, Object> tmp = new LinkedHashMap<Object, Object>(keyValues);
        tmp.put((String)T.label, label);
        Object[] keyValues1 = SqlgUtil.mapTokeyValues(tmp);
        this.streamVertex(keyValues1);
    }

    public void streamTemporaryVertex(String label, LinkedHashMap<String, Object> keyValues) {
        if (!this.tx().isInStreamingBatchMode()) {
            throw SqlgExceptions.invalidMode(TRANSACTION_MUST_BE_IN + this.tx().getBatchModeType().toString() + MODE_FOR_STREAM_VERTEX);
        }
        LinkedHashMap<Object, Object> tmp = new LinkedHashMap<Object, Object>(keyValues);
        tmp.put((String)T.label, label);
        Object[] keyValues1 = SqlgUtil.mapTokeyValues(tmp);
        this.streamTemporaryVertex(keyValues1);
    }

    public void streamTemporaryVertex(Object ... keyValues) {
        if (!this.tx().isInStreamingBatchMode()) {
            throw SqlgExceptions.invalidMode(TRANSACTION_MUST_BE_IN + this.tx().getBatchModeType().toString() + MODE_FOR_STREAM_VERTEX);
        }
        this.internalStreamTemporaryVertex(keyValues);
    }

    private SqlgVertex internalStreamTemporaryVertex(Object ... keyValues) {
        String label = ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex");
        SchemaTable schemaTablePair = SchemaTable.from(this, label);
        SchemaTable streamingBatchModeVertexSchemaTable = this.tx().getBatchManager().getStreamingBatchModeVertexSchemaTable();
        if (streamingBatchModeVertexSchemaTable != null && !streamingBatchModeVertexSchemaTable.toString().equals(schemaTablePair.toString())) {
            throw new IllegalStateException("Streaming batch mode must occur for one label at a time. Expected \"" + streamingBatchModeVertexSchemaTable + "\" found \"" + label + "\". First commit the transaction or call SqlgGraph.flush() before streaming a different label");
        }
        List<String> keys = this.tx().getBatchManager().getStreamingBatchModeVertexKeys();
        Triple<Map<String, PropertyType>, Map<String, Object>, Map<String, Object>> keyValuesTriple = SqlgUtil.validateVertexKeysValues(this.sqlDialect, keyValues, keys);
        Map allKeyValueMap = (Map)keyValuesTriple.getMiddle();
        Map columns = (Map)keyValuesTriple.getLeft();
        this.tx().readWrite();
        this.getTopology().ensureVertexTemporaryTableExist(schemaTablePair.getSchema(), schemaTablePair.getTable(), columns);
        return new SqlgVertex(this, schemaTablePair.getTable(), allKeyValueMap);
    }

    private SqlgVertex internalStreamVertex(Object ... keyValues) {
        String label = ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex");
        SchemaTable schemaTablePair = SchemaTable.from(this, label);
        SchemaTable streamingBatchModeVertexSchemaTable = this.tx().getBatchManager().getStreamingBatchModeVertexSchemaTable();
        if (streamingBatchModeVertexSchemaTable != null && !streamingBatchModeVertexSchemaTable.toString().equals(schemaTablePair.toString())) {
            throw new IllegalStateException("Streaming batch mode must occur for one label at a time. Expected \"" + streamingBatchModeVertexSchemaTable + "\" found \"" + label + "\". First commit the transaction or call SqlgGraph.flush() before streaming a different label");
        }
        List<String> keys = this.tx().getBatchManager().getStreamingBatchModeVertexKeys();
        Triple<Map<String, PropertyType>, Map<String, Object>, Map<String, Object>> keyValueMapTriple = SqlgUtil.validateVertexKeysValues(this.sqlDialect, keyValues, keys);
        Pair keyValueMapPair = Pair.of((Object)keyValueMapTriple.getMiddle(), (Object)keyValueMapTriple.getRight());
        Map columns = (Map)keyValueMapTriple.getLeft();
        this.tx().readWrite();
        this.getTopology().ensureVertexLabelExist(schemaTablePair.getSchema(), schemaTablePair.getTable(), columns);
        return new SqlgVertex(this, true, schemaTablePair.getSchema(), schemaTablePair.getTable(), (Pair<Map<String, Object>, Map<String, Object>>)keyValueMapPair);
    }

    public <L, R> void bulkAddEdges(String outVertexLabel, String inVertexLabel, String edgeLabel, Pair<String, String> idFields, Collection<Pair<L, R>> uids) {
        if (!(this.sqlDialect instanceof SqlBulkDialect)) {
            throw new UnsupportedOperationException(String.format("Bulk mode is not supported for %s", this.sqlDialect.dialectName()));
        }
        SqlBulkDialect sqlBulkDialect = (SqlBulkDialect)this.sqlDialect;
        if (!this.tx().isInStreamingBatchMode() && !this.tx().isInStreamingWithLockBatchMode()) {
            throw SqlgExceptions.invalidMode(TRANSACTION_MUST_BE_IN + (Object)((Object)BatchManager.BatchModeType.STREAMING) + " or " + (Object)((Object)BatchManager.BatchModeType.STREAMING_WITH_LOCK) + " mode for bulkAddEdges");
        }
        if (!uids.isEmpty()) {
            SchemaTable outSchemaTable = SchemaTable.from(this, outVertexLabel);
            SchemaTable inSchemaTable = SchemaTable.from(this, inVertexLabel);
            sqlBulkDialect.bulkAddEdges(this, outSchemaTable, inSchemaTable, edgeLabel, idFields, uids);
        }
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public GraphComputer compute() {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    public Iterator<Vertex> vertices(Object ... vertexIds) {
        this.tx().readWrite();
        if (this.tx().getBatchManager().isStreaming()) {
            throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
        }
        return this.createElementIterator(Vertex.class, vertexIds);
    }

    public Iterator<Edge> edges(Object ... edgeIds) {
        this.tx().readWrite();
        if (this.tx().getBatchManager().isStreaming()) {
            throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
        }
        return this.createElementIterator(Edge.class, edgeIds);
    }

    private <T extends Element> Iterator<T> createElementIterator(Class<T> clazz, Object ... ids) {
        if (0 == ids.length) {
            return this.elements(Vertex.class.isAssignableFrom(clazz), Collections.EMPTY_LIST).iterator();
        }
        if (clazz.isAssignableFrom(ids[0].getClass())) {
            if (!Stream.of(ids).allMatch(id -> clazz.isAssignableFrom(id.getClass()))) {
                throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
            }
            return Stream.of(ids).map(id -> (Element)id).iterator();
        }
        Class<?> firstClass = ids[0].getClass();
        if (!Stream.of(ids).map(Object::getClass).allMatch(firstClass::equals)) {
            throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
        }
        List<RecordId> recordIds = RecordId.from(ids);
        Iterable<T> elementIterable = this.elements(Vertex.class.isAssignableFrom(clazz), recordIds);
        return elementIterable.iterator();
    }

    public SqlgTransaction tx() {
        return this.sqlgTransaction;
    }

    public Graph.Variables variables() {
        throw Graph.Exceptions.variablesNotSupported();
    }

    public void close() throws Exception {
        this.logger.debug(String.format("Closing graph. Connection url = %s, maxPoolSize = %d", this.configuration.getString(JDBC_URL), this.configuration.getInt("maxPoolSize", 100)));
        if (this.tx().isOpen()) {
            this.tx().close();
        }
        this.topology.close();
        this.sqlgDataSource.close();
    }

    public <I extends Io> I io(Io.Builder<I> builder) {
        return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)SqlgIoRegistry.getInstance())).create();
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)"SqlGraph") + " (" + this.configuration.getProperty(JDBC_URL) + ")";
    }

    public ISqlGFeatures features() {
        return this.features;
    }

    public <T> T gis() {
        return this.getSqlDialect().getGis(this);
    }

    public String query(String query) {
        try {
            Connection conn = this.tx().getConnection();
            ObjectNode result = this.mapper.createObjectNode();
            ArrayNode dataNode = this.mapper.createArrayNode();
            ArrayNode metaNode = this.mapper.createArrayNode();
            Statement statement = conn.createStatement();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(query);
            }
            ResultSet rs = statement.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            boolean first = true;
            while (rs.next()) {
                int numColumns = rsmd.getColumnCount();
                ObjectNode obj = this.mapper.createObjectNode();
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = rsmd.getColumnLabel(i);
                    int type = rsmd.getColumnType(i);
                    Object o = type == 2003 ? rs.getArray(i) : rs.getObject(i);
                    this.sqlDialect.putJsonObject(obj, columnName, type, o);
                    if (!first) continue;
                    this.sqlDialect.putJsonMetaObject(this.mapper, metaNode, columnName, type, o);
                }
                first = false;
                dataNode.add((JsonNode)obj);
            }
            result.put("data", (JsonNode)dataNode);
            result.put("meta", (JsonNode)metaNode);
            String string = result.toString();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.tx().rollback();
        }
    }

    public void createUniqueConstraint(String label, String propertyKey) {
        throw new IllegalStateException("Not yet implemented!");
    }

    public void createVertexLabeledIndex(String label, Object ... dummykeyValues) {
        ConcurrentHashMap<String, PropertyType> columns = SqlgUtil.transformToColumnDefinitionMap(dummykeyValues);
        SchemaTable schemaTablePair = SchemaTable.from(this, label);
        VertexLabel vertexLabel = this.getTopology().ensureVertexLabelExist(schemaTablePair.getSchema(), schemaTablePair.getTable(), columns);
        ArrayList<PropertyColumn> properties = new ArrayList<PropertyColumn>();
        List<String> keys = SqlgUtil.transformToKeyList(dummykeyValues);
        for (String key : keys) {
            properties.add(vertexLabel.getProperty(key).get());
        }
        vertexLabel.ensureIndexExists(IndexType.NON_UNIQUE, properties);
    }

    public long countVertices() {
        this.tx().readWrite();
        return this.countElements(true);
    }

    public long countEdges() {
        this.tx().readWrite();
        return this.countElements(false);
    }

    private long countElements(boolean returnVertices) {
        long count = 0L;
        Set<String> tables = this.getTopology().getAllTables().keySet();
        for (String table : tables) {
            SchemaTable schemaTable = SchemaTable.from(this, table);
            if (!(returnVertices ? schemaTable.isVertexTable() : !schemaTable.isVertexTable())) continue;
            StringBuilder sql = new StringBuilder("SELECT COUNT(1) FROM ");
            sql.append("\"");
            sql.append(schemaTable.getSchema());
            sql.append("\".\"");
            sql.append(schemaTable.getTable());
            sql.append("\"");
            if (this.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            Connection conn = this.tx().getConnection();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sql.toString());
            }
            try {
                PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                Throwable throwable = null;
                try {
                    ResultSet rs = preparedStatement.executeQuery();
                    rs.next();
                    count += rs.getLong(1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return count;
    }

    public boolean isImplementForeignKeys() {
        return this.implementForeignKeys;
    }

    private SqlgPlugin findSqlgPlugin(DatabaseMetaData metadata) throws SQLException {
        for (SqlgPlugin p : ServiceLoader.load(SqlgPlugin.class, this.getClass().getClassLoader())) {
            this.logger.info("found plugin for SqlgPlugin.class");
            if (p.canWorkWith(metadata)) {
                return p;
            }
            this.logger.info("can not work with SqlgPlugin.class");
        }
        return null;
    }

    private SqlgPlugin findSqlgPlugin(String connectionUri) {
        for (SqlgPlugin p : ServiceLoader.load(SqlgPlugin.class, this.getClass().getClassLoader())) {
            if (p.getDriverFor(connectionUri) == null) continue;
            return p;
        }
        return null;
    }

    private <T extends Element> Iterable<T> elements(boolean returnVertices, List<RecordId> elementIds) {
        ArrayList<SqlgVertex> sqlgElements = new ArrayList<SqlgVertex>();
        if (elementIds.size() > 0) {
            Map<SchemaTable, List<Long>> distinctTableIdMap = RecordId.normalizeIds(elementIds);
            for (Map.Entry<SchemaTable, List<Long>> schemaTableListEntry : distinctTableIdMap.entrySet()) {
                SchemaTable schemaTable = schemaTableListEntry.getKey();
                String tableName = (returnVertices ? "V_" : "E_") + schemaTable.getTable();
                if (!this.getTopology().getAllTables().containsKey(schemaTable.getSchema() + "." + tableName)) continue;
                List<Long> schemaTableIds = schemaTableListEntry.getValue();
                StringBuilder sql = new StringBuilder("SELECT * FROM ");
                sql.append("\"");
                sql.append(schemaTable.getSchema());
                sql.append("\".\"");
                if (returnVertices) {
                    sql.append("V_");
                } else {
                    sql.append("E_");
                }
                sql.append(schemaTable.getTable());
                sql.append("\" WHERE ");
                sql.append(this.sqlDialect.maybeWrapInQoutes("ID"));
                sql.append(" IN (");
                int count = 1;
                for (Long id : schemaTableIds) {
                    sql.append(id.toString());
                    if (count++ >= schemaTableIds.size()) continue;
                    sql.append(",");
                }
                sql.append(")");
                if (this.getSqlDialect().needsSemicolon()) {
                    sql.append(";");
                }
                Connection conn = this.tx().getConnection();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(sql.toString());
                }
                try {
                    Statement statement = conn.createStatement();
                    Throwable throwable = null;
                    try {
                        statement.execute(sql.toString());
                        ResultSet resultSet = statement.getResultSet();
                        while (resultSet.next()) {
                            long id = resultSet.getLong("ID");
                            SqlgElement sqlgElement = returnVertices ? SqlgVertex.of(this, id, schemaTable.getSchema(), schemaTable.getTable()) : new SqlgEdge(this, id, schemaTable.getSchema(), schemaTable.getTable());
                            ((SqlgElement)sqlgElement).loadResultSet(resultSet);
                            sqlgElements.add((SqlgVertex)sqlgElement);
                        }
                    }
                    catch (Throwable resultSet) {
                        throwable = resultSet;
                        throw resultSet;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable resultSet) {
                                throwable.addSuppressed(resultSet);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            Set<String> tables = this.getTopology().getAllTables().keySet();
            for (String table : tables) {
                SchemaTable schemaTable = SchemaTable.from(this, table);
                if (!(returnVertices ? schemaTable.isVertexTable() : !schemaTable.isVertexTable())) continue;
                StringBuilder sql = new StringBuilder("SELECT * FROM ");
                sql.append("\"");
                sql.append(schemaTable.getSchema());
                sql.append("\".\"");
                sql.append(schemaTable.getTable());
                sql.append("\"");
                if (this.getSqlDialect().needsSemicolon()) {
                    sql.append(";");
                }
                Connection conn = this.tx().getConnection();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(sql.toString());
                }
                try {
                    Statement statement = conn.createStatement();
                    Throwable throwable = null;
                    try {
                        statement.execute(sql.toString());
                        ResultSet resultSet = statement.getResultSet();
                        while (resultSet.next()) {
                            long id = resultSet.getLong("ID");
                            SqlgElement sqlgElement = returnVertices ? SqlgVertex.of(this, id, schemaTable.getSchema(), schemaTable.getTable().substring("V_".length())) : new SqlgEdge(this, id, schemaTable.getSchema(), schemaTable.getTable().substring("E_".length()));
                            ((SqlgElement)sqlgElement).loadResultSet(resultSet);
                            sqlgElements.add((SqlgVertex)sqlgElement);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return sqlgElements;
    }

    public Connection getConnection() throws SQLException {
        return this.sqlgDataSource.getDatasource().getConnection();
    }

    public SqlgDataSourceFactory.SqlgDataSource getSqlgDataSource() {
        return this.sqlgDataSource;
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(Graph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Graph.class).addStrategies(new TraversalStrategy[]{new SqlgGraphStepStrategy(), new SqlgVertexStepStrategy(), new SqlgWhereStrategy(), TopologyStrategy.build().create()}));
    }

    public class SqlGFeatures
    implements ISqlGFeatures {
        public Graph.Features.GraphFeatures graph() {
            return new Graph.Features.GraphFeatures(){

                public boolean supportsComputer() {
                    return false;
                }

                public Graph.Features.VariableFeatures variables() {
                    return new SqlVariableFeatures();
                }

                public boolean supportsThreadedTransactions() {
                    return false;
                }
            };
        }

        public Graph.Features.VertexFeatures vertex() {
            return new SqlVertexFeatures();
        }

        public Graph.Features.EdgeFeatures edge() {
            return new SqlEdgeFeatures();
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }

        @Override
        public boolean supportsBatchMode() {
            return SqlgGraph.this.getSqlDialect().supportsBatchMode();
        }

        public class SqlVariableFeatures
        implements Graph.Features.VariableFeatures {
            @FeatureDescriptor(name="BooleanValues")
            public boolean supportsBooleanValues() {
                return false;
            }

            @FeatureDescriptor(name="DoubleValues")
            public boolean supportsDoubleValues() {
                return false;
            }

            @FeatureDescriptor(name="FloatValues")
            public boolean supportsFloatValues() {
                return false;
            }

            @FeatureDescriptor(name="IntegerValues")
            public boolean supportsIntegerValues() {
                return false;
            }

            @FeatureDescriptor(name="LongValues")
            public boolean supportsLongValues() {
                return false;
            }

            @FeatureDescriptor(name="MapValues")
            public boolean supportsMapValues() {
                return false;
            }

            @FeatureDescriptor(name="MixedListValues")
            public boolean supportsMixedListValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteValues")
            public boolean supportsByteValues() {
                return false;
            }

            @FeatureDescriptor(name="BooleanArrayValues")
            public boolean supportsBooleanArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteArrayValues")
            public boolean supportsByteArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="DoubleArrayValues")
            public boolean supportsDoubleArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="FloatArrayValues")
            public boolean supportsFloatArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="IntegerArrayValues")
            public boolean supportsIntegerArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="LongArrayValues")
            public boolean supportsLongArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="StringArrayValues")
            public boolean supportsStringArrayValues() {
                return false;
            }

            @FeatureDescriptor(name="SerializableValues")
            public boolean supportsSerializableValues() {
                return false;
            }

            @FeatureDescriptor(name="StringValues")
            public boolean supportsStringValues() {
                return false;
            }

            @FeatureDescriptor(name="UniformListValues")
            public boolean supportsUniformListValues() {
                return false;
            }
        }

        public class SqlEdgePropertyFeatures
        implements Graph.Features.EdgePropertyFeatures {
            @FeatureDescriptor(name="MapValues")
            public boolean supportsMapValues() {
                return false;
            }

            @FeatureDescriptor(name="MixedListValues")
            public boolean supportsMixedListValues() {
                return false;
            }

            @FeatureDescriptor(name="SerializableValues")
            public boolean supportsSerializableValues() {
                return false;
            }

            @FeatureDescriptor(name="UniformListValues")
            public boolean supportsUniformListValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteValues")
            public boolean supportsByteValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsByteValues();
            }

            @FeatureDescriptor(name="FloatValues")
            public boolean supportsFloatValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsFloatValues();
            }

            @FeatureDescriptor(name="BooleanArrayValues")
            public boolean supportsBooleanArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsBooleanArrayValues();
            }

            @FeatureDescriptor(name="ByteArrayValues")
            public boolean supportsByteArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsByteArrayValues();
            }

            @FeatureDescriptor(name="DoubleArrayValues")
            public boolean supportsDoubleArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsDoubleArrayValues();
            }

            @FeatureDescriptor(name="FloatArrayValues")
            public boolean supportsFloatArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsFloatArrayValues();
            }

            @FeatureDescriptor(name="IntegerArrayValues")
            public boolean supportsIntegerArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsIntegerArrayValues();
            }

            @FeatureDescriptor(name="LongArrayValues")
            public boolean supportsLongArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsLongArrayValues();
            }

            @FeatureDescriptor(name="StringArrayValues")
            public boolean supportsStringArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsStringArrayValues();
            }
        }

        public class SqlGVertexPropertyFeatures
        implements Graph.Features.VertexPropertyFeatures {
            @FeatureDescriptor(name="AddProperty")
            public boolean supportsAddProperty() {
                return true;
            }

            @FeatureDescriptor(name="RemoveProperty")
            public boolean supportsRemoveProperty() {
                return true;
            }

            @FeatureDescriptor(name="UserSuppliedIds")
            public boolean supportsUserSuppliedIds() {
                return false;
            }

            @FeatureDescriptor(name="NumericIds")
            public boolean supportsNumericIds() {
                return true;
            }

            @FeatureDescriptor(name="StringIds")
            public boolean supportsStringIds() {
                return false;
            }

            @FeatureDescriptor(name="UuidIds")
            public boolean supportsUuidIds() {
                return false;
            }

            @FeatureDescriptor(name="CustomIds")
            public boolean supportsCustomIds() {
                return false;
            }

            @FeatureDescriptor(name="AnyIds")
            public boolean supportsAnyIds() {
                return false;
            }

            @FeatureDescriptor(name="MapValues")
            public boolean supportsMapValues() {
                return false;
            }

            @FeatureDescriptor(name="MixedListValues")
            public boolean supportsMixedListValues() {
                return false;
            }

            @FeatureDescriptor(name="SerializableValues")
            public boolean supportsSerializableValues() {
                return false;
            }

            @FeatureDescriptor(name="UniformListValues")
            public boolean supportsUniformListValues() {
                return false;
            }

            @FeatureDescriptor(name="ByteValues")
            public boolean supportsByteValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsByteValues();
            }

            @FeatureDescriptor(name="FloatValues")
            public boolean supportsFloatValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsFloatValues();
            }

            @FeatureDescriptor(name="BooleanArrayValues")
            public boolean supportsBooleanArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsBooleanArrayValues();
            }

            @FeatureDescriptor(name="ByteArrayValues")
            public boolean supportsByteArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsByteArrayValues();
            }

            @FeatureDescriptor(name="DoubleArrayValues")
            public boolean supportsDoubleArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsDoubleArrayValues();
            }

            @FeatureDescriptor(name="FloatArrayValues")
            public boolean supportsFloatArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsFloatArrayValues();
            }

            @FeatureDescriptor(name="IntegerArrayValues")
            public boolean supportsIntegerArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsIntegerArrayValues();
            }

            @FeatureDescriptor(name="LongArrayValues")
            public boolean supportsLongArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsLongArrayValues();
            }

            @FeatureDescriptor(name="StringArrayValues")
            public boolean supportsStringArrayValues() {
                return SqlgGraph.this.getSchemaManager().getSqlDialect().supportsStringArrayValues();
            }
        }

        public class SqlEdgeFeatures
        implements Graph.Features.EdgeFeatures {
            @FeatureDescriptor(name="UserSuppliedIds")
            public boolean supportsUserSuppliedIds() {
                return false;
            }

            @FeatureDescriptor(name="NumericIds")
            public boolean supportsNumericIds() {
                return false;
            }

            @FeatureDescriptor(name="AnyIds")
            public boolean supportsAnyIds() {
                return false;
            }

            @FeatureDescriptor(name="StringIds")
            public boolean supportsStringIds() {
                return false;
            }

            @FeatureDescriptor(name="CustomIds")
            public boolean supportsCustomIds() {
                return false;
            }

            @FeatureDescriptor(name="UuidIds")
            public boolean supportsUuidIds() {
                return false;
            }

            public Graph.Features.EdgePropertyFeatures properties() {
                return new SqlEdgePropertyFeatures();
            }
        }

        public class SqlVertexFeatures
        implements Graph.Features.VertexFeatures {
            @FeatureDescriptor(name="MultiProperties")
            public boolean supportsMultiProperties() {
                return false;
            }

            @FeatureDescriptor(name="MetaProperties")
            public boolean supportsMetaProperties() {
                return false;
            }

            @FeatureDescriptor(name="UserSuppliedIds")
            public boolean supportsUserSuppliedIds() {
                return false;
            }

            @FeatureDescriptor(name="NumericIds")
            public boolean supportsNumericIds() {
                return false;
            }

            @FeatureDescriptor(name="StringIds")
            public boolean supportsStringIds() {
                return false;
            }

            @FeatureDescriptor(name="UuidIds")
            public boolean supportsUuidIds() {
                return false;
            }

            @FeatureDescriptor(name="AnyIds")
            public boolean supportsAnyIds() {
                return false;
            }

            @FeatureDescriptor(name="CustomIds")
            public boolean supportsCustomIds() {
                return false;
            }

            public Graph.Features.VertexPropertyFeatures properties() {
                return new SqlGVertexPropertyFeatures();
            }

            public VertexProperty.Cardinality getCardinality(String key) {
                return VertexProperty.Cardinality.single;
            }
        }
    }

    public static interface ISqlGFeatures
    extends Graph.Features {
        public boolean supportsBatchMode();
    }
}

