/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgGraph;

public class SqlgProperty<V>
implements Property<V>,
Serializable {
    private final String key;
    private V value;
    private SqlgElement element;
    protected SqlgGraph sqlgGraph;

    public SqlgProperty(SqlgGraph sqlgGraph, SqlgElement element, String key, V value) {
        this.sqlgGraph = sqlgGraph;
        this.element = element;
        this.key = key;
        this.value = value;
    }

    public String key() {
        return this.key;
    }

    public V value() throws NoSuchElementException {
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Element element() {
        return this.element;
    }

    public void remove() {
        this.element.properties.remove(this.key);
        boolean elementInInsertedCache = false;
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode()) {
            elementInInsertedCache = this.sqlgGraph.tx().getBatchManager().removeProperty(this, this.key);
        }
        if (!elementInInsertedCache) {
            StringBuilder sql = new StringBuilder("UPDATE ");
            sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(this.element.schema));
            sql.append(".");
            sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes((this.element instanceof Vertex ? "V_" : "E_") + this.element.table));
            sql.append(" SET ");
            sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(this.key));
            sql.append(" = ? WHERE ");
            sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("ID"));
            sql.append(" = ?");
            if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            Connection conn = this.sqlgGraph.tx().getConnection();
            try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                PropertyType propertyType = PropertyType.from(this.value);
                preparedStatement.setNull(1, this.sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType));
                preparedStatement.setLong(2, ((RecordId)this.element.id()).getId());
                int numberOfRowsUpdated = preparedStatement.executeUpdate();
                if (numberOfRowsUpdated != 1) {
                    throw new IllegalStateException("Remove property failed!");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Property)this, (Object)object);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Property)this);
    }
}

