/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.structure.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.structure.IndexRef;
import org.umlg.sqlg.structure.IndexType;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyManager;

class SqlgStartupManager {
    private Logger logger = LoggerFactory.getLogger((String)SqlgStartupManager.class.getName());
    private SqlgGraph sqlgGraph;
    private SqlDialect sqlDialect;

    SqlgStartupManager(SqlgGraph sqlgGraph) {
        this.sqlgGraph = sqlgGraph;
        this.sqlDialect = sqlgGraph.getSqlDialect();
    }

    void loadSchema() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SchemaManager.loadSchema()...");
            }
            boolean existSqlgSchema = this.existSqlgSchema();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (!existSqlgSchema) {
                this.createSqlgSchema();
            }
            if (!this.existGuiSchema()) {
                this.createGuiSchema();
            }
            if (!existSqlgSchema) {
                this.createSqlgSchemaTablesAndIndexes();
            }
            this.sqlgGraph.tx().commit();
            stopWatch.stop();
            this.logger.debug("Time to createVertexLabel sqlg topology: " + stopWatch.toString());
            if (!existSqlgSchema) {
                this.addPublicSchema();
                this.sqlgGraph.tx().commit();
            }
            if (!existSqlgSchema) {
                this.logger.debug("Upgrading sqlg from pre sqlg_schema version to sqlg_schema version");
                StopWatch stopWatch2 = new StopWatch();
                stopWatch2.start();
                this.loadSqlgSchemaFromInformationSchema();
                stopWatch2.stop();
                System.out.println("Time to upgrade sqlg from pre sqlg_schema: " + stopWatch2.toString());
                this.logger.debug("Done upgrading sqlg from pre sqlg_schema version to sqlg_schema version");
            } else {
                this.upgradePropertyIndexTypeToExist();
                this.sqlgGraph.tx().commit();
            }
            this.cacheTopology();
            if (this.sqlgGraph.configuration().getBoolean("validate.topology", false)) {
                this.validateTopology();
            }
            this.sqlgGraph.tx().commit();
        }
        catch (Exception e) {
            this.sqlgGraph.tx().rollback();
            throw e;
        }
    }

    private void cacheTopology() {
        this.sqlgGraph.getTopology().cacheTopology();
    }

    private void validateTopology() {
        this.sqlgGraph.getTopology().validateTopology();
        if (!this.sqlgGraph.getTopology().getValidationErrors().isEmpty()) {
            for (Topology.TopologyValidationError topologyValidationError : this.sqlgGraph.getTopology().getValidationErrors()) {
                this.logger.warn(topologyValidationError.toString());
            }
        }
    }

    private void upgradePropertyIndexTypeToExist() {
        Connection conn = this.sqlgGraph.tx().getConnection();
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            String catalog = null;
            String schemaPattern = "sqlg_schema";
            ResultSet propertyRs = metadata.getColumns(catalog, schemaPattern, "V_property", "index_type");
            if (!propertyRs.next()) {
                Statement statement = conn.createStatement();
                String sql = this.sqlDialect.sqlgAddPropertyIndexTypeColumn();
                statement.execute(sql);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadSqlgSchemaFromInformationSchema() {
        conn = this.sqlgGraph.tx().getConnection();
        try {
            metadata = conn.getMetaData();
            catalog = null;
            schemaPattern = null;
            types = new String[]{"TABLE"};
            schemaRs = metadata.getSchemas();
            var7_8 = null;
            try {
                while (schemaRs.next()) {
                    schema = schemaRs.getString(1);
                    if (schema.equals("sqlg_schema") || this.sqlDialect.getDefaultSchemas().contains(schema) || this.sqlDialect.getGisSchemas().contains(schema)) continue;
                    TopologyManager.addSchema(this.sqlgGraph, schema);
                }
            }
            catch (Throwable var8_11) {
                var7_8 = var8_11;
                throw var8_11;
            }
            finally {
                if (schemaRs != null) {
                    if (var7_8 != null) {
                        try {
                            schemaRs.close();
                        }
                        catch (Throwable var8_10) {
                            var7_8.addSuppressed(var8_10);
                        }
                    } else {
                        schemaRs.close();
                    }
                }
            }
            indices = this.sqlDialect.extractIndices(conn, catalog, schemaPattern);
            vertexRs = metadata.getTables(catalog, schemaPattern, "V_%", types);
            var8_9 = null;
lbl35:
            // 2 sources

            try {
                while (vertexRs.next()) {
                    block76: {
                        tblCat = vertexRs.getString(1);
                        schema = vertexRs.getString(2);
                        table = vertexRs.getString(3);
                        schemasToIgnore = new HashSet<String>(this.sqlDialect.getDefaultSchemas());
                        schemasToIgnore.remove(this.sqlDialect.getPublicSchema());
                        if (schema.equals("sqlg_schema") || schemasToIgnore.contains(schema) || this.sqlDialect.getGisSchemas().contains(schema) || this.sqlDialect.getSpacialRefTable().contains(table)) continue;
                        columns = new ConcurrentHashMap<K, V>();
                        columnsRs = metadata.getColumns(tblCat, schema, table, null);
                        metaDatas = new ArrayList<Triple>();
                        while (columnsRs.next()) {
                            columnName = columnsRs.getString(4);
                            columnType = columnsRs.getInt(5);
                            typeName = columnsRs.getString("TYPE_NAME");
                            metaDatas.add(Triple.of((Object)columnName, (Object)columnType, (Object)typeName));
                        }
                        columnsRs.close();
                        metaDataIter = metaDatas.listIterator();
                        while (metaDataIter.hasNext()) {
                            tripple = (Triple)metaDataIter.next();
                            columnName = (String)tripple.getLeft();
                            columnType = (Integer)tripple.getMiddle();
                            typeName = (String)tripple.getRight();
                            if (columnName.equals("ID")) continue;
                            this.extractProperty(schema, table, columnName, columnType, typeName, columns, metaDataIter);
                        }
                        label = table.substring("V_".length());
                        TopologyManager.addVertexLabel(this.sqlgGraph, schema, label, columns);
                        if (indices == null) break block76;
                        key = tblCat + "." + schema + "." + table;
                        idxs = indices.get(key);
                        if (idxs == null) continue;
                        for (IndexRef ir : idxs) {
                            TopologyManager.addIndex(this.sqlgGraph, schema, label, true, ir.getIndexName(), ir.getIndexType(), ir.getColumns());
                        }
                        ** GOTO lbl35
                    }
                    this.extractIndices(metadata, tblCat, schema, table, label, true);
                }
            }
            catch (Throwable tblCat) {
                var8_9 = tblCat;
                throw tblCat;
            }
            finally {
                if (vertexRs != null) {
                    if (var8_9 != null) {
                        try {
                            vertexRs.close();
                        }
                        catch (Throwable tblCat) {
                            var8_9.addSuppressed(tblCat);
                        }
                    } else {
                        vertexRs.close();
                    }
                }
            }
            edgeRs = metadata.getTables(catalog, schemaPattern, "E_%", types);
            var8_9 = null;
            try {
                while (edgeRs.next()) {
                    edgCat = edgeRs.getString(1);
                    schema = edgeRs.getString(2);
                    table = edgeRs.getString(3);
                    schemasToIgnore = new HashSet<String>(this.sqlDialect.getDefaultSchemas());
                    schemasToIgnore.remove(this.sqlDialect.getPublicSchema());
                    if (schema.equals("sqlg_schema") || schemasToIgnore.contains(schema) || this.sqlDialect.getGisSchemas().contains(schema) || this.sqlDialect.getSpacialRefTable().contains(table)) continue;
                    inOutSchemaTableMap = new HashMap<SchemaTable, MutablePair>();
                    columns = Collections.emptyMap();
                    columnsRs = metadata.getColumns(edgCat, schema, table, null);
                    edgeSchemaTable = SchemaTable.of(schema, table);
                    edgeAdded = false;
                    while (columnsRs.next()) {
                        column = columnsRs.getString(4);
                        if (!table.startsWith("E_") || !column.endsWith("__I") && !column.endsWith("__O")) continue;
                        split = column.split("\\.");
                        foreignKey = SchemaTable.of(split[0], split[1]);
                        if (column.endsWith("__I")) {
                            schemaTable = SchemaTable.of(split[0], split[1].substring(0, split[1].length() - "__I".length()));
                            if (inOutSchemaTableMap.containsKey(edgeSchemaTable)) {
                                inSchemaTable = (MutablePair)inOutSchemaTableMap.get(edgeSchemaTable);
                                if (inSchemaTable.getLeft() == null) {
                                    inSchemaTable.setLeft((Object)schemaTable);
                                } else {
                                    TopologyManager.addLabelToEdge(this.sqlgGraph, schema, table, true, foreignKey);
                                }
                            } else {
                                inOutSchemaTableMap.put(edgeSchemaTable, MutablePair.of((Object)schemaTable, null));
                            }
                        } else if (column.endsWith("__O")) {
                            schemaTable = SchemaTable.of(split[0], split[1].substring(0, split[1].length() - "__O".length()));
                            if (inOutSchemaTableMap.containsKey(edgeSchemaTable)) {
                                outSchemaTable = (MutablePair)inOutSchemaTableMap.get(edgeSchemaTable);
                                if (outSchemaTable.getRight() == null) {
                                    outSchemaTable.setRight((Object)schemaTable);
                                } else {
                                    TopologyManager.addLabelToEdge(this.sqlgGraph, schema, table, false, foreignKey);
                                }
                            } else {
                                inOutSchemaTableMap.put(edgeSchemaTable, MutablePair.of(null, (Object)schemaTable));
                            }
                        }
                        inOutLabels = (MutablePair)inOutSchemaTableMap.get(edgeSchemaTable);
                        if (edgeAdded || inOutLabels.getLeft() == null || inOutLabels.getRight() == null) continue;
                        TopologyManager.addEdgeLabel(this.sqlgGraph, schema, table, (SchemaTable)inOutLabels.getRight(), (SchemaTable)inOutLabels.getLeft(), columns);
                        edgeAdded = true;
                    }
                }
            }
            catch (Throwable edgCat) {
                var8_9 = edgCat;
                throw edgCat;
            }
            finally {
                if (edgeRs != null) {
                    if (var8_9 != null) {
                        try {
                            edgeRs.close();
                        }
                        catch (Throwable edgCat) {
                            var8_9.addSuppressed(edgCat);
                        }
                    } else {
                        edgeRs.close();
                    }
                }
            }
            edgeRs = metadata.getTables(catalog, schemaPattern, "E_%", types);
            var8_9 = null;
lbl161:
            // 2 sources

            try {
                while (edgeRs.next()) {
                    block77: {
                        edgCat = edgeRs.getString(1);
                        schema = edgeRs.getString(2);
                        table = edgeRs.getString(3);
                        schemasToIgnore = new HashSet<String>(this.sqlDialect.getDefaultSchemas());
                        schemasToIgnore.remove(this.sqlDialect.getPublicSchema());
                        if (schema.equals("sqlg_schema") || schemasToIgnore.contains(schema) || this.sqlDialect.getGisSchemas().contains(schema) || this.sqlDialect.getSpacialRefTable().contains(table)) continue;
                        columns = new HashMap<K, V>();
                        columnsRs = metadata.getColumns(edgCat, schema, table, null);
                        metaDatas = new ArrayList<E>();
                        while (columnsRs.next()) {
                            columnName = columnsRs.getString(4);
                            columnType = columnsRs.getInt(5);
                            typeName = columnsRs.getString("TYPE_NAME");
                            metaDatas.add(Triple.of((Object)columnName, (Object)columnType, (Object)typeName));
                        }
                        columnsRs.close();
                        metaDataIter = metaDatas.listIterator();
                        while (metaDataIter.hasNext()) {
                            tripple = metaDataIter.next();
                            columnName = (String)tripple.getLeft();
                            typeName = (String)tripple.getRight();
                            columnType = (Integer)tripple.getMiddle();
                            if (columnName.equals("ID")) continue;
                            this.extractProperty(schema, table, columnName, columnType, typeName, columns, metaDataIter);
                        }
                        TopologyManager.addEdgeColumn(this.sqlgGraph, schema, table, columns);
                        label = table.substring("E_".length());
                        if (indices == null) break block77;
                        key = edgCat + "." + schema + "." + table;
                        idxs = indices.get(key);
                        if (idxs == null) continue;
                        for (IndexRef ir : idxs) {
                            TopologyManager.addIndex(this.sqlgGraph, schema, label, false, ir.getIndexName(), ir.getIndexType(), ir.getColumns());
                        }
                        ** GOTO lbl161
                    }
                    this.extractIndices(metadata, edgCat, schema, table, label, false);
                }
            }
            catch (Throwable var9_19) {
                var8_9 = var9_19;
                throw var9_19;
            }
            finally {
                if (edgeRs != null) {
                    if (var8_9 != null) {
                        try {
                            edgeRs.close();
                        }
                        catch (Throwable var9_18) {
                            var8_9.addSuppressed(var9_18);
                        }
                    } else {
                        edgeRs.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractIndices(DatabaseMetaData metadata, String catalog, String schema, String table, String label, boolean isVertex) throws SQLException {
        try (ResultSet indexRs = metadata.getIndexInfo(catalog, schema, table, false, true);){
            String lastIndexName = null;
            IndexType lastIndexType = null;
            LinkedList<String> lastColumns = new LinkedList<String>();
            while (indexRs.next()) {
                String indexName = indexRs.getString("INDEX_NAME");
                System.out.println(indexName);
                boolean nonUnique = indexRs.getBoolean("NON_UNIQUE");
                if (lastIndexName == null) {
                    lastIndexName = indexName;
                    lastIndexType = nonUnique ? IndexType.NON_UNIQUE : IndexType.UNIQUE;
                } else if (!lastIndexName.equals(indexName)) {
                    if (!this.sqlDialect.isSystemIndex(lastIndexName) && !"gui_schema".equals(schema)) {
                        TopologyManager.addIndex(this.sqlgGraph, schema, label, isVertex, lastIndexName, lastIndexType, lastColumns);
                    }
                    lastColumns.clear();
                    lastIndexName = indexName;
                    lastIndexType = nonUnique ? IndexType.NON_UNIQUE : IndexType.UNIQUE;
                }
                lastColumns.add(indexRs.getString("COLUMN_NAME"));
            }
            if (!this.sqlDialect.isSystemIndex(lastIndexName) && !"gui_schema".equals(schema)) {
                TopologyManager.addIndex(this.sqlgGraph, schema, label, isVertex, lastIndexName, lastIndexType, lastColumns);
            }
        }
    }

    private void extractProperty(String schema, String table, String columnName, Integer columnType, String typeName, Map<String, PropertyType> columns, ListIterator<Triple<String, Integer, String>> metaDataIter) throws SQLException {
        PropertyType propertyType = null;
        if (metaDataIter.hasNext()) {
            Triple<String, Integer, String> column2MetaData = metaDataIter.next();
            String column2Name = (String)column2MetaData.getLeft();
            String typeName2 = (String)column2MetaData.getRight();
            int column2Type = (Integer)column2MetaData.getMiddle();
            if (column2Name.startsWith(columnName + "~~~")) {
                if (column2Type == 12) {
                    propertyType = PropertyType.ZONEDDATETIME;
                } else if (column2Type == 2003 && this.sqlDialect.sqlArrayTypeNameToPropertyType(typeName2, this.sqlgGraph, schema, table, column2Name, metaDataIter) == PropertyType.STRING_ARRAY) {
                    propertyType = PropertyType.ZONEDDATETIME_ARRAY;
                } else if (metaDataIter.hasNext()) {
                    Triple<String, Integer, String> column3MetaData = metaDataIter.next();
                    String column3Name = (String)column3MetaData.getLeft();
                    String typeName3 = (String)column3MetaData.getRight();
                    int column3Type = (Integer)column3MetaData.getMiddle();
                    if (column3Name.startsWith(columnName + "~~~")) {
                        if (column3Type == 2003) {
                            Preconditions.checkState((this.sqlDialect.sqlArrayTypeNameToPropertyType(typeName3, this.sqlgGraph, schema, table, column3Name, metaDataIter) == PropertyType.INTEGER_ARRAY ? 1 : 0) != 0, (Object)"Only Period have a third column and it must be a Integer");
                            propertyType = PropertyType.PERIOD_ARRAY;
                        } else {
                            Preconditions.checkState((column3Type == 4 ? 1 : 0) != 0, (Object)"Only Period have a third column and it must be a Integer");
                            propertyType = PropertyType.PERIOD;
                        }
                    } else {
                        metaDataIter.previous();
                        if (column2Type == 2003) {
                            Preconditions.checkState((this.sqlDialect.sqlArrayTypeNameToPropertyType(typeName2, this.sqlgGraph, schema, table, column2Name, metaDataIter) == PropertyType.INTEGER_ARRAY ? 1 : 0) != 0, (Object)"Only Period have a third column and it must be a Integer");
                            propertyType = PropertyType.DURATION_ARRAY;
                        } else {
                            Preconditions.checkState((column2Type == 4 ? 1 : 0) != 0, (Object)"Only Duration and Period have a second column and it must be a Integer");
                            propertyType = PropertyType.DURATION;
                        }
                    }
                }
            } else {
                metaDataIter.previous();
            }
        }
        if (propertyType == null) {
            propertyType = this.sqlDialect.sqlTypeToPropertyType(this.sqlgGraph, schema, table, columnName, columnType, typeName, metaDataIter);
        }
        columns.put(columnName, propertyType);
    }

    private void addPublicSchema() {
        this.sqlgGraph.addVertex(T.label, "sqlg_schema.schema", "name", this.sqlDialect.getPublicSchema(), "createdOn", LocalDateTime.now());
    }

    private void createGuiSchema() {
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement statement = conn.createStatement();){
            statement.execute("CREATE SCHEMA " + this.sqlDialect.maybeWrapInQoutes("gui_schema") + ";");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createSqlgSchemaTablesAndIndexes() {
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement statement = conn.createStatement();){
            List<String> creationScripts = this.sqlDialect.sqlgTopologyCreationScripts();
            for (String creationScript : creationScripts) {
                statement.execute(creationScript);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean existSqlgSchema() {
        Connection conn = this.sqlgGraph.tx().getConnection();
        try {
            if (this.sqlDialect.supportSchemas()) {
                DatabaseMetaData metadata = conn.getMetaData();
                return this.sqlDialect.schemaExists(metadata, null, "sqlg_schema");
            }
            throw new IllegalStateException("schemas not supported not supported, i.e. probably MariaDB not supported.");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean existGuiSchema() {
        Connection conn = this.sqlgGraph.tx().getConnection();
        try {
            if (this.sqlDialect.supportSchemas()) {
                DatabaseMetaData metadata = conn.getMetaData();
                return this.sqlDialect.schemaExists(metadata, null, "gui_schema");
            }
            throw new IllegalStateException("schemas not supported not supported, i.e. probably MariaDB not supported.");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createSqlgSchema() {
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement statement = conn.createStatement();){
            String creationScript = this.sqlDialect.sqlgSqlgSchemaCreationScript();
            statement.execute(creationScript);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

