/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadLocalTransaction;
import org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.dialect.SqlBulkDialect;
import org.umlg.sqlg.structure.AfterCommit;
import org.umlg.sqlg.structure.AfterRollback;
import org.umlg.sqlg.structure.BatchManager;
import org.umlg.sqlg.structure.BeforeCommit;
import org.umlg.sqlg.structure.ElementPropertyRollback;
import org.umlg.sqlg.structure.PreparedStatementCache;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.TransactionCache;

public class SqlgTransaction
extends AbstractThreadLocalTransaction {
    public static final String BATCH_MODE_NOT_SUPPORTED = "Batch mode not supported!";
    public static final String QUERY_LAZY = "query.lazy";
    private SqlgGraph sqlgGraph;
    private BeforeCommit beforeCommitFunction;
    private AfterCommit afterCommitFunction;
    private AfterRollback afterRollbackFunction;
    private Logger logger = LoggerFactory.getLogger((String)SqlgTransaction.class.getName());
    private boolean cacheVertices = false;
    private final ThreadLocal<TransactionCache> threadLocalTx = new ThreadLocal<TransactionCache>(){

        @Override
        protected TransactionCache initialValue() {
            return null;
        }
    };
    private final ThreadLocal<PreparedStatementCache> threadLocalPreparedStatementTx = new ThreadLocal<PreparedStatementCache>(){

        @Override
        protected PreparedStatementCache initialValue() {
            return new PreparedStatementCache();
        }
    };

    SqlgTransaction(Graph sqlgGraph, boolean cacheVertices) {
        super(sqlgGraph);
        this.sqlgGraph = (SqlgGraph)sqlgGraph;
        this.cacheVertices = cacheVertices;
    }

    protected void doOpen() {
        if (this.isOpen()) {
            throw Transaction.Exceptions.transactionAlreadyOpen();
        }
        try {
            Connection connection = this.sqlgGraph.getConnection();
            connection.setAutoCommit(false);
            if (this.sqlgGraph.getSqlDialect().supportsClientInfo()) {
                connection.setClientInfo("ApplicationName", Thread.currentThread().getName());
            }
            boolean lazy = this.sqlgGraph.getConfiguration().getBoolean(QUERY_LAZY, true);
            this.threadLocalTx.set(TransactionCache.of(this.cacheVertices, connection, new BatchManager(this.sqlgGraph, (SqlBulkDialect)this.sqlgGraph.getSqlDialect()), lazy));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doCommit() throws AbstractTransaction.TransactionException {
        if (!this.isOpen()) {
            return;
        }
        try {
            if (this.threadLocalTx.get().getBatchManager().isInBatchMode()) {
                this.getBatchManager().flush();
            }
            Connection connection = this.threadLocalTx.get().getConnection();
            if (this.beforeCommitFunction != null) {
                this.beforeCommitFunction.doBeforeCommit();
            }
            connection.commit();
            connection.setAutoCommit(true);
            if (this.afterCommitFunction != null) {
                this.afterCommitFunction.doAfterCommit();
            }
            this.threadLocalPreparedStatementTx.get().close();
            connection.close();
        }
        catch (Exception e) {
            this.rollback();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (this.threadLocalTx.get() != null) {
                this.threadLocalTx.get().clear();
                this.threadLocalTx.remove();
            }
            this.threadLocalPreparedStatementTx.remove();
        }
    }

    protected void doRollback() throws AbstractTransaction.TransactionException {
        if (!this.isOpen()) {
            return;
        }
        try {
            if (this.threadLocalTx.get().getBatchManager().isInBatchMode()) {
                try {
                    this.threadLocalTx.get().getBatchManager().close();
                }
                catch (Exception e) {
                    this.logger.debug("exception closing streams on rollback", (Throwable)e);
                }
            }
            Connection connection = this.threadLocalTx.get().getConnection();
            connection.setAutoCommit(false);
            connection.rollback();
            if (this.afterRollbackFunction != null) {
                this.afterRollbackFunction.doAfterRollback();
            }
            for (ElementPropertyRollback elementPropertyRollback : this.threadLocalTx.get().getElementPropertyRollback().keySet()) {
                elementPropertyRollback.clearProperties();
            }
            this.threadLocalPreparedStatementTx.get().close();
            connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.isOpen()) {
                this.threadLocalTx.get().clear();
                this.threadLocalTx.remove();
                this.threadLocalPreparedStatementTx.remove();
            }
        }
    }

    public void streamingWithLockBatchModeOn() {
        if (!this.sqlgGraph.features().supportsBatchMode()) {
            throw new IllegalStateException(BATCH_MODE_NOT_SUPPORTED);
        }
        this.readWrite();
        this.threadLocalTx.get().getBatchManager().batchModeOn(BatchManager.BatchModeType.STREAMING_WITH_LOCK);
    }

    public void streamingBatchModeOn() {
        if (!this.sqlgGraph.features().supportsBatchMode()) {
            throw new IllegalStateException(BATCH_MODE_NOT_SUPPORTED);
        }
        this.readWrite();
        this.threadLocalTx.get().getBatchManager().batchModeOn(BatchManager.BatchModeType.STREAMING);
    }

    public void batchMode(BatchManager.BatchModeType batchModeType) {
        switch (batchModeType) {
            case NONE: {
                this.readWrite();
                this.threadLocalTx.get().getBatchManager().batchModeOn(BatchManager.BatchModeType.NONE);
                break;
            }
            case NORMAL: {
                this.normalBatchModeOn();
                break;
            }
            case STREAMING: {
                this.streamingBatchModeOn();
                break;
            }
            case STREAMING_WITH_LOCK: {
                this.streamingWithLockBatchModeOn();
                break;
            }
            default: {
                throw new IllegalStateException("unhandled BatchModeType " + batchModeType.name());
            }
        }
    }

    public void normalBatchModeOn() {
        if (!this.sqlgGraph.features().supportsBatchMode()) {
            throw new IllegalStateException(BATCH_MODE_NOT_SUPPORTED);
        }
        this.readWrite();
        this.threadLocalTx.get().getBatchManager().batchModeOn(BatchManager.BatchModeType.NORMAL);
    }

    public boolean isInBatchMode() {
        return this.isInNormalBatchMode() || this.isInStreamingBatchMode() || this.isInStreamingWithLockBatchMode();
    }

    public boolean isInNormalBatchMode() {
        return this.isOpen() && this.threadLocalTx.get().getBatchManager().isInNormalMode();
    }

    public boolean isInStreamingBatchMode() {
        return this.isOpen() && this.threadLocalTx.get().getBatchManager().isInStreamingMode();
    }

    public boolean isInStreamingWithLockBatchMode() {
        return this.isOpen() && this.threadLocalTx.get().getBatchManager().isInStreamingModeWithLock();
    }

    public BatchManager.BatchModeType getBatchModeType() {
        assert (this.isOpen()) : "SqlgTransaction.getBatchModeType() must be called within a transaction.";
        return this.threadLocalTx.get().getBatchManager().getBatchModeType();
    }

    public BatchManager getBatchManager() {
        return this.threadLocalTx.get().getBatchManager();
    }

    public Connection getConnection() {
        if (!this.isOpen()) {
            this.readWrite();
        }
        return this.threadLocalTx.get().getConnection();
    }

    public void flush() {
        if (!this.isInBatchMode()) {
            throw new IllegalStateException("Transaction must be in batch mode to flush");
        }
        this.logger.debug("flushing transaction!!!");
        if (!this.getBatchManager().isBusyFlushing()) {
            this.getBatchManager().flush();
        }
    }

    void addElementPropertyRollback(ElementPropertyRollback elementPropertyRollback) {
        if (!this.isOpen()) {
            throw new IllegalStateException("A transaction must be in progress to add a elementPropertyRollback function!");
        }
        this.threadLocalTx.get().getElementPropertyRollback().put(elementPropertyRollback, null);
    }

    void beforeCommit(BeforeCommit beforeCommitFunction) {
        this.beforeCommitFunction = beforeCommitFunction;
    }

    void afterCommit(AfterCommit afterCommitFunction) {
        this.afterCommitFunction = afterCommitFunction;
    }

    void afterRollback(AfterRollback afterCommitFunction) {
        this.afterRollbackFunction = afterCommitFunction;
    }

    public boolean isOpen() {
        return this.threadLocalTx.get() != null;
    }

    SqlgVertex putVertexIfAbsent(SqlgGraph sqlgGraph, String schema, String table, Long id) {
        return this.threadLocalTx.get().putVertexIfAbsent(sqlgGraph, schema, table, id);
    }

    SqlgVertex putVertexIfAbsent(SqlgVertex sqlgVertex) {
        return this.threadLocalTx.get().putVertexIfAbsent(sqlgVertex);
    }

    void add(SqlgVertex sqlgVertex) {
        this.threadLocalTx.get().add(sqlgVertex);
    }

    public void add(PreparedStatement preparedStatement) {
        this.threadLocalPreparedStatementTx.get().add(preparedStatement);
    }

    public PreparedStatementCache getPreparedStatementCache() {
        return this.threadLocalPreparedStatementTx.get();
    }

    public boolean isLazyQueries() {
        return this.threadLocalTx.get().isLazyQueries();
    }

    public void setLazyQueries(boolean lazy) {
        this.readWrite();
        this.threadLocalTx.get().setLazyQueries(lazy);
    }
}

