/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.structure.BatchManager;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgProperty;
import org.umlg.sqlg.structure.SqlgVertexProperty;
import org.umlg.sqlg.structure.VertexLabel;
import org.umlg.sqlg.util.SqlgUtil;

public class SqlgVertex
extends SqlgElement
implements Vertex {
    public static final String WHERE = " WHERE ";
    private Logger logger = LoggerFactory.getLogger((String)SqlgVertex.class.getName());

    public SqlgVertex(SqlgGraph sqlgGraph, boolean complete, String schema, String table, Pair<Map<String, Object>, Map<String, Object>> keyValueMapPair) {
        super(sqlgGraph, schema, table);
        this.insertVertex(complete, keyValueMapPair);
        if (!sqlgGraph.tx().isInBatchMode()) {
            sqlgGraph.tx().add(this);
        }
    }

    @Override
    public String label() {
        if (this.schema != null && this.schema.length() > 0 && !this.schema.equals(this.sqlgGraph.getSqlDialect().getPublicSchema())) {
            return this.schema + "." + this.table;
        }
        return super.label();
    }

    SqlgVertex(SqlgGraph sqlgGraph, String table, Map<String, Object> keyValueMap) {
        super(sqlgGraph, "", table);
        this.sqlgGraph.tx().getBatchManager().addTemporaryVertex(this, keyValueMap);
    }

    public static SqlgVertex of(SqlgGraph sqlgGraph, Long id, String schema, String table) {
        if (!sqlgGraph.tx().isInBatchMode()) {
            return sqlgGraph.tx().putVertexIfAbsent(sqlgGraph, schema, table, id);
        }
        return new SqlgVertex(sqlgGraph, id, schema, table);
    }

    SqlgVertex(SqlgGraph sqlgGraph, Long id, String schema, String table) {
        super(sqlgGraph, id, schema, table);
    }

    public Edge addEdgeWithMap(String label, Vertex inVertex, Map<String, Object> keyValues) {
        Object[] parameters = SqlgUtil.mapToStringKeyValues(keyValues);
        return this.addEdge(label, inVertex, parameters);
    }

    public void streamEdge(String label, Vertex inVertex) {
        this.streamEdge(label, inVertex, new LinkedHashMap<String, Object>());
    }

    public void streamEdge(String label, Vertex inVertex, LinkedHashMap<String, Object> keyValues) {
        if (!this.sqlgGraph.tx().isInStreamingBatchMode()) {
            throw SqlgExceptions.invalidMode("Transaction must be in " + (Object)((Object)BatchManager.BatchModeType.STREAMING) + " mode for streamEdge");
        }
        if (this.sqlgGraph.tx().isOpen() && this.sqlgGraph.tx().getBatchManager().getStreamingBatchModeVertexSchemaTable() != null) {
            throw new IllegalStateException("Streaming vertex for label " + this.sqlgGraph.tx().getBatchManager().getStreamingBatchModeVertexSchemaTable().getTable() + " is in progress. Commit the transaction or call SqlgGraph.flush()");
        }
        SchemaTable streamingBatchModeEdgeLabel = this.sqlgGraph.tx().getBatchManager().getStreamingBatchModeEdgeSchemaTable();
        if (streamingBatchModeEdgeLabel != null && !streamingBatchModeEdgeLabel.getTable().substring("E_".length()).equals(label)) {
            throw new IllegalStateException("Streaming batch mode must occur for one label at a time. Expected \"" + streamingBatchModeEdgeLabel + "\" found \"" + label + "\". First commit the transaction or call SqlgGraph.flush() before streaming a different label");
        }
        LinkedHashMap<Object, Object> tmp = new LinkedHashMap<Object, Object>(keyValues);
        Object[] keyValues1 = SqlgUtil.mapTokeyValues(tmp);
        this.addEdgeInternal(true, label, inVertex, keyValues1);
    }

    public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
        SchemaTable streamingBatchModeEdgeLabel;
        boolean streaming;
        this.sqlgGraph.tx().readWrite();
        boolean bl = streaming = this.sqlgGraph.tx().isInStreamingBatchMode() || this.sqlgGraph.tx().isInStreamingWithLockBatchMode();
        if (streaming && (streamingBatchModeEdgeLabel = this.sqlgGraph.tx().getBatchManager().getStreamingBatchModeEdgeSchemaTable()) != null && !streamingBatchModeEdgeLabel.getTable().substring("E_".length()).equals(label)) {
            throw new IllegalStateException("Streaming batch mode must occur for one label at a time. Expected \"" + streamingBatchModeEdgeLabel + "\" found \"" + label + "\". First commit the transaction or call SqlgGraph.flush() before streaming a different label");
        }
        return this.addEdgeInternal(streaming, label, inVertex, keyValues);
    }

    private Edge addEdgeInternal(boolean complete, String label, Vertex inVertex, Object ... keyValues) {
        if (null == inVertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"vertex");
        }
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id());
        }
        ElementHelper.validateLabel((String)label);
        if (label.contains(".")) {
            throw new IllegalStateException(String.format("Edge label may not contain a '.' , the edge will be stored in the schema of the owning vertex. label = %s", label));
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Edge.Exceptions.userSuppliedIdsNotSupported();
        }
        List<String> previousBatchModeKeys = complete ? this.sqlgGraph.tx().getBatchManager().getStreamingBatchModeEdgeKeys() : Collections.emptyList();
        Triple<Map<String, PropertyType>, Map<String, Object>, Map<String, Object>> keyValueMapTriple = SqlgUtil.validateVertexKeysValues(this.sqlgGraph.getSqlDialect(), keyValues, previousBatchModeKeys);
        if (!complete && ((Map)keyValueMapTriple.getRight()).size() != ((Map)keyValueMapTriple.getMiddle()).size()) {
            throw Property.Exceptions.propertyValueCanNotBeNull();
        }
        Pair keyValueMapPair = Pair.of((Object)keyValueMapTriple.getMiddle(), (Object)keyValueMapTriple.getRight());
        Map columns = (Map)keyValueMapTriple.getLeft();
        Optional<VertexLabel> outVertexLabelOptional = this.sqlgGraph.getTopology().getVertexLabel(this.schema, this.table);
        Optional<VertexLabel> inVertexLabelOptional = this.sqlgGraph.getTopology().getVertexLabel(((SqlgVertex)inVertex).schema, ((SqlgVertex)inVertex).table);
        Preconditions.checkState((boolean)outVertexLabelOptional.isPresent(), (String)"Out VertexLabel must be present. Not found for %s", (Object[])new Object[]{this.schema + "." + this.table});
        Preconditions.checkState((boolean)inVertexLabelOptional.isPresent(), (String)"In VertexLabel must be present. Not found for %s", (Object[])new Object[]{((SqlgVertex)inVertex).schema + "." + ((SqlgVertex)inVertex).table});
        this.sqlgGraph.getTopology().ensureEdgeLabelExist(label, outVertexLabelOptional.get(), inVertexLabelOptional.get(), (Map<String, PropertyType>)columns);
        return new SqlgEdge(this.sqlgGraph, complete, this.schema, label, (SqlgVertex)inVertex, this, (Pair<Map<String, Object>, Map<String, Object>>)keyValueMapPair);
    }

    protected <V> Map<String, VertexProperty<V>> internalGetProperties(String ... propertyKeys) {
        this.sqlgGraph.tx().readWrite();
        Map metaPropertiesMap = super.internalGetProperties(propertyKeys);
        return metaPropertiesMap;
    }

    public <V> VertexProperty<V> property(String key) {
        SqlgVertex sqlgVertex;
        this.sqlgGraph.tx().readWrite();
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(this.getClass(), (Object)this.id());
        }
        if (!this.sqlgGraph.tx().isInBatchMode() && (sqlgVertex = this.sqlgGraph.tx().putVertexIfAbsent(this)) != this) {
            this.properties = sqlgVertex.properties;
        }
        return (VertexProperty)super.property(key);
    }

    public <V> VertexProperty<V> property(String key, V value) {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id());
        }
        ElementHelper.validateProperty((String)key, value);
        this.sqlgGraph.tx().readWrite();
        return (VertexProperty)super.property(key, value);
    }

    public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
        throw VertexProperty.Exceptions.metaPropertiesNotSupported();
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        if (keyValues.length > 0) {
            throw VertexProperty.Exceptions.metaPropertiesNotSupported();
        }
        return this.property(key, value);
    }

    @Override
    protected <V> SqlgProperty<V> instantiateProperty(String key, V value) {
        return new SqlgVertexProperty<V>(this.sqlgGraph, this, key, value);
    }

    @Override
    protected Property emptyProperty() {
        return VertexProperty.empty();
    }

    private Iterator<Edge> internalEdges(Direction direction, String ... labels) {
        this.sqlgGraph.tx().readWrite();
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode() && this.sqlgGraph.tx().getBatchManager().vertexIsCached(this)) {
            this.sqlgGraph.tx().flush();
        }
        GraphTraversalSource gts = "sqlg_schema".equals(this.schema) ? this.sqlgGraph.topology() : this.sqlgGraph.traversal();
        switch (direction) {
            case OUT: {
                return gts.V(new Object[]{this}).outE(labels);
            }
            case IN: {
                return gts.V(new Object[]{this}).inE(labels);
            }
            case BOTH: {
                return gts.V(new Object[]{this}).bothE(labels);
            }
        }
        return Collections.emptyIterator();
    }

    @Override
    public void remove() {
        this.sqlgGraph.tx().readWrite();
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(this.getClass(), (Object)this.id());
        }
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode()) {
            this.sqlgGraph.tx().getBatchManager().removeVertex(this.schema, this.table, this);
        } else {
            Pair<Set<SchemaTable>, Set<SchemaTable>> foreignKeys = this.sqlgGraph.getTopology().getTableLabels(this.getSchemaTablePrefixed());
            for (SchemaTable schemaTable : (Set)foreignKeys.getLeft()) {
                this.deleteEdgesWithInKey(schemaTable, this.id());
            }
            for (SchemaTable schemaTable : (Set)foreignKeys.getRight()) {
                this.deleteEdgesWithOutKey(schemaTable, this.id());
            }
            super.remove();
        }
    }

    private void deleteEdgesWithOutKey(SchemaTable edgeSchemaTable, Object id) {
        this.deleteEdges(Direction.OUT, edgeSchemaTable);
    }

    private void deleteEdgesWithInKey(SchemaTable edgeSchemaTable, Object id) {
        this.deleteEdges(Direction.IN, edgeSchemaTable);
    }

    private void deleteEdges(Direction direction, SchemaTable edgeSchemaTable) {
        StringBuilder sql = new StringBuilder("DELETE FROM ");
        sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(edgeSchemaTable.getSchema()));
        sql.append(".");
        sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(edgeSchemaTable.getTable()));
        sql.append(WHERE);
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.schema + "." + this.table + (direction == Direction.OUT ? "__O" : "__I")));
        sql.append(" = ?");
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            preparedStatement.setLong(1, ((RecordId)this.id()).getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void insertVertex(boolean complete, Pair<Map<String, Object>, Map<String, Object>> keyValueMapPair) {
        Map keyAllValueMap = (Map)keyValueMapPair.getLeft();
        Map keyNotNullValueMap = (Map)keyValueMapPair.getRight();
        if (this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode()) {
            this.internalBatchAddVertex(complete, keyAllValueMap);
        } else {
            this.internalAddVertex(keyNotNullValueMap);
        }
        this.properties.putAll(keyNotNullValueMap);
    }

    private void internalBatchAddVertex(boolean complete, Map<String, Object> keyValueMap) {
        this.sqlgGraph.tx().getBatchManager().addVertex(complete, this, keyValueMap);
    }

    private void internalAddVertex(Map<String, Object> keyValueMap) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes(this.schema));
        sql.append(".");
        sql.append(this.sqlgGraph.getSchemaManager().getSqlDialect().maybeWrapInQoutes("V_" + this.table));
        HashMap<String, Pair<PropertyColumn, Object>> propertyColumnValueMap = new HashMap<String, Pair<PropertyColumn, Object>>();
        Map<String, PropertyColumn> propertyColumns = this.sqlgGraph.getTopology().getSchema(this.schema).orElseThrow(() -> new IllegalStateException(String.format("Schema %s not found", this.schema))).getVertexLabel(this.table).orElseThrow(() -> new IllegalStateException(String.format("VertexLabel %s not found", this.table))).getProperties();
        if (!keyValueMap.isEmpty()) {
            for (Map.Entry<String, Object> keyValueEntry : keyValueMap.entrySet()) {
                PropertyColumn propertyColumn = propertyColumns.get(keyValueEntry.getKey());
                Pair propertyColumnObjectPair = Pair.of((Object)propertyColumn, (Object)keyValueEntry.getValue());
                propertyColumnValueMap.put(keyValueEntry.getKey(), (Pair<PropertyColumn, Object>)propertyColumnObjectPair);
            }
            sql.append(" ( ");
            this.writeColumnNames(propertyColumnValueMap, sql);
            sql.append(") VALUES ( ");
            this.writeColumnParameters(propertyColumnValueMap, sql);
            sql.append(")");
        } else {
            sql.append(" DEFAULT VALUES");
        }
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        int i = 1;
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString(), 1);){
            SqlgUtil.setKeyValuesAsParameterUsingPropertyColumn(this.sqlgGraph, i, preparedStatement, propertyColumnValueMap);
            preparedStatement.executeUpdate();
            ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
            if (!generatedKeys.next()) {
                throw new RuntimeException(String.format("Could not retrieve the id after an insert into %s", "VERTICES"));
            }
            this.recordId = RecordId.from(SchemaTable.of(this.schema, this.table), generatedKeys.getLong(1));
            this.insertGlobalUniqueIndex(keyValueMap, propertyColumns);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void retainLabels(Set<SchemaTable> vertexLabels, String ... labels) {
        HashSet<SchemaTable> toRemove = new HashSet<SchemaTable>();
        for (SchemaTable schemaTable : vertexLabels) {
            boolean retain = false;
            for (String label : labels) {
                if (label.startsWith("E_")) {
                    throw new IllegalStateException("labels may not start with E_");
                }
                if (!schemaTable.getTable().equals("E_" + label)) continue;
                retain = true;
                break;
            }
            if (retain) continue;
            toRemove.add(schemaTable);
        }
        vertexLabels.removeAll(toRemove);
    }

    private List<HasContainer> filterHasContainerOnKey(List<HasContainer> hasContainers, String key) {
        ArrayList<HasContainer> toRemove = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : hasContainers) {
            if (!hasContainer.getKey().equals(key)) continue;
            toRemove.add(hasContainer);
        }
        hasContainers.removeAll(toRemove);
        return toRemove;
    }

    private Set<SchemaTable> transformToOutSchemaTables(Set<String> edgeForeignKeys, Set<String> labels) {
        HashSet<SchemaTable> result = new HashSet<SchemaTable>();
        for (String edgeForeignKey : edgeForeignKeys) {
            String[] schemaTableArray = edgeForeignKey.split("\\.");
            String schema = schemaTableArray[0];
            String table = schemaTableArray[1];
            if (!table.endsWith("__O")) continue;
            table = table.substring(0, table.length() - "__O".length());
            if (!labels.isEmpty() && !labels.contains(table)) continue;
            result.add(SchemaTable.of(schema, table));
        }
        return result;
    }

    private Set<SchemaTable> transformToInSchemaTables(Set<String> edgeForeignKeys, Set<String> labels) {
        HashSet<SchemaTable> result = new HashSet<SchemaTable>();
        for (String edgeForeignKey : edgeForeignKeys) {
            String[] schemaTableArray = edgeForeignKey.split("\\.");
            String schema = schemaTableArray[0];
            String table = schemaTableArray[1];
            if (!table.endsWith("__I")) continue;
            table = table.substring(0, table.length() - "__I".length());
            if (!labels.isEmpty() && !labels.contains(table)) continue;
            result.add(SchemaTable.of(schema, table));
        }
        return result;
    }

    @Override
    protected void load() {
        block21: {
            if (!this.sqlgGraph.tx().isInBatchMode() && this.properties.isEmpty() || this.properties.isEmpty() && this.sqlgGraph.features().supportsBatchMode() && this.sqlgGraph.tx().isInBatchMode() && !this.sqlgGraph.tx().getBatchManager().vertexIsCached(this)) {
                if (this.sqlgGraph.tx().getBatchManager().isStreaming()) {
                    throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
                }
                VertexLabel vertexLabel = this.sqlgGraph.getTopology().getSchema(this.schema).get().getVertexLabel(this.table).get();
                StringBuilder sql = new StringBuilder("SELECT\n\t");
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
                for (PropertyColumn propertyColumn : vertexLabel.properties.values()) {
                    sql.append(", ");
                    sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(propertyColumn.getName()));
                    String[] ps = propertyColumn.getPropertyType().getPostFixes();
                    if (ps == null) continue;
                    for (String p : propertyColumn.getPropertyType().getPostFixes()) {
                        sql.append(", ");
                        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(propertyColumn.getName() + p));
                    }
                }
                sql.append("\nFROM\n\t");
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.schema));
                sql.append(".");
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("V_" + this.table));
                sql.append("\nWHERE\n\t");
                sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
                sql.append(" = ?");
                if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
                    sql.append(";");
                }
                Connection conn = this.sqlgGraph.tx().getConnection();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(sql.toString());
                }
                try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
                    preparedStatement.setLong(1, this.recordId.getId());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        this.loadResultSet(resultSet);
                        break block21;
                    }
                    throw new IllegalStateException(String.format("Vertex with label %s and id %d does not exist.", this.schema + "." + this.table, this.recordId.getId()));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void loadResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i);
            if (columnName.equals("ID") || columnName.equals("VERTEX_SCHEMA") || columnName.equals("VERTEX_TABLE") || this.sqlgGraph.getSqlDialect().columnsToIgnore().contains(columnName)) continue;
            this.loadProperty(resultSet, columnName, i);
        }
    }

    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        this.sqlgGraph.tx().readWrite();
        if (this.sqlgGraph.tx().getBatchManager().isStreaming()) {
            throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
        }
        return this.internalEdges(direction, edgeLabels);
    }

    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        this.sqlgGraph.tx().readWrite();
        if (this.sqlgGraph.tx().getBatchManager().isStreaming()) {
            throw new IllegalStateException("streaming is in progress, first flush or commit before querying.");
        }
        GraphTraversalSource gts = "sqlg_schema".equals(this.schema) ? this.sqlgGraph.topology() : this.sqlgGraph.traversal();
        switch (direction) {
            case OUT: {
                return gts.V(new Object[]{this}).out(edgeLabels).toList().iterator();
            }
            case IN: {
                return gts.V(new Object[]{this}).in(edgeLabels).toList().iterator();
            }
            case BOTH: {
                return gts.V(new Object[]{this}).both(edgeLabels).toList().iterator();
            }
        }
        return Collections.emptyIterator();
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        this.sqlgGraph.tx().readWrite();
        return this.internalGetProperties(propertyKeys).values().iterator();
    }

    @Override
    SchemaTable getSchemaTablePrefixed() {
        return SchemaTable.of(this.getSchema(), "V_" + this.getTable());
    }

    SchemaTable getSchemaTable() {
        return SchemaTable.of(this.getSchema(), this.getTable());
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }
}

