/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.dialect.SqlSchemaChangeDialect;
import org.umlg.sqlg.structure.AbstractLabel;
import org.umlg.sqlg.structure.EdgeLabel;
import org.umlg.sqlg.structure.EdgeRole;
import org.umlg.sqlg.structure.GlobalUniqueIndex;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.Schema;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.TopologyChangeAction;
import org.umlg.sqlg.structure.TopologyInf;
import org.umlg.sqlg.structure.TopologyListener;
import org.umlg.sqlg.structure.TopologyManager;
import org.umlg.sqlg.structure.VertexLabel;

public class Topology {
    private Logger logger = LoggerFactory.getLogger((String)Topology.class.getName());
    private SqlgGraph sqlgGraph;
    private boolean distributed;
    private ReentrantReadWriteLock reentrantReadWriteLock;
    private Map<String, Map<String, PropertyType>> allTableCache = new HashMap<String, Map<String, PropertyType>>();
    private Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> schemaTableForeignKeyCache = new HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>>();
    private Map<String, Set<String>> edgeForeignKeyCache = new HashMap<String, Set<String>>();
    private Map<String, Schema> schemas = new HashMap<String, Schema>();
    private Map<String, Schema> uncommittedSchemas = new HashMap<String, Schema>();
    private Set<String> uncommittedRemovedSchemas = new HashSet<String>();
    private Map<String, Schema> metaSchemas = new HashMap<String, Schema>();
    private Set<TopologyInf> sqlgSchemaAbstractLabels = new HashSet<TopologyInf>();
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String SQLG_NOTIFICATION_CHANNEL = "SQLG_NOTIFY";
    private Map<String, Map<String, PropertyType>> temporaryTables = new ConcurrentHashMap<String, Map<String, PropertyType>>();
    private Set<Integer> ownPids = new HashSet<Integer>();
    private SortedSet<LocalDateTime> notificationTimestamps = new TreeSet<LocalDateTime>();
    private List<TopologyValidationError> validationErrors = new ArrayList<TopologyValidationError>();
    private List<TopologyListener> topologyListeners = new ArrayList<TopologyListener>();
    private static final int LOCK_TIMEOUT = 100;
    public static final String CREATED_ON = "createdOn";
    public static final String SCHEMA_VERTEX_DISPLAY = "schemaVertex";
    public static final String SQLG_SCHEMA = "sqlg_schema";
    public static final String SQLG_SCHEMA_SCHEMA = "schema";
    public static final String SQLG_SCHEMA_SCHEMA_NAME = "name";
    public static final String SQLG_SCHEMA_VERTEX_LABEL = "vertex";
    public static final String SQLG_SCHEMA_VERTEX_LABEL_NAME = "name";
    public static final String SQLG_SCHEMA_EDGE_LABEL = "edge";
    public static final String SQLG_SCHEMA_EDGE_LABEL_NAME = "name";
    public static final String SQLG_SCHEMA_PROPERTY = "property";
    public static final String SQLG_SCHEMA_SCHEMA_VERTEX_EDGE = "schema_vertex";
    public static final String SQLG_SCHEMA_IN_EDGES_EDGE = "in_edges";
    public static final String SQLG_SCHEMA_OUT_EDGES_EDGE = "out_edges";
    public static final String SQLG_SCHEMA_VERTEX_PROPERTIES_EDGE = "vertex_property";
    public static final String SQLG_SCHEMA_EDGE_PROPERTIES_EDGE = "edge_property";
    public static final String SQLG_SCHEMA_PROPERTY_NAME = "name";
    public static final String SQLG_SCHEMA_INDEX = "index";
    public static final String SQLG_SCHEMA_INDEX_NAME = "name";
    public static final String SQLG_SCHEMA_INDEX_INDEX_TYPE = "index_type";
    public static final String SQLG_SCHEMA_VERTEX_INDEX_EDGE = "vertex_index";
    public static final String SQLG_SCHEMA_EDGE_INDEX_EDGE = "edge_index";
    public static final String SQLG_SCHEMA_INDEX_PROPERTY_EDGE = "index_property";
    public static final String SQLG_SCHEMA_GLOBAL_UNIQUE_INDEX = "globalUniqueIndex";
    public static final String SQLG_SCHEMA_GLOBAL_UNIQUE_INDEX_PROPERTY_EDGE = "globalUniqueIndex_property";
    public static final String SQLG_SCHEMA_GLOBAL_UNIQUE_INDEX_NAME = "name";
    public static final String SQLG_SCHEMA_LOG = "log";
    public static final String SQLG_SCHEMA_LOG_TIMESTAMP = "timestamp";
    public static final String SQLG_SCHEMA_LOG_LOG = "log";
    public static final String SQLG_SCHEMA_LOG_PID = "pid";
    public static final String SQLG_SCHEMA_PROPERTY_TYPE = "type";
    public static final List<String> SQLG_SCHEMA_SCHEMA_TABLES = Arrays.asList("sqlg_schema.V_schema", "sqlg_schema.V_vertex", "sqlg_schema.V_edge", "sqlg_schema.V_property", "sqlg_schema.V_index", "sqlg_schema.V_globalUniqueIndex", "sqlg_schema.V_log", "sqlg_schema.E_schema_vertex", "sqlg_schema.E_in_edges", "sqlg_schema.E_out_edges", "sqlg_schema.E_vertex_property", "sqlg_schema.E_edge_property", "sqlg_schema.E_vertex_index", "sqlg_schema.E_edge_index", "sqlg_schema.E_index_property", "sqlg_schema.E_globalUniqueIndex_property");
    public static final List<String> SQLG_SCHEMA_GLOBAL_UNIQUE_INDEX_SCHEMA = Arrays.asList("gui_schema");

    Topology(SqlgGraph sqlgGraph) {
        this.sqlgGraph = sqlgGraph;
        this.distributed = sqlgGraph.configuration().getBoolean("distributed", false);
        this.reentrantReadWriteLock = new ReentrantReadWriteLock();
        Schema sqlgSchema = Schema.instantiateSqlgSchema(this);
        this.metaSchemas.put(SQLG_SCHEMA, sqlgSchema);
        HashedMap columns = new HashedMap();
        columns.put("name", PropertyType.STRING);
        columns.put(CREATED_ON, PropertyType.LOCALDATETIME);
        VertexLabel schemaVertexLabel = sqlgSchema.createSqlgSchemaVertexLabel(SQLG_SCHEMA_SCHEMA, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(schemaVertexLabel);
        columns.put(SCHEMA_VERTEX_DISPLAY, PropertyType.STRING);
        VertexLabel vertexVertexLabel = sqlgSchema.createSqlgSchemaVertexLabel(SQLG_SCHEMA_VERTEX_LABEL, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(vertexVertexLabel);
        columns.remove(SCHEMA_VERTEX_DISPLAY);
        VertexLabel edgeVertexLabel = sqlgSchema.createSqlgSchemaVertexLabel(SQLG_SCHEMA_EDGE_LABEL, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(edgeVertexLabel);
        columns.put(SQLG_SCHEMA_PROPERTY_TYPE, PropertyType.STRING);
        VertexLabel propertyVertexLabel = sqlgSchema.createSqlgSchemaVertexLabel(SQLG_SCHEMA_PROPERTY, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(propertyVertexLabel);
        columns.clear();
        columns.put("name", PropertyType.STRING);
        columns.put(SQLG_SCHEMA_INDEX_INDEX_TYPE, PropertyType.STRING);
        columns.put(CREATED_ON, PropertyType.LOCALDATETIME);
        VertexLabel indexVertexLabel = sqlgSchema.createSqlgSchemaVertexLabel(SQLG_SCHEMA_INDEX, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(indexVertexLabel);
        columns.clear();
        columns.put("name", PropertyType.STRING);
        columns.put(CREATED_ON, PropertyType.LOCALDATETIME);
        VertexLabel globalUniqueIndexVertexLabel = sqlgSchema.createSqlgSchemaVertexLabel(SQLG_SCHEMA_GLOBAL_UNIQUE_INDEX, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(globalUniqueIndexVertexLabel);
        columns.clear();
        EdgeLabel schemaToVertexEdgeLabel = schemaVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_SCHEMA_VERTEX_EDGE, vertexVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(schemaToVertexEdgeLabel);
        EdgeLabel vertexInEdgeLabel = vertexVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_IN_EDGES_EDGE, edgeVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(vertexInEdgeLabel);
        EdgeLabel vertexOutEdgeLabel = vertexVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_OUT_EDGES_EDGE, edgeVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(vertexOutEdgeLabel);
        EdgeLabel vertexPropertyEdgeLabel = vertexVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_VERTEX_PROPERTIES_EDGE, propertyVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(vertexPropertyEdgeLabel);
        EdgeLabel edgePropertyEdgeLabel = edgeVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_EDGE_PROPERTIES_EDGE, propertyVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(edgePropertyEdgeLabel);
        EdgeLabel vertexIndexEdgeLabel = vertexVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_VERTEX_INDEX_EDGE, indexVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(vertexIndexEdgeLabel);
        EdgeLabel edgeIndexEdgeLabel = edgeVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_EDGE_INDEX_EDGE, indexVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(edgeIndexEdgeLabel);
        EdgeLabel indexPropertyEdgeLabel = indexVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_INDEX_PROPERTY_EDGE, propertyVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(indexPropertyEdgeLabel);
        EdgeLabel globalUniqueIndexPropertyEdgeLabel = globalUniqueIndexVertexLabel.loadSqlgSchemaEdgeLabel(SQLG_SCHEMA_GLOBAL_UNIQUE_INDEX_PROPERTY_EDGE, propertyVertexLabel, (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(globalUniqueIndexPropertyEdgeLabel);
        columns.clear();
        columns.put(SQLG_SCHEMA_LOG_TIMESTAMP, PropertyType.LOCALDATETIME);
        columns.put("log", PropertyType.JSON);
        columns.put(SQLG_SCHEMA_LOG_PID, PropertyType.INTEGER);
        VertexLabel logVertexLabel = sqlgSchema.createSqlgSchemaVertexLabel("log", (Map<String, PropertyType>)columns);
        this.sqlgSchemaAbstractLabels.add(logVertexLabel);
        this.schemas.put(sqlgGraph.getSqlDialect().getPublicSchema(), Schema.createPublicSchema(sqlgGraph, this, sqlgGraph.getSqlDialect().getPublicSchema()));
        this.schemas.put("gui_schema", Schema.createGlobalUniqueIndexSchema(this));
        sqlgSchema.cacheEdgeLabels();
        sqlgSchema.getVertexLabels().values().forEach(v -> this.allTableCache.put(v.getSchema().getName() + "." + "V_" + v.getLabel(), v.getPropertyTypeMap()));
        sqlgSchema.getEdgeLabels().values().forEach(e -> this.allTableCache.put(e.getSchema().getName() + "." + "E_" + e.getLabel(), e.getPropertyTypeMap()));
        sqlgSchema.getVertexLabels().values().forEach(v -> {
            SchemaTable vertexLabelSchemaTable = SchemaTable.of(v.getSchema().getName(), "V_" + v.getLabel());
            this.schemaTableForeignKeyCache.put(vertexLabelSchemaTable, (Pair<Set<SchemaTable>, Set<SchemaTable>>)Pair.of(new HashSet(), new HashSet()));
            v.getInEdgeLabels().forEach((edgeLabelName, edgeLabel) -> ((Set)this.schemaTableForeignKeyCache.get(vertexLabelSchemaTable).getLeft()).add(SchemaTable.of(edgeLabel.getSchema().getName(), "E_" + edgeLabel.getLabel())));
            v.getOutEdgeLabels().forEach((edgeLabelName, edgeLabel) -> ((Set)this.schemaTableForeignKeyCache.get(vertexLabelSchemaTable).getRight()).add(SchemaTable.of(v.getSchema().getName(), "E_" + edgeLabel.getLabel())));
        });
        this.edgeForeignKeyCache = sqlgSchema.getAllEdgeForeignKeys();
        if (this.distributed) {
            ((SqlSchemaChangeDialect)this.sqlgGraph.getSqlDialect()).registerListener(sqlgGraph);
        }
        this.sqlgGraph.tx().beforeCommit(this::beforeCommit);
        this.sqlgGraph.tx().afterCommit(this::afterCommit);
        this.sqlgGraph.tx().afterRollback(() -> {
            if (this.sqlgGraph.getSqlDialect().supportsTransactionalSchema()) {
                this.afterRollback();
            } else {
                this.afterCommit();
            }
        });
        if (this.sqlgGraph.getSqlDialect().requiredPreparedStatementDeallocate()) {
            this.registerListener((TopologyInf2, String2, TopologyChangeAction2) -> this.deallocateAll());
        }
    }

    SqlgGraph getSqlgGraph() {
        return this.sqlgGraph;
    }

    void close() {
        if (this.distributed) {
            ((SqlSchemaChangeDialect)this.sqlgGraph.getSqlDialect()).unregisterListener();
        }
    }

    public List<TopologyValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    void lock() {
        if (!this.isWriteLockHeldByCurrentThread()) {
            try {
                this.sqlgGraph.tx().readWrite();
                if (!this.reentrantReadWriteLock.writeLock().tryLock(100L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("timeout lapsed to acquire lock schema creation.");
                }
                if (this.distributed) {
                    ((SqlSchemaChangeDialect)this.sqlgGraph.getSqlDialect()).lock(this.sqlgGraph);
                    if (!this.notificationTimestamps.isEmpty()) {
                        LocalDateTime timestamp = this.notificationTimestamps.last();
                        List logs = this.sqlgGraph.topology().V(new Object[0]).hasLabel("sqlg_schema.log", new String[0]).has(SQLG_SCHEMA_LOG_TIMESTAMP, P.gt((Object)timestamp)).toList();
                        for (Vertex logVertex : logs) {
                            ObjectNode log = (ObjectNode)logVertex.value("log");
                            this.fromNotifyJson(timestamp, log);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void z_internalWriteLock() {
        if (!this.isWriteLockHeldByCurrentThread()) {
            try {
                this.sqlgGraph.tx().readWrite();
                if (!this.reentrantReadWriteLock.writeLock().tryLock(100L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("Timeout lapsed to acquire write lock for notification.");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void z_internalReadLock() {
        this.reentrantReadWriteLock.readLock().lock();
    }

    private void z_internalReadUnLock() {
        this.reentrantReadWriteLock.readLock().unlock();
    }

    boolean isWriteLockHeldByCurrentThread() {
        return this.reentrantReadWriteLock.isWriteLockedByCurrentThread();
    }

    public Schema ensureSchemaExist(String schemaName) {
        Optional<Schema> schemaOptional = this.getSchema(schemaName);
        if (!schemaOptional.isPresent()) {
            this.lock();
            schemaOptional = this.getSchema(schemaName);
            if (!schemaOptional.isPresent()) {
                Schema schema = Schema.createSchema(this.sqlgGraph, this, schemaName);
                this.uncommittedSchemas.put(schemaName, schema);
                this.fire(schema, "", TopologyChangeAction.CREATE);
                return schema;
            }
            return schemaOptional.get();
        }
        return schemaOptional.get();
    }

    public VertexLabel ensureVertexLabelExist(String label) {
        return this.ensureVertexLabelExist(this.sqlgGraph.getSqlDialect().getPublicSchema(), label, Collections.emptyMap());
    }

    public VertexLabel ensureVertexLabelExist(String label, Map<String, PropertyType> columns) {
        return this.ensureVertexLabelExist(this.sqlgGraph.getSqlDialect().getPublicSchema(), label, columns);
    }

    public VertexLabel ensureVertexLabelExist(String schemaName, String label) {
        return this.ensureVertexLabelExist(schemaName, label, Collections.emptyMap());
    }

    public VertexLabel ensureVertexLabelExist(String schemaName, String label, Map<String, PropertyType> properties) {
        Objects.requireNonNull(schemaName, "Given tables must not be null");
        Objects.requireNonNull(label, "Given table must not be null");
        Preconditions.checkArgument((!label.startsWith("V_") ? 1 : 0) != 0, (String)"label may not be prefixed with %s", (Object[])new Object[]{"V_"});
        Schema schema = this.ensureSchemaExist(schemaName);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (Object)"Schema must be present after calling ensureSchemaExist");
        return schema.ensureVertexLabelExist(label, properties);
    }

    public EdgeLabel ensureEdgeLabelExist(String edgeLabelName, VertexLabel outVertexLabel, VertexLabel inVertexLabel, Map<String, PropertyType> properties) {
        Objects.requireNonNull(edgeLabelName, "Given edgeLabelName must not be null");
        Objects.requireNonNull(outVertexLabel, "Given outVertexLabel must not be null");
        Objects.requireNonNull(inVertexLabel, "Given inVertexLabel must not be null");
        Schema outVertexSchema = outVertexLabel.getSchema();
        return outVertexSchema.ensureEdgeLabelExist(edgeLabelName, outVertexLabel, inVertexLabel, properties);
    }

    public void ensureVertexTemporaryTableExist(String schema, String table, Map<String, PropertyType> columns) {
        Objects.requireNonNull(schema, "Given schema may not be null");
        Objects.requireNonNull(table, "Given table may not be null");
        String prefixedTable = "V_" + table;
        if (!this.temporaryTables.containsKey(prefixedTable)) {
            this.lock();
            if (!this.temporaryTables.containsKey(prefixedTable)) {
                this.temporaryTables.put(prefixedTable, columns);
                this.createTempTable(prefixedTable, columns);
            }
        }
    }

    public SchemaTable ensureEdgeLabelExist(String edgeLabelName, SchemaTable foreignKeyOut, SchemaTable foreignKeyIn, Map<String, PropertyType> properties) {
        Objects.requireNonNull(edgeLabelName, "Given edgeLabelName must not be null");
        Objects.requireNonNull(foreignKeyOut, "Given outTable must not be null");
        Objects.requireNonNull(foreignKeyIn, "Given inTable must not be null");
        Preconditions.checkState((boolean)this.getVertexLabel(foreignKeyOut.getSchema(), foreignKeyOut.getTable()).isPresent(), (String)"The out vertex must already exist before invoking 'ensureEdgeLabelExist'. \"%s\" does not exist", (Object[])new Object[]{foreignKeyIn.toString()});
        Preconditions.checkState((boolean)this.getVertexLabel(foreignKeyIn.getSchema(), foreignKeyIn.getTable()).isPresent(), (String)"The in vertex must already exist before invoking 'ensureEdgeLabelExist'. \"%s\" does not exist", (Object[])new Object[]{foreignKeyIn.toString()});
        Schema outVertexSchema = this.getSchema(foreignKeyOut.getSchema()).get();
        Schema inVertexSchema = this.getSchema(foreignKeyIn.getSchema()).get();
        Optional<VertexLabel> outVertexLabel = outVertexSchema.getVertexLabel(foreignKeyOut.getTable());
        Optional<VertexLabel> inVertexLabel = inVertexSchema.getVertexLabel(foreignKeyIn.getTable());
        Preconditions.checkState((boolean)outVertexLabel.isPresent(), (Object)"out VertexLabel must be present");
        Preconditions.checkState((boolean)inVertexLabel.isPresent(), (Object)"in VertexLabel must be present");
        EdgeLabel edgeLabel = outVertexSchema.ensureEdgeLabelExist(edgeLabelName, outVertexLabel.get(), inVertexLabel.get(), properties);
        return SchemaTable.of(foreignKeyOut.getSchema(), edgeLabel.getLabel());
    }

    public void ensureVertexLabelPropertiesExist(String label, Map<String, PropertyType> properties) {
        this.ensureVertexLabelPropertiesExist(this.sqlgGraph.getSqlDialect().getPublicSchema(), label, properties);
    }

    public void ensureVertexLabelPropertiesExist(String schemaName, String label, Map<String, PropertyType> properties) {
        Preconditions.checkArgument((!label.startsWith("V_") ? 1 : 0) != 0, (String)"label may not start with \"%s\"", (Object[])new Object[]{"V_"});
        if (!schemaName.equals(SQLG_SCHEMA)) {
            Optional<Schema> schemaOptional = this.getSchema(schemaName);
            if (!schemaOptional.isPresent()) {
                throw new IllegalStateException(String.format("BUG: schema \"%s\" can not be null", schemaName));
            }
            schemaOptional.get().ensureVertexColumnsExist(label, properties);
        }
    }

    public void ensureEdgePropertiesExist(String label, Map<String, PropertyType> properties) {
        this.ensureEdgePropertiesExist(this.sqlgGraph.getSqlDialect().getPublicSchema(), label, properties);
    }

    public void ensureEdgePropertiesExist(String schemaName, String label, Map<String, PropertyType> properties) {
        Preconditions.checkArgument((!label.startsWith("E_") ? 1 : 0) != 0, (String)"label may not start with \"%s\"", (Object[])new Object[]{"E_"});
        Preconditions.checkState((!schemaName.equals(SQLG_SCHEMA) ? 1 : 0) != 0, (String)"Topology.ensureEdgePropertiesExist may not be called for \"%s\"", (Object[])new Object[]{SQLG_SCHEMA});
        if (!schemaName.equals(SQLG_SCHEMA)) {
            Optional<Schema> schemaOptional = this.getSchema(schemaName);
            if (!schemaOptional.isPresent()) {
                throw new IllegalStateException(String.format("BUG: schema %s can not be null", schemaName));
            }
            schemaOptional.get().ensureEdgeColumnsExist(label, properties);
        }
    }

    public GlobalUniqueIndex ensureGlobalUniqueIndexExist(Set<PropertyColumn> properties) {
        Objects.requireNonNull(properties, "properties may not be null");
        Schema globalUniqueIndexSchema = this.getSchema("gui_schema").orElseThrow(() -> new IllegalStateException("BUG: Global unique index schema gui_schema must exist"));
        return globalUniqueIndexSchema.ensureGlobalUniqueIndexExist(properties);
    }

    public void createTempTable(String tableName, Map<String, PropertyType> columns) {
        this.sqlgGraph.getSqlDialect().assertTableName(tableName);
        StringBuilder sql = new StringBuilder(this.sqlgGraph.getSqlDialect().createTemporaryTableStatement());
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(tableName));
        sql.append("(");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
        sql.append(" ");
        sql.append(this.sqlgGraph.getSqlDialect().getAutoIncrementPrimaryKeyConstruct());
        if (columns.size() > 0) {
            sql.append(", ");
        }
        AbstractLabel.buildColumns(this.sqlgGraph, columns, sql);
        sql.append(") ");
        sql.append(this.sqlgGraph.getSqlDialect().afterCreateTemporaryTableStatement());
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void beforeCommit() {
        Optional<JsonNode> jsonNodeOptional = this.toNotifyJson();
        if (jsonNodeOptional.isPresent() && this.distributed) {
            SqlSchemaChangeDialect sqlSchemaChangeDialect = (SqlSchemaChangeDialect)this.sqlgGraph.getSqlDialect();
            LocalDateTime timestamp = LocalDateTime.now();
            int pid = sqlSchemaChangeDialect.notifyChange(this.sqlgGraph, timestamp, jsonNodeOptional.get());
            this.ownPids.add(pid);
        }
    }

    private Schema removeSchemaFromCaches(String schema) {
        Object schemaTable;
        Schema s = this.schemas.remove(schema);
        Iterator<Object> all = this.allTableCache.keySet().iterator();
        while (all.hasNext()) {
            schemaTable = all.next();
            if (!((String)schemaTable).startsWith(schema + ".")) continue;
            all.remove();
        }
        all = this.edgeForeignKeyCache.keySet().iterator();
        while (all.hasNext()) {
            schemaTable = all.next();
            if (!((String)schemaTable).startsWith(schema + ".")) continue;
            all.remove();
        }
        all = this.schemaTableForeignKeyCache.keySet().iterator();
        while (all.hasNext()) {
            schemaTable = (SchemaTable)all.next();
            if (!((SchemaTable)schemaTable).getSchema().equals(schema)) continue;
            all.remove();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterCommit() {
        this.temporaryTables.clear();
        if (this.isWriteLockHeldByCurrentThread()) {
            Iterator<Object> it = this.uncommittedSchemas.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Schema> entry = it.next();
                this.schemas.put(entry.getKey(), entry.getValue());
                it.remove();
            }
            it = this.uncommittedRemovedSchemas.iterator();
            while (it.hasNext()) {
                String sch = (String)it.next();
                this.removeSchemaFromCaches(sch);
                it.remove();
            }
            Map<String, AbstractLabel> uncommittedAllTables = this.getUncommittedAllTables();
            for (Map.Entry entry : uncommittedAllTables.entrySet()) {
                String string = (String)entry.getKey();
                AbstractLabel abstractLabel = (AbstractLabel)entry.getValue();
                this.allTableCache.put(string, abstractLabel.getPropertyTypeMap());
            }
            Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> uncommittedSchemaTableForeignKeys = this.getUncommittedSchemaTableForeignKeys();
            for (Map.Entry<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> entry : uncommittedSchemaTableForeignKeys.entrySet()) {
                Pair<Set<SchemaTable>, Set<SchemaTable>> foreignKeys = this.schemaTableForeignKeyCache.get(entry.getKey());
                if (foreignKeys != null) {
                    ((Set)foreignKeys.getLeft()).addAll((Collection)entry.getValue().getLeft());
                    ((Set)foreignKeys.getRight()).addAll((Collection)entry.getValue().getRight());
                    continue;
                }
                this.schemaTableForeignKeyCache.put(entry.getKey(), entry.getValue());
            }
            Map<String, Set<String>> map = this.getUncommittedEdgeForeignKeys();
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                Set<String> foreignKeys = this.edgeForeignKeyCache.get(entry.getKey());
                if (foreignKeys == null) {
                    this.edgeForeignKeyCache.put(entry.getKey(), entry.getValue());
                    continue;
                }
                foreignKeys.addAll((Collection<String>)entry.getValue());
            }
            this.z_internalReadLock();
            try {
                for (Schema schema : this.schemas.values()) {
                    schema.afterCommit();
                }
            }
            finally {
                this.z_internalReadUnLock();
            }
            this.reentrantReadWriteLock.writeLock().unlock();
        }
    }

    private void afterRollback() {
        this.temporaryTables.clear();
        if (this.isWriteLockHeldByCurrentThread()) {
            Iterator<Map.Entry<String, Schema>> it = this.uncommittedSchemas.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Schema> entry = it.next();
                entry.getValue().afterRollback();
                it.remove();
            }
            this.uncommittedRemovedSchemas.clear();
            this.z_internalReadLock();
            try {
                for (Schema schema : this.schemas.values()) {
                    schema.afterRollback();
                }
            }
            finally {
                this.z_internalReadUnLock();
            }
            this.reentrantReadWriteLock.writeLock().unlock();
        }
    }

    public void deallocateAll() {
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement statement = conn.createStatement();){
            statement.execute("DEALLOCATE ALL");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void cacheTopology() {
        Schema schema;
        Optional<Schema> schemaOptional;
        String schemaName;
        this.lock();
        GraphTraversalSource traversalSource = this.sqlgGraph.topology();
        List logs = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.log", new String[0]).order().by(SQLG_SCHEMA_LOG_TIMESTAMP, (Comparator)Order.decr).limit(1L).toList();
        Preconditions.checkState((logs.size() <= 1 ? 1 : 0) != 0, (Object)"must load one or zero logs in cacheTopology");
        if (!logs.isEmpty()) {
            Vertex log = (Vertex)logs.get(0);
            Iterator timestamp = (LocalDateTime)log.value(SQLG_SCHEMA_LOG_TIMESTAMP);
            this.notificationTimestamps.add((LocalDateTime)((Object)timestamp));
        } else {
            this.notificationTimestamps.add(LocalDateTime.now());
        }
        List schemaVertices = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).toList();
        for (Vertex schemaVertex : schemaVertices) {
            schemaName = (String)schemaVertex.value("name");
            schemaOptional = this.getSchema(schemaName);
            if (schemaName.equals(SQLG_SCHEMA)) {
                Preconditions.checkState((boolean)schemaOptional.isPresent(), (Object)"\"public\" schema must always be present.");
            }
            if (!schemaOptional.isPresent()) {
                schema = Schema.loadUserSchema(this, schemaName);
                this.schemas.put(schemaName, schema);
            } else {
                schema = schemaOptional.get();
            }
            schema.loadVertexOutEdgesAndProperties(traversalSource, schemaVertex);
            schema.loadVertexIndices(traversalSource, schemaVertex);
            schema.loadEdgeIndices(traversalSource, schemaVertex);
        }
        schemaVertices = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).toList();
        for (Vertex schemaVertex : schemaVertices) {
            schemaName = (String)schemaVertex.value("name");
            schemaOptional = this.getSchema(schemaName);
            Preconditions.checkState((boolean)schemaOptional.isPresent(), (String)"schema %s must be present when loading in edges.", (Object[])new Object[]{schemaName});
            schema = schemaOptional.get();
            schema.loadInEdgeLabels(traversalSource, schemaVertex);
        }
        List globalUniqueIndexVertices = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.globalUniqueIndex", new String[0]).toList();
        for (Vertex globalUniqueIndexVertex : globalUniqueIndexVertices) {
            String globalUniqueIndexName = (String)globalUniqueIndexVertex.value("name");
            GlobalUniqueIndex globalUniqueIndex = GlobalUniqueIndex.instantiateGlobalUniqueIndex(this, globalUniqueIndexName);
            this.getGlobalUniqueIndexSchema().globalUniqueIndexes.put(globalUniqueIndexName, globalUniqueIndex);
            Set globalUniqueIndexProperties = traversalSource.V(new Object[]{globalUniqueIndexVertex}).out(new String[]{SQLG_SCHEMA_GLOBAL_UNIQUE_INDEX_PROPERTY_EDGE}).toSet();
            HashSet<PropertyColumn> guiPropertyColumns = new HashSet<PropertyColumn>();
            for (Vertex globalUniqueIndexPropertyVertex : globalUniqueIndexProperties) {
                Vertex vertexVertex;
                Vertex schemaVertex;
                boolean isForVertex = true;
                List vertexSchema = traversalSource.V(new Object[]{globalUniqueIndexPropertyVertex}).in(new String[]{SQLG_SCHEMA_VERTEX_PROPERTIES_EDGE}).as(SQLG_SCHEMA_VERTEX_LABEL, new String[0]).in(new String[]{SQLG_SCHEMA_SCHEMA_VERTEX_EDGE}).as(SQLG_SCHEMA_SCHEMA, new String[0]).select(SQLG_SCHEMA_VERTEX_LABEL, SQLG_SCHEMA_SCHEMA, new String[0]).toList();
                if (!vertexSchema.isEmpty()) {
                    Preconditions.checkState((vertexSchema.size() == 1 ? 1 : 0) != 0, (Object)"BUG: GlobalUniqueIndex %s property %s has more than one path to the schema.");
                    schemaVertex = (Vertex)((Map)vertexSchema.get(0)).get(SQLG_SCHEMA_SCHEMA);
                    vertexVertex = (Vertex)((Map)vertexSchema.get(0)).get(SQLG_SCHEMA_VERTEX_LABEL);
                    Schema guiPropertySchema = this.getSchema((String)schemaVertex.property("name").value()).get();
                    VertexLabel guiPropertyVertexLabel = guiPropertySchema.getVertexLabel((String)vertexVertex.property("name").value()).get();
                    PropertyColumn propertyColumn = guiPropertyVertexLabel.getProperty((String)globalUniqueIndexPropertyVertex.property("name").value()).get();
                    guiPropertyColumns.add(propertyColumn);
                    continue;
                }
                vertexSchema = traversalSource.V(new Object[]{globalUniqueIndexPropertyVertex}).in(new String[]{SQLG_SCHEMA_EDGE_PROPERTIES_EDGE}).as(SQLG_SCHEMA_EDGE_LABEL, new String[0]).in(new String[]{SQLG_SCHEMA_OUT_EDGES_EDGE}).as(SQLG_SCHEMA_VERTEX_LABEL, new String[0]).in(new String[]{SQLG_SCHEMA_SCHEMA_VERTEX_EDGE}).as(SQLG_SCHEMA_SCHEMA, new String[0]).select(SQLG_SCHEMA_EDGE_LABEL, SQLG_SCHEMA_VERTEX_LABEL, new String[]{SQLG_SCHEMA_SCHEMA}).toList();
                Preconditions.checkState((vertexSchema.size() == 1 ? 1 : 0) != 0, (Object)"BUG: GlobalUniqueIndex %s property %s has more than one path to the schema.");
                schemaVertex = (Vertex)((Map)vertexSchema.get(0)).get(SQLG_SCHEMA_SCHEMA);
                vertexVertex = (Vertex)((Map)vertexSchema.get(0)).get(SQLG_SCHEMA_VERTEX_LABEL);
                Vertex edgeVertex = (Vertex)((Map)vertexSchema.get(0)).get(SQLG_SCHEMA_EDGE_LABEL);
                Schema guiPropertySchema = this.getSchema((String)schemaVertex.property("name").value()).get();
                VertexLabel guiPropertyVertexLabel = guiPropertySchema.getVertexLabel((String)vertexVertex.property("name").value()).get();
                EdgeLabel guiPropertyEdgeLabel = guiPropertyVertexLabel.getOutEdgeLabel((String)edgeVertex.property("name").value()).get();
                PropertyColumn propertyColumn = guiPropertyEdgeLabel.getProperty((String)globalUniqueIndexPropertyVertex.property("name").value()).get();
                guiPropertyColumns.add(propertyColumn);
            }
            globalUniqueIndex.addGlobalUniqueProperties(guiPropertyColumns);
        }
        for (Schema schema2 : this.schemas.values()) {
            if (schema2.isSqlgSchema()) continue;
            this.allTableCache.putAll(schema2.getAllTables());
        }
        this.schemaTableForeignKeyCache.putAll(this.loadTableLabels());
        this.edgeForeignKeyCache.putAll(this.loadAllEdgeForeignKeys());
    }

    void validateTopology() {
        Connection conn = this.sqlgGraph.tx().getConnection();
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            for (Schema schema : this.getSchemas()) {
                ResultSet schemaRs = metadata.getSchemas(null, schema.getName());
                Throwable throwable = null;
                try {
                    if (!schemaRs.next()) {
                        this.validationErrors.add(new TopologyValidationError(schema));
                        continue;
                    }
                    this.validationErrors.addAll(schema.validateTopology(metadata));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (schemaRs == null) continue;
                    if (throwable != null) {
                        try {
                            schemaRs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    schemaRs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode toJson() {
        this.z_internalReadLock();
        try {
            ObjectNode topologyNode = new ObjectNode(OBJECT_MAPPER.getNodeFactory());
            ArrayNode schemaArrayNode = new ArrayNode(OBJECT_MAPPER.getNodeFactory());
            for (Schema schema : this.schemas.values()) {
                schemaArrayNode.add(schema.toJson());
            }
            topologyNode.set("schemas", (JsonNode)schemaArrayNode);
            ObjectNode objectNode = topologyNode;
            return objectNode;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    public String toString() {
        return this.toJson().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<JsonNode> toNotifyJson() {
        this.z_internalReadLock();
        try {
            ArrayNode committedSchemaArrayNode = null;
            ObjectNode topologyNode = null;
            for (Schema optional : this.schemas.values()) {
                Optional<JsonNode> jsonNodeOptional = optional.toNotifyJson();
                if (jsonNodeOptional.isPresent() && committedSchemaArrayNode == null) {
                    committedSchemaArrayNode = new ArrayNode(OBJECT_MAPPER.getNodeFactory());
                }
                if (!jsonNodeOptional.isPresent()) continue;
                committedSchemaArrayNode.add(jsonNodeOptional.get());
            }
            if (committedSchemaArrayNode != null) {
                topologyNode = new ObjectNode(OBJECT_MAPPER.getNodeFactory());
                topologyNode.set("schemas", committedSchemaArrayNode);
            }
            ArrayNode unCommittedSchemaArrayNode = null;
            if (this.isWriteLockHeldByCurrentThread()) {
                for (Schema schema : this.uncommittedSchemas.values()) {
                    Optional<JsonNode> jsonNodeOptional;
                    if (unCommittedSchemaArrayNode == null) {
                        unCommittedSchemaArrayNode = new ArrayNode(OBJECT_MAPPER.getNodeFactory());
                    }
                    if ((jsonNodeOptional = schema.toNotifyJson()).isPresent()) {
                        unCommittedSchemaArrayNode.add(jsonNodeOptional.get());
                        continue;
                    }
                    ObjectNode schemaNode = new ObjectNode(OBJECT_MAPPER.getNodeFactory());
                    schemaNode.put("name", schema.getName());
                    unCommittedSchemaArrayNode.add((JsonNode)schemaNode);
                }
                ArrayNode arrayNode = new ArrayNode(OBJECT_MAPPER.getNodeFactory());
                for (String schema : this.uncommittedRemovedSchemas) {
                    arrayNode.add(schema);
                }
                if (arrayNode.size() > 0) {
                    if (topologyNode == null) {
                        topologyNode = new ObjectNode(OBJECT_MAPPER.getNodeFactory());
                    }
                    topologyNode.set("uncommittedRemovedSchemas", (JsonNode)arrayNode);
                }
            }
            if (unCommittedSchemaArrayNode != null) {
                if (topologyNode == null) {
                    topologyNode = new ObjectNode(OBJECT_MAPPER.getNodeFactory());
                }
                topologyNode.set("uncommittedSchemas", unCommittedSchemaArrayNode);
            }
            if (topologyNode != null) {
                Optional<ObjectNode> optional = Optional.of(topologyNode);
                return optional;
            }
            Optional<JsonNode> optional = Optional.empty();
            return optional;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromNotifyJson(int pid, LocalDateTime notifyTimestamp) {
        this.z_internalWriteLock();
        try {
            if (!this.ownPids.contains(pid)) {
                List logs = this.sqlgGraph.topology().V(new Object[0]).hasLabel("sqlg_schema.log", new String[0]).has(SQLG_SCHEMA_LOG_TIMESTAMP, (Object)notifyTimestamp).toList();
                Preconditions.checkState((logs.size() == 1 ? 1 : 0) != 0, (String)"There must be one and only be one log, found %d", (Object[])new Object[]{logs.size()});
                LocalDateTime timestamp = (LocalDateTime)((Vertex)logs.get(0)).value(SQLG_SCHEMA_LOG_TIMESTAMP);
                Preconditions.checkState((boolean)timestamp.equals(notifyTimestamp), (Object)"notify log's timestamp does not match.");
                int backEndPid = (Integer)((Vertex)logs.get(0)).value(SQLG_SCHEMA_LOG_PID);
                Preconditions.checkState((backEndPid == pid ? 1 : 0) != 0, (Object)"notify pids do not match.");
                ObjectNode log = (ObjectNode)((Vertex)logs.get(0)).value("log");
                this.fromNotifyJson(timestamp, log);
            } else {
                this.ownPids.remove(pid);
            }
        }
        finally {
            this.sqlgGraph.tx().rollback();
        }
    }

    private void fromNotifyJson(LocalDateTime timestamp, ObjectNode log) {
        Schema schema;
        Optional<Schema> schemaOptional;
        String schemaName;
        ArrayNode schemas;
        for (String s : Arrays.asList("uncommittedSchemas", "schemas")) {
            schemas = (ArrayNode)log.get(s);
            if (schemas == null) continue;
            for (JsonNode jsonSchema : schemas) {
                schemaName = jsonSchema.get("name").asText();
                schemaOptional = this.getSchema(schemaName);
                if (schemaOptional.isPresent()) continue;
                schema = Schema.instantiateSchema(this, schemaName);
                this.schemas.put(schemaName, schema);
                this.fire(schema, "", TopologyChangeAction.CREATE);
            }
            for (JsonNode jsonSchema : schemas) {
                schemaName = jsonSchema.get("name").asText();
                schemaOptional = this.getSchema(schemaName);
                Preconditions.checkState((boolean)schemaOptional.isPresent(), (Object)"Schema must be present here");
                schema = schemaOptional.get();
                schema.fromNotifyJsonOutEdges(jsonSchema);
            }
        }
        for (String s : Arrays.asList("uncommittedSchemas", "schemas")) {
            schemas = (ArrayNode)log.get(s);
            if (schemas == null) continue;
            for (JsonNode jsonSchema : schemas) {
                schemaName = jsonSchema.get("name").asText();
                schemaOptional = this.getSchema(schemaName);
                Preconditions.checkState((boolean)schemaOptional.isPresent(), (Object)"Schema must be present here");
                schema = schemaOptional.get();
                schema.fromNotifyJsonInEdges(jsonSchema);
            }
        }
        ArrayNode rem = (ArrayNode)log.get("uncommittedRemovedSchemas");
        if (rem != null) {
            for (JsonNode jsonSchema : rem) {
                String name = jsonSchema.asText();
                Schema s = this.removeSchemaFromCaches(name);
                if (s == null) continue;
                this.fire(s, "", TopologyChangeAction.DELETE);
            }
        }
        this.notificationTimestamps.add(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        this.z_internalReadLock();
        try {
            if (o == null) {
                boolean bl = false;
                return bl;
            }
            if (!(o instanceof Topology)) {
                boolean bl = false;
                return bl;
            }
            Topology other = (Topology)o;
            if (this.schemas.equals(other.schemas)) {
                for (Map.Entry<String, Schema> schemaEntry : this.schemas.entrySet()) {
                    Schema schema = schemaEntry.getValue();
                    Optional<Schema> otherSchemaOptional = other.getSchema(schemaEntry.getKey());
                    if (!otherSchemaOptional.isPresent() || schema.deepEquals(otherSchemaOptional.get())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    public Set<TopologyInf> getSqlgSchemaAbstractLabels() {
        return this.sqlgSchemaAbstractLabels;
    }

    public Set<GlobalUniqueIndex> getGlobalUniqueIndexes() {
        return new HashSet<GlobalUniqueIndex>(this.getGlobalUniqueIndexSchema().getGlobalUniqueIndexes().values());
    }

    public Optional<GlobalUniqueIndex> getGlobalUniqueIndexes(String name) {
        return this.getGlobalUniqueIndexSchema().getGlobalUniqueIndex(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Schema> getSchemas() {
        this.z_internalReadLock();
        try {
            HashSet<Schema> result = new HashSet<Schema>();
            result.addAll(this.schemas.values());
            if (this.isWriteLockHeldByCurrentThread()) {
                result.addAll(this.uncommittedSchemas.values());
                if (this.uncommittedRemovedSchemas.size() > 0) {
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        Schema sch = (Schema)it.next();
                        if (!this.uncommittedRemovedSchemas.contains(sch.getName())) continue;
                        it.remove();
                    }
                }
            }
            Set<Schema> set = Collections.unmodifiableSet(result);
            return set;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    public Schema getPublicSchema() {
        Optional<Schema> schema = this.getSchema(this.sqlgGraph.getSqlDialect().getPublicSchema());
        Preconditions.checkState((boolean)schema.isPresent(), (Object)"BUG: The public schema must always be present");
        return schema.get();
    }

    public Schema getGlobalUniqueIndexSchema() {
        Optional<Schema> schema = this.getSchema("gui_schema");
        Preconditions.checkState((boolean)schema.isPresent(), (String)"BUG: The global unique index schema %s must always be present", (Object[])new Object[]{"gui_schema"});
        return schema.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Schema> getSchema(String schema) {
        this.z_internalReadLock();
        try {
            if (this.isWriteLockHeldByCurrentThread() && this.uncommittedRemovedSchemas.contains(schema)) {
                Optional<Schema> optional = Optional.empty();
                return optional;
            }
            Schema result = this.schemas.get(schema);
            if (result == null) {
                if (this.isWriteLockHeldByCurrentThread()) {
                    result = this.uncommittedSchemas.get(schema);
                }
                if (result == null) {
                    result = this.metaSchemas.get(schema);
                }
            }
            Optional<Schema> optional = Optional.ofNullable(result);
            return optional;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    public Optional<VertexLabel> getVertexLabel(String schemaName, String label) {
        Preconditions.checkArgument((!label.startsWith("V_") ? 1 : 0) != 0, (String)"vertex label may not start with %s", (Object[])new Object[]{"V_"});
        Optional<Schema> schemaOptional = this.getSchema(schemaName);
        if (schemaOptional.isPresent()) {
            return schemaOptional.get().getVertexLabel(label);
        }
        return Optional.empty();
    }

    public Optional<EdgeLabel> getEdgeLabel(String schemaName, String edgeLabelName) {
        Preconditions.checkArgument((!edgeLabelName.startsWith("E_") ? 1 : 0) != 0, (String)"edge label name may not start with %s", (Object[])new Object[]{"E_"});
        Optional<Schema> schemaOptional = this.getSchema(schemaName);
        if (schemaOptional.isPresent()) {
            Schema schema = schemaOptional.get();
            Optional<EdgeLabel> edgeLabelOptional = schema.getEdgeLabel(edgeLabelName);
            if (edgeLabelOptional.isPresent()) {
                return edgeLabelOptional;
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Map<String, AbstractLabel> getUncommittedAllTables() {
        Schema schema;
        Preconditions.checkState((boolean)this.isWriteLockHeldByCurrentThread(), (Object)"getUncommittedAllTables must be called with the lock held");
        HashMap<String, AbstractLabel> result = new HashMap<String, AbstractLabel>();
        for (Map.Entry<String, Schema> stringSchemaEntry : this.schemas.entrySet()) {
            schema = stringSchemaEntry.getValue();
            result.putAll(schema.getUncommittedLabels());
        }
        for (Map.Entry<String, Schema> stringSchemaEntry : this.uncommittedSchemas.entrySet()) {
            schema = stringSchemaEntry.getValue();
            result.putAll(schema.getUncommittedLabels());
        }
        return result;
    }

    private Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> getUncommittedSchemaTableForeignKeys() {
        Schema schema;
        Preconditions.checkState((boolean)this.isWriteLockHeldByCurrentThread(), (Object)"getUncommittedSchemaTableForeignKeys must be called with the lock held");
        HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> result = new HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>>();
        for (Map.Entry<String, Schema> stringSchemaEntry : this.schemas.entrySet()) {
            schema = stringSchemaEntry.getValue();
            result.putAll(schema.getUncommittedSchemaTableForeignKeys());
        }
        for (Map.Entry<String, Schema> stringSchemaEntry : this.uncommittedSchemas.entrySet()) {
            schema = stringSchemaEntry.getValue();
            result.putAll(schema.getUncommittedSchemaTableForeignKeys());
        }
        return result;
    }

    private Map<String, Set<String>> getUncommittedEdgeForeignKeys() {
        Schema schema;
        Preconditions.checkState((boolean)this.isWriteLockHeldByCurrentThread(), (Object)"getUncommittedEdgeForeignKeys must be called with the lock held");
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Schema> stringSchemaEntry : this.schemas.entrySet()) {
            schema = stringSchemaEntry.getValue();
            result.putAll(schema.getUncommittedEdgeForeignKeys());
        }
        for (Map.Entry<String, Schema> stringSchemaEntry : this.uncommittedSchemas.entrySet()) {
            schema = stringSchemaEntry.getValue();
            result.putAll(schema.getUncommittedEdgeForeignKeys());
        }
        return result;
    }

    public Map<String, Map<String, PropertyType>> getAllTables() {
        return this.getAllTables(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, PropertyType>> getAllTables(boolean withSqlgSchema) {
        this.z_internalReadLock();
        try {
            HashMap<Object, Object> result;
            if (this.isWriteLockHeldByCurrentThread()) {
                result = new HashMap();
                for (Map.Entry<String, Map<String, PropertyType>> entry : this.allTableCache.entrySet()) {
                    result.put(entry.getKey(), new HashMap<String, PropertyType>(entry.getValue()));
                }
            } else {
                result = new HashMap<String, Map<String, PropertyType>>(this.allTableCache);
            }
            if (this.isWriteLockHeldByCurrentThread()) {
                Map<String, AbstractLabel> uncommittedLabels = this.getUncommittedAllTables();
                for (String table : uncommittedLabels.keySet()) {
                    if (result.containsKey(table)) {
                        ((Map)result.get(table)).putAll(uncommittedLabels.get(table).getPropertyTypeMap());
                        continue;
                    }
                    result.put(table, uncommittedLabels.get(table).getPropertyTypeMap());
                }
            }
            if (!withSqlgSchema) {
                for (String string : SQLG_SCHEMA_SCHEMA_TABLES) {
                    result.remove(string);
                }
            }
            Map map = Collections.unmodifiableMap(result);
            return map;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, PropertyType>> getAllTablesWithout(Set<TopologyInf> filter) {
        this.z_internalReadLock();
        try {
            HashMap<String, Map<String, PropertyType>> result = new HashMap<String, Map<String, PropertyType>>(this.getAllTables());
            for (TopologyInf f : filter) {
                if (!(f instanceof AbstractLabel)) continue;
                AbstractLabel abstractLabel = (AbstractLabel)f;
                Schema schema = abstractLabel.getSchema();
                result.remove(schema.getName() + "." + (abstractLabel instanceof VertexLabel ? "V_" : "E_") + abstractLabel.getLabel());
            }
            Map<String, Map<String, PropertyType>> map = Collections.unmodifiableMap(result);
            return map;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, PropertyType>> getAllTablesFrom(Set<TopologyInf> selectFrom) {
        this.z_internalReadLock();
        try {
            HashMap<String, Map<String, PropertyType>> result = new HashMap<String, Map<String, PropertyType>>();
            for (TopologyInf f : selectFrom) {
                if (f instanceof AbstractLabel) {
                    AbstractLabel abstractLabel = (AbstractLabel)f;
                    Schema schema = abstractLabel.getSchema();
                    String key = schema.getName() + "." + (abstractLabel instanceof VertexLabel ? "V_" : "E_") + abstractLabel.getLabel();
                    Map<String, PropertyType> tmp = this.allTableCache.get(key);
                    result.put(key, tmp);
                    continue;
                }
                if (!(f instanceof GlobalUniqueIndex)) continue;
                GlobalUniqueIndex globalUniqueIndex = (GlobalUniqueIndex)f;
                String key = "gui_schema.V_" + globalUniqueIndex.getName();
                Map<String, PropertyType> tmp = this.allTableCache.get(key);
                result.put(key, tmp);
            }
            Map map = Collections.unmodifiableMap(result);
            return map;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PropertyColumn> getPropertiesFor(SchemaTable schemaTable) {
        this.z_internalReadLock();
        try {
            Optional<Schema> schemaOptional = this.getSchema(schemaTable.getSchema());
            if (schemaOptional.isPresent()) {
                Map<String, PropertyColumn> map = Collections.unmodifiableMap(schemaOptional.get().getPropertiesFor(schemaTable));
                return map;
            }
            Map<String, PropertyColumn> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PropertyColumn> getPropertiesWithGlobalUniqueIndexFor(SchemaTable schemaTable) {
        this.z_internalReadLock();
        try {
            Optional<Schema> schemaOptional = this.getSchema(schemaTable.getSchema());
            if (schemaOptional.isPresent()) {
                Map<String, PropertyColumn> map = Collections.unmodifiableMap(schemaOptional.get().getPropertiesWithGlobalUniqueIndexFor(schemaTable));
                return map;
            }
            Map<String, PropertyColumn> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PropertyType> getTableFor(SchemaTable schemaTable) {
        this.z_internalReadLock();
        try {
            Map<String, PropertyType> temporaryPropertyMap;
            Optional<Schema> schemaOptional = this.getSchema(schemaTable.getSchema());
            if (schemaOptional.isPresent()) {
                Map<String, PropertyType> map = schemaOptional.get().getTableFor(schemaTable);
                return map;
            }
            if (this.isWriteLockHeldByCurrentThread() && (temporaryPropertyMap = this.temporaryTables.get(schemaTable.getTable())) != null) {
                Map<String, PropertyType> map = Collections.unmodifiableMap(temporaryPropertyMap);
                return map;
            }
            Map<String, PropertyType> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> getTableLabels() {
        this.z_internalReadLock();
        try {
            if (this.isWriteLockHeldByCurrentThread()) {
                Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> uncommittedSchemaTableForeignKeys = this.getUncommittedSchemaTableForeignKeys();
                for (Map.Entry<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> schemaTablePairEntry : this.schemaTableForeignKeyCache.entrySet()) {
                    Pair<Set<SchemaTable>, Set<SchemaTable>> uncommittedForeignKeys = uncommittedSchemaTableForeignKeys.get(schemaTablePairEntry.getKey());
                    if (uncommittedForeignKeys != null) {
                        ((Set)uncommittedForeignKeys.getLeft()).addAll((Collection)schemaTablePairEntry.getValue().getLeft());
                        ((Set)uncommittedForeignKeys.getRight()).addAll((Collection)schemaTablePairEntry.getValue().getRight());
                        continue;
                    }
                    uncommittedSchemaTableForeignKeys.put(schemaTablePairEntry.getKey(), schemaTablePairEntry.getValue());
                }
                Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> map = Collections.unmodifiableMap(uncommittedSchemaTableForeignKeys);
                return map;
            }
            Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> map = Collections.unmodifiableMap(this.schemaTableForeignKeyCache);
            return map;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> loadTableLabels() {
        this.z_internalReadLock();
        try {
            HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> map = new HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>>();
            for (Map.Entry<String, Schema> schemaEntry : this.schemas.entrySet()) {
                Map<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> result = schemaEntry.getValue().getTableLabels();
                map.putAll(result);
            }
            HashMap<SchemaTable, Pair<Set<SchemaTable>, Set<SchemaTable>>> hashMap = map;
            return hashMap;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    public Pair<Set<SchemaTable>, Set<SchemaTable>> getTableLabels(SchemaTable schemaTable) {
        return this.getTableLabels().get(schemaTable);
    }

    public Set<String> getEdgeForeignKeys(String schemaTable) {
        return this.getAllEdgeForeignKeys().get(schemaTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getAllEdgeForeignKeys() {
        this.z_internalReadLock();
        try {
            if (this.isWriteLockHeldByCurrentThread()) {
                HashMap<String, Set<String>> committed = new HashMap<String, Set<String>>(this.edgeForeignKeyCache);
                Map<String, Set<String>> uncommittedEdgeForeignKeys = this.getUncommittedEdgeForeignKeys();
                for (Map.Entry<String, Set<String>> uncommittedEntry : uncommittedEdgeForeignKeys.entrySet()) {
                    Set committedForeignKeys = (Set)committed.get(uncommittedEntry.getKey());
                    if (committedForeignKeys != null) {
                        HashSet originalPlusUncommittedForeignKeys = new HashSet(committedForeignKeys);
                        originalPlusUncommittedForeignKeys.addAll(uncommittedEntry.getValue());
                        committed.put(uncommittedEntry.getKey(), originalPlusUncommittedForeignKeys);
                        continue;
                    }
                    committed.put(uncommittedEntry.getKey(), uncommittedEntry.getValue());
                }
                Map<String, Set<String>> map = Collections.unmodifiableMap(committed);
                return map;
            }
            Map<String, Set<String>> map = Collections.unmodifiableMap(this.edgeForeignKeyCache);
            return map;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> loadAllEdgeForeignKeys() {
        this.z_internalReadLock();
        try {
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            for (Schema schema : this.schemas.values()) {
                result.putAll(schema.getAllEdgeForeignKeys());
            }
            HashMap<String, Set<String>> hashMap = result;
            return hashMap;
        }
        finally {
            this.z_internalReadUnLock();
        }
    }

    void addToEdgeForeignKeyCache(String name, String foreignKey) {
        Set<String> foreignKeys = this.edgeForeignKeyCache.get(name);
        if (foreignKeys == null) {
            foreignKeys = new HashSet<String>();
            foreignKeys.add(foreignKey);
            this.edgeForeignKeyCache.put(name, foreignKeys);
        } else {
            foreignKeys.add(foreignKey);
        }
    }

    void removeFromEdgeForeignKeyCache(String name, String foreignKey) {
        Set<String> foreignKeys = this.edgeForeignKeyCache.get(name);
        if (foreignKeys != null) {
            foreignKeys.remove(foreignKey);
        }
        if (foreignKeys.isEmpty()) {
            this.edgeForeignKeyCache.remove(name);
        }
    }

    void addToAllTables(String tableName, Map<String, PropertyType> propertyTypeMap) {
        this.allTableCache.put(tableName, propertyTypeMap);
        SchemaTable schemaTable = SchemaTable.from(this.sqlgGraph, tableName);
        if (schemaTable.getTable().startsWith("V_") && !this.schemaTableForeignKeyCache.containsKey(schemaTable)) {
            this.schemaTableForeignKeyCache.put(schemaTable, (Pair<Set<SchemaTable>, Set<SchemaTable>>)Pair.of(new HashSet(), new HashSet()));
        }
    }

    void addOutForeignKeysToVertexLabel(VertexLabel vertexLabel, EdgeLabel edgeLabel) {
        SchemaTable schemaTable = SchemaTable.of(vertexLabel.getSchema().getName(), "V_" + vertexLabel.getLabel());
        Pair foreignKeys = this.schemaTableForeignKeyCache.get(schemaTable);
        if (foreignKeys == null) {
            foreignKeys = Pair.of(new HashSet(), new HashSet());
            this.schemaTableForeignKeyCache.put(schemaTable, (Pair<Set<SchemaTable>, Set<SchemaTable>>)foreignKeys);
        }
        ((Set)foreignKeys.getRight()).add(SchemaTable.of(vertexLabel.getSchema().getName(), "E_" + edgeLabel.getLabel()));
    }

    void addInForeignKeysToVertexLabel(VertexLabel vertexLabel, EdgeLabel edgeLabel) {
        SchemaTable schemaTable = SchemaTable.of(vertexLabel.getSchema().getName(), "V_" + vertexLabel.getLabel());
        Pair foreignKeys = this.schemaTableForeignKeyCache.get(schemaTable);
        if (foreignKeys == null) {
            foreignKeys = Pair.of(new HashSet(), new HashSet());
            this.schemaTableForeignKeyCache.put(schemaTable, (Pair<Set<SchemaTable>, Set<SchemaTable>>)foreignKeys);
        }
        ((Set)foreignKeys.getLeft()).add(SchemaTable.of(edgeLabel.getSchema().getName(), "E_" + edgeLabel.getLabel()));
    }

    void removeOutForeignKeysFromVertexLabel(VertexLabel vertexLabel, EdgeLabel edgeLabel) {
        SchemaTable schemaTable = SchemaTable.of(vertexLabel.getSchema().getName(), "V_" + vertexLabel.getLabel());
        Pair<Set<SchemaTable>, Set<SchemaTable>> foreignKeys = this.schemaTableForeignKeyCache.get(schemaTable);
        if (foreignKeys != null) {
            ((Set)foreignKeys.getRight()).remove(SchemaTable.of(vertexLabel.getSchema().getName(), "E_" + edgeLabel.getLabel()));
        }
    }

    void removeInForeignKeysFromVertexLabel(VertexLabel vertexLabel, EdgeLabel edgeLabel) {
        SchemaTable schemaTable = SchemaTable.of(vertexLabel.getSchema().getName(), "V_" + vertexLabel.getLabel());
        Pair<Set<SchemaTable>, Set<SchemaTable>> foreignKeys = this.schemaTableForeignKeyCache.get(schemaTable);
        if (foreignKeys != null && edgeLabel.isValid()) {
            ((Set)foreignKeys.getLeft()).remove(SchemaTable.of(edgeLabel.getSchema().getName(), "E_" + edgeLabel.getLabel()));
        }
    }

    void removeVertexLabel(VertexLabel vertexLabel) {
        SchemaTable schemaTable = SchemaTable.of(vertexLabel.getSchema().getName(), "V_" + vertexLabel.getLabel());
        this.schemaTableForeignKeyCache.remove(schemaTable);
        for (EdgeLabel lbl : vertexLabel.getOutEdgeLabels().values()) {
            this.removeFromEdgeForeignKeyCache(lbl.getSchema().getName() + "." + "E_" + lbl.getLabel(), vertexLabel.getSchema().getName() + "." + vertexLabel.getLabel() + "__O");
        }
        for (EdgeLabel lbl : vertexLabel.getInEdgeLabels().values()) {
            if (!lbl.isValid()) continue;
            this.removeFromEdgeForeignKeyCache(lbl.getSchema().getName() + "." + "E_" + lbl.getLabel(), vertexLabel.getSchema().getName() + "." + vertexLabel.getLabel() + "__I");
        }
    }

    public void registerListener(TopologyListener topologyListener) {
        this.topologyListeners.add(topologyListener);
    }

    void fire(TopologyInf topologyInf, String oldValue, TopologyChangeAction action) {
        for (TopologyListener topologyListener : this.topologyListeners) {
            topologyListener.change(topologyInf, oldValue, action);
        }
    }

    void removeSchema(Schema schema, boolean preserveData) {
        this.lock();
        if (!this.uncommittedRemovedSchemas.contains(schema.getName())) {
            for (VertexLabel vlbl : schema.getVertexLabels().values()) {
                for (EdgeRole er : vlbl.getInEdgeRoles().values()) {
                    if (er.getEdgeLabel().getSchema() == schema) continue;
                    er.remove(preserveData);
                }
            }
            this.uncommittedRemovedSchemas.add(schema.getName());
            TopologyManager.removeSchema(this.sqlgGraph, schema.getName());
            if (!preserveData) {
                schema.delete();
            }
            this.fire(schema, "", TopologyChangeAction.DELETE);
        }
    }

    static class TopologyValidationError {
        private TopologyInf error;

        TopologyValidationError(TopologyInf error) {
            this.error = error;
        }

        public String toString() {
            return String.format("%s does not exist", this.error.getName());
        }
    }
}

