/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.umlg.sqlg.structure.AbstractLabel;
import org.umlg.sqlg.structure.BatchManager;
import org.umlg.sqlg.structure.EdgeLabel;
import org.umlg.sqlg.structure.Index;
import org.umlg.sqlg.structure.IndexType;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.VertexLabel;

public class TopologyManager {
    public static final String CREATED_ON = "createdOn";
    public static final String DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG = " does not exist in Sqlg's topology. BUG!!!";
    public static final String SCHEMA = "Schema ";
    public static final String FOUND_IN_SQLG_S_TOPOLOGY_BUG = " found in Sqlg's topology. BUG!!!";
    public static final String MULTIPLE = "Multiple ";

    private TopologyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vertex addSchema(SqlgGraph sqlgGraph, String schema) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            Vertex vertex = sqlgGraph.addVertex(T.label, "sqlg_schema.schema", "name", schema, CREATED_ON, LocalDateTime.now());
            return vertex;
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSchema(SqlgGraph sqlgGraph, String schema) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List schemas = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)schema).toList();
            if (schemas.size() > 0) {
                Vertex vs = (Vertex)schemas.get(0);
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).out(new String[]{"vertex_property"}).drop().iterate();
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).out(new String[]{"vertex_property"}).inE(new String[]{"globalUniqueIndex_property"}).drop().iterate();
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).out(new String[]{"vertex_index"}).drop().iterate();
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).out(new String[]{"vertex_property"}).drop().iterate();
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).out(new String[]{"out_edges"}).out(new String[]{"edge_property"}).inE(new String[]{"globalUniqueIndex_property"}).drop().iterate();
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).out(new String[]{"out_edges"}).out(new String[]{"edge_property"}).drop().iterate();
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).out(new String[]{"out_edges"}).out(new String[]{"edge_index"}).drop().iterate();
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).out(new String[]{"out_edges"}).drop().iterate();
                traversalSource.V(new Object[]{vs}).out(new String[]{"schema_vertex"}).drop().iterate();
                for (Vertex v : traversalSource.V(new Object[0]).hasLabel("sqlg_schema.globalUniqueIndex", new String[0]).toList()) {
                    if (v.edges(Direction.OUT, new String[]{"globalUniqueIndex_property"}).hasNext()) continue;
                    traversalSource.V(new Object[]{v}).drop().iterate();
                }
                traversalSource.V(new Object[]{vs}).drop().iterate();
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVertexLabel(SqlgGraph sqlgGraph, String schema, String tableName, Map<String, PropertyType> columns) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List schemas = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)schema).toList();
            Preconditions.checkState((!schemas.isEmpty() ? 1 : 0) != 0, (Object)(SCHEMA + schema + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((schemas.size() == 1 ? 1 : 0) != 0, (Object)(MULTIPLE + schema + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((!tableName.startsWith("V_") ? 1 : 0) != 0);
            Vertex schemaVertex = (Vertex)schemas.get(0);
            Vertex vertex = sqlgGraph.addVertex(T.label, "sqlg_schema.vertex", "name", tableName, "schemaVertex", schema + "." + "V_" + tableName, CREATED_ON, LocalDateTime.now());
            schemaVertex.addEdge("schema_vertex", vertex, new Object[0]);
            for (Map.Entry<String, PropertyType> columnEntry : columns.entrySet()) {
                Vertex property = sqlgGraph.addVertex(T.label, "sqlg_schema.property", "name", columnEntry.getKey(), "type", columnEntry.getValue().name(), CREATED_ON, LocalDateTime.now());
                vertex.addEdge("vertex_property", property, new Object[0]);
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeVertexLabel(SqlgGraph sqlgGraph, VertexLabel lbl) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List schemas = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)lbl.getSchema().getName()).toList();
            if (schemas.size() > 0) {
                Vertex schemaVertex = (Vertex)schemas.get(0);
                List vertices = traversalSource.V(new Object[]{schemaVertex}).out(new String[]{"schema_vertex"}).has("name", (Object)lbl.getLabel()).toList();
                if (vertices.size() > 0) {
                    Vertex vertex = (Vertex)vertices.get(0);
                    traversalSource.V(new Object[]{vertex}).out(new String[]{"vertex_property"}).drop().iterate();
                    vertex.remove();
                }
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEdgeLabel(SqlgGraph sqlgGraph, String schema, String prefixedTable, SchemaTable foreignKeyOut, SchemaTable foreignKeyIn, Map<String, PropertyType> columns) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List schemas = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)schema).toList();
            Preconditions.checkState((!schemas.isEmpty() ? 1 : 0) != 0, (Object)(SCHEMA + schema + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((schemas.size() == 1 ? 1 : 0) != 0, (Object)(MULTIPLE + schema + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            Vertex schemaVertex = (Vertex)schemas.get(0);
            List outVertices = traversalSource.V(new Object[]{schemaVertex}).out(new String[]{"schema_vertex"}).has("name", (Object)foreignKeyOut.getTable()).toList();
            Preconditions.checkState((!outVertices.isEmpty() ? 1 : 0) != 0, (Object)("Out vertex " + foreignKeyOut.toString() + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((outVertices.size() == 1 ? 1 : 0) != 0, (Object)("Multiple out vertices " + foreignKeyOut.toString() + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((boolean)prefixedTable.startsWith("E_"));
            Vertex outVertex = (Vertex)outVertices.get(0);
            schemas = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)foreignKeyIn.getSchema()).toList();
            Preconditions.checkState((!schemas.isEmpty() ? 1 : 0) != 0, (Object)(SCHEMA + schema + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((schemas.size() == 1 ? 1 : 0) != 0, (Object)(MULTIPLE + schema + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            Vertex schemaInVertex = (Vertex)schemas.get(0);
            List inVertices = traversalSource.V(new Object[]{schemaInVertex}).out(new String[]{"schema_vertex"}).has("name", (Object)foreignKeyIn.getTable()).toList();
            Preconditions.checkState((!inVertices.isEmpty() ? 1 : 0) != 0, (Object)("In vertex " + foreignKeyIn.toString() + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((inVertices.size() == 1 ? 1 : 0) != 0, (Object)("Multiple in vertices " + foreignKeyIn.toString() + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            Vertex inVertex = (Vertex)inVertices.get(0);
            Vertex edgeVertex = sqlgGraph.addVertex(T.label, "sqlg_schema.edge", "name", prefixedTable.substring("E_".length()), CREATED_ON, LocalDateTime.now());
            outVertex.addEdge("out_edges", edgeVertex, new Object[0]);
            inVertex.addEdge("in_edges", edgeVertex, new Object[0]);
            for (Map.Entry<String, PropertyType> columnEntry : columns.entrySet()) {
                Vertex property = sqlgGraph.addVertex(T.label, "sqlg_schema.property", "name", columnEntry.getKey(), "type", columnEntry.getValue().name(), CREATED_ON, LocalDateTime.now());
                edgeVertex.addEdge("edge_property", property, new Object[0]);
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEdgeLabel(SqlgGraph sqlgGraph, EdgeLabel edge) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List edges = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)edge.getSchema().getName()).out(new String[]{"schema_vertex"}).out(new String[]{"out_edges"}).has("name", (Object)edge.getName()).toList();
            if (edges.size() > 0) {
                Vertex edgeV = (Vertex)edges.get(0);
                traversalSource.V(new Object[]{edgeV}).out(new String[]{"edge_property"}).drop().iterate();
                traversalSource.V(new Object[]{edgeV}).drop().iterate();
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLabelToEdge(SqlgGraph sqlgGraph, String schema, String prefixedTable, boolean in, SchemaTable foreignKey) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List schemas = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)schema).toList();
            Preconditions.checkState((!schemas.isEmpty() ? 1 : 0) != 0, (Object)(SCHEMA + schema + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((schemas.size() == 1 ? 1 : 0) != 0, (Object)(MULTIPLE + schema + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            String foreignKeySchema = foreignKey.getSchema();
            schemas = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)foreignKeySchema).toList();
            Preconditions.checkState((!schemas.isEmpty() ? 1 : 0) != 0, (Object)(SCHEMA + foreignKeySchema + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((schemas.size() == 1 ? 1 : 0) != 0, (Object)(MULTIPLE + foreignKeySchema + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            Vertex foreignKeySchemaVertex = (Vertex)schemas.get(0);
            Preconditions.checkState((boolean)prefixedTable.startsWith("E_"));
            List edgeVertices = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.edge", new String[0]).has("name", (Object)prefixedTable.substring("E_".length())).as("a", new String[0]).in(new String[]{"out_edges"}).in(new String[]{"schema_vertex"}).has("name", (Object)schema).select("a").dedup(new String[0]).toList();
            Preconditions.checkState((!edgeVertices.isEmpty() ? 1 : 0) != 0, (Object)("Edge vertex " + foreignKey.toString() + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((edgeVertices.size() == 1 ? 1 : 0) != 0, (Object)("Multiple edge vertices " + foreignKey.toString() + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            Vertex edgeVertex = (Vertex)edgeVertices.get(0);
            String foreignKeyVertexTable = in ? foreignKey.getTable().substring(0, foreignKey.getTable().length() - "__I".length()) : foreignKey.getTable().substring(0, foreignKey.getTable().length() - "__O".length());
            List foreignKeyVertices = traversalSource.V(new Object[]{foreignKeySchemaVertex}).out(new String[]{"schema_vertex"}).has("name", (Object)foreignKeyVertexTable).toList();
            Preconditions.checkState((!foreignKeyVertices.isEmpty() ? 1 : 0) != 0, (Object)("Out vertex " + foreignKey.toString() + DOES_NOT_EXIST_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((foreignKeyVertices.size() == 1 ? 1 : 0) != 0, (Object)("Multiple out vertices " + foreignKey.toString() + FOUND_IN_SQLG_S_TOPOLOGY_BUG));
            Preconditions.checkState((boolean)prefixedTable.startsWith("E_"));
            Vertex foreignKeyVertex = (Vertex)foreignKeyVertices.get(0);
            if (in) {
                foreignKeyVertex.addEdge("in_edges", edgeVertex, new Object[0]);
            } else {
                foreignKeyVertex.addEdge("out_edges", edgeVertex, new Object[0]);
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVertexColumn(SqlgGraph sqlgGraph, String schema, String prefixedTable, Map.Entry<String, PropertyType> column) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            Preconditions.checkArgument((boolean)prefixedTable.startsWith("V_"), (Object)("prefixedTable must be for a vertex. prefixedTable = " + prefixedTable));
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List vertices = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)schema).out(new String[]{"schema_vertex"}).has("name", (Object)prefixedTable.substring("V_".length())).toList();
            if (vertices.size() == 0) {
                throw new IllegalStateException("Found no vertex for " + schema + "." + prefixedTable);
            }
            if (vertices.size() > 1) {
                throw new IllegalStateException("Found more than one vertex for " + schema + "." + prefixedTable);
            }
            Vertex vertex = (Vertex)vertices.get(0);
            Vertex property = sqlgGraph.addVertex(T.label, "sqlg_schema.property", "name", column.getKey(), "type", column.getValue().name(), CREATED_ON, LocalDateTime.now());
            vertex.addEdge("vertex_property", property, new Object[0]);
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeVertexColumn(SqlgGraph sqlgGraph, String schema, String prefixedTable, String column) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            Preconditions.checkArgument((boolean)prefixedTable.startsWith("V_"), (Object)("prefixedTable must be for a vertex. prefixedTable = " + prefixedTable));
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)schema).out(new String[]{"schema_vertex"}).has("name", (Object)prefixedTable.substring("V_".length())).out(new String[]{"vertex_property"}).has("name", (Object)column).drop().iterate();
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEdgeColumn(SqlgGraph sqlgGraph, String schema, String prefixedTable, String column) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            Preconditions.checkArgument((boolean)prefixedTable.startsWith("E_"), (Object)("prefixedTable must be for an edge. prefixedTable = " + prefixedTable));
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            traversalSource.V(new Object[0]).hasLabel("sqlg_schema.edge", new String[0]).has("name", (Object)prefixedTable.substring("E_".length())).as("a", new String[0]).in(new String[]{"out_edges"}).in(new String[]{"schema_vertex"}).has("name", (Object)schema).select("a").out(new String[]{"edge_property"}).has("name", (Object)column).drop().iterate();
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIndex(SqlgGraph sqlgGraph, Index index) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            AbstractLabel abstractLabel = index.getParentLabel();
            List abstractLabelVertexes = abstractLabel instanceof VertexLabel ? traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)abstractLabel.getSchema().getName()).out(new String[]{"schema_vertex"}).has("name", (Object)abstractLabel.getLabel()).toList() : traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)abstractLabel.getSchema().getName()).out(new String[]{"schema_vertex"}).out(new String[]{"out_edges"}).has("name", (Object)abstractLabel.getLabel()).dedup(new String[0]).toList();
            Preconditions.checkState((!abstractLabelVertexes.isEmpty() ? 1 : 0) != 0, (String)"AbstractLabel %s.%s does not exists", (Object[])new Object[]{abstractLabel.getSchema().getName(), abstractLabel.getLabel()});
            Preconditions.checkState((abstractLabelVertexes.size() == 1 ? 1 : 0) != 0, (String)"BUG: multiple AbstractLabels found for %s.%s", (Object[])new Object[]{abstractLabel.getSchema().getName(), abstractLabel.getLabel()});
            Vertex abstractLabelVertex = (Vertex)abstractLabelVertexes.get(0);
            Vertex indexVertex = sqlgGraph.addVertex(T.label, "sqlg_schema.index", "name", index.getName(), "index_type", index.getIndexType().toString(), CREATED_ON, LocalDateTime.now());
            if (abstractLabel instanceof VertexLabel) {
                abstractLabelVertex.addEdge("vertex_index", indexVertex, new Object[0]);
            } else {
                abstractLabelVertex.addEdge("edge_index", indexVertex, new Object[0]);
            }
            for (PropertyColumn property : index.getProperties()) {
                List propertyVertexes = traversalSource.V(new Object[]{abstractLabelVertex}).out(new String[]{abstractLabel instanceof VertexLabel ? "vertex_property" : "edge_property"}).has("name", (Object)property.getName()).toList();
                Preconditions.checkState((!propertyVertexes.isEmpty() ? 1 : 0) != 0, (String)"Property %s for AbstractLabel %s.%s does not exists", (Object[])new Object[]{property.getName(), abstractLabel.getSchema().getName(), abstractLabel.getLabel()});
                Preconditions.checkState((propertyVertexes.size() == 1 ? 1 : 0) != 0, (String)"BUG: multiple Properties %s found for AbstractLabels found for %s.%s", (Object[])new Object[]{property.getName(), abstractLabel.getSchema().getName(), abstractLabel.getLabel()});
                Vertex propertyVertex = (Vertex)propertyVertexes.get(0);
                indexVertex.addEdge("index_property", propertyVertex, new Object[0]);
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIndex(SqlgGraph sqlgGraph, Index index) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            AbstractLabel abstractLabel = index.getParentLabel();
            List abstractLabelVertexes = abstractLabel instanceof VertexLabel ? traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)abstractLabel.getSchema().getName()).out(new String[]{"schema_vertex"}).has("name", (Object)abstractLabel.getLabel()).toList() : traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)abstractLabel.getSchema().getName()).out(new String[]{"schema_vertex"}).out(new String[]{"out_edges"}).has("name", (Object)abstractLabel.getLabel()).dedup(new String[0]).toList();
            if (abstractLabelVertexes.size() > 0) {
                Vertex v = (Vertex)abstractLabelVertexes.get(0);
                traversalSource.V(new Object[]{v.id()}).out(new String[]{abstractLabel instanceof VertexLabel ? "vertex_index" : "edge_index"}).has("name", (Object)index.getName()).out(new String[]{"index_property"}).drop().iterate();
                traversalSource.V(new Object[]{v.id()}).out(new String[]{abstractLabel instanceof VertexLabel ? "vertex_index" : "edge_index"}).has("name", (Object)index.getName()).drop().iterate();
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIndex(SqlgGraph sqlgGraph, String schema, String label, boolean vertex, String index, IndexType indexType, List<String> properties) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List abstractLabelVertexes = vertex ? traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)schema).out(new String[]{"schema_vertex"}).has("name", (Object)label).toList() : traversalSource.V(new Object[0]).hasLabel("sqlg_schema.schema", new String[0]).has("name", (Object)schema).out(new String[]{"schema_vertex"}).out(new String[]{"out_edges"}).has("name", (Object)label).dedup(new String[0]).toList();
            Preconditions.checkState((!abstractLabelVertexes.isEmpty() ? 1 : 0) != 0, (String)"AbstractLabel %s.%s does not exists", (Object[])new Object[]{schema, label});
            Preconditions.checkState((abstractLabelVertexes.size() == 1 ? 1 : 0) != 0, (String)"BUG: multiple AbstractLabels found for %s.%s", (Object[])new Object[]{schema, label});
            Vertex abstractLabelVertex = (Vertex)abstractLabelVertexes.get(0);
            boolean createdIndexVertex = false;
            Vertex indexVertex = null;
            for (String property : properties) {
                List propertyVertexes = traversalSource.V(new Object[]{abstractLabelVertex}).out(new String[]{vertex ? "vertex_property" : "edge_property"}).has("name", (Object)property).toList();
                if (!createdIndexVertex && !propertyVertexes.isEmpty()) {
                    createdIndexVertex = true;
                    indexVertex = sqlgGraph.addVertex(T.label, "sqlg_schema.index", "name", index, "index_type", indexType.toString(), CREATED_ON, LocalDateTime.now());
                    if (vertex) {
                        abstractLabelVertex.addEdge("vertex_index", indexVertex, new Object[0]);
                    } else {
                        abstractLabelVertex.addEdge("edge_index", indexVertex, new Object[0]);
                    }
                }
                if (propertyVertexes.isEmpty()) continue;
                Preconditions.checkState((propertyVertexes.size() == 1 ? 1 : 0) != 0, (String)"BUG: multiple Properties %s found for AbstractLabels found for %s.%s", (Object[])new Object[]{property, schema, label});
                Preconditions.checkState((indexVertex != null ? 1 : 0) != 0);
                Vertex propertyVertex = (Vertex)propertyVertexes.get(0);
                indexVertex.addEdge("index_property", propertyVertex, new Object[0]);
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    static void addEdgeColumn(SqlgGraph sqlgGraph, String schema, String prefixedTable, Map<String, PropertyType> column) {
        for (Map.Entry<String, PropertyType> stringPropertyTypeEntry : column.entrySet()) {
            TopologyManager.addEdgeColumn(sqlgGraph, schema, prefixedTable, stringPropertyTypeEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEdgeColumn(SqlgGraph sqlgGraph, String schema, String prefixedTable, Map.Entry<String, PropertyType> column) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            Preconditions.checkArgument((boolean)prefixedTable.startsWith("E_"), (Object)("prefixedTable must be for an edge. prefixedTable = " + prefixedTable));
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            Set edges = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.edge", new String[0]).has("name", (Object)prefixedTable.substring("E_".length())).as("a", new String[0]).in(new String[]{"out_edges"}).in(new String[]{"schema_vertex"}).has("name", (Object)schema).select("a").toSet();
            if (edges.size() == 0) {
                throw new IllegalStateException("Found no edge for " + prefixedTable);
            }
            if (edges.size() > 1) {
                throw new IllegalStateException("Found more than one edge for " + prefixedTable);
            }
            Vertex edge = (Vertex)edges.iterator().next();
            Vertex property = sqlgGraph.addVertex(T.label, "sqlg_schema.property", "name", column.getKey(), "type", column.getValue().name(), CREATED_ON, LocalDateTime.now());
            edge.addEdge("edge_property", property, new Object[0]);
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addGlobalUniqueIndex(SqlgGraph sqlgGraph, String globalUniqueIndexName, Set<PropertyColumn> properties) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List uniquePropertyConstraints = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.globalUniqueIndex", new String[0]).has("name", (Object)globalUniqueIndexName).toList();
            if (uniquePropertyConstraints.size() > 0) {
                throw new IllegalStateException("Unique property constraint with name already exists. name = " + globalUniqueIndexName);
            }
            Vertex globalUniquePropertyConstraint = sqlgGraph.addVertex(T.label, "sqlg_schema.globalUniqueIndex", "name", globalUniqueIndexName, CREATED_ON, LocalDateTime.now());
            for (PropertyColumn property : properties) {
                List uniquePropertyConstraintProperty;
                String elementLabel = property.getParentLabel().getLabel();
                if (property.getParentLabel() instanceof VertexLabel) {
                    uniquePropertyConstraintProperty = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.vertex", new String[0]).has("name", (Object)elementLabel).out(new String[]{"vertex_property"}).has("name", (Object)property.getName()).toList();
                } else {
                    Set edges = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.edge", new String[0]).has("name", (Object)elementLabel).as("a", new String[0]).in(new String[]{"out_edges"}).in(new String[]{"schema_vertex"}).has("name", (Object)property.getParentLabel().getSchema().getName()).select("a").toSet();
                    if (edges.size() == 0) {
                        throw new IllegalStateException(String.format("Found no edge for %s.%s", property.getParentLabel().getSchema().getName(), elementLabel));
                    }
                    if (edges.size() > 1) {
                        throw new IllegalStateException(String.format("Found more than one edge for %s.%s", property.getParentLabel().getSchema().getName(), elementLabel));
                    }
                    Vertex edge = (Vertex)edges.iterator().next();
                    uniquePropertyConstraintProperty = traversalSource.V(new Object[]{edge}).out(new String[]{"edge_property"}).has("name", (Object)property.getName()).toList();
                }
                if (uniquePropertyConstraintProperty.size() == 0) {
                    throw new IllegalStateException(String.format("Found no Property for %s.%s.%s", property.getParentLabel().getSchema().getName(), property.getParentLabel().getLabel(), property.getName()));
                }
                Vertex propertyVertex = (Vertex)uniquePropertyConstraintProperty.get(0);
                globalUniquePropertyConstraint.addEdge("globalUniqueIndex_property", propertyVertex, new Object[0]);
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeGlobalUniqueIndex(SqlgGraph sqlgGraph, String globalUniqueIndexName) {
        BatchManager.BatchModeType batchModeType = TopologyManager.flushAndSetTxToNone(sqlgGraph);
        try {
            GraphTraversalSource traversalSource = sqlgGraph.topology();
            List uniquePropertyConstraints = traversalSource.V(new Object[0]).hasLabel("sqlg_schema.globalUniqueIndex", new String[0]).has("name", (Object)globalUniqueIndexName).toList();
            if (uniquePropertyConstraints.size() > 0) {
                traversalSource.V(new Object[]{uniquePropertyConstraints.get(0)}).out(new String[]{"globalUniqueIndex_property"}).drop().iterate();
                traversalSource.V(new Object[]{uniquePropertyConstraints.get(0)}).drop().iterate();
            }
        }
        finally {
            sqlgGraph.tx().batchMode(batchModeType);
        }
    }

    private static BatchManager.BatchModeType flushAndSetTxToNone(SqlgGraph sqlgGraph) {
        BatchManager.BatchModeType batchModeType = sqlgGraph.tx().getBatchModeType();
        if (sqlgGraph.tx().isInBatchMode()) {
            batchModeType = sqlgGraph.tx().getBatchModeType();
            sqlgGraph.tx().flush();
            sqlgGraph.tx().batchMode(BatchManager.BatchModeType.NONE);
        }
        return batchModeType;
    }
}

