/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.WeakHashMap;
import org.umlg.sqlg.structure.BatchManager;
import org.umlg.sqlg.structure.ElementPropertyRollback;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;

class TransactionCache {
    private Connection connection;
    private Map<ElementPropertyRollback, Object> elementPropertyRollbackFunctions = new WeakHashMap<ElementPropertyRollback, Object>();
    private BatchManager batchManager;
    private boolean cacheVertices = false;
    private Map<RecordId, SqlgVertex> vertexCache = new WeakHashMap<RecordId, SqlgVertex>();
    private boolean lazyQueries;

    static TransactionCache of(boolean cacheVertices, Connection connection, BatchManager batchManager, boolean lazyQueries) {
        return new TransactionCache(cacheVertices, connection, batchManager, lazyQueries);
    }

    private TransactionCache(boolean cacheVertices, Connection connection, BatchManager batchManager, boolean lazyQueries) {
        this.cacheVertices = cacheVertices;
        this.connection = connection;
        this.batchManager = batchManager;
        this.lazyQueries = lazyQueries;
    }

    Connection getConnection() {
        return this.connection;
    }

    Map<ElementPropertyRollback, Object> getElementPropertyRollback() {
        return this.elementPropertyRollbackFunctions;
    }

    BatchManager getBatchManager() {
        return this.batchManager;
    }

    void clear() {
        this.elementPropertyRollbackFunctions.clear();
        this.batchManager.clear();
        if (this.cacheVertices) {
            this.vertexCache.clear();
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    SqlgVertex putVertexIfAbsent(SqlgGraph sqlgGraph, String schema, String table, Long id) {
        SqlgVertex sqlgVertex;
        RecordId recordId = RecordId.from(SchemaTable.of(schema, table), id);
        if (this.cacheVertices) {
            sqlgVertex = this.vertexCache.get(recordId);
            if (sqlgVertex == null) {
                sqlgVertex = new SqlgVertex(sqlgGraph, id, schema, table);
                this.vertexCache.put(recordId, sqlgVertex);
                return sqlgVertex;
            }
        } else {
            sqlgVertex = new SqlgVertex(sqlgGraph, id, schema, table);
        }
        return sqlgVertex;
    }

    SqlgVertex putVertexIfAbsent(SqlgVertex sqlgVertex) {
        RecordId vertexRecordId = (RecordId)sqlgVertex.id();
        if (this.cacheVertices) {
            SqlgVertex sqlgVertexFromCache = this.vertexCache.get(vertexRecordId);
            if (sqlgVertexFromCache == null) {
                SchemaTable schemaTable = vertexRecordId.getSchemaTable();
                RecordId recordId = RecordId.from(SchemaTable.of(schemaTable.getSchema(), schemaTable.getTable()), vertexRecordId.getId());
                this.vertexCache.put(recordId, sqlgVertex);
                return sqlgVertex;
            }
            return sqlgVertexFromCache;
        }
        return sqlgVertex;
    }

    void add(SqlgVertex sqlgVertex) {
        RecordId vertexRecordId = (RecordId)sqlgVertex.id();
        if (this.vertexCache.containsKey(vertexRecordId)) {
            throw new IllegalStateException("The vertex cache should never already contain a new vertex!");
        }
        SchemaTable schemaTable = vertexRecordId.getSchemaTable();
        RecordId recordId = RecordId.from(SchemaTable.of(schemaTable.getSchema(), schemaTable.getTable()), vertexRecordId.getId());
        this.vertexCache.put(recordId, sqlgVertex);
    }

    public boolean isLazyQueries() {
        return this.lazyQueries;
    }

    public void setLazyQueries(boolean lazyQueries) {
        this.lazyQueries = lazyQueries;
    }
}

