/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.structure.AbstractLabel;
import org.umlg.sqlg.structure.EdgeLabel;
import org.umlg.sqlg.structure.EdgeRole;
import org.umlg.sqlg.structure.Index;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.Schema;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.structure.TopologyChangeAction;
import org.umlg.sqlg.structure.TopologyManager;

public class VertexLabel
extends AbstractLabel {
    private Logger logger = LoggerFactory.getLogger((String)VertexLabel.class.getName());
    private Schema schema;
    Map<String, EdgeLabel> inEdgeLabels = new HashMap<String, EdgeLabel>();
    Map<String, EdgeLabel> outEdgeLabels = new HashMap<String, EdgeLabel>();
    private Map<String, EdgeLabel> uncommittedInEdgeLabels = new HashMap<String, EdgeLabel>();
    private Map<String, EdgeLabel> uncommittedOutEdgeLabels = new HashMap<String, EdgeLabel>();
    private Map<String, EdgeRemoveType> uncommittedRemovedInEdgeLabels = new HashMap<String, EdgeRemoveType>();
    private Map<String, EdgeRemoveType> uncommittedRemovedOutEdgeLabels = new HashMap<String, EdgeRemoveType>();

    static VertexLabel createSqlgSchemaVertexLabel(Schema schema, String label, Map<String, PropertyType> columns) {
        Preconditions.checkArgument((boolean)schema.isSqlgSchema(), (String)"createSqlgSchemaVertexLabel may only be called for \"%s\"", (Object[])new Object[]{"sqlg_schema"});
        VertexLabel vertexLabel = new VertexLabel(schema, label);
        for (Map.Entry<String, PropertyType> propertyEntry : columns.entrySet()) {
            PropertyColumn property = new PropertyColumn(vertexLabel, propertyEntry.getKey(), propertyEntry.getValue());
            vertexLabel.properties.put(propertyEntry.getKey(), property);
        }
        return vertexLabel;
    }

    static VertexLabel createVertexLabel(SqlgGraph sqlgGraph, Schema schema, String label, Map<String, PropertyType> columns) {
        Preconditions.checkArgument((!schema.isSqlgSchema() ? 1 : 0) != 0, (String)"createVertexLabel may not be called for \"%s\"", (Object[])new Object[]{"sqlg_schema"});
        VertexLabel vertexLabel = new VertexLabel(schema, label, columns);
        vertexLabel.createVertexLabelOnDb(columns);
        TopologyManager.addVertexLabel(sqlgGraph, schema.getName(), label, columns);
        vertexLabel.committed = false;
        return vertexLabel;
    }

    VertexLabel(Schema schema, String label) {
        super(schema.getSqlgGraph(), label);
        this.schema = schema;
    }

    private VertexLabel(Schema schema, String label, Map<String, PropertyType> properties) {
        super(schema.getSqlgGraph(), label, properties);
        this.schema = schema;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public Map<String, EdgeLabel> getInEdgeLabels() {
        HashMap<String, EdgeLabel> result = new HashMap<String, EdgeLabel>();
        result.putAll(this.inEdgeLabels);
        if (this.schema.getTopology().isWriteLockHeldByCurrentThread()) {
            result.putAll(this.uncommittedInEdgeLabels);
            for (String e : this.uncommittedRemovedInEdgeLabels.keySet()) {
                result.remove(e);
            }
        }
        return result;
    }

    public Map<String, EdgeLabel> getOutEdgeLabels() {
        HashMap<String, EdgeLabel> result = new HashMap<String, EdgeLabel>();
        result.putAll(this.outEdgeLabels);
        if (this.schema.getTopology().isWriteLockHeldByCurrentThread()) {
            result.putAll(this.uncommittedOutEdgeLabels);
            for (String e : this.uncommittedRemovedOutEdgeLabels.keySet()) {
                result.remove(e);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, EdgeRole> getInEdgeRoles() {
        HashMap<String, EdgeRole> result = new HashMap<String, EdgeRole>();
        for (String k : this.inEdgeLabels.keySet()) {
            result.put(k, new EdgeRole(this, this.inEdgeLabels.get(k), Direction.IN, true));
        }
        if (this.schema.getTopology().isWriteLockHeldByCurrentThread()) {
            for (String k : this.uncommittedInEdgeLabels.keySet()) {
                result.put(k, new EdgeRole(this, this.uncommittedInEdgeLabels.get(k), Direction.IN, false));
            }
            for (String e : this.uncommittedRemovedInEdgeLabels.keySet()) {
                result.remove(e);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, EdgeRole> getOutEdgeRoles() {
        HashMap<String, EdgeRole> result = new HashMap<String, EdgeRole>();
        for (String k : this.outEdgeLabels.keySet()) {
            result.put(k, new EdgeRole(this, this.outEdgeLabels.get(k), Direction.OUT, true));
        }
        if (this.schema.getTopology().isWriteLockHeldByCurrentThread()) {
            for (String k : this.uncommittedOutEdgeLabels.keySet()) {
                result.put(k, new EdgeRole(this, this.uncommittedOutEdgeLabels.get(k), Direction.OUT, false));
            }
            for (String e : this.uncommittedRemovedOutEdgeLabels.keySet()) {
                result.remove(e);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public Optional<EdgeLabel> getOutEdgeLabel(String edgeLabelName) {
        EdgeLabel edgeLabel = this.getOutEdgeLabels().get(this.schema.getName() + "." + edgeLabelName);
        if (edgeLabel != null) {
            return Optional.of(edgeLabel);
        }
        return Optional.empty();
    }

    Map<String, EdgeLabel> getUncommittedOutEdgeLabels() {
        if (this.schema.getTopology().isWriteLockHeldByCurrentThread()) {
            HashMap<String, EdgeLabel> result = new HashMap<String, EdgeLabel>();
            result.putAll(this.uncommittedOutEdgeLabels);
            for (EdgeLabel outEdgeLabel : this.outEdgeLabels.values()) {
                Map<String, PropertyColumn> propertyMap = outEdgeLabel.getUncommittedPropertyTypeMap();
                if (propertyMap.isEmpty() && outEdgeLabel.getUncommittedRemovedProperties().isEmpty()) continue;
                result.put(outEdgeLabel.getLabel(), outEdgeLabel);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    Optional<EdgeLabel> getUncommittedOutEdgeLabel(String edgeLabelName) {
        EdgeLabel edgeLabel;
        if (this.schema.getTopology().isWriteLockHeldByCurrentThread() && (edgeLabel = this.getUncommittedOutEdgeLabels().get(edgeLabelName)) != null) {
            return Optional.of(edgeLabel);
        }
        return Optional.empty();
    }

    void addToUncommittedInEdgeLabels(Schema schema, EdgeLabel edgeLabel) {
        this.uncommittedInEdgeLabels.put(schema.getName() + "." + edgeLabel.getLabel(), edgeLabel);
    }

    void addToUncommittedOutEdgeLabels(Schema schema, EdgeLabel edgeLabel) {
        this.uncommittedOutEdgeLabels.put(schema.getName() + "." + edgeLabel.getLabel(), edgeLabel);
    }

    EdgeLabel loadSqlgSchemaEdgeLabel(String edgeLabelName, VertexLabel inVertexLabel, Map<String, PropertyType> properties) {
        Preconditions.checkState((boolean)this.schema.isSqlgSchema(), (String)"loadSqlgSchemaEdgeLabel must be called for \"%s\" found \"%s\"", (Object[])new Object[]{"sqlg_schema", this.schema.getName()});
        EdgeLabel edgeLabel = EdgeLabel.loadSqlgSchemaEdgeLabel(edgeLabelName, this, inVertexLabel, properties);
        this.outEdgeLabels.put(this.schema.getName() + "." + edgeLabel.getLabel(), edgeLabel);
        inVertexLabel.inEdgeLabels.put(this.schema.getName() + "." + edgeLabel.getLabel(), edgeLabel);
        return edgeLabel;
    }

    public EdgeLabel ensureEdgeLabelExist(String edgeLabelName, VertexLabel inVertexLabel) {
        return this.getSchema().ensureEdgeLabelExist(edgeLabelName, this, inVertexLabel, Collections.emptyMap());
    }

    public EdgeLabel ensureEdgeLabelExist(String edgeLabelName, VertexLabel inVertexLabel, Map<String, PropertyType> properties) {
        return this.getSchema().ensureEdgeLabelExist(edgeLabelName, this, inVertexLabel, properties);
    }

    EdgeLabel addEdgeLabel(String edgeLabelName, VertexLabel inVertexLabel, Map<String, PropertyType> properties) {
        EdgeLabel edgeLabel = EdgeLabel.createEdgeLabel(edgeLabelName, this, inVertexLabel, properties);
        if (this.schema.isSqlgSchema()) {
            this.outEdgeLabels.put(this.schema.getName() + "." + edgeLabel.getLabel(), edgeLabel);
            inVertexLabel.inEdgeLabels.put(this.schema.getName() + "." + edgeLabel.getLabel(), edgeLabel);
        } else {
            this.uncommittedOutEdgeLabels.put(this.schema.getName() + "." + edgeLabel.getLabel(), edgeLabel);
            inVertexLabel.uncommittedInEdgeLabels.put(this.schema.getName() + "." + edgeLabel.getLabel(), edgeLabel);
        }
        return edgeLabel;
    }

    public void ensurePropertiesExist(Map<String, PropertyType> columns) {
        for (Map.Entry<String, PropertyType> column : columns.entrySet()) {
            if (this.properties.containsKey(column.getKey())) continue;
            Preconditions.checkState((!this.schema.isSqlgSchema() ? 1 : 0) != 0, (String)"schema may not be %s", (Object[])new Object[]{"sqlg_schema"});
            if (this.uncommittedProperties.containsKey(column.getKey())) continue;
            this.schema.getTopology().lock();
            if (this.uncommittedProperties.containsKey(column.getKey())) continue;
            TopologyManager.addVertexColumn(this.sqlgGraph, this.schema.getName(), "V_" + this.getLabel(), column);
            this.addColumn(this.schema.getName(), "V_" + this.getLabel(), (ImmutablePair<String, PropertyType>)ImmutablePair.of((Object)column.getKey(), (Object)((Object)column.getValue())));
            PropertyColumn propertyColumn = new PropertyColumn(this, column.getKey(), column.getValue());
            propertyColumn.setCommitted(false);
            this.uncommittedProperties.put(column.getKey(), propertyColumn);
            this.getSchema().getTopology().fire(propertyColumn, "", TopologyChangeAction.CREATE);
        }
    }

    private void createVertexLabelOnDb(Map<String, PropertyType> columns) {
        StringBuilder sql = new StringBuilder(this.sqlgGraph.getSqlDialect().createTableStatement());
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.schema.getName()));
        sql.append(".");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("V_" + this.getLabel()));
        sql.append(" (");
        sql.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes("ID"));
        sql.append(" ");
        sql.append(this.sqlgGraph.getSqlDialect().getAutoIncrementPrimaryKeyConstruct());
        if (columns.size() > 0) {
            sql.append(", ");
        }
        VertexLabel.buildColumns(this.sqlgGraph, columns, sql);
        sql.append(")");
        if (this.sqlgGraph.getSqlDialect().needsSemicolon()) {
            sql.append(";");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    Pair<Set<SchemaTable>, Set<SchemaTable>> getTableLabels() {
        HashSet<SchemaTable> inSchemaTables = new HashSet<SchemaTable>();
        HashSet<SchemaTable> outSchemaTables = new HashSet<SchemaTable>();
        for (EdgeLabel inEdgeLabel : this.inEdgeLabels.values()) {
            inSchemaTables.add(SchemaTable.of(inEdgeLabel.getSchema().getName(), "E_" + inEdgeLabel.getLabel()));
        }
        for (EdgeLabel outEdgeLabel : this.outEdgeLabels.values()) {
            outSchemaTables.add(SchemaTable.of(outEdgeLabel.getSchema().getName(), "E_" + outEdgeLabel.getLabel()));
        }
        if (this.schema.getTopology().isWriteLockHeldByCurrentThread()) {
            for (EdgeLabel inEdgeLabel : this.uncommittedInEdgeLabels.values()) {
                inSchemaTables.add(SchemaTable.of(inEdgeLabel.getSchema().getName(), "E_" + inEdgeLabel.getLabel()));
            }
            for (EdgeLabel outEdgeLabel : this.uncommittedOutEdgeLabels.values()) {
                outSchemaTables.add(SchemaTable.of(outEdgeLabel.getSchema().getName(), "E_" + outEdgeLabel.getLabel()));
            }
        }
        return Pair.of(inSchemaTables, outSchemaTables);
    }

    @Override
    void afterCommit() {
        EdgeLabel lbl;
        String s;
        EdgeLabel edgeLabel;
        String edgeLabelName;
        Map.Entry<String, EdgeLabel> edgeLabelEntry;
        Preconditions.checkState((boolean)this.schema.getTopology().isWriteLockHeldByCurrentThread(), (Object)"VertexLabel.afterCommit must hold the write lock");
        super.afterCommit();
        Iterator<Map.Entry<String, EdgeLabel>> edgeLabelEntryIter = this.uncommittedOutEdgeLabels.entrySet().iterator();
        while (edgeLabelEntryIter.hasNext()) {
            edgeLabelEntry = edgeLabelEntryIter.next();
            edgeLabelName = edgeLabelEntry.getKey();
            edgeLabel = edgeLabelEntry.getValue();
            this.outEdgeLabels.put(edgeLabelName, edgeLabel);
            edgeLabel.afterCommit();
            this.getSchema().addToAllEdgeCache(edgeLabel);
            edgeLabelEntryIter.remove();
        }
        edgeLabelEntryIter = this.uncommittedInEdgeLabels.entrySet().iterator();
        while (edgeLabelEntryIter.hasNext()) {
            edgeLabelEntry = edgeLabelEntryIter.next();
            edgeLabelName = edgeLabelEntry.getKey();
            edgeLabel = edgeLabelEntry.getValue();
            this.inEdgeLabels.put(edgeLabelName, edgeLabel);
            edgeLabel.afterCommit();
            edgeLabelEntryIter.remove();
        }
        Iterator<String> it = this.uncommittedRemovedOutEdgeLabels.keySet().iterator();
        while (it.hasNext()) {
            s = it.next();
            lbl = this.outEdgeLabels.remove(s);
            if (lbl != null) {
                this.getSchema().getTopology().removeFromEdgeForeignKeyCache(lbl.getSchema().getName() + "." + "E_" + lbl.getLabel(), this.getSchema().getName() + "." + this.getLabel() + "__O");
                this.getSchema().getTopology().removeOutForeignKeysFromVertexLabel(this, lbl);
            }
            it.remove();
        }
        it = this.uncommittedRemovedInEdgeLabels.keySet().iterator();
        while (it.hasNext()) {
            s = it.next();
            lbl = this.inEdgeLabels.remove(s);
            if (lbl != null) {
                this.getSchema().getTopology().removeFromEdgeForeignKeyCache(lbl.getSchema().getName() + "." + "E_" + lbl.getLabel(), this.getSchema().getName() + "." + this.getLabel() + "__I");
                this.getSchema().getTopology().removeInForeignKeysFromVertexLabel(this, lbl);
            }
            it.remove();
        }
        for (EdgeLabel edgeLabel2 : this.outEdgeLabels.values()) {
            edgeLabel2.afterCommit();
        }
        for (EdgeLabel edgeLabel2 : this.inEdgeLabels.values()) {
            edgeLabel2.afterCommit();
        }
    }

    void afterRollbackForInEdges() {
        Preconditions.checkState((boolean)this.schema.getTopology().isWriteLockHeldByCurrentThread(), (Object)"VertexLabel.afterRollback must hold the write lock");
        super.afterRollback();
        Iterator<EdgeLabel> it = this.uncommittedInEdgeLabels.values().iterator();
        while (it.hasNext()) {
            EdgeLabel edgeLabel = it.next();
            edgeLabel.afterRollbackInEdges(this);
            it.remove();
        }
    }

    void afterRollbackForOutEdges() {
        Preconditions.checkState((boolean)this.schema.getTopology().isWriteLockHeldByCurrentThread(), (Object)"VertexLabel.afterRollback must hold the write lock");
        super.afterRollback();
        Iterator<EdgeLabel> it = this.uncommittedOutEdgeLabels.values().iterator();
        while (it.hasNext()) {
            EdgeLabel edgeLabel = it.next();
            it.remove();
            edgeLabel.afterRollbackOutEdges(this);
        }
        for (EdgeLabel edgeLabel : this.outEdgeLabels.values()) {
            edgeLabel.afterRollbackOutEdges(this);
        }
    }

    public String toString() {
        return this.toJson().toString();
    }

    void addToOutEdgeLabels(String schema, EdgeLabel edgeLabel) {
        edgeLabel.addToOutVertexLabel(this);
        this.outEdgeLabels.put(schema + "." + edgeLabel.getLabel(), edgeLabel);
    }

    void addToInEdgeLabels(EdgeLabel edgeLabel) {
        edgeLabel.addToInVertexLabel(this);
        this.inEdgeLabels.put(edgeLabel.getSchema().getName() + "." + edgeLabel.getLabel(), edgeLabel);
    }

    @Override
    protected JsonNode toJson() {
        ObjectNode vertexLabelNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        vertexLabelNode.put("schema", this.getSchema().getName());
        vertexLabelNode.put("label", this.getLabel());
        vertexLabelNode.set("properties", super.toJson());
        ArrayNode outEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (EdgeLabel edgeLabel : this.outEdgeLabels.values()) {
            outEdgeLabelsArrayNode.add(edgeLabel.toJson());
        }
        vertexLabelNode.set("outEdgeLabels", (JsonNode)outEdgeLabelsArrayNode);
        ArrayNode inEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        for (EdgeLabel edgeLabel : this.inEdgeLabels.values()) {
            inEdgeLabelsArrayNode.add(edgeLabel.toJson());
        }
        vertexLabelNode.set("inEdgeLabels", (JsonNode)inEdgeLabelsArrayNode);
        if (this.schema.getTopology().isWriteLockHeldByCurrentThread()) {
            outEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (EdgeLabel edgeLabel : this.uncommittedOutEdgeLabels.values()) {
                outEdgeLabelsArrayNode.add(edgeLabel.toJson());
            }
            vertexLabelNode.set("uncommittedOutEdgeLabels", (JsonNode)outEdgeLabelsArrayNode);
            inEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (EdgeLabel edgeLabel : this.uncommittedInEdgeLabels.values()) {
                inEdgeLabelsArrayNode.add(edgeLabel.toJson());
            }
            vertexLabelNode.set("uncommittedInEdgeLabels", (JsonNode)inEdgeLabelsArrayNode);
        }
        return vertexLabelNode;
    }

    @Override
    protected Optional<JsonNode> toNotifyJson() {
        ObjectNode edgeRemove;
        Optional<JsonNode> jsonNodeOptional;
        ArrayNode outEdgeLabelsArrayNode;
        ObjectNode vertexLabelNode = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
        vertexLabelNode.put("label", this.getLabel());
        Optional<JsonNode> abstractLabelNode = super.toNotifyJson();
        if (abstractLabelNode.isPresent()) {
            vertexLabelNode.set("uncommittedProperties", abstractLabelNode.get().get("uncommittedProperties"));
            vertexLabelNode.set("uncommittedIndexes", abstractLabelNode.get().get("uncommittedIndexes"));
            vertexLabelNode.set("uncommittedRemovedProperties", abstractLabelNode.get().get("uncommittedRemovedProperties"));
            vertexLabelNode.set("uncommittedRemovedIndexes", abstractLabelNode.get().get("uncommittedRemovedIndexes"));
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedOutEdgeLabels.isEmpty()) {
            outEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (EdgeLabel edgeLabel : this.uncommittedOutEdgeLabels.values()) {
                jsonNodeOptional = edgeLabel.toNotifyJson();
                Preconditions.checkState((boolean)jsonNodeOptional.isPresent(), (Object)"There must be data to notify as the edgeLabel itself is uncommitted");
                outEdgeLabelsArrayNode.add(jsonNodeOptional.get());
            }
            vertexLabelNode.set("uncommittedOutEdgeLabels", (JsonNode)outEdgeLabelsArrayNode);
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedRemovedOutEdgeLabels.isEmpty()) {
            outEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (String string : this.uncommittedRemovedOutEdgeLabels.keySet()) {
                edgeRemove = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
                edgeRemove.put("label", string);
                edgeRemove.put("type", this.uncommittedRemovedOutEdgeLabels.get(string).toString());
                outEdgeLabelsArrayNode.add((JsonNode)edgeRemove);
            }
            vertexLabelNode.set("uncommittedRemovedOutEdgeLabels", (JsonNode)outEdgeLabelsArrayNode);
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedInEdgeLabels.isEmpty()) {
            ArrayNode inEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (EdgeLabel edgeLabel : this.uncommittedInEdgeLabels.values()) {
                jsonNodeOptional = edgeLabel.toNotifyJson();
                Preconditions.checkState((boolean)jsonNodeOptional.isPresent(), (Object)"There must be data to notify as the edgeLabel itself is uncommitted");
                inEdgeLabelsArrayNode.add(jsonNodeOptional.get());
            }
            vertexLabelNode.set("uncommittedInEdgeLabels", (JsonNode)inEdgeLabelsArrayNode);
        }
        if (this.getSchema().getTopology().isWriteLockHeldByCurrentThread() && !this.uncommittedRemovedInEdgeLabels.isEmpty()) {
            outEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
            for (String string : this.uncommittedRemovedInEdgeLabels.keySet()) {
                edgeRemove = new ObjectNode(Topology.OBJECT_MAPPER.getNodeFactory());
                edgeRemove.put("label", string);
                edgeRemove.put("type", this.uncommittedRemovedInEdgeLabels.get(string).toString());
                outEdgeLabelsArrayNode.add((JsonNode)edgeRemove);
            }
            vertexLabelNode.set("uncommittedRemovedInEdgeLabels", (JsonNode)outEdgeLabelsArrayNode);
        }
        outEdgeLabelsArrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        boolean foundOutEdgeLabel = false;
        for (EdgeLabel edgeLabel : this.outEdgeLabels.values()) {
            Optional<JsonNode> jsonNodeOptional2 = edgeLabel.toNotifyJson();
            if (!jsonNodeOptional2.isPresent()) continue;
            foundOutEdgeLabel = true;
            outEdgeLabelsArrayNode.add(jsonNodeOptional2.get());
        }
        if (foundOutEdgeLabel) {
            vertexLabelNode.set("outEdgeLabels", (JsonNode)outEdgeLabelsArrayNode);
        }
        ArrayNode arrayNode = new ArrayNode(Topology.OBJECT_MAPPER.getNodeFactory());
        boolean foundInEdgeLabels = false;
        for (EdgeLabel edgeLabel : this.inEdgeLabels.values()) {
            Optional<JsonNode> jsonNodeOptional3 = edgeLabel.toNotifyJson();
            if (!jsonNodeOptional3.isPresent()) continue;
            foundInEdgeLabels = true;
            arrayNode.add(jsonNodeOptional3.get());
        }
        if (foundInEdgeLabels) {
            vertexLabelNode.set("inEdgeLabels", (JsonNode)arrayNode);
        }
        return Optional.of(vertexLabelNode);
    }

    void fromNotifyJsonOutEdge(JsonNode vertexLabelJson, boolean fire) {
        super.fromPropertyNotifyJson(vertexLabelJson, fire);
        for (String s : Arrays.asList("uncommittedOutEdgeLabels", "outEdgeLabels")) {
            ArrayNode uncommittedOutEdgeLabels = (ArrayNode)vertexLabelJson.get(s);
            if (uncommittedOutEdgeLabels == null) continue;
            for (JsonNode uncommittedOutEdgeLabel : uncommittedOutEdgeLabels) {
                String schemaName = uncommittedOutEdgeLabel.get("schema").asText();
                Preconditions.checkState((boolean)schemaName.equals(this.getSchema().getName()), (Object)"out edges must be for the same schema that the edge specifies");
                String edgeLabelName = uncommittedOutEdgeLabel.get("label").asText();
                Optional<EdgeLabel> edgeLabelOptional = this.schema.getEdgeLabel(edgeLabelName);
                EdgeLabel edgeLabel = !edgeLabelOptional.isPresent() ? new EdgeLabel(this.getSchema().getTopology(), edgeLabelName) : edgeLabelOptional.get();
                edgeLabel.addToOutVertexLabel(this);
                this.outEdgeLabels.put(schemaName + "." + edgeLabel.getLabel(), edgeLabel);
                edgeLabel.fromPropertyNotifyJson(uncommittedOutEdgeLabel, edgeLabelOptional.isPresent());
                this.getSchema().getTopology().addToAllTables(this.getSchema().getName() + "." + "E_" + edgeLabel.getLabel(), edgeLabel.getPropertyTypeMap());
                this.getSchema().addToAllEdgeCache(edgeLabel);
                this.getSchema().getTopology().addOutForeignKeysToVertexLabel(this, edgeLabel);
                this.getSchema().getTopology().addToEdgeForeignKeyCache(this.getSchema().getName() + "." + "E_" + edgeLabel.getLabel(), this.getSchema().getName() + "." + this.getLabel() + "__O");
                if (edgeLabelOptional.isPresent()) continue;
                this.getSchema().getTopology().fire(edgeLabel, "", TopologyChangeAction.CREATE);
            }
        }
        ArrayNode uncommittedRemoveOutEdgeLabels = (ArrayNode)vertexLabelJson.get("uncommittedRemovedOutEdgeLabels");
        if (uncommittedRemoveOutEdgeLabels != null) {
            for (JsonNode n : uncommittedRemoveOutEdgeLabels) {
                EdgeLabel lbl = this.outEdgeLabels.remove(n.get("label").asText());
                if (lbl == null) continue;
                EdgeRemoveType ert = EdgeRemoveType.valueOf(n.get("type").asText());
                this.getSchema().getTopology().removeFromEdgeForeignKeyCache(lbl.getSchema().getName() + "." + "E_" + lbl.getLabel(), this.getSchema().getName() + "." + this.getLabel() + "__O");
                this.getSchema().getTopology().removeOutForeignKeysFromVertexLabel(this, lbl);
                lbl.outVertexLabels.remove(this);
                switch (ert) {
                    case LABEL: {
                        this.getSchema().getTopology().fire(lbl, "", TopologyChangeAction.DELETE);
                        break;
                    }
                    case ROLE: {
                        this.getSchema().getTopology().fire(new EdgeRole(this, lbl, Direction.OUT, true), "", TopologyChangeAction.DELETE);
                        break;
                    }
                }
            }
        }
    }

    void fromNotifyJsonInEdge(JsonNode vertexLabelJson) {
        for (String s : Arrays.asList("uncommittedInEdgeLabels", "inEdgeLabels")) {
            ArrayNode uncommittedInEdgeLabels = (ArrayNode)vertexLabelJson.get(s);
            if (uncommittedInEdgeLabels == null) continue;
            for (JsonNode uncommittedInEdgeLabel : uncommittedInEdgeLabels) {
                String schemaName = uncommittedInEdgeLabel.get("schema").asText();
                String edgeLabelName = uncommittedInEdgeLabel.get("label").asText();
                Optional<Schema> schemaOptional = this.getSchema().getTopology().getSchema(schemaName);
                Preconditions.checkState((boolean)schemaOptional.isPresent(), (String)"Schema %s must be present", (Object[])new Object[]{schemaName});
                Optional<EdgeLabel> edgeLabelOptional = schemaOptional.get().getEdgeLabel(edgeLabelName);
                Preconditions.checkState((boolean)edgeLabelOptional.isPresent(), (String)"edge label must be present as the in can not be there without the out. EdgeLabel: %s", (Object[])new Object[]{edgeLabelName});
                EdgeLabel edgeLabel = edgeLabelOptional.get();
                edgeLabel.addToInVertexLabel(this);
                this.inEdgeLabels.put(schemaName + "." + edgeLabel.getLabel(), edgeLabel);
                edgeLabel.fromPropertyNotifyJson(uncommittedInEdgeLabel, false);
                this.getSchema().getTopology().addInForeignKeysToVertexLabel(this, edgeLabel);
                this.getSchema().getTopology().addToEdgeForeignKeyCache(edgeLabel.getSchema().getName() + "." + "E_" + edgeLabel.getLabel(), this.getSchema().getName() + "." + this.getLabel() + "__I");
            }
        }
        ArrayNode uncommittedRemoveInEdgeLabels = (ArrayNode)vertexLabelJson.get("uncommittedRemovedInEdgeLabels");
        if (uncommittedRemoveInEdgeLabels != null) {
            for (JsonNode n : uncommittedRemoveInEdgeLabels) {
                EdgeLabel lbl = this.inEdgeLabels.remove(n.get("label").asText());
                if (lbl == null) continue;
                EdgeRemoveType ert = EdgeRemoveType.valueOf(n.get("type").asText());
                if (lbl.isValid()) {
                    this.getSchema().getTopology().removeFromEdgeForeignKeyCache(lbl.getSchema().getName() + "." + "E_" + lbl.getLabel(), this.getSchema().getName() + "." + this.getLabel() + "__I");
                    this.getSchema().getTopology().removeInForeignKeysFromVertexLabel(this, lbl);
                }
                lbl.inVertexLabels.remove(this);
                switch (ert) {
                    case LABEL: {
                        this.getSchema().getTopology().fire(lbl, "", TopologyChangeAction.DELETE);
                        break;
                    }
                    case ROLE: {
                        this.getSchema().getTopology().fire(new EdgeRole(this, lbl, Direction.IN, true), "", TopologyChangeAction.DELETE);
                    }
                }
            }
        }
    }

    public int hashCode() {
        return (this.schema.getName() + this.getLabel()).hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof VertexLabel)) {
            return false;
        }
        VertexLabel otherVertexLabel = (VertexLabel)other;
        return this.schema.equals(otherVertexLabel.getSchema()) && super.equals(otherVertexLabel);
    }

    boolean deepEquals(VertexLabel other) {
        Preconditions.checkState((boolean)this.equals(other), (Object)"deepEquals is only called after equals has succeeded");
        if (!this.outEdgeLabels.equals(other.outEdgeLabels)) {
            return false;
        }
        if (this.outEdgeLabels.size() != other.outEdgeLabels.size()) {
            return false;
        }
        for (EdgeLabel outEdgeLabel : this.outEdgeLabels.values()) {
            for (EdgeLabel otherOutEdgeLabel : other.outEdgeLabels.values()) {
                if (!outEdgeLabel.equals(otherOutEdgeLabel) || outEdgeLabel.deepEquals(otherOutEdgeLabel)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Topology.TopologyValidationError> validateTopology(DatabaseMetaData metadata) throws SQLException {
        ArrayList<Topology.TopologyValidationError> validationErrors = new ArrayList<Topology.TopologyValidationError>();
        for (PropertyColumn propertyColumn : this.getProperties().values()) {
            ResultSet propertyRs = metadata.getColumns(null, this.getSchema().getName(), "V_" + this.getLabel(), propertyColumn.getName());
            Throwable throwable = null;
            try {
                if (propertyRs.next()) continue;
                validationErrors.add(new Topology.TopologyValidationError(propertyColumn));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (propertyRs == null) continue;
                if (throwable != null) {
                    try {
                        propertyRs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                propertyRs.close();
            }
        }
        for (Index index : this.getIndexes().values()) {
            validationErrors.addAll(index.validateTopology(metadata));
        }
        return validationErrors;
    }

    @Override
    protected String getPrefix() {
        return "V_";
    }

    Pair<Set<SchemaTable>, Set<SchemaTable>> getUncommittedSchemaTableForeignKeys() {
        Pair result = Pair.of(new HashSet(), new HashSet());
        for (Map.Entry<String, EdgeLabel> uncommittedEdgeLabelEntry : this.uncommittedOutEdgeLabels.entrySet()) {
            ((Set)result.getRight()).add(SchemaTable.of(this.getSchema().getName(), "E_" + uncommittedEdgeLabelEntry.getValue().getLabel()));
        }
        for (Map.Entry<String, EdgeLabel> uncommittedEdgeLabelEntry : this.uncommittedInEdgeLabels.entrySet()) {
            ((Set)result.getLeft()).add(SchemaTable.of(uncommittedEdgeLabelEntry.getValue().getSchema().getName(), "E_" + uncommittedEdgeLabelEntry.getValue().getLabel()));
        }
        return result;
    }

    @Override
    void removeProperty(PropertyColumn propertyColumn, boolean preserveData) {
        this.getSchema().getTopology().lock();
        if (!this.uncommittedRemovedProperties.contains(propertyColumn.getName())) {
            this.uncommittedRemovedProperties.add(propertyColumn.getName());
            TopologyManager.removeVertexColumn(this.sqlgGraph, this.schema.getName(), "V_" + this.getLabel(), propertyColumn.getName());
            if (!preserveData) {
                this.removeColumn(this.schema.getName(), "V_" + this.getLabel(), propertyColumn.getName());
            }
            this.getSchema().getTopology().fire(propertyColumn, "", TopologyChangeAction.DELETE);
        }
    }

    void removeOutEdge(EdgeLabel lbl) {
        this.uncommittedRemovedOutEdgeLabels.put(lbl.getFullName(), EdgeRemoveType.LABEL);
    }

    void removeInEdge(EdgeLabel lbl) {
        this.uncommittedRemovedInEdgeLabels.put(lbl.getFullName(), EdgeRemoveType.LABEL);
    }

    void removeEdgeRole(EdgeRole er, boolean preserveData) {
        if (er.getVertexLabel() != this) {
            throw new IllegalStateException("Trying to remove a EdgeRole from a non owner VertexLabel");
        }
        Set<VertexLabel> ers = null;
        switch (er.getDirection()) {
            case BOTH: {
                throw new IllegalStateException("BOTH is not a supported direction");
            }
            case IN: {
                ers = er.getEdgeLabel().getInVertexLabels();
                break;
            }
            case OUT: {
                ers = er.getEdgeLabel().getOutVertexLabels();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown direction!");
            }
        }
        if (!ers.contains(this)) {
            throw new IllegalStateException("Trying to remove a EdgeRole from a non owner VertexLabel");
        }
        if (ers.size() == 1) {
            er.getEdgeLabel().remove(preserveData);
        } else {
            this.getSchema().getTopology().lock();
            switch (er.getDirection()) {
                case BOTH: {
                    throw new IllegalStateException("BOTH is not a supported direction");
                }
                case IN: {
                    this.uncommittedRemovedInEdgeLabels.put(er.getEdgeLabel().getFullName(), EdgeRemoveType.ROLE);
                    er.getEdgeLabel().removeInVertexLabel(this, preserveData);
                    break;
                }
                case OUT: {
                    this.uncommittedRemovedOutEdgeLabels.put(er.getEdgeLabel().getFullName(), EdgeRemoveType.ROLE);
                    er.getEdgeLabel().removeOutVertexLabel(this, preserveData);
                }
            }
            this.getSchema().getTopology().fire(er, "", TopologyChangeAction.DELETE);
        }
    }

    @Override
    public void remove(boolean preserveData) {
        this.getSchema().removeVertexLabel(this, preserveData);
    }

    void delete() {
        String schema = this.getSchema().getName();
        String tableName = "V_" + this.getLabel();
        SqlDialect sqlDialect = this.sqlgGraph.getSqlDialect();
        sqlDialect.assertTableName(tableName);
        StringBuilder sql = new StringBuilder("DROP TABLE IF EXISTS ");
        sql.append(sqlDialect.maybeWrapInQoutes(schema));
        sql.append(".");
        sql.append(sqlDialect.maybeWrapInQoutes(tableName));
        if (sqlDialect.supportsCascade()) {
            sql.append(" CASCADE");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sql.toString());
        }
        if (sqlDialect.needsSemicolon()) {
            sql.append(";");
        }
        Connection conn = this.sqlgGraph.tx().getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum EdgeRemoveType {
        LABEL,
        ROLE;

    }
}

