/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.structure.ds;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.structure.SqlgDataSourceFactory;

public class C3P0DataSource
implements SqlgDataSourceFactory.SqlgDataSource {
    private static Logger logger = LoggerFactory.getLogger((String)C3P0DataSource.class.getName());
    private final ComboPooledDataSource dss;
    private final String jdbcUrl;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    C3P0DataSource(String jdbcUrl, ComboPooledDataSource dss) {
        this.dss = dss;
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public final DataSource getDatasource() {
        return this.dss;
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            int numBusyConnections = this.dss.getNumBusyConnections();
            if (numBusyConnections > 0) {
                logger.debug("Open connection on calling close. " + numBusyConnections);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not close connection " + this.jdbcUrl, e);
        }
        finally {
            this.dss.close();
        }
    }

    @Override
    public String getPoolStatsAsJson() {
        try {
            StringBuilder json = new StringBuilder();
            json.append("[");
            json.append("{\"jdbcUrl\":\"").append(this.jdbcUrl).append("\",");
            json.append("\"jndi\": false,");
            json.append("\"numConnections\":\"").append(String.valueOf(this.dss.getNumConnections())).append("\",");
            json.append("\"numBusyConnections\":\"").append(String.valueOf(this.dss.getNumConnections())).append("\",");
            json.append("\"numIdleConnections\":\"").append(String.valueOf(this.dss.getNumConnections())).append("\",");
            json.append("\"numUnclosedOrphanedConnections\":\"").append(String.valueOf(this.dss.getNumConnections())).append("\",");
            json.append("\"numMinPoolSize\":\"").append(String.valueOf(this.dss.getMinPoolSize())).append("\",");
            json.append("\"numMaxPoolSize\":\"").append(String.valueOf(this.dss.getMaxPoolSize())).append("\",");
            json.append("\"numMaxIdleTime\":\"").append(String.valueOf(this.dss.getMaxIdleTime())).append("\"");
            json.append("}");
            json.append("]");
            return json.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Json generation failed", e);
        }
    }
}

