/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.umlg.sqlg.sql.dialect.SqlDialect;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.sql.parse.WhereClause;
import org.umlg.sqlg.strategy.Emit;
import org.umlg.sqlg.structure.PropertyColumn;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgElement;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.Topology;

public class SqlgUtil {
    private static final int BULK_WITHIN_COUNT = 1;
    private static final String PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL = "Property array value elements may not be null.";

    private SqlgUtil() {
    }

    public static List<Emit<SqlgElement>> loadResultSetIntoResultIterator(SqlgGraph sqlgGraph, ResultSetMetaData resultSetMetaData, ResultSet resultSet, SchemaTableTree rootSchemaTableTree, List<LinkedList<SchemaTableTree>> subQueryStacks, boolean first, Map<String, Integer> lastElementIdCountMap) throws SQLException {
        ArrayList<Emit<SqlgElement>> result = new ArrayList<Emit<SqlgElement>>();
        if (resultSet.next()) {
            if (first) {
                for (LinkedList<SchemaTableTree> subQueryStack : subQueryStacks) {
                    for (SchemaTableTree schemaTableTree : subQueryStack) {
                        schemaTableTree.clearColumnNamePropertNameMap();
                    }
                }
                SqlgUtil.populateIdCountMap(resultSetMetaData, rootSchemaTableTree, lastElementIdCountMap);
            }
            int subQueryDepth = 1;
            for (LinkedList<SchemaTableTree> subQueryStack : subQueryStacks) {
                List labeledElements = SqlgUtil.loadLabeledElements(sqlgGraph, resultSet, subQueryStack, subQueryDepth == subQueryStacks.size(), lastElementIdCountMap);
                result.addAll(labeledElements);
                if (subQueryDepth == subQueryStacks.size()) {
                    SchemaTableTree lastSchemaTableTree = subQueryStack.getLast();
                    if (labeledElements.isEmpty()) {
                        SqlgElement e = (SqlgElement)SqlgUtil.loadElement(sqlgGraph, lastElementIdCountMap, resultSet, lastSchemaTableTree);
                        Emit<SqlgElement> emit = new Emit<SqlgElement>(e, Collections.emptySet());
                        if (lastSchemaTableTree.isLocalStep() && lastSchemaTableTree.isOptionalLeftJoin()) {
                            emit.setIncomingOnlyLocalOptionalStep(true);
                        }
                        result.add(emit);
                    }
                    if (lastSchemaTableTree.getReplacedStepDepth() == lastSchemaTableTree.getStepDepth() && lastSchemaTableTree.isEmit() && lastSchemaTableTree.isUntilFirst()) {
                        Emit repeatEmit = labeledElements.get(labeledElements.size() - 1);
                        repeatEmit.setRepeat(true);
                    }
                }
                ++subQueryDepth;
            }
        }
        return result;
    }

    private static void populateIdCountMap(ResultSetMetaData resultSetMetaData, SchemaTableTree rootSchemaTableTree, Map<String, Integer> lastElementIdCountMap) throws SQLException {
        lastElementIdCountMap.clear();
        for (int columnCount = 1; columnCount <= resultSetMetaData.getColumnCount(); ++columnCount) {
            String mapKey;
            String columnLabel = resultSetMetaData.getColumnLabel(columnCount);
            String unAliased = rootSchemaTableTree.getAliasColumnNameMap().get(columnLabel);
            String string = mapKey = unAliased != null ? unAliased : columnLabel;
            if (!mapKey.endsWith("~&~ID")) continue;
            lastElementIdCountMap.put(mapKey, columnCount);
        }
    }

    private static <E extends SqlgElement> List<Emit<E>> loadLabeledElements(SqlgGraph sqlgGraph, ResultSet resultSet, LinkedList<SchemaTableTree> subQueryStack, boolean lastQueryStack, Map<String, Integer> lastElementIdCountMap) throws SQLException {
        ArrayList<Emit<Emit<SqlgVertex>>> result = new ArrayList<Emit<Emit<SqlgVertex>>>();
        int count = 1;
        for (SchemaTableTree schemaTableTree : subQueryStack) {
            if (!schemaTableTree.getLabels().isEmpty()) {
                String idProperty = schemaTableTree.labeledAliasId();
                Integer columnCount = lastElementIdCountMap.get(idProperty);
                Long id = resultSet.getLong(columnCount);
                if (!resultSet.wasNull()) {
                    SqlgElement sqlgElement;
                    String rawLabel;
                    if (schemaTableTree.getSchemaTable().isVertexTable()) {
                        rawLabel = schemaTableTree.getSchemaTable().getTable().substring("V_".length());
                        sqlgElement = SqlgVertex.of(sqlgGraph, id, schemaTableTree.getSchemaTable().getSchema(), rawLabel);
                    } else {
                        rawLabel = schemaTableTree.getSchemaTable().getTable().substring("E_".length());
                        sqlgElement = new SqlgEdge(sqlgGraph, id, schemaTableTree.getSchemaTable().getSchema(), rawLabel);
                    }
                    schemaTableTree.loadProperty(resultSet, sqlgElement);
                    if (schemaTableTree.isEmit() && !lastQueryStack) {
                        result.add(new Emit<SqlgVertex>((SqlgVertex)sqlgElement, Collections.emptySet()));
                    } else if (schemaTableTree.isEmit() && lastQueryStack && count != subQueryStack.size()) {
                        result.add(new Emit<SqlgVertex>((SqlgVertex)sqlgElement, Collections.emptySet()));
                    } else {
                        result.add(new Emit<SqlgVertex>((SqlgVertex)sqlgElement, schemaTableTree.getRealLabels()));
                    }
                }
            }
            ++count;
        }
        return result;
    }

    private static <E> E loadElement(SqlgGraph sqlgGraph, Map<String, Integer> columnMap, ResultSet resultSet, SchemaTableTree leafSchemaTableTree) throws SQLException {
        SqlgElement sqlgElement;
        SchemaTable schemaTable = leafSchemaTableTree.getSchemaTable();
        String idProperty = leafSchemaTableTree.idProperty();
        Integer columnCount = columnMap.get(idProperty);
        Long id = resultSet.getLong(columnCount);
        if (schemaTable.isVertexTable()) {
            String rawLabel = schemaTable.getTable().substring("V_".length());
            sqlgElement = SqlgVertex.of(sqlgGraph, id, schemaTable.getSchema(), rawLabel);
        } else {
            String rawLabel = schemaTable.getTable().substring("E_".length());
            sqlgElement = new SqlgEdge(sqlgGraph, id, schemaTable.getSchema(), rawLabel);
        }
        leafSchemaTableTree.loadProperty(resultSet, sqlgElement);
        return (E)sqlgElement;
    }

    public static boolean isBulkWithinAndOut(SqlgGraph sqlgGraph, HasContainer hasContainer) {
        BiPredicate p = hasContainer.getPredicate().getBiPredicate();
        return (p == Contains.within || p == Contains.without) && ((Collection)hasContainer.getPredicate().getValue()).size() > sqlgGraph.configuration().getInt("bulk.within.count", 1);
    }

    public static boolean isBulkWithin(SqlgGraph sqlgGraph, HasContainer hasContainer) {
        BiPredicate p = hasContainer.getPredicate().getBiPredicate();
        return p == Contains.within && ((Collection)hasContainer.getPredicate().getValue()).size() > sqlgGraph.configuration().getInt("bulk.within.count", 1);
    }

    public static void setParametersOnStatement(SqlgGraph sqlgGraph, LinkedList<SchemaTableTree> schemaTableTreeStack, Connection conn, PreparedStatement preparedStatement, int parameterIndex) throws SQLException {
        LinkedListMultimap keyValueMap = LinkedListMultimap.create();
        for (SchemaTableTree schemaTableTree : schemaTableTreeStack) {
            for (HasContainer hasContainer : schemaTableTree.getHasContainers()) {
                if (sqlgGraph.getSqlDialect().supportsBulkWithinOut() && SqlgUtil.isBulkWithinAndOut(sqlgGraph, hasContainer)) continue;
                WhereClause whereClause = WhereClause.from(hasContainer.getPredicate());
                whereClause.putKeyValueMap(hasContainer, (Multimap<String, Object>)keyValueMap);
            }
        }
        List<ImmutablePair<PropertyType, Object>> typeAndValues = SqlgUtil.transformToTypeAndValue((Multimap<String, Object>)keyValueMap);
        SqlgUtil.setKeyValuesAsParameter(sqlgGraph, false, parameterIndex, preparedStatement, typeAndValues);
    }

    public static int setKeyValuesAsParameterUsingPropertyColumn(SqlgGraph sqlgGraph, int i, PreparedStatement preparedStatement, Map<String, Pair<PropertyColumn, Object>> properties) throws SQLException {
        i = SqlgUtil.setKeyValuesAsParameterUsingPropertyColumn(sqlgGraph, true, i, preparedStatement, properties.values());
        return i;
    }

    public static int setKeyValuesAsParameterUsingPropertyColumn(SqlgGraph sqlgGraph, boolean mod, int parameterStartIndex, PreparedStatement preparedStatement, Collection<Pair<PropertyColumn, Object>> typeAndValues) throws SQLException {
        for (Pair<PropertyColumn, Object> pair : typeAndValues) {
            parameterStartIndex = SqlgUtil.setKeyValueAsParameter(sqlgGraph, mod, parameterStartIndex, preparedStatement, (ImmutablePair<PropertyType, Object>)ImmutablePair.of((Object)((Object)((PropertyColumn)pair.getLeft()).getPropertyType()), (Object)pair.getRight()));
        }
        return parameterStartIndex;
    }

    public static int setKeyValuesAsParameter(SqlgGraph sqlgGraph, int i, PreparedStatement preparedStatement, Map<String, Object> keyValues) throws SQLException {
        List<ImmutablePair<PropertyType, Object>> typeAndValues = SqlgUtil.transformToTypeAndValue(keyValues);
        i = SqlgUtil.setKeyValuesAsParameter(sqlgGraph, true, i, preparedStatement, typeAndValues);
        return i;
    }

    public static int setKeyValuesAsParameter(SqlgGraph sqlgGraph, boolean mod, int parameterStartIndex, PreparedStatement preparedStatement, Collection<ImmutablePair<PropertyType, Object>> typeAndValues) throws SQLException {
        for (ImmutablePair<PropertyType, Object> pair : typeAndValues) {
            parameterStartIndex = SqlgUtil.setKeyValueAsParameter(sqlgGraph, mod, parameterStartIndex, preparedStatement, pair);
        }
        return parameterStartIndex;
    }

    private static int setKeyValueAsParameter(SqlgGraph sqlgGraph, boolean mod, int parameterStartIndex, PreparedStatement preparedStatement, ImmutablePair<PropertyType, Object> pair) throws SQLException {
        switch ((PropertyType)((Object)pair.left)) {
            case BOOLEAN: {
                preparedStatement.setBoolean(parameterStartIndex++, (Boolean)pair.right);
                break;
            }
            case BYTE: {
                preparedStatement.setByte(parameterStartIndex++, (Byte)pair.right);
                break;
            }
            case SHORT: {
                preparedStatement.setShort(parameterStartIndex++, (Short)pair.right);
                break;
            }
            case INTEGER: {
                preparedStatement.setInt(parameterStartIndex++, (Integer)pair.right);
                break;
            }
            case LONG: {
                preparedStatement.setLong(parameterStartIndex++, (Long)pair.right);
                break;
            }
            case FLOAT: {
                preparedStatement.setFloat(parameterStartIndex++, ((Float)pair.right).floatValue());
                break;
            }
            case DOUBLE: {
                preparedStatement.setDouble(parameterStartIndex++, (Double)pair.right);
                break;
            }
            case STRING: {
                preparedStatement.setString(parameterStartIndex++, (String)pair.right);
                break;
            }
            case LOCALDATE: {
                preparedStatement.setTimestamp(parameterStartIndex++, Timestamp.valueOf(((LocalDate)pair.right).atStartOfDay()));
                break;
            }
            case LOCALDATETIME: {
                preparedStatement.setTimestamp(parameterStartIndex++, Timestamp.valueOf((LocalDateTime)pair.right));
                break;
            }
            case ZONEDDATETIME: {
                if (sqlgGraph.getSqlDialect().needsTimeZone()) {
                    preparedStatement.setTimestamp(parameterStartIndex++, Timestamp.valueOf(((ZonedDateTime)pair.right).toLocalDateTime()), Calendar.getInstance(TimeZone.getTimeZone(((ZonedDateTime)pair.right).getZone().getId())));
                } else {
                    preparedStatement.setTimestamp(parameterStartIndex++, Timestamp.valueOf(((ZonedDateTime)pair.right).toLocalDateTime()));
                }
                if (!mod) break;
                preparedStatement.setString(parameterStartIndex++, ((ZonedDateTime)pair.right).getZone().getId());
                break;
            }
            case LOCALTIME: {
                preparedStatement.setTime(parameterStartIndex++, Time.valueOf((LocalTime)pair.right));
                break;
            }
            case PERIOD: {
                preparedStatement.setInt(parameterStartIndex++, ((Period)pair.right).getYears());
                preparedStatement.setInt(parameterStartIndex++, ((Period)pair.right).getMonths());
                preparedStatement.setInt(parameterStartIndex++, ((Period)pair.right).getDays());
                break;
            }
            case DURATION: {
                preparedStatement.setLong(parameterStartIndex++, ((Duration)pair.right).getSeconds());
                preparedStatement.setInt(parameterStartIndex++, ((Duration)pair.right).getNano());
                break;
            }
            case JSON: {
                sqlgGraph.getSqlDialect().setJson(preparedStatement, parameterStartIndex, (JsonNode)pair.getRight());
                ++parameterStartIndex;
                break;
            }
            case POINT: {
                sqlgGraph.getSqlDialect().setPoint(preparedStatement, parameterStartIndex, pair.getRight());
                ++parameterStartIndex;
                break;
            }
            case LINESTRING: {
                sqlgGraph.getSqlDialect().setLineString(preparedStatement, parameterStartIndex, pair.getRight());
                ++parameterStartIndex;
                break;
            }
            case POLYGON: {
                sqlgGraph.getSqlDialect().setPolygon(preparedStatement, parameterStartIndex, pair.getRight());
                ++parameterStartIndex;
                break;
            }
            case GEOGRAPHY_POINT: {
                sqlgGraph.getSqlDialect().setPoint(preparedStatement, parameterStartIndex, pair.getRight());
                ++parameterStartIndex;
                break;
            }
            case GEOGRAPHY_POLYGON: {
                sqlgGraph.getSqlDialect().setPolygon(preparedStatement, parameterStartIndex, pair.getRight());
                ++parameterStartIndex;
                break;
            }
            case BOOLEAN_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.BOOLEAN_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case boolean_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.boolean_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case BYTE_ARRAY: {
                byte[] byteArray = SqlgUtil.convertObjectArrayToBytePrimitiveArray((Object[])pair.getRight());
                preparedStatement.setBytes(parameterStartIndex++, byteArray);
                break;
            }
            case byte_ARRAY: {
                preparedStatement.setBytes(parameterStartIndex++, (byte[])pair.right);
                break;
            }
            case SHORT_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.SHORT_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case short_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.short_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case INTEGER_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.INTEGER_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case int_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.int_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case LONG_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.LONG_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case long_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.long_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case FLOAT_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.FLOAT_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case float_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.float_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case DOUBLE_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.DOUBLE_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case double_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.double_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case STRING_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.STRING_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case LOCALDATETIME_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.LOCALDATETIME_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case LOCALDATE_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.LOCALDATE_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case LOCALTIME_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.LOCALTIME_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                break;
            }
            case ZONEDDATETIME_ARRAY: {
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.ZONEDDATETIME_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), pair.right));
                if (!mod) break;
                List zones = Arrays.asList((ZonedDateTime[])pair.right).stream().map(z -> z.getZone().getId()).collect(Collectors.toList());
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.STRING_ARRAY, SqlgUtil.transformArrayToInsertValue(PropertyType.STRING_ARRAY, zones.toArray()));
                break;
            }
            case DURATION_ARRAY: {
                Duration[] durations = (Duration[])pair.getRight();
                List seconds = Arrays.stream(durations).map(Duration::getSeconds).collect(Collectors.toList());
                List nanos = Arrays.stream(durations).map(Duration::getNano).collect(Collectors.toList());
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.long_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), seconds.toArray()));
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.int_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), nanos.toArray()));
                break;
            }
            case PERIOD_ARRAY: {
                Period[] periods = (Period[])pair.getRight();
                List years = Arrays.stream(periods).map(Period::getYears).collect(Collectors.toList());
                List months = Arrays.stream(periods).map(Period::getMonths).collect(Collectors.toList());
                List days = Arrays.stream(periods).map(Period::getDays).collect(Collectors.toList());
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.int_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), years.toArray()));
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.int_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), months.toArray()));
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.int_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), days.toArray()));
                break;
            }
            case JSON_ARRAY: {
                JsonNode[] objectNodes = (JsonNode[])pair.getRight();
                sqlgGraph.getSqlDialect().setArray(preparedStatement, parameterStartIndex++, PropertyType.JSON_ARRAY, SqlgUtil.transformArrayToInsertValue((PropertyType)((Object)pair.left), objectNodes));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type " + ((PropertyType)((Object)pair.left)).name());
            }
        }
        return parameterStartIndex;
    }

    public static SchemaTable parseLabel(String label) {
        Objects.requireNonNull(label, "label may not be null!");
        String[] schemaLabel = label.split("\\.");
        if (schemaLabel.length != 2) {
            throw new IllegalStateException(String.format("label must be if the format 'schema.table', %s", label));
        }
        return SchemaTable.of(schemaLabel[0], schemaLabel[1]);
    }

    public static SchemaTable parseLabelMaybeNoSchema(SqlgGraph sqlgGraph, String label) {
        Objects.requireNonNull(label, "label may not be null!");
        String[] schemaLabel = label.split("\\.");
        if (schemaLabel.length == 2) {
            return SchemaTable.of(schemaLabel[0], schemaLabel[1]);
        }
        if (schemaLabel.length == 1) {
            return SchemaTable.of(sqlgGraph.getSqlDialect().getPublicSchema(), schemaLabel[0]);
        }
        throw new IllegalStateException("label must be if the format 'schema.table' or just 'table'");
    }

    public static Object[] mapTokeyValues(Map<Object, Object> keyValues) {
        Object[] result = new Object[keyValues.size() * 2];
        int i = 0;
        for (Map.Entry<Object, Object> entry : keyValues.entrySet()) {
            result[i++] = entry.getKey();
            result[i++] = entry.getValue();
        }
        return result;
    }

    public static Object[] mapToStringKeyValues(Map<String, Object> keyValues) {
        Object[] result = new Object[keyValues.size() * 2];
        int i = 0;
        for (Map.Entry<String, Object> entry : keyValues.entrySet()) {
            result[i++] = entry.getKey();
            result[i++] = entry.getValue();
        }
        return result;
    }

    public static List<String> transformToKeyList(Object ... keyValues) {
        ArrayList<String> keys = new ArrayList<String>();
        int i = 1;
        for (Object keyValue : keyValues) {
            if (i++ % 2 == 0) continue;
            keys.add((String)keyValue);
        }
        return keys;
    }

    public static ConcurrentHashMap<String, PropertyType> transformToColumnDefinitionMap(Object ... keyValues) {
        HashSet<String> keys = new HashSet<String>();
        ConcurrentHashMap<String, PropertyType> result = new ConcurrentHashMap<String, PropertyType>();
        int i = 1;
        Object key = null;
        for (Object keyValue : keyValues) {
            if (i++ % 2 != 0) {
                key = keyValue;
                continue;
            }
            if (key == T.label || keys.contains(key)) continue;
            keys.add((String)key);
            if (keyValue == null) {
                result.put((String)key, PropertyType.STRING);
                continue;
            }
            result.put((String)key, PropertyType.from(keyValue));
        }
        return result;
    }

    public static Triple<Map<String, PropertyType>, Map<String, Object>, Map<String, Object>> validateVertexKeysValues(SqlDialect sqlDialect, Object[] keyValues) {
        LinkedHashMap<String, Object> resultAllValues = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> resultNotNullValues = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, PropertyType> keyPropertyTypeMap = new LinkedHashMap<String, PropertyType>();
        if (keyValues.length % 2 != 0) {
            throw Element.Exceptions.providedKeyValuesMustBeAMultipleOfTwo();
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!(keyValues[i] instanceof String) && !(keyValues[i] instanceof T)) {
                throw Element.Exceptions.providedKeyValuesMustHaveALegalKeyOnEvenIndices();
            }
            if (keyValues[i].equals(T.id)) {
                throw Vertex.Exceptions.userSuppliedIdsNotSupported();
            }
            if (keyValues[i].equals(T.label)) continue;
            String key = (String)keyValues[i];
            sqlDialect.validateColumnName(key);
            Object value = keyValues[i + 1];
            ElementHelper.validateProperty((String)key, (Object)value);
            sqlDialect.validateProperty(key, value);
            if (value != null) {
                resultNotNullValues.put(key, value);
                keyPropertyTypeMap.put(key, PropertyType.from(value));
            } else {
                keyPropertyTypeMap.put(key, PropertyType.STRING);
            }
            resultAllValues.put(key, value);
        }
        return Triple.of(keyPropertyTypeMap, resultAllValues, resultNotNullValues);
    }

    public static Triple<Map<String, PropertyType>, Map<String, Object>, Map<String, Object>> validateVertexKeysValues(SqlDialect sqlDialect, Object[] keyValues, List<String> previousBatchModeKeys) {
        LinkedHashMap<String, Object> resultAllValues = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> resultNotNullValues = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, PropertyType> keyPropertyTypeMap = new LinkedHashMap<String, PropertyType>();
        if (keyValues.length % 2 != 0) {
            throw Element.Exceptions.providedKeyValuesMustBeAMultipleOfTwo();
        }
        int keyCount = 0;
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!(keyValues[i] instanceof String) && !(keyValues[i] instanceof T)) {
                throw Element.Exceptions.providedKeyValuesMustHaveALegalKeyOnEvenIndices();
            }
            if (keyValues[i].equals(T.id)) {
                throw Vertex.Exceptions.userSuppliedIdsNotSupported();
            }
            if (keyValues[i].equals(T.label)) continue;
            String key = (String)keyValues[i];
            sqlDialect.validateColumnName(key);
            Object value = keyValues[i + 1];
            if (value != null) {
                ElementHelper.validateProperty((String)key, (Object)value);
                sqlDialect.validateProperty(key, value);
            }
            if (value != null) {
                resultNotNullValues.put(key, value);
                keyPropertyTypeMap.put(key, PropertyType.from(value));
            } else {
                keyPropertyTypeMap.put(key, PropertyType.STRING);
            }
            resultAllValues.put(key, value);
            if (previousBatchModeKeys == null || previousBatchModeKeys.isEmpty() || key.equals(previousBatchModeKeys.get(keyCount++))) continue;
            throw new IllegalStateException("Streaming batch mode must occur for the same keys in the same order. Expected " + previousBatchModeKeys.get(keyCount - 1) + " found " + key);
        }
        return Triple.of(keyPropertyTypeMap, resultAllValues, resultNotNullValues);
    }

    public static Pair<Map<String, Object>, Map<String, Object>> transformToInsertValues(Object ... keyValues) {
        LinkedHashMap<String, Object> resultAllValues = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> resultNotNullValues = new LinkedHashMap<String, Object>();
        int i = 1;
        Object key = null;
        for (Object keyValue : keyValues) {
            if (i++ % 2 != 0) {
                key = keyValue;
                continue;
            }
            if (key == T.label || key == T.id) continue;
            if (keyValue != null) {
                resultNotNullValues.put((String)key, keyValue);
            }
            resultAllValues.put((String)key, keyValue);
        }
        return Pair.of(resultAllValues, resultNotNullValues);
    }

    public static List<ImmutablePair<PropertyType, Object>> transformToTypeAndValue(Multimap<String, Object> keyValues) {
        ArrayList<ImmutablePair<PropertyType, Object>> result = new ArrayList<ImmutablePair<PropertyType, Object>>();
        for (Map.Entry entry : keyValues.entries()) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (key.equals(T.label.getAccessor())) continue;
            if (key.equals(T.id.getAccessor()) || "ID".equals(key)) {
                if (value instanceof Long) {
                    result.add((ImmutablePair<PropertyType, Object>)ImmutablePair.of((Object)((Object)PropertyType.LONG), (Object)((Long)value)));
                    continue;
                }
                RecordId id = !(value instanceof RecordId) ? RecordId.from(value) : (RecordId)value;
                result.add((ImmutablePair<PropertyType, Object>)ImmutablePair.of((Object)((Object)PropertyType.LONG), (Object)id.getId()));
                continue;
            }
            result.add((ImmutablePair<PropertyType, Object>)ImmutablePair.of((Object)((Object)PropertyType.from(value)), value));
        }
        return result;
    }

    public static List<ImmutablePair<PropertyType, Object>> transformToTypeAndValue(Map<String, Object> keyValues) {
        ArrayList<ImmutablePair<PropertyType, Object>> result = new ArrayList<ImmutablePair<PropertyType, Object>>();
        for (Map.Entry<String, Object> entry : keyValues.entrySet()) {
            Object value = entry.getValue();
            if (entry.getKey().equals(T.label)) continue;
            result.add((ImmutablePair<PropertyType, Object>)ImmutablePair.of((Object)((Object)PropertyType.from(value)), (Object)value));
        }
        return result;
    }

    public static Object[] transformArrayToInsertValue(PropertyType propertyType, Object value) {
        return SqlgUtil.getArray(propertyType, value);
    }

    private static Object[] getArray(PropertyType propertyType, Object val) {
        int arrlength = Array.getLength(val);
        Object[] outputArray = new Object[arrlength];
        block7: for (int i = 0; i < arrlength; ++i) {
            switch (propertyType) {
                case LOCALDATETIME_ARRAY: {
                    outputArray[i] = Timestamp.valueOf((LocalDateTime)Array.get(val, i));
                    continue block7;
                }
                case LOCALDATE_ARRAY: {
                    outputArray[i] = Timestamp.valueOf(((LocalDate)Array.get(val, i)).atStartOfDay());
                    continue block7;
                }
                case LOCALTIME_ARRAY: {
                    outputArray[i] = Time.valueOf((LocalTime)Array.get(val, i));
                    continue block7;
                }
                case ZONEDDATETIME_ARRAY: {
                    ZonedDateTime zonedDateTime = (ZonedDateTime)Array.get(val, i);
                    outputArray[i] = Timestamp.valueOf(zonedDateTime.toLocalDateTime());
                    continue block7;
                }
                case BYTE_ARRAY: {
                    Byte aByte = (Byte)Array.get(val, i);
                    outputArray[i] = (byte)aByte;
                    continue block7;
                }
                default: {
                    outputArray[i] = Array.get(val, i);
                }
            }
        }
        return outputArray;
    }

    public static String removeTrailingInId(String foreignKey) {
        if (foreignKey.endsWith("__I")) {
            return foreignKey.substring(0, foreignKey.length() - "__I".length());
        }
        return foreignKey;
    }

    public static String removeTrailingOutId(String foreignKey) {
        if (foreignKey.endsWith("__O")) {
            return foreignKey.substring(0, foreignKey.length() - "__O".length());
        }
        return foreignKey;
    }

    public static Map<String, Map<String, PropertyType>> filterHasContainers(Topology topology, List<HasContainer> hasContainers, boolean withSqlgSchema) {
        HasContainer fromHasContainer = null;
        HasContainer withoutHasContainer = null;
        for (HasContainer hasContainer : hasContainers) {
            if (hasContainer.getKey().equals("~~TopologySelectionFrom~~")) {
                fromHasContainer = hasContainer;
                break;
            }
            if (!hasContainer.getKey().equals("~~TopologySelectionWithout~~")) continue;
            withoutHasContainer = hasContainer;
            break;
        }
        Map<String, Map<String, PropertyType>> filteredAllTables = fromHasContainer != null ? topology.getAllTablesFrom((Set)fromHasContainer.getPredicate().getValue()) : (withoutHasContainer != null ? topology.getAllTablesWithout((Set)withoutHasContainer.getPredicate().getValue()) : topology.getAllTables(withSqlgSchema));
        return filteredAllTables;
    }

    public static void removeTopologyStrategyHasContainer(List<HasContainer> hasContainers) {
        Optional<HasContainer> fromHasContainer = hasContainers.stream().filter(h -> h.getKey().equals("~~TopologySelectionFrom~~")).findAny();
        Optional<HasContainer> withoutHasContainer = hasContainers.stream().filter(h -> h.getKey().equals("~~TopologySelectionWithout~~")).findAny();
        fromHasContainer.ifPresent(hasContainers::remove);
        withoutHasContainer.ifPresent(hasContainers::remove);
    }

    public static void dropDb(SqlgGraph sqlgGraph) {
        block40: {
            try {
                SqlDialect sqlDialect = sqlgGraph.getSqlDialect();
                Connection conn = sqlgGraph.tx().getConnection();
                DatabaseMetaData metadata = conn.getMetaData();
                if (sqlDialect.supportsCascade()) {
                    String schema;
                    String catalog = null;
                    String schemaPattern = null;
                    String tableNamePattern = "%";
                    String[] types = new String[]{"TABLE"};
                    ResultSet result = metadata.getTables(catalog, schemaPattern, tableNamePattern, types);
                    while (result.next()) {
                        schema = result.getString(2);
                        String table = result.getString(3);
                        if (sqlDialect.getGisSchemas().contains(schema) || sqlDialect.getSpacialRefTable().contains(table)) continue;
                        StringBuilder sql = new StringBuilder("DROP TABLE ");
                        sql.append(sqlDialect.maybeWrapInQoutes(schema));
                        sql.append(".");
                        sql.append(sqlDialect.maybeWrapInQoutes(table));
                        sql.append(" CASCADE");
                        if (sqlDialect.needsSemicolon()) {
                            sql.append(";");
                        }
                        PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                        Throwable throwable = null;
                        try {
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    catalog = null;
                    schemaPattern = null;
                    result = metadata.getSchemas(catalog, schemaPattern);
                    while (result.next()) {
                        schema = result.getString(1);
                        if (sqlDialect.getDefaultSchemas().contains(schema)) continue;
                        StringBuilder sql = new StringBuilder("DROP SCHEMA ");
                        sql.append(sqlDialect.maybeWrapInQoutes(schema));
                        if (sqlDialect.needsSchemaDropCascade()) {
                            sql.append(" CASCADE");
                        }
                        if (sqlDialect.needsSemicolon()) {
                            sql.append(";");
                        }
                        PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                        Throwable throwable = null;
                        try {
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    break block40;
                }
                if (sqlDialect.supportSchemas()) break block40;
                ResultSet result = metadata.getCatalogs();
                while (result.next()) {
                    StringBuilder sql = new StringBuilder("DROP DATABASE ");
                    String database = result.getString(1);
                    if (sqlDialect.getDefaultSchemas().contains(database)) continue;
                    sql.append(sqlDialect.maybeWrapInQoutes(database));
                    if (sqlDialect.needsSemicolon()) {
                        sql.append(";");
                    }
                    PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                    Throwable throwable = null;
                    try {
                        preparedStatement.executeUpdate();
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        preparedStatement.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Byte[] convertPrimitiveByteArrayToByteArray(byte[] value) {
        Byte[] target = new Byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            Array.set(target, i, value[i]);
        }
        return target;
    }

    public static Object convertByteArrayToPrimitiveArray(Byte[] value) {
        byte[] target = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, (byte)value[i]);
        }
        return target;
    }

    public static byte[] convertObjectArrayToBytePrimitiveArray(Object[] byteArray) {
        byte[] target = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            Array.set(target, i, byteArray[i]);
        }
        return target;
    }

    public static Boolean[] convertObjectArrayToBooleanArray(Object[] booleanArray) {
        Boolean[] target = new Boolean[booleanArray.length];
        for (int i = 0; i < booleanArray.length; ++i) {
            Array.set(target, i, booleanArray[i]);
        }
        return target;
    }

    public static boolean[] convertObjectArrayToBooleanPrimitiveArray(Object[] booleanArray) {
        boolean[] target = new boolean[booleanArray.length];
        for (int i = 0; i < booleanArray.length; ++i) {
            Array.set(target, i, booleanArray[i]);
        }
        return target;
    }

    public static Short[] convertObjectOfIntegersArrayToShortArray(Object[] shortArray) {
        Short[] target = new Short[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            Array.set(target, i, ((Integer)shortArray[i]).shortValue());
        }
        return target;
    }

    public static Short[] convertObjectOfShortsArrayToShortArray(Object[] shortArray) {
        Short[] target = new Short[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            Array.set(target, i, shortArray[i]);
        }
        return target;
    }

    public static short[] convertObjectOfIntegersArrayToShortPrimitiveArray(Object[] shortArray) {
        short[] target = new short[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            Array.set(target, i, ((Integer)shortArray[i]).shortValue());
        }
        return target;
    }

    public static short[] convertObjectOfShortsArrayToShortPrimitiveArray(Object[] shortArray) {
        short[] target = new short[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            Array.set(target, i, shortArray[i]);
        }
        return target;
    }

    public static Integer[] convertObjectOfIntegersArrayToIntegerArray(Object[] integerArray) {
        Integer[] target = new Integer[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            Array.set(target, i, integerArray[i]);
        }
        return target;
    }

    public static int[] convertObjectOfIntegersArrayToIntegerPrimitiveArray(Object[] integerArray) {
        int[] target = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            Array.set(target, i, integerArray[i]);
        }
        return target;
    }

    public static long[] convertObjectOfLongsArrayToLongPrimitiveArray(Object[] longArray) {
        long[] target = new long[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            Array.set(target, i, longArray[i]);
        }
        return target;
    }

    public static double[] convertObjectOfDoublesArrayToDoublePrimitiveArray(Object[] doubleArray) {
        double[] target = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            Array.set(target, i, doubleArray[i]);
        }
        return target;
    }

    public static float[] convertObjectOfFloatsArrayToFloatPrimitiveArray(Object[] floatArray) {
        float[] target = new float[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            Array.set(target, i, floatArray[i]);
        }
        return target;
    }

    public static Long[] convertObjectOfLongsArrayToLongArray(Object[] longArray) {
        Long[] target = new Long[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            Array.set(target, i, longArray[i]);
        }
        return target;
    }

    public static Double[] convertObjectOfDoublesArrayToDoubleArray(Object[] doubleArray) {
        Double[] target = new Double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            Array.set(target, i, doubleArray[i]);
        }
        return target;
    }

    public static Float[] convertObjectOfFloatsArrayToFloatArray(Object[] doubleArray) {
        Float[] target = new Float[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            Array.set(target, i, doubleArray[i]);
        }
        return target;
    }

    public static String[] convertObjectOfStringsArrayToStringArray(Object[] stringArray) {
        String[] target = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Array.set(target, i, stringArray[i]);
        }
        return target;
    }

    public static float[] convertFloatArrayToPrimitiveFloat(Float[] floatArray) {
        float[] target = new float[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            Array.set(target, i, Float.valueOf(floatArray[i].floatValue()));
        }
        return target;
    }

    public static <T> T copyToLocalDateTime(Timestamp[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, value[i].toLocalDateTime());
        }
        return target;
    }

    public static <T> T copyObjectArrayOfTimestampToLocalDateTime(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, ((Timestamp)value[i]).toLocalDateTime());
        }
        return target;
    }

    public static <T> T copyObjectArrayOfTimestampToLocalDate(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, ((Timestamp)value[i]).toLocalDateTime().toLocalDate());
        }
        return target;
    }

    public static <T> T copyToLocalDate(Date[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, value[i].toLocalDate());
        }
        return target;
    }

    public static <T> T copyObjectArrayOfDateToLocalDate(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, ((Date)value[i]).toLocalDate());
        }
        return target;
    }

    private static <T> T copyToLocalDate(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, ((Date)value[i]).toLocalDate());
        }
        return target;
    }

    public static <T> T copyToLocalTime(Time[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, value[i].toLocalTime());
        }
        return target;
    }

    public static <T> T copyObjectArrayOfTimeToLocalTime(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException(PROPERTY_ARRAY_VALUE_ELEMENTS_MAY_NOT_BE_NULL);
            }
            Array.set(target, i, ((Time)value[i]).toLocalTime());
        }
        return target;
    }
}

