package org.umlg.sqlg.structure;

import org.apache.commons.configuration2.Configuration;
import org.umlg.sqlg.sql.dialect.SqlDialect;

import javax.sql.DataSource;

public interface SqlgDataSource {
    String C3P0DataSource = "org.umlg.sqlg.structure.ds.c3p0.SqlgC3P0DataSource";
    String SqlgHikariDataSource = "org.umlg.sqlg.structure.ds.hikari.SqlgHikariDataSource";
    DataSource getDatasource();

    SqlDialect getDialect();

    void close();

    String getPoolStatsAsJson();

    static boolean isPostgres(Configuration configuration) {
        return configuration.getString("jdbc.url").contains("postgresql");
    }

    static boolean isMsSqlServer(Configuration configuration) {
        return configuration.getString("jdbc.url").contains("sqlserver");
    }

    static boolean isHsqldb(Configuration configuration) {
        return configuration.getString("jdbc.url").contains("hsqldb");
    }

    static boolean isH2(Configuration configuration) {
        return configuration.getString("jdbc.url").contains("h2");
    }

    static boolean isMariaDb(Configuration configuration) {
        return configuration.getString("jdbc.url").contains("mariadb");
    }

    static boolean isMysql(Configuration configuration) {
        return configuration.getString("jdbc.url").contains("mysql");
    }

    default boolean isC3p0() {
        return false;
    }

    default boolean isHikari() {
        return false;
    }
}
