/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.dialect;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Type;
import org.umlg.sqlg.sql.dialect.BaseSqlDialect;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.util.SqlgUtil;

public class HsqldbDialect
extends BaseSqlDialect {
    public String dialectName() {
        return "HsqldbDialect";
    }

    public Set<String> getDefaultSchemas() {
        return new HashSet<String>(Arrays.asList("PUBLIC", "INFORMATION_SCHEMA", "SYSTEM_LOBS"));
    }

    public String getPublicSchema() {
        return "PUBLIC";
    }

    public String existIndexQuery(SchemaTable schemaTable, String prefix, String indexName) {
        StringBuilder sb = new StringBuilder("SELECT * FROM INFORMATION_SCHEMA.SYSTEM_INDEXINFO WHERE TABLE_SCHEM = '");
        sb.append(schemaTable.getSchema());
        sb.append("' AND  TABLE_NAME = '");
        sb.append(prefix);
        sb.append(schemaTable.getTable());
        sb.append("' AND INDEX_NAME = '");
        sb.append(indexName);
        sb.append("'");
        return sb.toString();
    }

    public boolean supportsTransactionalSchema() {
        return false;
    }

    public void validateProperty(Object key, Object value) {
        if (value instanceof String) {
            return;
        }
        if (value instanceof Character) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof Byte) {
            return;
        }
        if (value instanceof Short) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        if (value instanceof Double) {
            return;
        }
        if (value instanceof LocalDate) {
            return;
        }
        if (value instanceof LocalDateTime) {
            return;
        }
        if (value instanceof ZonedDateTime) {
            return;
        }
        if (value instanceof LocalTime) {
            return;
        }
        if (value instanceof Period) {
            return;
        }
        if (value instanceof Duration) {
            return;
        }
        if (value instanceof byte[]) {
            return;
        }
        if (value instanceof boolean[]) {
            return;
        }
        if (value instanceof char[]) {
            return;
        }
        if (value instanceof short[]) {
            return;
        }
        if (value instanceof int[]) {
            return;
        }
        if (value instanceof long[]) {
            return;
        }
        if (value instanceof double[]) {
            return;
        }
        if (value instanceof String[]) {
            return;
        }
        if (value instanceof Character[]) {
            return;
        }
        if (value instanceof Boolean[]) {
            return;
        }
        if (value instanceof Byte[]) {
            return;
        }
        if (value instanceof Short[]) {
            return;
        }
        if (value instanceof Integer[]) {
            return;
        }
        if (value instanceof Long[]) {
            return;
        }
        if (value instanceof Double[]) {
            return;
        }
        if (value instanceof LocalDateTime[]) {
            return;
        }
        if (value instanceof LocalDate[]) {
            return;
        }
        if (value instanceof LocalTime[]) {
            return;
        }
        if (value instanceof ZonedDateTime[]) {
            return;
        }
        if (value instanceof Duration[]) {
            return;
        }
        if (value instanceof Period[]) {
            return;
        }
        throw Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)value);
    }

    public String getColumnEscapeKey() {
        return "\"";
    }

    public String getPrimaryKeyType() {
        return "BIGINT NOT NULL PRIMARY KEY";
    }

    public String getAutoIncrementPrimaryKeyConstruct() {
        return "BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY";
    }

    public String[] propertyTypeToSqlDefinition(PropertyType propertyType) {
        switch (propertyType) {
            case BOOLEAN: {
                return new String[]{"BOOLEAN"};
            }
            case BYTE: {
                return new String[]{"TINYINT"};
            }
            case SHORT: {
                return new String[]{"SMALLINT"};
            }
            case INTEGER: {
                return new String[]{"INTEGER"};
            }
            case LONG: {
                return new String[]{"BIGINT"};
            }
            case FLOAT: {
                return new String[]{"REAL"};
            }
            case DOUBLE: {
                return new String[]{"DOUBLE"};
            }
            case LOCALDATE: {
                return new String[]{"DATE"};
            }
            case LOCALDATETIME: {
                return new String[]{"TIMESTAMP WITH TIME ZONE"};
            }
            case ZONEDDATETIME: {
                return new String[]{"TIMESTAMP WITH TIME ZONE", "LONGVARCHAR"};
            }
            case LOCALTIME: {
                return new String[]{"TIME WITH TIME ZONE"};
            }
            case PERIOD: {
                return new String[]{"INTEGER", "INTEGER", "INTEGER"};
            }
            case DURATION: {
                return new String[]{"BIGINT", "INTEGER"};
            }
            case STRING: {
                return new String[]{"LONGVARCHAR"};
            }
            case JSON: {
                throw new IllegalStateException("HSQLDB does not support json types, use good ol string instead!");
            }
            case POINT: {
                throw new IllegalStateException("HSQLDB does not support gis types!");
            }
            case POLYGON: {
                throw new IllegalStateException("HSQLDB does not support gis types!");
            }
            case GEOGRAPHY_POINT: {
                throw new IllegalStateException("HSQLDB does not support gis types!");
            }
            case GEOGRAPHY_POLYGON: {
                throw new IllegalStateException("HSQLDB does not support gis types!");
            }
            case BYTE_ARRAY: {
                return new String[]{"LONGVARBINARY"};
            }
            case byte_ARRAY: {
                return new String[]{"LONGVARBINARY"};
            }
            case boolean_ARRAY: {
                return new String[]{"BOOLEAN ARRAY DEFAULT ARRAY[]"};
            }
            case BOOLEAN_ARRAY: {
                return new String[]{"BOOLEAN ARRAY DEFAULT ARRAY[]"};
            }
            case SHORT_ARRAY: {
                return new String[]{"SMALLINT ARRAY DEFAULT ARRAY[]"};
            }
            case short_ARRAY: {
                return new String[]{"SMALLINT ARRAY DEFAULT ARRAY[]"};
            }
            case int_ARRAY: {
                return new String[]{"INTEGER ARRAY DEFAULT ARRAY[]"};
            }
            case INTEGER_ARRAY: {
                return new String[]{"INTEGER ARRAY DEFAULT ARRAY[]"};
            }
            case LONG_ARRAY: {
                return new String[]{"BIGINT ARRAY DEFAULT ARRAY[]"};
            }
            case long_ARRAY: {
                return new String[]{"BIGINT ARRAY DEFAULT ARRAY[]"};
            }
            case float_ARRAY: {
                return new String[]{"REAL ARRAY DEFAULT ARRAY[]"};
            }
            case DOUBLE_ARRAY: {
                return new String[]{"DOUBLE ARRAY DEFAULT ARRAY[]"};
            }
            case double_ARRAY: {
                return new String[]{"DOUBLE ARRAY DEFAULT ARRAY[]"};
            }
            case STRING_ARRAY: {
                return new String[]{"LONGVARCHAR ARRAY DEFAULT ARRAY[]"};
            }
            case LOCALDATETIME_ARRAY: {
                return new String[]{"TIMESTAMP WITH TIME ZONE ARRAY DEFAULT ARRAY[]"};
            }
            case LOCALDATE_ARRAY: {
                return new String[]{"DATE ARRAY DEFAULT ARRAY[]"};
            }
            case LOCALTIME_ARRAY: {
                return new String[]{"TIME WITH TIME ZONE ARRAY DEFAULT ARRAY[]"};
            }
            case ZONEDDATETIME_ARRAY: {
                return new String[]{"TIMESTAMP WITH TIME ZONE ARRAY DEFAULT ARRAY[]", "LONGVARCHAR ARRAY DEFAULT ARRAY[]"};
            }
            case DURATION_ARRAY: {
                return new String[]{"BIGINT ARRAY DEFAULT ARRAY[]", "INTEGER ARRAY DEFAULT ARRAY[]"};
            }
            case PERIOD_ARRAY: {
                return new String[]{"INTEGER ARRAY DEFAULT ARRAY[]", "INTEGER ARRAY DEFAULT ARRAY[]", "INTEGER ARRAY DEFAULT ARRAY[]"};
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public int propertyTypeToJavaSqlType(PropertyType propertyType) {
        switch (propertyType) {
            case BOOLEAN: {
                return 16;
            }
            case BYTE: {
                return -6;
            }
            case SHORT: {
                return 5;
            }
            case INTEGER: {
                return 4;
            }
            case LONG: {
                return -5;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return 2005;
            }
            case LOCALDATETIME: {
                return 93;
            }
            case LOCALDATE: {
                return 91;
            }
            case LOCALTIME: {
                return 92;
            }
            case JSON: {
                return 1111;
            }
            case byte_ARRAY: {
                return 2003;
            }
            case boolean_ARRAY: {
                return 2003;
            }
            case short_ARRAY: {
                return 2003;
            }
            case int_ARRAY: {
                return 2003;
            }
            case long_ARRAY: {
                return 2003;
            }
            case float_ARRAY: {
                return 2003;
            }
            case double_ARRAY: {
                return 2003;
            }
            case STRING_ARRAY: {
                return 2003;
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public PropertyType sqlTypeToPropertyType(SqlgGraph sqlgGraph, String schema, String table, String column, int sqlType, String typeName) {
        switch (sqlType) {
            case 16: {
                return PropertyType.BOOLEAN;
            }
            case 5: {
                return PropertyType.SHORT;
            }
            case 4: {
                return PropertyType.INTEGER;
            }
            case -5: {
                return PropertyType.LONG;
            }
            case 7: {
                return PropertyType.FLOAT;
            }
            case 8: {
                return PropertyType.DOUBLE;
            }
            case 12: {
                return PropertyType.STRING;
            }
            case 93: {
                return PropertyType.LOCALDATETIME;
            }
            case 91: {
                return PropertyType.LOCALDATE;
            }
            case 92: {
                return PropertyType.LOCALTIME;
            }
            case -3: {
                return PropertyType.byte_ARRAY;
            }
            case 2003: {
                switch (typeName) {
                    case "BOOLEAN ARRAY": {
                        return PropertyType.boolean_ARRAY;
                    }
                    case "SMALLINT ARRAY": {
                        return PropertyType.short_ARRAY;
                    }
                    case "INTEGER ARRAY": {
                        return PropertyType.int_ARRAY;
                    }
                    case "BIGINT ARRAY": {
                        return PropertyType.long_ARRAY;
                    }
                    case "DOUBLE ARRAY": {
                        return PropertyType.double_ARRAY;
                    }
                }
                if (typeName.contains("VARCHAR") && typeName.contains("ARRAY")) {
                    return PropertyType.STRING_ARRAY;
                }
                throw new RuntimeException(String.format("Array type not supported sqlType = %s and typeName = %s", String.valueOf(sqlType), typeName));
            }
        }
        throw new IllegalStateException("Unknown sqlType " + sqlType);
    }

    public String getForeignKeyTypeDefinition() {
        return "BIGINT";
    }

    public boolean supportsFloatValues() {
        return false;
    }

    public boolean supportsByteValues() {
        return true;
    }

    public boolean supportsFloatArrayValues() {
        return false;
    }

    public String getArrayDriverType(PropertyType propertyType) {
        switch (propertyType) {
            case boolean_ARRAY: {
                return "BOOLEAN";
            }
            case BOOLEAN_ARRAY: {
                return "BOOLEAN";
            }
            case SHORT_ARRAY: {
                return "SMALLINT";
            }
            case short_ARRAY: {
                return "SMALLINT";
            }
            case INTEGER_ARRAY: {
                return "INTEGER";
            }
            case int_ARRAY: {
                return "INTEGER";
            }
            case LONG_ARRAY: {
                return "BIGINT";
            }
            case long_ARRAY: {
                return "BIGINT";
            }
            case DOUBLE_ARRAY: {
                return "DOUBLE";
            }
            case double_ARRAY: {
                return "DOUBLE";
            }
            case STRING_ARRAY: {
                return "VARCHAR";
            }
            case LOCALDATETIME_ARRAY: {
                return "TIMESTAMP";
            }
            case LOCALDATE_ARRAY: {
                return "DATE";
            }
            case LOCALTIME_ARRAY: {
                return "TIME";
            }
        }
        throw new IllegalStateException("propertyType " + propertyType.name() + " unknown!");
    }

    public String createTableStatement() {
        return "CREATE TABLE ";
    }

    public void prepareDB(Connection conn) {
        Throwable throwable;
        PreparedStatement preparedStatement;
        StringBuilder sql = new StringBuilder("SET DATABASE TRANSACTION CONTROL MVCC;");
        try {
            preparedStatement = conn.prepareStatement(sql.toString());
            throwable = null;
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        sql = new StringBuilder("SET DATABASE DEFAULT TABLE TYPE CACHED;");
        try {
            preparedStatement = conn.prepareStatement(sql.toString());
            throwable = null;
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void validateColumnName(String column) {
        super.validateColumnName(column);
    }

    public Set<String> getSpacialRefTable() {
        return Collections.emptySet();
    }

    public List<String> getGisSchemas() {
        return Collections.emptyList();
    }

    public void setJson(PreparedStatement preparedStatement, int parameterStartIndex, JsonNode right) {
        throw new IllegalStateException("Hsqldb does not support json types, this should not have happened!");
    }

    public void setPoint(PreparedStatement preparedStatement, int parameterStartIndex, Object point) {
        throw new IllegalStateException("Hsqldb does not support gis types, this should not have happened!");
    }

    public void setLineString(PreparedStatement preparedStatement, int parameterStartIndex, Object lineString) {
        throw new IllegalStateException("Hsqldb does not support gis types, this should not have happened!");
    }

    public void setPolygon(PreparedStatement preparedStatement, int parameterStartIndex, Object point) {
        throw new IllegalStateException("Hsqldb does not support gis types, this should not have happened!");
    }

    public void setGeographyPoint(PreparedStatement preparedStatement, int parameterStartIndex, Object point) {
        throw new IllegalStateException("Hsqldb does not support gis types, this should not have happened!");
    }

    public void handleOther(Map<String, Object> properties, String columnName, Object o, PropertyType propertyType) {
        throw new IllegalStateException("Hsqldb does not support other types, this should not have happened!");
    }

    public <T> T getGis(SqlgGraph sqlgGraph) {
        throw new IllegalStateException("Hsqldb does not support other types, this should not have happened!");
    }

    public void lockTable(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("Hsqldb does not support table locking!");
    }

    public void alterSequenceCacheSize(SqlgGraph sqlgGraph, SchemaTable schemaTable, String sequence, int batchSize) {
        throw new UnsupportedOperationException("Hsqldb does not support alterSequenceCacheSize!");
    }

    public long nextSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("Hsqldb does not support nextSequenceVal!");
    }

    public long currSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("Hsqldb does not support currSequenceVal!");
    }

    public String sequenceName(SqlgGraph sqlgGraph, SchemaTable outSchemaTable, String prefix) {
        throw new UnsupportedOperationException("Hsqldb does not support sequenceName!");
    }

    public boolean supportsBulkWithinOut() {
        return false;
    }

    public String createTemporaryTableStatement() {
        return "DECLARE LOCAL TEMPORARY TABLE ";
    }

    public String afterCreateTemporaryTableStatement() {
        return "";
    }

    public List<String> sqlgTopologyCreationScripts() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("CREATE SCHEMA \"sqlg_schema\";");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_schema\" (\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" LONGVARCHAR);");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_vertex\" (\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" LONGVARCHAR, \"schemaVertex\" LONGVARCHAR);");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_edge\" (\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" LONGVARCHAR);");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_property\" (\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" LONGVARCHAR, \"type\" LONGVARCHAR);");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_schema_vertex\"(\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"sqlg_schema.vertex__I\" BIGINT, \"sqlg_schema.schema__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.vertex__I\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.schema__O\") REFERENCES \"sqlg_schema\".\"V_schema\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_in_edges\"(\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"sqlg_schema.edge__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.edge__I\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_out_edges\"(\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"sqlg_schema.edge__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.edge__I\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_vertex_property\"(\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_edge_property\"(\"ID\" BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
        return result;
    }

    public Long getPrimaryKeyStartValue() {
        return 0L;
    }

    private Array createArrayOf(Connection conn, PropertyType propertyType, Object[] data) {
        CharacterType type;
        switch (propertyType) {
            case STRING_ARRAY: {
                type = Type.SQL_VARCHAR;
                break;
            }
            case long_ARRAY: {
                type = Type.SQL_BIGINT;
                break;
            }
            case LONG_ARRAY: {
                type = Type.SQL_BIGINT;
                break;
            }
            case int_ARRAY: {
                type = Type.SQL_INTEGER;
                break;
            }
            case INTEGER_ARRAY: {
                type = Type.SQL_INTEGER;
                break;
            }
            case SHORT_ARRAY: {
                type = Type.SQL_SMALLINT;
                break;
            }
            case short_ARRAY: {
                type = Type.SQL_SMALLINT;
                break;
            }
            case FLOAT_ARRAY: {
                type = Type.SQL_DOUBLE;
                break;
            }
            case float_ARRAY: {
                type = Type.SQL_DOUBLE;
                break;
            }
            case DOUBLE_ARRAY: {
                type = Type.SQL_DOUBLE;
                break;
            }
            case double_ARRAY: {
                type = Type.SQL_DOUBLE;
                break;
            }
            case BOOLEAN_ARRAY: {
                type = Type.SQL_BIT;
                break;
            }
            case boolean_ARRAY: {
                type = Type.SQL_BIT;
                break;
            }
            case LOCALDATETIME_ARRAY: {
                type = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case LOCALDATE_ARRAY: {
                type = Type.SQL_DATE;
                break;
            }
            case LOCALTIME_ARRAY: {
                type = Type.SQL_TIME;
                break;
            }
            case ZONEDDATETIME_ARRAY: {
                type = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled array type " + propertyType.name());
            }
        }
        return new JDBCArrayBasic(data, (Type)type);
    }

    public Object convertArray(PropertyType propertyType, Array array) throws SQLException {
        switch (propertyType) {
            case BOOLEAN_ARRAY: {
                return SqlgUtil.convertObjectArrayToBooleanArray((Object[])((Object[])array.getArray()));
            }
            case boolean_ARRAY: {
                return SqlgUtil.convertObjectArrayToBooleanPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case SHORT_ARRAY: {
                return SqlgUtil.convertObjectOfIntegersArrayToShortArray((Object[])((Object[])array.getArray()));
            }
            case short_ARRAY: {
                return SqlgUtil.convertObjectOfIntegersArrayToShortPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case INTEGER_ARRAY: {
                return SqlgUtil.convertObjectOfIntegersArrayToIntegerArray((Object[])((Object[])array.getArray()));
            }
            case int_ARRAY: {
                return SqlgUtil.convertObjectOfIntegersArrayToIntegerPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case LONG_ARRAY: {
                return SqlgUtil.convertObjectOfLongsArrayToLongArray((Object[])((Object[])array.getArray()));
            }
            case long_ARRAY: {
                return SqlgUtil.convertObjectOfLongsArrayToLongPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case DOUBLE_ARRAY: {
                return SqlgUtil.convertObjectOfDoublesArrayToDoubleArray((Object[])((Object[])array.getArray()));
            }
            case double_ARRAY: {
                return SqlgUtil.convertObjectOfDoublesArrayToDoublePrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case FLOAT_ARRAY: {
                return SqlgUtil.convertObjectOfFloatsArrayToFloatArray((Object[])((Object[])array.getArray()));
            }
            case float_ARRAY: {
                return SqlgUtil.convertObjectOfFloatsArrayToFloatPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case STRING_ARRAY: {
                return SqlgUtil.convertObjectOfStringsArrayToStringArray((Object[])((Object[])array.getArray()));
            }
            case LOCALDATETIME_ARRAY: {
                Object[] timestamps = (Object[])array.getArray();
                return SqlgUtil.copyObjectArrayOfTimestampToLocalDateTime((Object[])timestamps, (Object)new LocalDateTime[timestamps.length]);
            }
            case LOCALDATE_ARRAY: {
                Object[] dates = (Object[])array.getArray();
                return SqlgUtil.copyObjectArrayOfDateToLocalDate((Object[])dates, (Object)new LocalDate[dates.length]);
            }
            case LOCALTIME_ARRAY: {
                Object[] times = (Object[])array.getArray();
                return SqlgUtil.copyObjectArrayOfTimeToLocalTime((Object[])times, (Object)new LocalTime[times.length]);
            }
        }
        throw new IllegalStateException("Unhandled property type " + propertyType.name());
    }

    public void setArray(PreparedStatement statement, int index, PropertyType type, Object[] values) throws SQLException {
        statement.setArray(index, this.createArrayOf(statement.getConnection(), type, values));
    }
}

