package org.unlaxer.jaddress;

import java.util.Map;
import java.util.function.Supplier;

import org.unlaxer.util.collection.ID;

public interface PoisonPillHolder{
	
	public Map<ID,PoisonPill> poisonPillByID();
	
	public default PoisonPill poisonPill(ID id) {
		return  poisonPillByID().get(id);
	}
	
	public default PoisonPill createAndSetPoisonPill(ID id ,Supplier<? extends RuntimeException> throwable) {
		PoisonPill poisonPill = new PoisonPill(throwable.get());
		poisonPillByID().put(id , poisonPill);
		return poisonPill;
	}
	
	public default void apply(PoisonPillEnabler poisonPillEnabler) {
		
		poisonPillEnabler.keyset()
			.forEach(id->{
				PoisonPill poisonPill = poisonPill(id);
				if(poisonPill != null) {
					poisonPill.setEnable(
						poisonPillEnabler.isEnable(id)
					);
				}
			});
	}

}