package org.unlaxer.jaddress;

import java.nio.file.Path;

public class ProjectContext {
	
	static DynamicProjectContext projectContext = DynamicProjectContext.fromCurrentFolder();

	public static Path getProjectHome() {
		return projectContext.getProjectHome();
	}

	public static Path getJavaFilePath(SubProjects subProjects, GradleStructure gradleStructure, Class<?> clazz) {
		return projectContext.getJavaFilePath(subProjects, gradleStructure, clazz);
	}

	public static Path getJavaFilePath(SubProjects subProjects, GradleStructure gradleStructure, Package targetPackage,
			String className) {
		return projectContext.getJavaFilePath(subProjects, gradleStructure, targetPackage, className);
	}

	public static Path getPath(SubProjects subProjects, GradleStructure gradleStructure, Package targetPackage) {
		return projectContext.getPath(subProjects, gradleStructure, targetPackage);
	}

	public static Path getPath(SubProjects subProjects, GradleStructure gradleStructure, Package targetPackage,
			String... successorPaths) {
		return projectContext.getPath(subProjects, gradleStructure, targetPackage, successorPaths);
	}

	public static Path getPath(SubProjects subProjects, GradleStructure gradleStructure, String... successorPaths) {
		return projectContext.getPath(subProjects, gradleStructure, successorPaths);
	}

	public static Path getPath(SubProjects subProjects, String... successorPaths) {
		return projectContext.getPath(subProjects, successorPaths);
	}
	
	public static Path switchProject(Path pathThatCreateWithThisContext , DynamicProjectContext switchToProjectContext) {
		return projectContext.switchProject(pathThatCreateWithThisContext, switchToProjectContext);
	}

	public static DynamicProjectContext getProjectContext() {
		
		return projectContext;
	}
}
