package org.unlaxer.jaddress;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.unlaxer.util.properties.SystemProperties;

public class UserHomeContext{
	
	public static Path getPathWithFolderAndFile(String folder , String fileName){
		return getPathWithFolderAndFile(folder, fileName, true);
	}
	
	public static Path getPathWithFolderAndFile(String folder , String fileName , boolean makeDirectory){
		
		Path folderPath = getPathWithFolder(folder, makeDirectory);
		return folderPath.resolve(fileName).toAbsolutePath();
	}
	
	public static File getFileWithFolderAndFile(String folder , String fileName){

		return getPathWithFolderAndFile(folder, fileName).toFile();
	}
	public static Path getPathWithFolder(String folder){
		return getPathWithFolder(folder , true);
	}
	
	public static Path getPathWithFolder(String folder , boolean makeDirectory){
		
		String userHome = SystemProperties.UserHome.getProperty().orElseThrow(IllegalArgumentException::new);
		Path folderPath = Paths.get(userHome, folder);
		if(makeDirectory) {
			folderPath.toFile().mkdirs();
		}
		return folderPath;
	}
}