package org.unlaxer.jaddress.entity.standard;

import static org.unlaxer.jaddress.entity.standard.FieldsCharacteristics.*;
import static org.unlaxer.jaddress.entity.standard.階層要素.*;

public enum AddressFields{
	
	ID(false ,code ),
	郵便番号(false,code),
	
	都道府県コード(true,code , 国域Top1/*都道府県 , その他*/),
	都道府県名(false,name , 国域Top1/*都道府県 , その他*/),
	都道府県カナ(false,kana , 国域Top1/*都道府県 , その他*/),
	
	市区群町村コード(true,code ,国域Top2 , 国域Top3 , 国域Top4 /* 東京23区 , 政令指定市 , 市 , 群 , 区 , 町村*/),
	市区群町村名(false,name ,国域Top2 , 国域Top3 , 国域Top4 /* 東京23区 , 政令指定市 , 市 , 群 , 区 , 町村*/),
	市区群町村カナ(false,kana ,国域Top2 , 国域Top3 , 国域Top4 /* 東京23区 , 政令指定市 , 市 , 群 , 区 , 町村*/),
	
	大字通称コード(true,code , 国域Top4 /*町または大字*/),
	大字通称名(true,name ,  国域Top4 /*町または大字*/),
	大字通称カナ(true,kana ,  国域Top4 /*町または大字*/),
	
	字丁目コード(true,code , 町域Top1 , 字小字),
	字丁目名(false,name , 町域Top1 , 字小字),
	字丁目カナ(true,kana , 町域Top1 , 字小字),
	
	
	//
	番地名(true,name , 街区符号 , 町域Top2),
	番地カナ(true,kana , 街区符号 , 町域Top2),
	
	号名(true,name , 住居番号 , 町域Top3),
	号カナ(true,kana , 住居番号 , 町域Top3),
	
	枝番号名(true , name , 町域Top4),
	枝番号カナ(true , kana , 町域Top4),

	建物名(true,name , 建物),
	建物カナ(true,kana , 建物),
	
	棟名(true,name , 建物Bottom3),
	棟カナ(true,kana , 建物Bottom3),
	
	階数名(true,name , 建物Bottom2),
	階数カナ(true,kana , 建物Bottom2),
	

	部屋番号名(true,name , 建物Bottom1),
	部屋番号カナ(true,name , 建物Bottom1),
	
	方書き名(true,name , 方書き),
	方書きカナ(true,kana , 方書き),

	ダミーサフィックス名(true,name , ダミーサフィックス),
	ダミーサフィックスカナ(true,kana , ダミーサフィックス),
	
	;
	
	public final boolean isNullable;
	public final FieldsCharacteristics characteristics;
	final int order;
	public 階層要素[] levelElements;
	
	private AddressFields(boolean isNullable, FieldsCharacteristics characteristics , 階層要素... levelElements) {
		this.isNullable = isNullable;
		this.characteristics = characteristics;
		order = 1 << ordinal();
	}
	
	public int value() {
		return order;
	}
	
	public static class AddressState{
		public final int value;

		public AddressState(int state) {
			super();
			this.value = state;
		}
		
	}
		
	
	public AddressState state(詳細住所 address) {
		
		return new AddressState(
			(address._ID == null ? 0 : ID.value() ) + //
			(address._郵便番号 == null ? 0 : 郵便番号.value() ) + //
			(address._都道府県コード == null ? 0 : 都道府県コード.value() ) + //
			(address._市区群町村コード == null ? 0 : 市区群町村コード.value() ) + //
			(address._大字通称コード == null ? 0 : 大字通称コード.value() ) + //
			(address._字丁目コード == null ? 0 : 字丁目コード.value() ) + //
			(address._都道府県名 == null ? 0 : 都道府県名.value() ) + //
			(address._都道府県カナ == null ? 0 : 都道府県カナ.value() ) + //
			(address._市区群町村名 == null ? 0 : 市区群町村名.value() ) + //
			(address._市区群町村カナ == null ? 0 : 市区群町村カナ.value() ) + //
			(address._大字通称名 == null ? 0 : 大字通称名.value() ) + //
			(address._大字通称カナ == null ? 0 : 大字通称カナ.value() ) + //
			(address._字丁目名 == null ? 0 : 字丁目名.value() ) + //
			(address._字丁目カナ == null ? 0 : 字丁目カナ.value() ) + //
			(address._番地名 == null ? 0 : 番地名.value() ) + //
			(address._番地カナ == null ? 0 : 番地カナ.value() ) + //
			(address._号名 == null ? 0 : 号名.value() ) + //
			(address._号カナ == null ? 0 : 号カナ.value() ) + //
			(address._建物名 == null ? 0 : 建物名.value() ) + //
			(address._建物カナ == null ? 0 : 建物カナ.value() ) + //
			(address._棟名 == null ? 0 : 棟名.value() ) + //
			(address._棟カナ == null ? 0 : 棟カナ.value() ) + //
			(address._階数名 == null ? 0 : 階数名.value() ) + //
			(address._階数カナ == null ? 0 : 階数カナ.value() ) + //
			(address._部屋番号名 == null ? 0 : 部屋番号名.value() ) + //
			(address._部屋番号カナ == null ? 0 : 部屋番号カナ.value() ) + //
			(address._方書き名 == null ? 0 : 方書き名.value() ) + //
			(address._方書きカナ == null ? 0 : 方書きカナ.value() ) + //
			(address._ダミーサフィックス名 == null ? 0 : ダミーサフィックス名.value() ) + //
			(address._ダミーサフィックスカナ == null ? 0 : ダミーサフィックスカナ.value() ) //
		); 
	}
	public boolean isEmpty(詳細住所 address) {

		switch (this) {
		
		case ID:
			return address._ID== null;
		case 郵便番号:
			return address._郵便番号 == null;
		case 都道府県コード:
			return address._都道府県コード == null;
		case 市区群町村コード:
			return address._市区群町村コード == null;
		case 大字通称コード:
			return address._大字通称コード == null;
		case 字丁目コード:
			return address._字丁目コード == null;
		case 都道府県名:
			return address._都道府県名 == null;
		case 都道府県カナ:
			return address._都道府県カナ == null;
		case 市区群町村名:
			return address._市区群町村名 == null;
		case 市区群町村カナ:
			return address._市区群町村カナ == null;
		case 大字通称名:
			return address._大字通称名 == null;
		case 大字通称カナ:
			return address._大字通称カナ == null;
		case 字丁目名:
			return address._字丁目名 == null;
		case 字丁目カナ:
			return address._字丁目カナ == null;
		case 番地名:
			return address._番地名 == null;
		case 番地カナ:
			return address._番地カナ == null;
		case 号名:
			return address._号名 == null;
		case 号カナ:
			return address._号カナ == null;
		case 建物名:
			return address._建物名 == null;
		case 建物カナ:
			return address._建物カナ == null;
		case 棟名:
			return address._棟名 == null;
		case 棟カナ:
			return address._棟カナ == null;
		case 階数名:
			return address._階数名 == null;
		case 階数カナ:
			return address._階数カナ == null;
		case 部屋番号名:
			return address._部屋番号名 == null;
		case 部屋番号カナ:
			return address._部屋番号カナ == null;
		case 方書き名:
			return address._方書き名 == null;
		case 方書きカナ:
			return address._方書きカナ == null;
		case ダミーサフィックス名:
			return address._ダミーサフィックス名 == null;
		case ダミーサフィックスカナ:
			return address._ダミーサフィックスカナ == null;
		default:
			throw new IllegalArgumentException();
		}
	}
}