package org.unlaxer.jaddress.entity.standard;

import java.io.Serializable;

public class Range階層要素 implements Serializable{
		
	private static final long serialVersionUID = 413437009693447466L;
	
	final 階層要素 startInclusive;
	final 階層要素 endInclusive;
	
	public Range階層要素(階層要素 startInclusive, 階層要素 endInclusive) {
		super();
		this.startInclusive = startInclusive;
		this.endInclusive = endInclusive;
	}
	
	public Range階層要素(階層要素 startInclusive) {
		super();
		this.startInclusive = startInclusive;
		this.endInclusive = startInclusive;
	}

	public 階層要素 startInclusive() {
		return startInclusive;
	}

	public 階層要素 endInclusive() {
		return endInclusive;
	}
	
	public boolean contains(int level) {
		
		return startInclusive.level <= level && endInclusive.level  >=level;
	}
	
	public boolean contains(階層要素 target階層要素) {
		
		return contains(target階層要素.level);
	}
	
	public boolean isSingle() {
		return startInclusive == endInclusive;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((endInclusive == null) ? 0 : endInclusive.hashCode());
		result = prime * result + ((startInclusive == null) ? 0 : startInclusive.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Range階層要素 other = (Range階層要素) obj;
		if (endInclusive != other.endInclusive)
			return false;
		if (startInclusive != other.startInclusive)
			return false;
		return true;
	}
}