package org.unlaxer.jaddress.entity.standard;

import java.io.Serializable;
import java.util.Optional;

import org.unlaxer.util.collection.ID;

import io.vavr.control.Either;

public class SingleOrRange階層要素 implements Serializable , IDHolder , LevelHolder , OffsetHolder , NameHolder{
	
	private static final long serialVersionUID = -566332162216464081L;
	
	final Either<階層要素, 定義済みRange階層要素> inner;
	final ID id;
	final int level;
	public Optional<OffsetOfBlock> offsetOfBlock = Optional.empty();
	public Optional<OffsetOfBuilding> offsetOfBuilding = Optional.empty();


	public SingleOrRange階層要素(Either<階層要素, 定義済みRange階層要素> either) {
		super();
		this.inner = either;
		id = either.isRight() ? 
				either.get().id():
				either.getLeft().id();
				
		level = either.isRight() ? 
				either.get().level():
				either.getLeft().level();
	}
	
	public SingleOrRange階層要素(定義済みRange階層要素 _定義済みRange階層要素) {
		super();
		this.inner = Either.right(_定義済みRange階層要素);
		id = _定義済みRange階層要素.id();
		level = _定義済みRange階層要素.level();
	}
	
	public SingleOrRange階層要素(階層要素 _階層要素) {
		super();
		this.inner = Either.left(_階層要素);
		id = _階層要素.id();
		level = _階層要素.level();

	}
	
	public static SingleOrRange階層要素 of(階層要素 _階層要素){
		return new SingleOrRange階層要素(_階層要素);
	}
	
	public static SingleOrRange階層要素 of(定義済みRange階層要素 _定義済みRange階層要素){
		return new SingleOrRange階層要素(_定義済みRange階層要素);
	}
	
	public boolean isSingle() {
		return inner.isLeft();
	}
	
	public boolean isRange() {
		return inner.isRight();
	}
	
	public Optional<階層要素> 階層要素(){
		
		return inner.isLeft() ? 
				Optional.of(inner.getLeft()) :
				Optional.empty();
	}
	
	public Optional<定義済みRange階層要素> 定義済みRange階層要素(){
		
		return inner.isRight() ? 
				Optional.of(inner.get()) :
				Optional.empty();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((inner == null) ? 0 : inner.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SingleOrRange階層要素 other = (SingleOrRange階層要素) obj;
		if (inner == null) {
			if (other.inner != null)
				return false;
		} else if (!inner.equals(other.inner))
			return false;
		return true;
	}
	
	public int ordinal() {
		return 階層要素()
			.map(_階層要素->_階層要素.ordinal())
			.orElseGet(()->定義済みRange階層要素().get().ordinal());
	}
	
	public 階層要素 start階層要素() {
		return 
			isSingle() ? 
				inner.getLeft() :
				inner.get().range.startInclusive();
				
	}
	
	public 階層要素 end階層要素() {
		return 
			isSingle() ? 
				inner.getLeft() :
				inner.get().range.endInclusive();
	}
	
	@Override
	public ID id() {
		return id; 
	}

	@Override
	public int level() {
		return inner.isRight() ?
				inner.get().level() : 
				inner.getLeft().level();
	}

	@Override
	public String name() {
		return inner.isRight() ?
				inner.get().name() : 
				inner.getLeft().name();
	}

	@Override
	public String toString() {
		return id().getName();
	}

	@Override
	public Optional<OffsetOfBlock> offsetOfBlock() {
		return offsetOfBlock;
	}

	@Override
	public Optional<OffsetOfBuilding> offsetOfBuilding() {
		return offsetOfBuilding;
	}

	@Override
	public void setOffsetOfBlock(OffsetOfBlock offsetOfBlock) {
		this.offsetOfBlock = Optional.of(offsetOfBlock);
	}

	@Override
	public void setOffsetOfBuilding(OffsetOfBuilding offsetOfBuilding) {
		this.offsetOfBuilding= Optional.of(offsetOfBuilding);
	}
	
	public boolean equals(定義済みRange階層要素 _定義済みRange階層要素) {
		if(inner.isLeft()) {
			return false;
		}
		return inner.get().equals(_定義済みRange階層要素);
	}
	
	public boolean equals(階層要素 _階層要素) {
		if(inner.isRight()) {
			return false;
		}
		return inner.getLeft().equals(_階層要素);
	}

}