package org.unlaxer.jaddress.entity.standard;

import java.util.Optional;

import org.unlaxer.util.collection.ID;

public enum 定義済みRange階層要素 implements IDHolder , LevelHolder {
	全体(
		new Range階層要素(
			階層要素.国域Top1,
//			階層要素.都道府県,
			階層要素.ダミーサフィックス
		)
	),
	都道府県から町名まで(
	new Range階層要素(
		階層要素.国域Top1,
		階層要素.国域Top4
	)
	),
	町名より後(
		new Range階層要素(
			階層要素.町域Top1,
			階層要素.ダミーサフィックス
		)
	),
//	町名より後から建物以前まで(
//		new Range階層要素(
//			階層要素.町域Top1,
//			階層要素.町域Top4
//		)
//	),
	丁目から枝番まで(
		new Range階層要素(
			階層要素.町域Top1,
			階層要素.町域Top4
		)
	),
	都道府県以降から建物より前まで(
		new Range階層要素(
			階層要素.国域Top1,
			階層要素.町域Top4
		)
	),
	丁目以降(
		new Range階層要素(
			階層要素.町域Top1,
			階層要素.ダミーサフィックス
		)
	),
	建物以降(
		new Range階層要素(
			階層要素.建物,
			階層要素.ダミーサフィックス
		)
	),
	建物より後(
		new Range階層要素(
			階層要素.建物Bottom3,
			階層要素.ダミーサフィックス
		)
	),
	建物より後部屋番号より前(
		new Range階層要素(
			階層要素.建物Bottom3,
			階層要素.建物Bottom2
		)
	),
	建物より後部階数より前(
		new Range階層要素(
			階層要素.建物Bottom3,
			階層要素.建物Bottom3
		)
	)
	;
	
	Range階層要素 range;
	ID id;

	private 定義済みRange階層要素(Range階層要素 range) {
		this.range = range;
		id = ID.of(this);
	}
	
	public Range階層要素 get() {
		return range;
	}
	
	public static Optional<定義済みRange階層要素> of(階層要素 start階層要素,  階層要素 end階層要素){
		
		for (定義済みRange階層要素 current : values()) {
			
			Range階層要素 range階層要素 = current.get();
			
			if(range階層要素.startInclusive == start階層要素 &&
				range階層要素.endInclusive == end階層要素){
				return Optional.of(current);
			}
		}
		return Optional.empty();
	}

	@Override
	public ID id() {
		return id;
	}
	
	@Override
	public int level() {
		return range.startInclusive.level;
	}
}