package org.unlaxer.jaddress.entity.standard;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.unlaxer.util.collection.Comparators;

import io.vavr.Lazy;

public class 市区町村 implements IntNumber{
	
	static Map<Integer,市区町村> 市区町村ByCode;
	
	static Lazy<Map<String,市区町村>> 市区町村ByName =
		Lazy.of(()->市区町村ByCode.values().stream()
				.collect(Collectors.toMap(市区町村::asString, Function.identity()))
		);
		
	static Lazy<Map<String,市区町村>> 市区町村ByBaseName =
		Lazy.of(()->市区町村ByCode.values().stream()
			.collect(Collectors.toMap(
				code->{
					String value = code.asString();
					boolean expectedsSuffix = 
							value.endsWith("市") ||
							value.endsWith("区") ||
							value.endsWith("町") ||
							value.endsWith("村");// ||
					return expectedsSuffix ?
							value.substring(0, value.length()-1):
							value;
				}, 
				Function.identity()))
		);

	
	int code;
	市区町村Value _市区町村Value;

	public 市区町村(int code, 市区町村Value _市区町村Value) {
		super();
		this.code = code;
		this._市区町村Value = _市区町村Value;
	}

	@Override
	public int code() {
		return code;
	}
	
	public 市区町村Value get() {
		return _市区町村Value;
	}
	
	public String asString() {
		return _市区町村Value.value;
	}

	
	public static Optional<市区町村> from(String _市区町村){
		市区町村 getting = 市区町村ByName.get().get(_市区町村);
		if(getting !=null) {
			return Optional.of(getting);
		}
		return Optional.ofNullable(市区町村ByBaseName.get().get(_市区町村));

	}
	
	/**
	 * @param 市区町村Set must be longerIsFirst
	 */
	public static void set(SortedSet<市区町村Value> 市区町村Set) {
		
		市区町村ByCode = new LinkedHashMap<Integer, 市区町村>();
		
		int code = 0;
		for(市区町村Value 市区町村 :  市区町村Set) {
			
			市区町村ByCode.put(code, new 市区町村(code , 市区町村));
		}
	}
	
	public static final Comparator<市区町村> longerIsFirst = (x,y)->{
		return Comparators.longerIsFirst.compare(x.asString() , y.asString());
	};
	
}