package org.unlaxer.jaddress.entity.standard;

import org.unlaxer.jaddress.model.MaxLength._MaxLength;
import org.unlaxer.jaddress.model.MinLength._MinLength;

import java.util.Comparator;

import org.unlaxer.jaddress.model.StringValue;
import org.unlaxer.jaddress.util.normalize.WordReplacer;
import org.unlaxer.util.collection.Comparators;

@_MinLength(1)
@_MaxLength(100)
public class 市区町村Value extends StringValue {

	private static final long serialVersionUID = -383393676791778101L;
	
	public 市区町村Value(String value) {
		super(WordReplacer.replace(value));
	}
	
	public static final Comparator<市区町村Value> longerIsFirst = (x,y)->{
		return Comparators.longerIsFirst.compare(x.value , y.value);
	};

}