package org.unlaxer.jaddress.entity.standard;

import org.apache.commons.lang3.StringUtils;
import org.unlaxer.jaddress.model.MaxLength._MaxLength;
import org.unlaxer.jaddress.model.MinLength._MinLength;
import org.unlaxer.jaddress.model.StringValue;

import com.ibm.icu.text.Transliterator;

import io.vavr.Tuple2;

@_MinLength(7)
@_MaxLength(7)
public class 郵便番号 extends StringValue{

	private static final long serialVersionUID = -65053401079345611L;
	
	public final String hyphonated;
	
	public 郵便番号(String value) {
		super(removeNotNumber(value));
		hyphonated = super.value.substring(0,3)+"-" + super.value.substring(3,7);
	}
	
	static Transliterator transliterator = Transliterator.getInstance("Fullwidth-Halfwidth");
	
	static String removeNotNumber(String word) {
		
		String result = transliterator.transliterate(word);
		return result.replaceAll("-", "");
	}
	
	public String asString() {
		return value;
	}
	
	public int asInt() {
		return Integer.parseInt(value);
	}
	
	public boolean isDivisionBase() {
		return value.endsWith("0");
	}
	
	public Tuple2<郵便番号,郵便番号> divisionRange() {
		if(false == isDivisionBase()) {
			throw new IllegalStateException("this method suitable for this object is divisionBase");
		}
		int index = value.length();
		while(true) {
			index--;
			if(value.substring(index, index+1).equals("0")){
				continue;
			}
			break;
		}
		String base = value.substring(0,index+1);
		String next = base+StringUtils.repeat("9", 7-base.length());
		
		return new Tuple2<>(this , 郵便番号.fromString(next));
	}

	
	public String asHyphonated() {
		return hyphonated;
	}
	
	public static 郵便番号 fromString(String zip){
		return new 郵便番号(zip);
	}
}