package org.unlaxer.jaddress.entity.standard;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import io.vavr.Lazy;

public enum 都道府県 implements ByteNumber {
	北海道(1),
	青森県(2),
	岩手県(3),
	宮城県(4),
	秋田県(5),
	山形県(6),
	福島県(7),
	茨城県(8),
	栃木県(9),
	群馬県(10),
	埼玉県(11),
	千葉県(12),
	東京都(13),
	神奈川県(14),
	新潟県(15),
	富山県(16),
	石川県(17),
	福井県(18),
	山梨県(19),
	長野県(20),
	岐阜県(21),
	静岡県(22),
	愛知県(23),
	三重県(24),
	滋賀県(25),
	京都府(26),
	大阪府(27),
	兵庫県(28),
	奈良県(29),
	和歌山県(30),
	鳥取県(31),
	島根県(32),
	岡山県(33),
	広島県(34),
	山口県(35),
	徳島県(36),
	香川県(37),
	愛媛県(38),
	高知県(39),
	福岡県(40),
	佐賀県(41),
	長崎県(42),
	熊本県(43),
	大分県(44),
	宮崎県(45),
	鹿児島県(46),
	沖縄県(47)
	;
	byte code;
	都道府県Value _都道府県;
	
	static Lazy<Map<String,都道府県>> 都道府県ByName =
		Lazy.of(()->Stream.of(values())
				.collect(Collectors.toMap(都道府県::asString, Function.identity()))
		);
	
	static Lazy<Map<String,都道府県>> 都道府県ByBaseName =
		Lazy.of(()->Stream.of(values())
				.collect(Collectors.toMap(
					code->{
						String value = code.get().value;
						return value.substring(0, value.length()-1);
					}, 
					Function.identity()))
		);

	private 都道府県(int code) {
		this.code = (byte)code;
		_都道府県 = new 都道府県Value(name());
	}
	
	public 都道府県Value get() {
		return _都道府県;
	}
	
	public String asString() {
		return _都道府県.value;
	}

	@Override
	public byte code() {
		return code;
	}
	
	public static Optional<都道府県> from(String _都道府県) {
		都道府県 getting = 都道府県ByName.get().get(_都道府県);
		if(getting !=null) {
			return Optional.of(getting);
		}
		return Optional.ofNullable(都道府県ByBaseName.get().get(_都道府県));
	}
}