package org.unlaxer.jaddress.entity.standard;

import org.unlaxer.jaddress.parser.TopOrBottom;

public enum 階層Domain{
	無し,
	国域,
	町域,
	建物	
	;
	
	public DomainAndOffset ofTop(int offset) {
		return new DomainAndOffset(this, new Offset(TopOrBottom.TOP, offset));
	}
	
	public DomainAndOffset of(int offset) {
		return ofTop(offset);
	}

	
	public DomainAndOffset ofBottom(int offset) {
		return new DomainAndOffset(this, new Offset(TopOrBottom.BOTTOM, offset));
	}
	
	public static class DomainAndOffset{
		public final 階層Domain domain;
		public final Offset offset;
		final String toString;
		
		public DomainAndOffset(階層Domain domain, Offset offset) {
			super();
			this.domain = domain;
			this.offset = offset;
			toString = domain.name() + offset.toString();
		}
		
		@Override
		public String toString() {
			return toString;
		}
	}
}