package org.unlaxer.jaddress.entity.standard;

import static org.unlaxer.jaddress.entity.standard.階層Domain.*;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;

import org.unlaxer.jaddress.entity.standard.階層Domain.DomainAndOffset;
import org.unlaxer.util.collection.ID;

public enum 階層要素 implements IDHolder , LevelHolder{
	
	ZIP(0,false,"郵便番号"),
	全体(0,true,"全体"),
	
	空(0,false,"要素外、empty"),
//	非階層要素(0,"住所の階層要素ではない"),
	不明(0,false,"不明"),
	
	国域Top1(1 , true,  国域.of(1) , "都道府県"),
	国域Top2(2 , true ,  国域.of(2) , "市、群"),
	国域Top3(3 , true ,  国域.of(3) , "区"),
	国域Top4(4 , true ,  国域.of(4) , "町村"),
	
	都道府県(1 , false),
	その他(1, false , "どの市区町村にも所属しない土地","埋立地","鳥島","須美寿島"),
	東京23区(2 , false ),
	政令指定市(2 , false),
	市(2 , false),
	群(2 , false),
	区(3 , false),
	町村(4 , false),
	町または大字(4, false , "姫路市の区","長崎県の免,里など"),
	

	町域Top1(5 , true , 町域.of(1) , "丁目（３階層）や番地（2階層）など"),
	町域Top2(6 , true ,  町域.of(2) , "無番地含む。番地（３階層）や号(2階層)など"),
	町域Top3(7 , true , 町域.of(3) , "号（３階層）や枝番号(2階層)や部屋番号など"),
	町域Top4(8 , true ,  町域.of(4) , "枝番号（３階層）や枝番号"),
	
	丁目(5, false , "丁目なしもあり"),
	字小字(5 , false),
	地番(6, false , "無番地含む"),
	街区符号(6, false , "番など"),
	住居番号(7, false , "号など"),
	支号(7, false , "地番に対する枝番号"),
	枝番号(8, false ,"住居番号に対する枝番号"),
	
	建物(9 , true),
	
	建物Top1(10 , false ,  階層Domain.建物.of(1) , "棟"),
	建物Top2(11 , false , 階層Domain.建物.of(2) , "階数"),
	建物Top3(12 , false , 階層Domain.建物.of(3) , "部屋番号"),
	
	建物Bottom3(10 , true , 階層Domain.建物.ofBottom(3) , "棟"),
	建物Bottom2(11 , true ,  階層Domain.建物.ofBottom(2) , "階数"),
	建物Bottom1(12 , true ,  階層Domain.建物.ofBottom(1) , "部屋番号"),
	
    棟(10 , false),
    階数(11 , false),
    部屋番号(12 , false),
    
	方書き(13 , true),
	ダミーサフィックス(14 , true){

		@Override
		public String toString() {
			return "ダミー";
		}
	},
	
	;
	
	public final int level;
	public final String[] description;
	public final ID id;
	DomainAndOffset domainAndOffset;
	
	static class Holder{
		public static Map<Integer,SortedSet<階層要素>> 階層要素群byLevel = new HashMap<>();
		public static Map<Integer,階層要素> 階層要素byLevel = new HashMap<>();
		public static final Comparator<階層要素> lowerIsTop = (x,y)-> x.ordinal() - y.ordinal();
	}
	private 階層要素(int level , boolean exports , DomainAndOffset domainAndOffset, String... description) {
		this.level = level;
		this.description = description;
		id = ID.of(this);
		Holder.階層要素群byLevel
			.computeIfAbsent(level ,_level-> new TreeSet<>(Holder.lowerIsTop))
			.add(this);
		if(exports) {
			Holder.階層要素byLevel.put(level, this);
		}
		this.domainAndOffset = domainAndOffset;
	}
	
	private 階層要素(int level , boolean exports , String... description) {
		this(level, exports , null, description);
	}
	
	public static Optional<階層要素> byLevel(int level) {
		return Optional.ofNullable(Holder.階層要素byLevel.get(level));
	}
	
	public Optional<DomainAndOffset> domainAndOffset() {
		return Optional.ofNullable(domainAndOffset);
	}
	
	public String shortName() {
		return domainAndOffset == null ? 
				name():
				domainAndOffset.toString();
	}

	@Override
	public ID id() {
		return id;
	}

	@Override
	public int level() {
		return level;
	}
	
	@Override
	public String toString() {
		return shortName();
	}
}